/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.engine.dataentity.logic;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.dataentity.logic.IPSDELogicParam;
import net.ibizsys.model.engine.dataentity.logic.IPSDELogicEngine;
import net.ibizsys.model.engine.dataentity.logic.IPSDELogicParamAddin;
import net.ibizsys.model.engine.dataentity.logic.IPSDELogicSession;
import net.ibizsys.model.engine.dataentity.logic.PSDELogicEntityListParamAddin;
import net.ibizsys.model.engine.dataentity.logic.PSDELogicSessionHolder;
import net.ibizsys.model.engine.plugin.IPSModelEngineAddin;
import net.ibizsys.model.engine.plugin.PSModelEngineAddin2Base;
import net.ibizsys.model.engine.plugin.PSModelEngineAddinException;
import net.ibizsys.model.engine.util.IEntity;
import net.ibizsys.model.engine.util.IEntityDTO;
import net.ibizsys.model.engine.util.IPage;
import net.ibizsys.model.util.DataTypeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public abstract class PSDELogicParamAddinBase<E extends IPSDELogicEngine<?>, M extends IPSDELogicParam>
extends PSModelEngineAddin2Base<E, M>
implements IPSDELogicParamAddin<E, M> {
    private static final Log log = LogFactory.getLog(PSDELogicParamAddinBase.class);
    private String strCodeName = null;

    @Override
    protected void onInit() throws Exception {
        this.strCodeName = this.getPSDELogicParam().getCodeName();
        super.onInit();
    }

    protected M getPSDELogicParam() {
        return (M)((IPSDELogicParam)this.getAddinData());
    }

    @Override
    public String getCodeName() {
        return this.strCodeName;
    }

    @Override
    public String getName() {
        return String.format("\u903b\u8f91\u53c2\u6570[%1$s]", this.getPSDELogicParam().getName());
    }

    @Override
    public void beginSession(IPSDELogicSession iPSDELogicEngineSession) {
        this.onBeginSession(iPSDELogicEngineSession);
    }

    protected void onBeginSession(IPSDELogicSession iPSDELogicEngineSession) {
    }

    @Override
    public void endSession(IPSDELogicSession iPSDELogicEngineSession) {
        this.onEndSession(iPSDELogicEngineSession);
    }

    protected void onEndSession(IPSDELogicSession iPSDELogicEngineSession) {
    }

    @Override
    public Map<String, Object> any(IPSDELogicSession iPSDELogicEngineSession) {
        Object objParam = this.getValue(iPSDELogicEngineSession);
        if (objParam instanceof IEntity) {
            return ((IEntity)objParam).any();
        }
        throw new PSModelEngineAddinException(this, String.format("\u672a\u652f\u6301any\u64cd\u4f5c", new Object[0]));
    }

    @Override
    public void set(IPSDELogicSession iPSDELogicEngineSession, String name, Object objValue) {
        Object objParam = this.getValue(iPSDELogicEngineSession);
        if (objValue instanceof String && objParam instanceof IEntity) {
            ((IEntity)objParam).set(name, (String)objValue);
            return;
        }
        if (objParam instanceof IEntity) {
            ((IEntity)objParam).set(name, objValue);
            return;
        }
        throw new PSModelEngineAddinException(this, String.format("\u672a\u652f\u6301set\u64cd\u4f5c", new Object[0]));
    }

    @Override
    public void reset(IPSDELogicSession iPSDELogicEngineSession, String name) {
        Object objParam = this.getValue(iPSDELogicEngineSession);
        if (objParam instanceof IEntity) {
            ((IEntity)objParam).reset(name);
            return;
        }
        throw new PSModelEngineAddinException(this, String.format("\u672a\u652f\u6301reset\u64cd\u4f5c", new Object[0]));
    }

    @Override
    public void resetAll(IPSDELogicSession iPSDELogicEngineSession) {
        Object objParam = this.getValue(iPSDELogicEngineSession);
        if (objParam instanceof IEntity) {
            ((IEntity)objParam).resetAll();
            return;
        }
        throw new PSModelEngineAddinException(this, String.format("\u672a\u652f\u6301resetAll\u64cd\u4f5c", new Object[0]));
    }

    @Override
    public Object get(IPSDELogicSession iPSDELogicEngineSession, String name) {
        if (ObjectUtils.isEmpty((Object)name)) {
            throw new PSModelEngineAddinException(this, String.format("\u672a\u6307\u5b9a\u5c5e\u6027", new Object[0]));
        }
        Object objParam = this.getValue(iPSDELogicEngineSession);
        if (objParam instanceof IEntity) {
            return ((IEntity)objParam).get(name);
        }
        if ("total".equalsIgnoreCase(name)) {
            if (objParam instanceof IPage) {
                return ((IPage)objParam).getTotalElements();
            }
        } else if ("size".equalsIgnoreCase(name) || "length".equalsIgnoreCase(name)) {
            List list = PSDELogicParamAddinBase.asList(objParam);
            if (list != null) {
                return list.size();
            }
        } else {
            List list = PSDELogicParamAddinBase.asList(objParam);
            if (list != null) {
                int nPos = Integer.parseInt(name);
                if (nPos < 0 || nPos >= list.size()) {
                    throw new PSModelEngineAddinException(this, String.format("\u65e0\u6548\u7684\u4f4d\u7f6e[%1$s]", nPos));
                }
                return list.get(nPos);
            }
        }
        throw new PSModelEngineAddinException(this, String.format("\u672a\u652f\u6301get[%1$s]\u64cd\u4f5c", name));
    }

    @Override
    public boolean contains(IPSDELogicSession iPSDELogicEngineSession, String name) {
        Object objParam = this.getValue(iPSDELogicEngineSession);
        if (objParam instanceof IEntity) {
            return ((IEntity)objParam).contains(name);
        }
        throw new PSModelEngineAddinException(this, String.format("\u672a\u652f\u6301contains\u64cd\u4f5c", new Object[0]));
    }

    @Override
    public void copyTo(IPSDELogicSession iPSDELogicEngineSession, Object dstParam) {
        Object objParam = this.getValue(iPSDELogicEngineSession);
        if (objParam instanceof IEntity && dstParam instanceof IEntity) {
            ((IEntity)objParam).copyTo((IEntity)dstParam);
            return;
        }
        throw new PSModelEngineAddinException(this, String.format("\u672a\u652f\u6301copyTo\u64cd\u4f5c", new Object[0]));
    }

    @Override
    public void copyTo(Object dstParam, List<String> fieldList, boolean bCopyIfNotExists) {
        this.copyTo(PSDELogicSessionHolder.getCurrentMust(), dstParam, fieldList, bCopyIfNotExists);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void copyTo(IPSDELogicSession iPSDELogicEngineSession, Object dstParam, List<String> fieldList, boolean bCopyIfNotExists) {
        Object objParam = this.getValue(iPSDELogicEngineSession);
        if (!(objParam instanceof IEntity) || !(dstParam instanceof IEntity)) throw new PSModelEngineAddinException(this, String.format("\u672a\u652f\u6301copyTo\u64cd\u4f5c", new Object[0]));
        IEntity srcEntity = (IEntity)objParam;
        IEntity dstEntity = (IEntity)dstParam;
        if (ObjectUtils.isEmpty(fieldList)) {
            if (bCopyIfNotExists) {
                if (!(srcEntity instanceof IEntityDTO)) throw new PSModelEngineAddinException(this, String.format("\u672a\u652f\u6301copyTo\u64cd\u4f5c", new Object[0]));
                ((IEntityDTO)srcEntity).copyToIf(dstEntity);
                return;
            } else {
                srcEntity.copyTo(dstEntity);
            }
            return;
        } else {
            for (String field : fieldList) {
                if (!srcEntity.contains(field) || bCopyIfNotExists && dstEntity.contains(field)) continue;
                dstEntity.set(field, srcEntity.get(field));
            }
        }
    }

    @Override
    public void bind(IPSDELogicSession iPSDELogicEngineSession, Object paramObject) {
        iPSDELogicEngineSession.setParam((IPSDELogicParam)this.getPSDELogicParam(), paramObject);
    }

    @Override
    public void renew(IPSDELogicSession iPSDELogicEngineSession) {
        iPSDELogicEngineSession.setParam((IPSDELogicParam)this.getPSDELogicParam(), (Object)null);
    }

    @Override
    public void append(IPSDELogicSession iPSDELogicEngineSession, int nPos, Object paramObject, int nSrcPos, int nSrcLength) {
        Object obj = this.getValue(iPSDELogicEngineSession);
        if (!(obj instanceof List)) {
            throw new PSModelEngineAddinException(this, String.format("\u76ee\u6807\u53c2\u6570\u4e0d\u662f\u6570\u636e\u5bf9\u8c61\u5217\u8868\u7c7b\u578b", new Object[0]));
        }
        List list = (List)obj;
        List srcList = PSDELogicParamAddinBase.asList(paramObject);
        if (srcList != null) {
            int nLength = srcList.size();
            if (nSrcPos >= 0 && nSrcLength > 0) {
                if (nSrcPos + nSrcLength > nLength) {
                    throw new PSModelEngineAddinException(this, String.format("\u5217\u8868\u957f\u5ea6\u6ea2\u51fa", new Object[0]));
                }
                nLength = nSrcPos + nSrcLength;
            }
            int nInsertPos = nPos;
            if (nPos > list.size()) {
                throw new PSModelEngineAddinException(this, String.format("\u63d2\u5165\u4f4d\u7f6e\u6ea2\u51fa", new Object[0]));
            }
            for (int i = nSrcPos; i < nLength; ++i) {
                if (nInsertPos >= 0) {
                    list.add(nInsertPos, srcList.get(i));
                    ++nInsertPos;
                    continue;
                }
                list.add(srcList.get(i));
            }
        } else if (nPos >= 0) {
            if (nPos > list.size()) {
                throw new PSModelEngineAddinException(this, String.format("\u63d2\u5165\u4f4d\u7f6e\u6ea2\u51fa", new Object[0]));
            }
            list.add(nPos, paramObject);
        } else {
            list.add(paramObject);
        }
    }

    @Override
    public void sort(IPSDELogicSession iPSDELogicEngineSession, final String field, String strSortDir) {
        Object obj = this.getValue(iPSDELogicEngineSession);
        if (!(obj instanceof List)) {
            throw new PSModelEngineAddinException(this, String.format("\u76ee\u6807\u53c2\u6570\u4e0d\u662f\u6570\u636e\u5bf9\u8c61\u5217\u8868\u7c7b\u578b", new Object[0]));
        }
        List list = (List)obj;
        boolean bSortDesc = "desc".equalsIgnoreCase(strSortDir);
        Collections.sort(list, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                IEntity e1 = (IEntity)o1;
                IEntity e2 = (IEntity)o2;
                Object v1 = e1.get(field);
                Object v2 = e2.get(field);
                if (v1 == null && v2 == null) {
                    return 0;
                }
                if (v1 != null && v2 == null) {
                    return 1;
                }
                if (v1 == null && v2 != null) {
                    return -1;
                }
                return (int)DataTypeUtils.compare((int)DataTypeUtils.getObjectDataType((Object)v1), (Object)v1, (Object)v2);
            }
        });
        if (bSortDesc) {
            Collections.reverse(list);
        }
    }

    @Override
    public int count(IPSDELogicSession iPSDELogicEngineSession) {
        Object obj = this.getValue(iPSDELogicEngineSession);
        if (obj == null) {
            return 0;
        }
        if (!(obj instanceof List)) {
            throw new PSModelEngineAddinException(this, String.format("\u672a\u652f\u6301count\u64cd\u4f5c", new Object[0]));
        }
        return ((List)obj).size();
    }

    @Override
    public Object aggregate(IPSDELogicSession iPSDELogicEngineSession, String field, String strAggMode) {
        Object obj = this.getValue(iPSDELogicEngineSession);
        if (!(obj instanceof List)) {
            throw new PSModelEngineAddinException(this, String.format("\u672a\u652f\u6301aggregate\u64cd\u4f5c", new Object[0]));
        }
        try {
            return PSDELogicEntityListParamAddin.aggregate(strAggMode, (List)obj, field);
        }
        catch (Exception ex) {
            throw new PSModelEngineAddinException((IPSModelEngineAddin)this, String.format("aggregate\u64cd\u4f5c\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), (Throwable)ex);
        }
    }

    @Override
    public Object aggregate(String field, String strAggMode) {
        return this.aggregate(PSDELogicSessionHolder.getCurrentMust(), field, strAggMode);
    }

    @Override
    public void debug(IPSDELogicSession iPSDELogicEngineSession, Map<String, Object> data) {
        Object objValue = null;
        try {
            objValue = iPSDELogicEngineSession.getParam((IPSDELogicParam)this.getPSDELogicParam(), true);
        }
        catch (Throwable ex) {
            data.put("info", String.format("\u83b7\u53d6\u903b\u8f91\u53c2\u6570[%1$s]\u5b9e\u9645\u503c\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getCodeName(), ex.getMessage()));
        }
        if (objValue == null) {
            data.put("data", null);
        } else {
            try {
                Object objData = this.getUtil().serialize(objValue);
                if (objData instanceof String) {
                    data.put("data", (String)objData);
                } else {
                    data.put("data", objData.toString());
                }
            }
            catch (Throwable ex) {
                if (objValue instanceof String) {
                    data.put("data", (String)objValue);
                }
                data.put("data", objValue.toString());
            }
        }
    }

    @Override
    public Object getValue(IPSDELogicSession iPSDELogicEngineSession) {
        try {
            return iPSDELogicEngineSession.getParam((IPSDELogicParam)this.getPSDELogicParam());
        }
        catch (Exception ex) {
            throw new PSModelEngineAddinException((IPSModelEngineAddin)this, String.format("\u83b7\u53d6\u53c2\u6570\u503c\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), (Throwable)ex);
        }
    }

    @Override
    public Object getValue() {
        return this.getValue(PSDELogicSessionHolder.getCurrentMust());
    }

    @Override
    public Map<String, Object> any() {
        return this.any(PSDELogicSessionHolder.getCurrentMust());
    }

    @Override
    public void set(String name, Object objValue) {
        this.set(PSDELogicSessionHolder.getCurrentMust(), name, objValue);
    }

    @Override
    public void reset(String name) {
        this.reset(PSDELogicSessionHolder.getCurrentMust(), name);
    }

    @Override
    public void resetAll() {
        this.resetAll(PSDELogicSessionHolder.getCurrentMust());
    }

    @Override
    public void copyTo(Object dstParam) {
        this.copyTo(PSDELogicSessionHolder.getCurrentMust(), dstParam);
    }

    @Override
    public Object get(String name) {
        return this.get(PSDELogicSessionHolder.getCurrentMust(), name);
    }

    @Override
    public boolean contains(String name) {
        return this.contains(PSDELogicSessionHolder.getCurrentMust(), name);
    }

    @Override
    public void bind(Object paramObject) {
        this.bind(PSDELogicSessionHolder.getCurrentMust(), paramObject);
    }

    @Override
    public void renew() {
        this.renew(PSDELogicSessionHolder.getCurrentMust());
    }

    @Override
    public void append(int nPos, Object paramObject, int nSrcPos, int nSrcLength) {
        this.append(PSDELogicSessionHolder.getCurrentMust(), nPos, paramObject, nSrcPos, nSrcLength);
    }

    @Override
    public void sort(String field, String strSortDir) {
        this.sort(PSDELogicSessionHolder.getCurrentMust(), field, strSortDir);
    }

    @Override
    public int count() {
        return this.count(PSDELogicSessionHolder.getCurrentMust());
    }

    public static List asList(Object object) {
        if (object instanceof List) {
            return (List)object;
        }
        if (object instanceof IPage) {
            return ((IPage)object).getContent();
        }
        return null;
    }

    public static Map asMap(Object object) {
        if (object instanceof Map) {
            return (Map)object;
        }
        return null;
    }

    public static Object[] asObjects(Object object) {
        if (object == null) {
            return null;
        }
        List list = PSDELogicParamAddinBase.asList(object);
        if (list != null) {
            return list.toArray(new Object[list.size()]);
        }
        return new Object[]{object};
    }

    public static Object max(List list, String field) throws Exception {
        if (list == null || list.size() == 0) {
            return null;
        }
        Object maxValue = null;
        for (Object objItem : list) {
            if (!(objItem instanceof IEntity)) {
                throw new Exception(String.format("\u5217\u8868\u9879\u4e0d\u662f\u6570\u636e\u5bf9\u8c61\u7c7b\u578b", new Object[0]));
            }
            IEntity iEntity = (IEntity)objItem;
            Object objValue = iEntity.get(field);
            if (objValue == null) continue;
            if (maxValue == null) {
                maxValue = objValue;
                continue;
            }
            if (DataTypeUtils.compare((int)DataTypeUtils.getObjectDataType((Object)maxValue), (Object)maxValue, (Object)objValue) >= 0L) continue;
            maxValue = objValue;
        }
        return maxValue;
    }

    public static Object min(List list, String field) throws Exception {
        if (list == null || list.size() == 0) {
            return null;
        }
        Object minValue = null;
        for (Object objItem : list) {
            if (!(objItem instanceof IEntity)) {
                throw new Exception(String.format("\u5217\u8868\u9879\u4e0d\u662f\u6570\u636e\u5bf9\u8c61\u7c7b\u578b", new Object[0]));
            }
            IEntity iEntity = (IEntity)objItem;
            Object objValue = iEntity.get(field);
            if (minValue == null) {
                minValue = objValue;
                continue;
            }
            if (DataTypeUtils.compare((int)DataTypeUtils.getObjectDataType((Object)minValue), (Object)minValue, (Object)objValue) <= 0L) continue;
            minValue = objValue;
        }
        return minValue;
    }

    public static BigDecimal sum(List list, String field) throws Exception {
        if (list == null || list.size() == 0) {
            return null;
        }
        BigDecimal sumValue = null;
        for (Object objItem : list) {
            if (!(objItem instanceof IEntity)) {
                throw new Exception(String.format("\u5217\u8868\u9879\u4e0d\u662f\u6570\u636e\u5bf9\u8c61\u7c7b\u578b", new Object[0]));
            }
            IEntity iEntity = (IEntity)objItem;
            Object objValue = iEntity.get(field);
            BigDecimal curValue = DataTypeUtils.getBigDecimalValue((Object)objValue, null);
            if (curValue == null) continue;
            if (sumValue == null) {
                sumValue = curValue;
                continue;
            }
            sumValue = sumValue.add(curValue);
        }
        return sumValue;
    }

    public static BigDecimal avg(List list, String field) throws Exception {
        if (list == null || list.size() == 0) {
            return null;
        }
        BigDecimal sumvalue = PSDELogicParamAddinBase.sum(list, field);
        if (sumvalue == null) {
            return null;
        }
        return sumvalue.divide(BigDecimal.valueOf(list.size()));
    }

    public static Object aggregate(String calcType, List list, String field) throws Exception {
        if (PSModelEnums.DER1NDEFMapType.COUNT.value.equalsIgnoreCase(calcType)) {
            if (list == null) {
                return 0;
            }
            return list.size();
        }
        if (PSModelEnums.DER1NDEFMapType.MAX.value.equalsIgnoreCase(calcType)) {
            return PSDELogicParamAddinBase.max(list, field);
        }
        if (PSModelEnums.DER1NDEFMapType.MIN.value.equalsIgnoreCase(calcType)) {
            return PSDELogicParamAddinBase.min(list, field);
        }
        if (PSModelEnums.DER1NDEFMapType.SUM.value.equalsIgnoreCase(calcType)) {
            return PSDELogicParamAddinBase.sum(list, field);
        }
        if (PSModelEnums.DER1NDEFMapType.AVG.value.equalsIgnoreCase(calcType)) {
            return PSDELogicParamAddinBase.avg(list, field);
        }
        throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u8ba1\u7b97\u7c7b\u578b[%1$s]", calcType));
    }
}

