/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.engine.database;

import java.util.Map;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.database.IPSSysDBScheme;
import net.ibizsys.model.dataentity.ds.IPSDEDataQuery;
import net.ibizsys.model.dataentity.ds.IPSDEDataQueryCode;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.model.engine.IPSModelEngineHolder;
import net.ibizsys.model.engine.database.IPSSysDBSchemeEngine;
import net.ibizsys.model.engine.database.PSSysDBSchemeEngineBaseBase;
import net.ibizsys.model.engine.database.sql.ISQLGenEngine;
import net.ibizsys.model.engine.util.IAction;
import net.ibizsys.model.system.IPSSysModelGroup;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class PSSysDBSchemeEngineBase<T extends IPSSysDBScheme>
extends PSSysDBSchemeEngineBaseBase<T>
implements IPSSysDBSchemeEngine<T> {
    private ISQLGenEngine iSQLGenEngine = null;

    @Override
    public void init(IPSModelEngineHolder iPSModelEngineContext, String id, T iPSSysDBScheme) throws Exception {
        this.setConfigFolder("sysdbscheme." + PSModelUtils.calcUniqueTag((IPSSysModelGroup)iPSSysDBScheme.getPSSysModelGroup(), (String)iPSSysDBScheme.getDSLink()));
        super.init(iPSModelEngineContext, id, iPSSysDBScheme);
    }

    @Override
    protected void onPrepareSetting() throws Exception {
        this.setDBType(this.getPSModelEngineHolder().getParam(this.getConfigFolder() + ".dbtype", "MYSQL5"));
        if (StringUtils.hasLength((String)((IPSSysDBScheme)this.getPSModelObject()).getDBObjNameCase())) {
            this.setDBObjNameCase(this.getPSModelEngineHolder().getParam(this.getConfigFolder() + ".dbobjnamecase", ((IPSSysDBScheme)this.getPSModelObject()).getDBObjNameCase()));
        }
        super.onPrepareSetting();
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();
    }

    public IPSSysDBScheme getPSSysDBScheme() {
        return (IPSSysDBScheme)this.getPSModelObject();
    }

    @Override
    public boolean isEnableSQL() {
        return true;
    }

    protected ISQLGenEngine getSQLGenEngine(boolean tryMode) throws Exception {
        ISQLGenEngine iSQLGenEngine;
        if (this.iSQLGenEngine != null || tryMode) {
            return this.iSQLGenEngine;
        }
        this.iSQLGenEngine = iSQLGenEngine = this.getPSModelEngineHolder().getPSModelEngineAddin(this, this.getDBType(), ISQLGenEngine.class);
        return this.iSQLGenEngine;
    }

    protected void setSQLGenEngine(ISQLGenEngine iSQLGenEngine) {
        this.iSQLGenEngine = iSQLGenEngine;
    }

    @Override
    public String getSQL(final IPSDEDataSet iPSDEDataSet, final Map<String, Object> params) {
        return this.executeAction("\u83b7\u53d6\u6570\u636e\u96c6SQL\u4ee3\u7801", new IAction<String>(){

            @Override
            public String execute(Object[] args) throws Throwable {
                return PSSysDBSchemeEngineBase.this.onGetSQL(iPSDEDataSet, (Map<String, Object>)params);
            }
        }, String.class);
    }

    protected String onGetSQL(IPSDEDataSet iPSDEDataSet, Map<String, Object> params) throws Throwable {
        return this.getSQLGenEngine(false).generate(iPSDEDataSet, params);
    }

    protected IPSDEDataQueryCode getPSDEDataQueryCode(IPSDEDataQuery iPSDEDataQuery, boolean tryMode) throws Exception {
        if (!ObjectUtils.isEmpty((Object)iPSDEDataQuery.getAllPSDEDataQueryCodes())) {
            for (IPSDEDataQueryCode iPSDEDataQueryCode : iPSDEDataQuery.getAllPSDEDataQueryCodes()) {
                if (!this.getDBType().equalsIgnoreCase(iPSDEDataQueryCode.getDBType())) continue;
                return iPSDEDataQueryCode;
            }
        }
        if (tryMode) {
            return null;
        }
        throw new Exception(String.format("\u672a\u5b9a\u4e49\u67e5\u8be2\u4ee3\u7801[%1$s]", this.getDBType()));
    }

    @Override
    public String getSQL(final IPSDEDataQuery iPSDEDataQuery, final Map<String, Object> params) {
        return this.executeAction("\u83b7\u53d6\u6570\u636e\u67e5\u8be2SQL\u4ee3\u7801", new IAction<String>(){

            @Override
            public String execute(Object[] args) throws Throwable {
                return PSSysDBSchemeEngineBase.this.onGetSQL(iPSDEDataQuery, (Map<String, Object>)params);
            }
        }, String.class);
    }

    protected String onGetSQL(IPSDEDataQuery iPSDEDataQuery, Map<String, Object> params) throws Throwable {
        throw new Exception("\u6ca1\u6709\u5b9e\u73b0");
    }
}

