/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.engine.ba;

import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.ba.IPSSysBDScheme;
import net.ibizsys.model.engine.IPSModelEngineHolder;
import net.ibizsys.model.engine.ba.IPSSysBDSchemeEngine;
import net.ibizsys.model.engine.database.PSSysDBSchemeEngineBaseBase;
import net.ibizsys.model.engine.database.sql.ISQLGenEngine;
import net.ibizsys.model.system.IPSSysModelGroup;
import net.ibizsys.model.system.IPSSystemModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public abstract class PSSysBDSchemeEngineBase<M extends IPSSysBDScheme>
extends PSSysDBSchemeEngineBaseBase<M>
implements IPSSysBDSchemeEngine<M> {
    private static final Log log = LogFactory.getLog(PSSysBDSchemeEngineBase.class);
    private ISQLGenEngine iSQLGenEngine = null;
    private String dbName = null;

    @Override
    public void init(IPSModelEngineHolder iPSModelEngineContext, String id, M iPSModelObject) throws Exception {
        if (iPSModelObject.getPSSysModelGroup() != null) {
            this.setConfigFolder("sysbdscheme." + PSModelUtils.calcUniqueTag((IPSSysModelGroup)iPSModelObject.getPSSysModelGroup(), (String)iPSModelObject.getCodeName()));
        } else {
            this.setConfigFolder("sysbdscheme." + PSModelUtils.calcUniqueTag((IPSSystemModule)iPSModelObject.getPSSystemModule(), (String)iPSModelObject.getCodeName()));
        }
        super.init(iPSModelEngineContext, id, iPSModelObject);
    }

    @Override
    protected void onPrepareSetting() throws Exception {
        this.setDBType(this.getPSModelEngineHolder().getParam(this.getConfigFolder() + ".dbtype", null));
        if (!StringUtils.hasLength((String)this.getDBType())) {
            this.setDBType(this.getPSModelEngineHolder().getParam(this.getConfigFolder() + ".bdtype", null));
        }
        if (StringUtils.hasLength((String)((IPSSysBDScheme)this.getPSModelObject()).getCodeName())) {
            this.setDBName(this.getPSModelEngineHolder().getParam(this.getConfigFolder() + ".dbname", ((IPSSysBDScheme)this.getPSModelObject()).getCodeName().toLowerCase()));
        } else {
            this.setDBName(this.getPSModelEngineHolder().getParam(this.getConfigFolder() + ".dbname", null));
        }
        if (StringUtils.hasLength((String)((IPSSysBDScheme)this.getPSModelObject()).getDBObjNameCase())) {
            this.setDBObjNameCase(this.getPSModelEngineHolder().getParam(this.getConfigFolder() + ".dbobjnamecase", ((IPSSysBDScheme)this.getPSModelObject()).getDBObjNameCase()));
        }
        super.onPrepareSetting();
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();
    }

    protected void setDBName(String dbName) {
        this.dbName = dbName;
    }

    @Override
    public String getDBName() {
        return this.dbName;
    }

    @Override
    public boolean isEnableSQL() {
        return false;
    }

    protected ISQLGenEngine getSQLGenEngine(boolean tryMode) throws Exception {
        ISQLGenEngine iSQLGenEngine;
        if (this.iSQLGenEngine != null || tryMode) {
            return this.iSQLGenEngine;
        }
        this.iSQLGenEngine = iSQLGenEngine = this.getPSModelEngineHolder().getPSModelEngineAddin(this, this.getDBType(), ISQLGenEngine.class);
        return this.iSQLGenEngine;
    }

    protected void setSQLGenEngine(ISQLGenEngine iSQLGenEngine) {
        this.iSQLGenEngine = iSQLGenEngine;
    }

    @Override
    protected String getRealDBObjName(String name) {
        if (StringUtils.hasLength((String)name) && this.getDBObjNameCaseMode() != PSModelEnums.DBObjNameCaseMode.DEFAULT) {
            if (this.getDBObjNameCaseMode() == PSModelEnums.DBObjNameCaseMode.LCASE) {
                return name.toLowerCase();
            }
            if (this.getDBObjNameCaseMode() == PSModelEnums.DBObjNameCaseMode.UCASE) {
                return name.toUpperCase();
            }
        }
        return name;
    }
}

