/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.engine;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.IPSSystem;
import net.ibizsys.model.IPSSystemService;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.dataentity.dataflow.IPSDEDataFlowNode;
import net.ibizsys.model.dataentity.logic.IPSDELogicNode;
import net.ibizsys.model.dataentity.service.IPSDEMethodDTO;
import net.ibizsys.model.engine.IPSModelEngine;
import net.ibizsys.model.engine.IPSModelEngineFactory;
import net.ibizsys.model.engine.IPSModelEngineHolder;
import net.ibizsys.model.engine.IPSSystemEngine;
import net.ibizsys.model.engine.IPSSystemLogger;
import net.ibizsys.model.engine.IPSSystemUtil;
import net.ibizsys.model.engine.dataentity.dataflow.IPSDEDataFlowNodeAddin;
import net.ibizsys.model.engine.dataentity.logic.IPSDELogicNodeAddin;
import net.ibizsys.model.engine.dataentity.service.IPSDEMethodDTOEngine;
import net.ibizsys.model.engine.eai.IPSSysDataSyncAgentEngine;
import net.ibizsys.model.engine.plugin.IPSModelEngineAddin;
import net.ibizsys.model.engine.res.IPSSysSFPluginEngine;
import net.ibizsys.model.engine.service.IPSSubSysServiceAPIEngine;
import net.ibizsys.model.engine.sysutil.IPSSysUtilEngine;
import net.ibizsys.model.res.IPSSysDataSyncAgent;
import net.ibizsys.model.res.IPSSysSFPlugin;
import net.ibizsys.model.res.IPSSysSFPluginSupportable;
import net.ibizsys.model.res.IPSSysUtil;
import net.ibizsys.model.service.IPSSubSysServiceAPI;
import net.ibizsys.model.system.IPSSystemModule;
import net.ibizsys.model.util.DataTypeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class PSModelEngineHolderBase
implements IPSModelEngineHolder {
    private static final Log log = LogFactory.getLog(PSModelEngineHolderBase.class);
    private final IPSSystemService iPSSystemService;
    private final IPSSystem iPSSystem;
    private final IPSModelEngineFactory iPSModelEngineFactory;
    private Map<String, Object> paramMap = new HashMap<String, Object>();
    private Map<String, IPSModelEngine<?>> psModelEngineMap = new ConcurrentHashMap();
    private Map<String, BiFunction<IPSModelEngineHolder, IPSModelObject, String>> psModelSubTypeFunctionMap = new HashMap<String, BiFunction<IPSModelEngineHolder, IPSModelObject, String>>();
    private static Map<String, BiFunction<IPSModelEngineHolder, IPSModelObject, String>> PSModelSubTypeFunctionMap = new HashMap<String, BiFunction<IPSModelEngineHolder, IPSModelObject, String>>();
    private IPSSystemEngine<?> iPSSystemEngine = null;
    private IPSSystemLogger iPSSystemLogger = null;
    private IPSSystemUtil iPSSystemUtil = null;

    public PSModelEngineHolderBase(IPSModelEngineFactory iPSModelEngineFactory, IPSSystemService iPSSystemService, Map<String, Object> map) {
        Assert.notNull((Object)iPSModelEngineFactory, (String)"\u4f20\u5165\u6a21\u578b\u5f15\u64ce\u5de5\u5382\u5bf9\u8c61\u65e0\u6548");
        Assert.notNull((Object)iPSSystemService, (String)"\u4f20\u5165\u7cfb\u7edf\u6a21\u578b\u670d\u52a1\u5bf9\u8c61\u65e0\u6548");
        this.iPSModelEngineFactory = iPSModelEngineFactory;
        this.iPSSystemService = iPSSystemService;
        this.iPSSystem = iPSSystemService.getPSSystem();
        this.reload(map);
        try {
            this.iPSSystemEngine = this.getPSModelEngine((IPSModelObject)this.iPSSystem, IPSSystemEngine.class);
            this.iPSSystemLogger = this.getPSModelEngineAddin(this.getPSSystemEngine(), null, IPSSystemLogger.class);
            this.iPSSystemUtil = this.getPSModelEngineAddin(this.getPSSystemEngine(), null, IPSSystemUtil.class);
            this.iPSSystemEngine.start();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public IPSSystemService getPSSystemService() {
        return this.iPSSystemService;
    }

    @Override
    public IPSModelEngineFactory getPSModelEngineFactory() {
        return this.iPSModelEngineFactory;
    }

    protected void reload(Map<String, Object> map) {
        this.paramMap.clear();
        if (map != null) {
            this.load("", map, true);
        }
    }

    protected void load(String pkey, Map<String, Object> map, boolean bOverwrite) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String strKey = null;
            strKey = StringUtils.hasLength((String)pkey) ? String.format("%1$s.%2$s", pkey, entry.getKey()).toLowerCase() : entry.getKey().toLowerCase();
            if (entry.getValue() instanceof Map) {
                this.load(strKey, (Map)entry.getValue(), bOverwrite);
                continue;
            }
            if (!bOverwrite && this.containsParam(strKey)) continue;
            this.setParam(strKey, entry.getValue());
        }
    }

    @Override
    public void setParams(String pkey, Map<String, Object> params) {
        this.load(pkey, params, true);
    }

    @Override
    public void setParamsIf(String pkey, Map<String, Object> params) {
        this.load(pkey, params, false);
    }

    @Override
    public void setParam(String key, Object objValue) {
        Assert.hasLength((String)key, (String)"\u4f20\u5165\u952e\u540d\u4e3a\u7a7a");
        if (objValue != null) {
            this.paramMap.put(key.toLowerCase(), objValue);
        } else {
            this.paramMap.remove(key.toLowerCase());
        }
    }

    @Override
    public String getParam(String key, String strDefault) {
        Object objValue = this.getParam(key);
        if (objValue != null) {
            if (objValue instanceof String) {
                if (!ObjectUtils.isEmpty((Object)objValue)) {
                    return (String)objValue;
                }
            } else {
                return objValue.toString();
            }
        }
        return strDefault;
    }

    @Override
    public int getParam(String key, int defaultValue) throws Exception {
        Object objValue = this.getParam(key);
        if (objValue != null) {
            return DataTypeUtils.getIntegerValue((Object)objValue, (Integer)defaultValue);
        }
        return defaultValue;
    }

    @Override
    public long getParam(String key, long defaultValue) throws Exception {
        Object objValue = this.getParam(key);
        if (objValue != null) {
            return DataTypeUtils.getLongValue((Object)objValue, (Long)defaultValue);
        }
        return defaultValue;
    }

    @Override
    public double getParam(String key, double defaultValue) throws Exception {
        Object objValue = this.getParam(key);
        if (objValue != null) {
            return DataTypeUtils.getDoubleValue((Object)objValue, (Double)defaultValue);
        }
        return defaultValue;
    }

    @Override
    public boolean getParam(String key, boolean bDefault) throws Exception {
        Object objValue = this.getParam(key);
        if (objValue != null) {
            return DataTypeUtils.getBooleanValue((Object)objValue, (Boolean)bDefault);
        }
        return bDefault;
    }

    @Override
    public Object getParam(String key) {
        Assert.hasLength((String)key, (String)"\u4f20\u5165\u952e\u540d\u4e3a\u7a7a");
        return this.paramMap.get(key.toLowerCase());
    }

    @Override
    public boolean containsParam(String key) {
        Assert.hasLength((String)key, (String)"\u4f20\u5165\u952e\u540d\u4e3a\u7a7a");
        return this.paramMap.containsKey(key.toLowerCase());
    }

    @Override
    public Map<String, Object> getParams(String pkey, Map<String, Object> params) {
        String pkeyPrefix = (pkey + ".").toLowerCase();
        int nPKeyLength = pkeyPrefix.length();
        for (Map.Entry<String, Object> entry : this.paramMap.entrySet()) {
            int nPos = entry.getKey().indexOf(pkeyPrefix);
            if (nPos != 0) continue;
            String key = entry.getKey().substring(nPKeyLength);
            if (params == null) {
                params = new HashMap<String, Object>();
            }
            params.put(key, entry.getValue());
        }
        return params;
    }

    @Override
    public void removeParam(String key) {
        Assert.hasLength((String)key, (String)"\u4f20\u5165\u952e\u540d\u4e3a\u7a7a");
        this.paramMap.remove(key.toLowerCase());
    }

    @Override
    public void removeParams(String pkey) {
        Map<String, Object> params = this.getParams(pkey, null);
        if (!ObjectUtils.isEmpty(params)) {
            this.removeParams(params.keySet());
        }
    }

    @Override
    public void removeParams(Set<String> keys) {
        Assert.notEmpty(keys, (String)"\u4f20\u5165\u952e\u540d\u96c6\u5408\u4e3a\u7a7a");
        for (String key : keys) {
            this.removeParam(key);
        }
    }

    @Override
    public IPSSystemEngine<?> getPSSystemEngine() {
        return this.iPSSystemEngine;
    }

    @Override
    public IPSSystemLogger getPSSystemLogger() {
        return this.iPSSystemLogger;
    }

    @Override
    public IPSSystemUtil getPSSystemUtil() {
        return this.iPSSystemUtil;
    }

    @Override
    public <T extends IPSModelEngine<?>> T getPSModelEngine(IPSModelObject iPSModelObject, Class<T> psModelEngineCls) throws Exception {
        return this.getPSModelEngine(iPSModelObject, psModelEngineCls, null);
    }

    @Override
    public <T extends IPSModelEngine<?>> T getPSModelEngine(IPSModelObject iPSModelObject, Class<T> psModelEngineCls, String subType) throws Exception {
        IPSSysSFPlugin iPSSysSFPlugin;
        String psModelEngineTag = this.getPSModelEngineTag(iPSModelObject, psModelEngineCls);
        IPSModelEngine<Object> engine = this.psModelEngineMap.get(psModelEngineTag);
        if (engine != null) {
            return (T)engine;
        }
        if (iPSModelObject instanceof IPSSysSFPluginSupportable && (iPSSysSFPlugin = ((IPSSysSFPluginSupportable)iPSModelObject).getPSSysSFPlugin()) != null) {
            IPSSysSFPluginEngine iPSSysSFPluginEngine = this.getPSModelEngine((IPSModelObject)iPSSysSFPlugin, IPSSysSFPluginEngine.class, null);
            engine = iPSSysSFPluginEngine.getRuntimeObject(psModelEngineCls, true);
        }
        if (engine == null) {
            if (!StringUtils.hasLength((String)subType)) {
                subType = this.getPSModelSubType(iPSModelObject, psModelEngineCls);
            }
            if ((engine = this.iPSModelEngineFactory.getObject(psModelEngineCls, subType)) == null) {
                if (StringUtils.hasLength((String)subType)) {
                    engine = this.iPSModelEngineFactory.getObject(psModelEngineCls, null);
                }
                if (engine == null) {
                    if (StringUtils.hasLength((String)subType)) {
                        throw new Exception(String.format("\u65e0\u6cd5\u5efa\u7acb\u6a21\u578b\u5bf9\u8c61[%1$s][%2$s]\u5f15\u64ce\u5bf9\u8c61", iPSModelObject, subType));
                    }
                    throw new Exception(String.format("\u65e0\u6cd5\u5efa\u7acb\u6a21\u578b\u5bf9\u8c61[%1$s]\u5f15\u64ce\u5bf9\u8c61", iPSModelObject));
                }
            }
        }
        IPSModelEngine<?> iPSModelEngine = engine;
        try {
            iPSModelEngine.init(this, psModelEngineTag, iPSModelObject);
        }
        catch (Exception ex) {
            throw new Exception(String.format("\u521d\u59cb\u5316\u6a21\u578b\u5bf9\u8c61[%1$s]\u5f15\u64ce\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSModelObject, ex.getMessage()));
        }
        this.psModelEngineMap.put(psModelEngineTag, iPSModelEngine);
        return (T)iPSModelEngine;
    }

    protected String getPSModelEngineTag(IPSModelObject iPSModelObject, Class<?> psModelEngineCls) throws Exception {
        String modelTag = PSModelUtils.calcFullUniqueTag((IPSModelObject)iPSModelObject, (boolean)true);
        if (!StringUtils.hasLength((String)modelTag)) {
            throw new Exception(String.format("\u65e0\u6cd5\u8ba1\u7b97\u6a21\u578b\u5bf9\u8c61[%1$s]\u6807\u8bb0", iPSModelObject));
        }
        return String.format("%1$s.%2$s", psModelEngineCls.getSimpleName(), modelTag);
    }

    @Override
    public <T extends IPSModelEngineAddin<?, ?>> T getPSModelEngineAddin(IPSModelEngine<?> iPSModelEngine, Object data, Class<T> psModelEngineCls) throws Exception {
        return this.getPSModelEngineAddin(iPSModelEngine, data, psModelEngineCls, null);
    }

    @Override
    public <T extends IPSModelEngineAddin<?, ?>> T getPSModelEngineAddin(IPSModelEngine<?> iPSModelEngine, Object data, Class<T> psModelEngineCls, String subType) throws Exception {
        IPSSysSFPlugin iPSSysSFPlugin;
        IPSModelEngineAddin addin = null;
        if (data instanceof IPSSysSFPluginSupportable && (iPSSysSFPlugin = ((IPSSysSFPluginSupportable)data).getPSSysSFPlugin()) != null) {
            IPSSysSFPluginEngine iPSSysSFPluginEngine = this.getPSModelEngine((IPSModelObject)iPSSysSFPlugin, IPSSysSFPluginEngine.class, null);
            addin = (IPSModelEngineAddin)iPSSysSFPluginEngine.getRuntimeObject(psModelEngineCls, true);
        }
        if (addin == null) {
            if (!StringUtils.hasLength((String)subType) && data instanceof IPSModelObject) {
                subType = this.getPSModelSubType((IPSModelObject)data, psModelEngineCls);
            }
            if ((addin = (IPSModelEngineAddin)this.iPSModelEngineFactory.getObject(psModelEngineCls, subType)) == null) {
                if (StringUtils.hasLength((String)subType)) {
                    addin = (IPSModelEngineAddin)this.iPSModelEngineFactory.getObject(psModelEngineCls, null);
                }
                if (addin == null) {
                    if (StringUtils.hasLength((String)subType)) {
                        throw new Exception(String.format("\u65e0\u6cd5\u5efa\u7acb\u6a21\u578b\u5f15\u64ce\u63d2\u4ef6[%1$s][%2$s]", psModelEngineCls.getSimpleName(), subType));
                    }
                    throw new Exception(String.format("\u65e0\u6cd5\u5efa\u7acb\u6a21\u578b\u5f15\u64ce\u63d2\u4ef6[%1$s]\u5f15\u64ce\u5bf9\u8c61", psModelEngineCls.getSimpleName()));
                }
            }
        }
        try {
            addin.init(this, iPSModelEngine, data);
            return (T)addin;
        }
        catch (Exception ex) {
            throw new Exception(String.format("\u521d\u59cb\u5316\u6a21\u578b\u5f15\u64ce\u63d2\u4ef6[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", psModelEngineCls.getSimpleName(), ex.getMessage()));
        }
    }

    protected String getPSModelSubType(IPSModelObject iPSModelObject, Class<?> psModelEngineCls) {
        BiFunction<IPSModelEngineHolder, IPSModelObject, String> biFunction = PSModelSubTypeFunctionMap.get(psModelEngineCls.getSimpleName());
        if (biFunction != null) {
            return biFunction.apply(this, iPSModelObject);
        }
        return null;
    }

    static {
        PSModelSubTypeFunctionMap.put(IPSSysDataSyncAgentEngine.class.getSimpleName(), new BiFunction<IPSModelEngineHolder, IPSModelObject, String>(){

            @Override
            public String apply(IPSModelEngineHolder iPSModelEngineHolder, IPSModelObject iPSModelObject) {
                IPSSysDataSyncAgent iPSSysDataSyncAgent = (IPSSysDataSyncAgent)iPSModelObject;
                String configFolder = "syseaiagent." + PSModelUtils.calcUniqueTag((IPSSystemModule)iPSSysDataSyncAgent.getPSSystemModule(), (String)iPSSysDataSyncAgent.getCodeName());
                return iPSModelEngineHolder.getParam(configFolder + ".agenttype", iPSSysDataSyncAgent.getAgentType());
            }
        });
        PSModelSubTypeFunctionMap.put(IPSSubSysServiceAPIEngine.class.getSimpleName(), new BiFunction<IPSModelEngineHolder, IPSModelObject, String>(){

            @Override
            public String apply(IPSModelEngineHolder iPSModelEngineHolder, IPSModelObject iPSModelObject) {
                IPSSubSysServiceAPI iPSSubSysServiceAPI = (IPSSubSysServiceAPI)iPSModelObject;
                return iPSSubSysServiceAPI.getServiceType();
            }
        });
        PSModelSubTypeFunctionMap.put(IPSSysUtilEngine.class.getSimpleName(), new BiFunction<IPSModelEngineHolder, IPSModelObject, String>(){

            @Override
            public String apply(IPSModelEngineHolder iPSModelEngineHolder, IPSModelObject iPSModelObject) {
                IPSSysUtil iPSSysUtil = (IPSSysUtil)iPSModelObject;
                if (PSModelEnums.SysUtilType.USER.value.equals(iPSSysUtil.getUtilType())) {
                    return String.format("%1$s:%2$s", iPSSysUtil.getUtilType(), iPSSysUtil.getUtilTag());
                }
                return iPSSysUtil.getUtilType();
            }
        });
        PSModelSubTypeFunctionMap.put(IPSDELogicNodeAddin.class.getSimpleName(), new BiFunction<IPSModelEngineHolder, IPSModelObject, String>(){

            @Override
            public String apply(IPSModelEngineHolder iPSModelEngineHolder, IPSModelObject iPSModelObject) {
                IPSDELogicNode iPSDELogicNode = (IPSDELogicNode)iPSModelObject;
                return iPSDELogicNode.getLogicNodeType();
            }
        });
        PSModelSubTypeFunctionMap.put(IPSDEDataFlowNodeAddin.class.getSimpleName(), new BiFunction<IPSModelEngineHolder, IPSModelObject, String>(){

            @Override
            public String apply(IPSModelEngineHolder iPSModelEngineHolder, IPSModelObject iPSModelObject) {
                IPSDEDataFlowNode iPSDEDataFlowNode = (IPSDEDataFlowNode)iPSModelObject;
                return iPSDEDataFlowNode.getNodeType();
            }
        });
        PSModelSubTypeFunctionMap.put(IPSDEMethodDTOEngine.class.getSimpleName(), new BiFunction<IPSModelEngineHolder, IPSModelObject, String>(){

            @Override
            public String apply(IPSModelEngineHolder iPSModelEngineHolder, IPSModelObject iPSModelObject) {
                IPSDEMethodDTO iPSDEMethodDTO = (IPSDEMethodDTO)iPSModelObject;
                return iPSDEMethodDTO.getType();
            }
        });
    }
}

