/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.engine;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.engine.IPSModelEngineFactory;
import net.ibizsys.model.engine.IPSSystemLogger;
import net.ibizsys.model.engine.IPSSystemUtil;
import net.ibizsys.model.engine.PSSystemLogger;
import net.ibizsys.model.engine.PSSystemUtil;
import net.ibizsys.model.engine.dataentity.action.PSDEActionInputDTOEngine;
import net.ibizsys.model.engine.dataentity.ds.PSDEFilterDTOEngine;
import net.ibizsys.model.engine.dataentity.service.IPSDEMethodDTOEngine;
import net.ibizsys.model.engine.dataentity.service.PSDEMethodDTOEngine;
import net.ibizsys.model.engine.service.IPSSubSysServiceAPIEngine;
import net.ibizsys.model.engine.service.PSSubSysServiceAPIEngine;
import net.ibizsys.model.engine.service.client.IWebClient;
import net.ibizsys.model.engine.service.client.WebClient;
import net.ibizsys.model.engine.sysutil.IPSSysUtilEngine;
import net.ibizsys.model.engine.sysutil.PSSysUtilEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class PSModelEngineFactoryBase
implements IPSModelEngineFactory {
    private static final Log log = LogFactory.getLog(PSModelEngineFactoryBase.class);
    private Map<String, EngineObject> engineObjectMap = new ConcurrentHashMap<String, EngineObject>();
    private Map<String, Map> engineObjectListMap = new ConcurrentHashMap<String, Map>();

    public PSModelEngineFactoryBase() {
        this.prepareEngineObjects();
    }

    protected void prepareEngineObjects() {
        this.registerObjectIf(IPSDEMethodDTOEngine.class, PSModelEnums.DEMethodDTOType.DEFAULT.value, PSDEMethodDTOEngine.class);
        this.registerObjectIf(IPSDEMethodDTOEngine.class, PSModelEnums.DEMethodDTOType.DEFILTER.value, PSDEFilterDTOEngine.class);
        this.registerObjectIf(IPSDEMethodDTOEngine.class, PSModelEnums.DEMethodDTOType.DEDATASETINPUT.value, PSDEFilterDTOEngine.class);
        this.registerObjectIf(IPSDEMethodDTOEngine.class, PSModelEnums.DEMethodDTOType.DEACTIONINPUT.value, PSDEActionInputDTOEngine.class);
        this.registerObjectIf(IPSSystemLogger.class, null, PSSystemLogger.class);
        this.registerObjectIf(IPSSystemUtil.class, null, PSSystemUtil.class);
        this.registerObjectIf(IPSSysUtilEngine.class, null, PSSysUtilEngine.class);
        this.registerObjectIf(IPSSubSysServiceAPIEngine.class, null, PSSubSysServiceAPIEngine.class);
        this.registerObjectIf(IWebClient.class, null, WebClient.class);
    }

    protected boolean registerEngineObject(Class<?> cls, String type, Object objObject) {
        return this.registerEngineObject(cls, type, objObject, 100);
    }

    protected boolean registerEngineObject(Class<?> cls, String type, Object objObject, int order) {
        EngineObject lastObject;
        String strTag = null;
        strTag = StringUtils.hasLength((String)type) ? String.format("%1$s|%2$s", this.getObjectType(cls), type) : String.format("%1$s|", this.getObjectType(cls));
        if (objObject instanceof String) {
            try {
                objObject = Class.forName((String)((Object)objObject));
            }
            catch (Exception ex) {
                return false;
            }
        }
        if ((lastObject = this.engineObjectMap.get(strTag)) != null) {
            if (order > lastObject.order) {
                log.warn((Object)String.format("\u65e0\u6cd5\u6ce8\u518c\u5f15\u64ce\u5bf9\u8c61[%1$s][%2$s]\uff0c\u4f18\u5148\u7ea7\u4e0d\u8db3", objObject, strTag));
                return false;
            }
            log.warn((Object)String.format("\u6ce8\u518c\u5f15\u64ce\u5bf9\u8c61[%1$s][%2$s]\uff0c\u66ff\u6362[%3$s]", objObject, strTag, lastObject.object));
        } else {
            log.debug((Object)String.format("\u6ce8\u518c\u5f15\u64ce\u5bf9\u8c61[%1$s][%2$s]", objObject, strTag));
        }
        EngineObject runtimeObject = new EngineObject();
        runtimeObject.object = objObject;
        runtimeObject.order = order;
        this.engineObjectMap.put(strTag, runtimeObject);
        return true;
    }

    @Override
    public boolean registerObject(Class<?> cls, String type, Object objectType) {
        return this.registerObject(cls, type, objectType, 100);
    }

    @Override
    public boolean registerObjectPrimary(Class<?> cls, String type, Object objectType) {
        return this.registerObject(cls, type, objectType, 50);
    }

    @Override
    public boolean registerObject(Class<?> cls, String type, Object objectType, int orderValue) {
        return this.registerEngineObject(cls, type, objectType, orderValue);
    }

    @Override
    public boolean registerObjectIf(Class<?> cls, String type, Object objectType) {
        if (this.containsObject(cls, type)) {
            return false;
        }
        return this.registerObject(cls, type, objectType);
    }

    @Override
    public boolean containsObject(Class<?> cls, String type) {
        EngineObject runtimeObject = null;
        runtimeObject = StringUtils.hasLength((String)type) ? this.engineObjectMap.get(String.format("%1$s|%2$s", this.getObjectType(cls), type)) : this.engineObjectMap.get(String.format("%1$s|", this.getObjectType(cls)));
        return !ObjectUtils.isEmpty((Object)runtimeObject);
    }

    @Override
    public <T> T getObject(Class<T> cls) {
        return this.getObject(cls, "");
    }

    @Override
    public <T> T getObject(Class<T> cls, String type) {
        EngineObject runtimeObject = null;
        runtimeObject = StringUtils.hasLength((String)type) ? this.engineObjectMap.get(String.format("%1$s|%2$s", this.getObjectType(cls), type)) : this.engineObjectMap.get(String.format("%1$s|", this.getObjectType(cls)));
        if (ObjectUtils.isEmpty((Object)runtimeObject)) {
            return null;
        }
        return this.getObject(cls, runtimeObject, false);
    }

    @Override
    public Class<?> getObjectClass(Class<?> cls) {
        return this.getObjectClass(cls, "");
    }

    @Override
    public Class<?> getObjectClass(Class<?> cls, String type) {
        EngineObject runtimeObject = null;
        runtimeObject = StringUtils.hasLength((String)type) ? this.engineObjectMap.get(String.format("%1$s|%2$s", this.getObjectType(cls), type)) : this.engineObjectMap.get(String.format("%1$s|", this.getObjectType(cls)));
        if (ObjectUtils.isEmpty((Object)runtimeObject)) {
            return null;
        }
        Object obj = runtimeObject.object;
        if (obj == null) {
            return null;
        }
        if (obj instanceof Class) {
            return (Class)obj;
        }
        if (obj instanceof String) {
            try {
                return Class.forName((String)obj);
            }
            catch (Exception ex) {
                log.warn((Object)String.format("\u5f15\u64ce\u5bf9\u8c61[%1$s]\u4e0d\u5b58\u5728", obj));
                return null;
            }
        }
        return obj.getClass();
    }

    @Override
    public <T> Map<String, T> getObjects(Class<T> cls) {
        return this.getObjects(cls, null);
    }

    @Override
    public <T> Map<String, T> getObjects(Class<T> cls, String typePrefix) {
        String strTag = null;
        strTag = StringUtils.hasLength((String)typePrefix) ? String.format("%1$s|%2$s", this.getObjectType(cls), typePrefix) : String.format("%1$s|", this.getObjectType(cls));
        Map objMap = this.engineObjectListMap.get(strTag);
        if (objMap != null) {
            return objMap;
        }
        HashMap<String, T> map = new HashMap<String, T>();
        for (Map.Entry<String, EngineObject> entry : this.engineObjectMap.entrySet()) {
            T t;
            if (entry.getKey().indexOf(strTag) != 0 || (t = this.getObject(cls, entry.getValue(), true)) == null) continue;
            map.put(entry.getKey().substring(this.getObjectType(cls).length() + 1), t);
        }
        this.engineObjectListMap.put(strTag, map);
        return map;
    }

    protected <T> T getObject(Class<T> cls, EngineObject runtimeObject, boolean bTryMode) {
        Object obj = runtimeObject.object;
        if (obj instanceof Class) {
            Object objInstance;
            try {
                objInstance = this.createObject(obj);
            }
            catch (Exception e) {
                if (bTryMode) {
                    log.warn((Object)String.format("\u65e0\u6cd5\u5efa\u7acb\u5f15\u64ce\u5bf9\u8c61[%1$s]", obj));
                    return null;
                }
                throw new RuntimeException(e);
            }
            if (cls.isAssignableFrom(objInstance.getClass())) {
                return (T)objInstance;
            }
        } else if (obj instanceof String) {
            Object objInstance;
            try {
                objInstance = this.createObject(obj);
            }
            catch (Exception e) {
                if (bTryMode) {
                    log.warn((Object)String.format("\u65e0\u6cd5\u5efa\u7acb\u5f15\u64ce\u5bf9\u8c61[%1$s]", obj));
                    return null;
                }
                throw new RuntimeException(e);
            }
            if (cls.isAssignableFrom(objInstance.getClass())) {
                return (T)objInstance;
            }
        } else if (cls.isAssignableFrom(obj.getClass())) {
            return (T)obj;
        }
        if (bTryMode) {
            return null;
        }
        throw new RuntimeException(String.format("[%1$s]\u7c7b\u578b\u4e0d\u6b63\u786e", obj));
    }

    protected String getObjectType(Class<?> cls) {
        return cls.getSimpleName();
    }

    protected Object createObject(Object objCls) throws Exception {
        Assert.notNull((Object)objCls, (String)"\u4f20\u5165\u5bf9\u8c61\u7c7b\u578b\u65e0\u6548");
        if (objCls instanceof Class) {
            return ((Class)objCls).newInstance();
        }
        return Class.forName(objCls.toString()).newInstance();
    }

    static class EngineObject {
        public Object object = null;
        public int order = 100;
    }
}

