/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.engine.groovy.support;

import java.util.Map;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.engine.plugin.IPSModelEngineAddin;
import net.ibizsys.model.engine.plugin.PSModelEngineAddinException;
import net.ibizsys.model.engine.service.IPSSubSysServiceAPIEngine;
import net.ibizsys.model.engine.service.client.IWebClient;
import net.ibizsys.model.engine.service.client.IWebClientRep;
import net.ibizsys.model.engine.service.client.IWebClientRepEntity;
import net.ibizsys.model.engine.service.client.WebClientRepEntity;
import net.ibizsys.model.util.DataTypeUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class PSSubSysServiceAPIEngineExtension {
    static final String METHOD_DOWNLOAD = "DOWNLOAD";
    static final String METHOD_UPLOAD = "UPLOAD";

    public static IWebClientRepEntity get(IWebClient webClient, Object param) {
        return PSSubSysServiceAPIEngineExtension.execute(webClient, PSModelEnums.RequestMethod.GET.value, param);
    }

    public static IWebClientRepEntity post(IWebClient webClient, Object param) {
        return PSSubSysServiceAPIEngineExtension.execute(webClient, PSModelEnums.RequestMethod.POST.value, param);
    }

    public static IWebClientRepEntity head(IWebClient webClient, Object param) {
        return PSSubSysServiceAPIEngineExtension.execute(webClient, PSModelEnums.RequestMethod.HEAD.value, param);
    }

    public static IWebClientRepEntity put(IWebClient webClient, Object param) {
        return PSSubSysServiceAPIEngineExtension.execute(webClient, PSModelEnums.RequestMethod.PUT.value, param);
    }

    public static IWebClientRepEntity patch(IWebClient webClient, Object param) {
        return PSSubSysServiceAPIEngineExtension.execute(webClient, PSModelEnums.RequestMethod.PATCH.value, param);
    }

    public static IWebClientRepEntity delete(IWebClient webClient, Object param) {
        return PSSubSysServiceAPIEngineExtension.execute(webClient, PSModelEnums.RequestMethod.DELETE.value, param);
    }

    public static IWebClientRepEntity options(IWebClient webClient, Object param) {
        return PSSubSysServiceAPIEngineExtension.execute(webClient, PSModelEnums.RequestMethod.OPTIONS.value, param);
    }

    public static IWebClientRepEntity trace(IWebClient webClient, Object param) {
        return PSSubSysServiceAPIEngineExtension.execute(webClient, PSModelEnums.RequestMethod.TRACE.value, param);
    }

    public static IWebClientRepEntity upload(IWebClient webClient, Object param) {
        return PSSubSysServiceAPIEngineExtension.execute(webClient, METHOD_UPLOAD, param);
    }

    public static IWebClientRepEntity download(IWebClient webClient, Object param) {
        return PSSubSysServiceAPIEngineExtension.execute(webClient, METHOD_DOWNLOAD, param);
    }

    public static IWebClientRepEntity execute(IWebClient webClient, String method, Object param) {
        Assert.hasLength((String)method, (String)"\u672a\u4f20\u5165\u8bf7\u6c42\u65b9\u5f0f");
        if (ObjectUtils.isEmpty((Object)param)) {
            throw new PSModelEngineAddinException((IPSModelEngineAddin)webClient, String.format("\u4f20\u5165\u53c2\u6570\u65e0\u6548", new Object[0]));
        }
        String strUri = null;
        Map uriParams = null;
        Map headers = null;
        Map queries = null;
        Object objBody = null;
        Object objTag = null;
        String strContentType = null;
        if (param instanceof String) {
            strUri = (String)param;
        } else if (param instanceof Map) {
            Map map = (Map)param;
            Object obj = map.get("uri");
            if (obj instanceof String) {
                strUri = (String)obj;
            } else {
                obj = map.get("url");
                if (obj instanceof String) {
                    strUri = (String)obj;
                }
            }
            obj = map.get("param");
            if (obj instanceof Map && (uriParams = (Map)obj).size() == 0) {
                uriParams = null;
            }
            if ((obj = map.get("header")) instanceof Map && (headers = (Map)obj).size() == 0) {
                headers = null;
            }
            if ((obj = map.get("query")) instanceof Map && (queries = (Map)obj).size() == 0) {
                queries = null;
            }
            if ((obj = map.get("contenttype")) instanceof String) {
                strContentType = (String)obj;
            }
            objBody = map.get("body");
            objTag = map.get("tag");
        } else {
            throw new PSModelEngineAddinException((IPSModelEngineAddin)webClient, String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u4f20\u5165\u53c2\u6570", new Object[0]));
        }
        if (!StringUtils.hasLength((String)strUri)) {
            throw new PSModelEngineAddinException((IPSModelEngineAddin)webClient, String.format("\u672a\u4f20\u5165\u8fdc\u7a0b\u8def\u5f84", new Object[0]));
        }
        try {
            if (PSModelEnums.RequestMethod.GET.value.equalsIgnoreCase(method)) {
                if (queries == null && objBody instanceof Map) {
                    queries = objBody;
                }
                return WebClientRepEntity.from((IWebClientRep)webClient.get(strUri, uriParams, headers, queries, String.class, objTag));
            }
            if (PSModelEnums.RequestMethod.POST.value.equalsIgnoreCase(method)) {
                return WebClientRepEntity.from((IWebClientRep)webClient.post(strUri, uriParams, headers, queries, objBody, strContentType, String.class, objTag));
            }
            if (PSModelEnums.RequestMethod.PUT.value.equalsIgnoreCase(method)) {
                return WebClientRepEntity.from((IWebClientRep)webClient.put(strUri, uriParams, headers, queries, objBody, strContentType, String.class, objTag));
            }
            if (PSModelEnums.RequestMethod.PATCH.value.equalsIgnoreCase(method)) {
                return WebClientRepEntity.from((IWebClientRep)webClient.patch(strUri, uriParams, headers, queries, objBody, strContentType, String.class, objTag));
            }
            if (PSModelEnums.RequestMethod.DELETE.value.equalsIgnoreCase(method)) {
                if (queries == null && objBody instanceof Map) {
                    queries = objBody;
                }
                return WebClientRepEntity.from((IWebClientRep)webClient.delete(strUri, uriParams, headers, queries, String.class, objTag));
            }
            if (PSModelEnums.RequestMethod.HEAD.value.equalsIgnoreCase(method)) {
                if (queries == null && objBody instanceof Map) {
                    queries = objBody;
                }
                return WebClientRepEntity.from((IWebClientRep)webClient.head(strUri, uriParams, headers, queries, String.class, objTag));
            }
            if (METHOD_UPLOAD.equalsIgnoreCase(method)) {
                return WebClientRepEntity.from((IWebClientRep)webClient.upload(strUri, uriParams, headers, queries, objBody, objTag));
            }
            if (METHOD_DOWNLOAD.equalsIgnoreCase(method)) {
                return WebClientRepEntity.from((IWebClientRep)webClient.download(strUri, uriParams, headers, queries, objBody, objTag));
            }
            throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u8bf7\u6c42\u65b9\u5f0f[%1$s]", method));
        }
        catch (Throwable ex) {
            throw new PSModelEngineAddinException((IPSModelEngineAddin)webClient, ex.getMessage(), ex);
        }
    }

    public static void tokenExpireIn(IPSSubSysServiceAPIEngine iPSSubSysServiceAPIEngine, Object objTime) throws Throwable {
        int seconds;
        if (objTime != null && (seconds = DataTypeUtils.getIntegerValue((Object)objTime, (Integer)-1).intValue()) > 0) {
            iPSSubSysServiceAPIEngine.tokenExpireIn(seconds);
        }
    }
}

