package net.ibizsys.model.engine.groovy.support;

import java.util.Map;

import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import net.ibizsys.model.PSModelEnums.RequestMethod;
import net.ibizsys.model.engine.plugin.PSModelEngineAddinException;
import net.ibizsys.model.engine.service.IPSSubSysServiceAPIEngine;
import net.ibizsys.model.engine.service.client.IWebClient;
import net.ibizsys.model.engine.service.client.IWebClientRepEntity;
import net.ibizsys.model.engine.service.client.WebClientRepEntity;
import net.ibizsys.model.util.DataTypeUtils;

public class PSSubSysServiceAPIEngineExtension {

	/**
	 * 扩展方式：下载文件
	 */
	final static String METHOD_DOWNLOAD = "DOWNLOAD";

	/**
	 * 扩展方式：上传文件
	 */
	final static String METHOD_UPLOAD = "UPLOAD";

	public static IWebClientRepEntity get(IWebClient webClient, Object param) {
		return execute(webClient, RequestMethod.GET.value, param);
	}

	public static IWebClientRepEntity post(IWebClient webClient, Object param) {
		return execute(webClient, RequestMethod.POST.value, param);
	}

	public static IWebClientRepEntity head(IWebClient webClient, Object param) {
		return execute(webClient, RequestMethod.HEAD.value, param);
	}

	public static IWebClientRepEntity put(IWebClient webClient, Object param) {
		return execute(webClient, RequestMethod.PUT.value, param);
	}

	public static IWebClientRepEntity patch(IWebClient webClient, Object param) {
		return execute(webClient, RequestMethod.PATCH.value, param);
	}

	public static IWebClientRepEntity delete(IWebClient webClient, Object param) {
		return execute(webClient, RequestMethod.DELETE.value, param);
	}

	public static IWebClientRepEntity options(IWebClient webClient, Object param) {
		return execute(webClient, RequestMethod.OPTIONS.value, param);
	}

	public static IWebClientRepEntity trace(IWebClient webClient, Object param) {
		return execute(webClient, RequestMethod.TRACE.value, param);
	}

	public static IWebClientRepEntity upload(IWebClient webClient, Object param) {
		return execute(webClient, METHOD_UPLOAD, param);
	}

	public static IWebClientRepEntity download(IWebClient webClient, Object param) {
		return execute(webClient, METHOD_DOWNLOAD, param);
	}

	public static IWebClientRepEntity execute(IWebClient webClient, String method, Object param) {
		Assert.hasLength(method, "未传入请求方式");
		// Assert.notEmpty(param, "未传入请求cans");
		if (ObjectUtils.isEmpty(param)) {
			throw new PSModelEngineAddinException(webClient, String.format("传入参数无效"));
		}

		String strUri = null;
		Map<String, Object> uriParams = null;
		Map<String, Object> headers = null;
		Map<String, Object> queries = null;
		Object objBody = null;
		Object objTag = null;
		String strContentType = null;
		if (param instanceof String) {
			strUri = (String) param;
		} else if (param instanceof Map) {
			Map map = (Map) param;
			Object obj = map.get("uri");
			if (obj instanceof String) {
				strUri = (String) obj;
			} else {
				obj = map.get("url");
				if (obj instanceof String) {
					strUri = (String) obj;
				}
			}

			obj = map.get("param");
			if (obj instanceof Map) {
				uriParams = (Map) obj;
				if (uriParams.size() == 0) {
					uriParams = null;
				}
			}

			obj = map.get("header");
			if (obj instanceof Map) {
				headers = (Map) obj;
				if (headers.size() == 0) {
					headers = null;
				}
			}

			obj = map.get("query");
			if (obj instanceof Map) {
				queries = (Map) obj;
				if (queries.size() == 0) {
					queries = null;
				}
			}

			obj = map.get("contenttype");
			if (obj instanceof String) {
				strContentType = (String) obj;
			}

			objBody = map.get("body");
			objTag = map.get("tag");

		} else
			throw new PSModelEngineAddinException(webClient, String.format("无法识别的传入参数"));

		if (!StringUtils.hasLength(strUri)) {
			throw new PSModelEngineAddinException(webClient, String.format("未传入远程路径"));
		}

		try {

			if (RequestMethod.GET.value.equalsIgnoreCase(method)) {
				if (queries == null) {
					if (objBody instanceof Map) {
						queries = (Map) objBody;
					}
				}
				return WebClientRepEntity.from(webClient.get(strUri, uriParams, headers, queries, String.class, objTag));
			}
			if (RequestMethod.POST.value.equalsIgnoreCase(method)) {
				return WebClientRepEntity.from(webClient.post(strUri, uriParams, headers, queries, objBody, strContentType, String.class, objTag));
			}
			if (RequestMethod.PUT.value.equalsIgnoreCase(method)) {
				return WebClientRepEntity.from(webClient.put(strUri, uriParams, headers, queries, objBody, strContentType, String.class, objTag));
			}
			if (RequestMethod.PATCH.value.equalsIgnoreCase(method)) {
				return WebClientRepEntity.from(webClient.patch(strUri, uriParams, headers, queries, objBody, strContentType, String.class, objTag));
			}

			if (RequestMethod.DELETE.value.equalsIgnoreCase(method)) {
				if (queries == null) {
					if (objBody instanceof Map) {
						queries = (Map) objBody;
					}
				}
				return WebClientRepEntity.from(webClient.delete(strUri, uriParams, headers, queries, String.class, objTag));
			}

			if (RequestMethod.HEAD.value.equalsIgnoreCase(method)) {
				if (queries == null) {
					if (objBody instanceof Map) {
						queries = (Map) objBody;
					}
				}
				return WebClientRepEntity.from(webClient.head(strUri, uriParams, headers, queries, String.class, objTag));
			}

			if (METHOD_UPLOAD.equalsIgnoreCase(method)) {
				return WebClientRepEntity.from(webClient.upload(strUri, uriParams, headers, queries, objBody, objTag));
			}

			if (METHOD_DOWNLOAD.equalsIgnoreCase(method)) {
				return WebClientRepEntity.from(webClient.download(strUri, uriParams, headers, queries, objBody, objTag));
			}


			throw new Exception(String.format("无法识别的请求方式[%1$s]", method));

		} catch (Throwable ex) {
			// throw new SystemRuntimeException(this.getSystemRuntime(),
			// this.getModelRuntime(), String.format("Web请求发生异常，%1$s",
			// ex.getMessage()), ex);
			throw new PSModelEngineAddinException(webClient, ex.getMessage(), ex);
		}
	}

	
	
	public static void tokenExpireIn(IPSSubSysServiceAPIEngine iPSSubSysServiceAPIEngine, Object objTime) throws Throwable {
		if(objTime != null) {
			int seconds = DataTypeUtils.getIntegerValue(objTime, -1);
			if(seconds > 0) {
				iPSSubSysServiceAPIEngine.tokenExpireIn(seconds);
			}
		}
	}
}
