package net.ibizsys.model.engine.groovy.res;

import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;

import org.springframework.util.StringUtils;

import groovy.lang.GroovyClassLoader;
import net.ibizsys.model.engine.res.PSSysSFPluginEngineBase;
import net.ibizsys.model.engine.util.KeyValueUtils;
import net.ibizsys.model.res.IPSSysSFPlugin;

public class GroovyPSSysSFPluginEngine extends PSSysSFPluginEngineBase<IPSSysSFPlugin> implements IGroovyPSSysSFPluginEngine<IPSSysSFPlugin> {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(GroovyPSSysSFPluginEngine.class);

	// private final static Map<String, Map<String, String>> GroovyRTCodeMapMap
	// = new HashMap<String, Map<String, String>>();
	private static Random random = new Random();

	private final static Map<String, String> GroovyRTCodeMap = new ConcurrentHashMap<>();
	private final static Map<String, Class<?>> GroovyRTClassMap = new ConcurrentHashMap<>();

	private boolean groovyRTObject = false;
	private Class<?> rtObjectClass = null;

	@Override
	protected void onInit() throws Exception {
		if (this.isRuntimePlugin()) {
			if (!StringUtils.hasLength(this.getRTObjectName())) {
				throw new Exception(String.format("系统后台插件[%1$s]设置为运行时组件但未指定组件名称", this.getName()));
			}
			try {

				if (this.getRTObjectName().indexOf(RTOBJECTNAME_GROOVY) == 0) {
					setGroovyRTObject(true);
					if (this.getRTObjectName().length() > RTOBJECTNAME_GROOVY.length() + 1) {
						this.setRTObjectName(this.getRTObjectName().substring(RTOBJECTNAME_GROOVY.length() + 1));
					} else {
						this.setRTObjectName(null);
					}
				}
				String strTemplCode = this.getRTObjectCode();
				if (!this.isGroovyRTObject()) {
					try {
						rtObjectClass = Class.forName(this.getRTObjectName());
						if (StringUtils.hasLength(strTemplCode)) {
							// 判断代码是否更新
							String strCodeTag = null;
							if (StringUtils.hasLength(rtObjectClass.getCanonicalName())) {
								strCodeTag = GroovyRTCodeMap.get(rtObjectClass.getCanonicalName());
							}

							if (!StringUtils.hasLength(strCodeTag)) {
								log.warn(String.format("系统后台插件[%1$s]使用内置组件[%2$s]，忽略动态代码", this.getName(), this.getRTObjectName()));
							} else {
								// 判断代码是否一致
								String strTag = KeyValueUtils.genUniqueId(strTemplCode);
								if (!strCodeTag.equals(strTag)) {
									log.warn(String.format("系统后台插件[%1$s]组件[%2$s]代码变化，重新编译", this.getName(), this.getRTObjectName()));
									this.rtObjectClass = null;
								}
							}
						}
					} catch (Exception ex) {
						if (!StringUtils.hasLength(strTemplCode)) {
							throw ex;
						}
						log.warn(String.format("系统后台插件[%1$s]使用动态代码构建组件[%2$s]", this.getName(), this.getRTObjectName()));
					}
				}

				if (this.rtObjectClass == null) {
					if (!StringUtils.hasLength(strTemplCode)) {
						throw new Exception(String.format("系统后台插件[%1$s]未指定Groovy代码", this.getName()));
					}
					String strTag = KeyValueUtils.genUniqueId(strTemplCode);
					rtObjectClass = GroovyRTClassMap.get(strTag);
					if (!this.getPSModelObject().isLazyMode()) {
						if (rtObjectClass == null) {
							try {
								// 判断代码中是否有包信息
								if (strTemplCode.indexOf("package ") == -1) {
									String strAutoPackage = String.format("package net.ibizsys.model.engine.groovy.plugin.a%1$s\r\n", random.nextInt(99999999));
									strTemplCode = strAutoPackage + strTemplCode;
								}
								try (GroovyClassLoader groovyClassLoader = new GroovyClassLoader()) {
									rtObjectClass = groovyClassLoader.parseClass(strTemplCode);
								}

								GroovyRTClassMap.put(strTag, rtObjectClass);
								if (StringUtils.hasLength(rtObjectClass.getCanonicalName())) {
									GroovyRTCodeMap.put(rtObjectClass.getCanonicalName(), strTag);
								}
							} catch (Exception ex) {
								log.error(ex);
								throw new Exception(String.format("系统后台插件[%1$s]指定组件[%2$s]编译发生异常，%3$s", this.getName(), this.getRTObjectName(), ex.getMessage()));
							}
						}
						this.setRTObjectCode(strTemplCode);
						this.setGroovyRTObject(true);
					} else {
						this.setGroovyRTObject(true);
					}
				}
			} catch (Exception ex) {
				throw ex;
			}
		}
		super.onInit();
	}

	// private void prepareSystemParams(String strSystemId) {
	//
	//
	// synchronized (groovyRTClassMapMap) {
	// this.groovyRTClassMap = groovyRTClassMapMap.get(strSystemId);
	// if(this.groovyRTClassMap == null) {
	// this.groovyRTClassMap = new ConcurrentHashMap<String, Class<?>>();
	// groovyRTClassMapMap.put(strSystemId, this.groovyRTClassMap);
	// }
	// }
	//
	// synchronized (groovyRTCodeMapMap) {
	// this.groovyRTCodeMap = groovyRTCodeMapMap.get(strSystemId);
	// if(this.groovyRTCodeMap == null) {
	// this.groovyRTCodeMap = new ConcurrentHashMap<String, String>();
	// groovyRTCodeMapMap.put(strSystemId, this.groovyRTCodeMap);
	// }
	// }
	//
	// synchronized (groovyHotCodeMapMap) {
	// this.groovyHotCodeMap = groovyHotCodeMapMap.get(strSystemId);
	// if(this.groovyHotCodeMap == null) {
	// this.groovyHotCodeMap = new ConcurrentHashMap<String, String>();
	// groovyHotCodeMapMap.put(strSystemId, this.groovyHotCodeMap);
	// }
	// }
	// }

	@Override
	protected Class<?> getRTObjectClass() {
		return rtObjectClass;
	}

	@Override
	public boolean isGroovyRTObject() {
		return this.groovyRTObject;
	}

	protected void setGroovyRTObject(boolean groovyRTObject) {
		this.groovyRTObject = groovyRTObject;
	}
}
