package net.ibizsys.model.engine.groovy.plugin;

import java.util.HashMap;
import java.util.Map;

import groovy.lang.Closure;
import net.ibizsys.model.engine.IPSModelEngine;
import net.ibizsys.model.engine.IPSModelEngineHolder;
import net.ibizsys.model.engine.IPSSystemEngine;
import net.ibizsys.model.engine.PSModelEngineException;
import net.ibizsys.model.engine.plugin.IPSModelEngineAddin;
import net.ibizsys.model.engine.plugin.IPSModelEngineScript;
import net.ibizsys.model.engine.plugin.PSModelEngineAddinException;
import net.ibizsys.model.engine.util.IAction;
import net.ibizsys.model.util.Errors;

/**
 * 模型运行时脚本插件基类
 * @author lionlau
 *
 */
public abstract class ScriptProxy extends groovy.lang.Script{

	private Object owner = null;
	private IPSModelEngineHolder iPSModelEngineHolder = null;
	private Map<String, Closure<?>> closureMap = new HashMap<>();
	
	
	public void setOwner(Object owner) {
		this.owner = owner;
	}
	
	public Object getOwner() {
		return this.owner;
	}
	
	public void setPSModelEngineHolder(IPSModelEngineHolder iPSModelEngineHolder) {
		this.iPSModelEngineHolder = iPSModelEngineHolder;
	}
	
	public IPSSystemEngine getSys(){
		return this.iPSModelEngineHolder.getPSSystemEngine();
	}
	
	public IPSModelEngineHolder getPSModelEngineHolder() {
		return this.iPSModelEngineHolder;
	}
	
	public String getName() {
		if(this.getOwner() instanceof IPSModelEngine) {
			return ((IPSModelEngine)this.getOwner()).getName();
		}
		
		if(this.getOwner() instanceof IPSModelEngineAddin) {
			return ((IPSModelEngineAddin)this.getOwner()).getName();
		}
		return null;
	}
	
	public String getFullName() {
		if(this.getOwner() instanceof IPSModelEngine) {
			return ((IPSModelEngine)this.getOwner()).getFullName();
		}
		
		if(this.getOwner() instanceof IPSModelEngineAddin) {
			return ((IPSModelEngineAddin)this.getOwner()).getFullName();
		}
		return null;
	}
	
	public IPSModelEngine getEngine() {
		if(this.getOwner() instanceof IPSModelEngine) {
			return (IPSModelEngine)this.getOwner();
		}
		
		if(this.getOwner() instanceof IPSModelEngineAddin) {
			return ((IPSModelEngineAddin)this.getOwner()).getPSModelEngine();
		}
		
		return null;
	}

	public IPSModelEngineAddin getAddin() {
		if(this.getOwner() instanceof IPSModelEngineAddin) {
			return ((IPSModelEngineAddin)this.getOwner());
		}
		return null;
	}
	
	
	public void before(Closure<?> closure) {
		this.before(IPSModelEngineScript.METHOD_EXECUTE, closure);
	}
	
	public void after(Closure<?> closure) {
		this.after(IPSModelEngineScript.METHOD_EXECUTE, closure);
	}
	
	public void execute(Closure<?> closure) {
		this.execute(IPSModelEngineScript.METHOD_EXECUTE, closure);
	}
	
	public void before(String methodName, Closure<?> closure) {
		String strTag = String.format("%1$s|%2$s", methodName, IPSModelEngineScript.ATTACHMODE_BEFORE).toUpperCase();
		closure.setDelegate(this.getOwner());
		//closure.setResolveStrategy(Closure.DELEGATE_FIRST);
		closureMap.put(strTag, closure);
	}
	
	public void after(String methodName, Closure<?> closure) {
		String strTag = String.format("%1$s|%2$s", methodName, IPSModelEngineScript.ATTACHMODE_AFTER).toUpperCase();
		closure.setDelegate(this.getOwner());
		//closure.setResolveStrategy(Closure.DELEGATE_FIRST);
		closureMap.put(strTag, closure);
	}
	
	public void execute(String methodName, Closure<?> closure) {
		String strTag = String.format("%1$s|%2$s", methodName, IPSModelEngineScript.ATTACHMODE_EXECUTE).toUpperCase();
		closure.setDelegate(this.getOwner());
		//closure.setResolveStrategy(Closure.DELEGATE_FIRST);
		closureMap.put(strTag, closure);
	}
	
	public Object call(Object... args) {
		return call(IPSModelEngineScript.METHOD_EXECUTE, IPSModelEngineScript.ATTACHMODE_EXECUTE, args);
	}

	public Object call(String methodName, String attachMode, Object... args) {
		String strTag = String.format("%1$s|%2$s", methodName, attachMode).toUpperCase();
		Closure<?> closure = closureMap.get(strTag);
		if(closure == null) {
			throw new RuntimeException(String.format("无法获取[%1$s]对应的闭包函数", strTag));
		}
		try {
			if(args == null || args.length == 0) {
				return closure.call();
			}
			return closure.call(args);
		}
		catch (Throwable ex) {
			ex.printStackTrace();
			throw new RuntimeException(String.format("执行脚本[%1$s][%2$s]发生异常，%3$s", methodName, attachMode, ex.getMessage()), ex);
		}
	}

	public boolean contains(String methodName, String attachMode) {
		String strTag = String.format("%1$s|%2$s", methodName, attachMode).toUpperCase();
		return closureMap.containsKey(strTag);
	}
	
	public boolean support(String methodName) {
		String strTag = String.format("%1$s|%2$s", methodName, IPSModelEngineScript.ATTACHMODE_BEFORE).toUpperCase();
		if(closureMap.containsKey(strTag)) {
			return true;
		}
		strTag = String.format("%1$s|%2$s", methodName, IPSModelEngineScript.ATTACHMODE_EXECUTE).toUpperCase();
		if(closureMap.containsKey(strTag)) {
			return true;
		}
		
		strTag = String.format("%1$s|%2$s", methodName, IPSModelEngineScript.ATTACHMODE_AFTER).toUpperCase();
		return closureMap.containsKey(strTag);
	}
	
	
	public Object callAround(String methodName, IAction iAction, Object... args) throws Throwable {
		String strTag = String.format("%1$s|%2$s", methodName, IPSModelEngineScript.ATTACHMODE_BEFORE).toUpperCase();
		Closure<?> closure = closureMap.get(strTag);
		if(closure != null) {
			try {
				if(args == null || args.length == 0) {
					closure.call();
				}
				else {
					closure.call(args);
				}
			}
			catch (Throwable ex) {
				ex.printStackTrace();
				throw new RuntimeException(String.format("执行脚本[%1$s][%2$s]发生异常，%3$s", methodName, IPSModelEngineScript.ATTACHMODE_BEFORE, ex.getMessage()), ex);
			}
		}
		
		Object ret = null;
		strTag = String.format("%1$s|%2$s", methodName, IPSModelEngineScript.ATTACHMODE_EXECUTE).toUpperCase();
		closure = closureMap.get(strTag);
		if(closure != null) {
			try {
				if(args == null || args.length == 0) {
					ret = closure.call();
				}
				else {
					ret = closure.call(args);
				}
			}
			catch (Throwable ex) {
				ex.printStackTrace();
				throw new RuntimeException(String.format("执行脚本[%1$s][%2$s]发生异常，%3$s", methodName, IPSModelEngineScript.ATTACHMODE_EXECUTE, ex.getMessage()), ex);
			}
		}
		else {
			ret = iAction.execute(args);
		}
		
		strTag = String.format("%1$s|%2$s", methodName, IPSModelEngineScript.ATTACHMODE_AFTER).toUpperCase();
		closure = closureMap.get(strTag);
		if(closure != null) {
			int nLength = 1;
			if(args != null ) {
				nLength += args.length;
			}
			Object[] newArgs = new Object[nLength];
			
			//第一个参数为返回值
			newArgs[0] = ret;
			if(nLength>1) {
				System.arraycopy(args, 0, newArgs, 1, args.length);
			}
			try {
				ret = closure.call(args);
			}
			catch (Throwable ex) {
				ex.printStackTrace();
				throw new RuntimeException(String.format("执行脚本[%1$s][%2$s]发生异常，%3$s", methodName, IPSModelEngineScript.ATTACHMODE_AFTER, ex.getMessage()), ex);
			}
		}
		return ret;
	}
	
	
	protected void exception(String strErrorInfo) {
		exception(strErrorInfo, Errors.INTERNALERROR);
	}

	protected void exception(String strErrorInfo, int nErrorCode) {
		if(this.getOwner() instanceof IPSModelEngine) {
			throw new PSModelEngineException((IPSModelEngine)this.getOwner(), strErrorInfo, nErrorCode) ;
		}
		
		if(this.getOwner() instanceof IPSModelEngineAddin) {
			throw new PSModelEngineAddinException((IPSModelEngineAddin)this.getOwner(), strErrorInfo, nErrorCode) ;
		}
		throw new PSModelEngineException(this.getSys(), strErrorInfo, nErrorCode) ;
	}

	protected void info(String strInfo) {
		this.getPSModelEngineHolder().getPSSystemLogger().info(String.format("[GROOVY] %1$s", this.getFullName()), strInfo, null);
	}

	protected void warn(String strInfo) {
		this.getPSModelEngineHolder().getPSSystemLogger().warn(String.format("[GROOVY] %1$s", this.getFullName()), strInfo, null);
	}

	protected void error(String strInfo) {
		this.getPSModelEngineHolder().getPSSystemLogger().error(String.format("[GROOVY] %1$s", this.getFullName()), strInfo, null);
	}
}
