package net.ibizsys.model.engine.groovy.plugin;

import org.codehaus.groovy.control.CompilerConfiguration;
import org.springframework.util.ObjectUtils;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import net.ibizsys.model.engine.plugin.PSModelEngineAddinException;
import net.ibizsys.model.engine.plugin.PSModelEngineScriptBase;
import net.ibizsys.model.engine.util.IAction;

public class GroovyPSModelEngineScript extends PSModelEngineScriptBase{
	
	private ScriptProxy scriptProxy = null;
	
	@Override
	protected void onInit() throws Exception {
		if(this.getScriptProxy(true) == null) {
			this.prepareScriptProxy();
			this.getScriptProxy(false);
		}
		super.onInit();
	}
	
	protected void prepareScriptProxy() throws Exception{
		if(!(this.getAddinData() instanceof String)
				|| ObjectUtils.isEmpty(this.getAddinData())) {
			throw new Exception("未传入脚本代码");
		}
		
		this.setScriptProxy(this.createScriptProxy(this.getPSModelEngine(), (String) this.getAddinData(), ScriptProxy.class));
	}
	
	protected ScriptProxy getScriptProxy() {
		try {
			return this.getScriptProxy(false);
		}
		catch (Exception ex) {
			throw new PSModelEngineAddinException(this, ex.getMessage());
		}
	}

	protected ScriptProxy getScriptProxy(boolean tryMode) throws Exception{
		if(this.scriptProxy!=null || tryMode) {
			return this.scriptProxy;
		}
		throw new Exception("脚本对象无效");
	}
	
	protected void setScriptProxy(ScriptProxy scriptProxy) {
		this.scriptProxy = scriptProxy;
	}
	
	
	protected <T> T createScriptProxy(Object owner, String strScriptCode, Class<? extends ScriptProxy> cls) throws Exception{
		CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
		compilerConfiguration.setScriptBaseClass(cls.getName());
		try(GroovyClassLoader classLoader = new GroovyClassLoader(Thread.currentThread().getContextClassLoader())) {
			GroovyShell groovyShell = new GroovyShell(classLoader, compilerConfiguration);
			groovy.lang.Script script = groovyShell.parse(strScriptCode);
			((ScriptProxy)script).setOwner(owner);
			((ScriptProxy)script).setPSModelEngineHolder(this.getPSModelEngineHolder());
			script.run();
			return (T)script;
		}
		catch (Exception ex) {
			throw new Exception(String.format("建立模型引擎脚本对象发生异常，%1$s", ex.getMessage()), ex);
		}
	}

	@Override
	public Object call(Object... args) {
		return getScriptProxy().call(args);
	}

	@Override
	public Object call(String methodName, String attachMode, Object... args) {
		return getScriptProxy().call(methodName, attachMode, args);
	}

	@Override
	public boolean contains(String methodName, String attachMode) {
		return getScriptProxy().contains(methodName, attachMode);
	}

	@Override
	public boolean support(String methodName) {
		return getScriptProxy().support(methodName);
	}

	@Override
	public Object callAround(String methodName, IAction iAction, Object... args) throws Throwable {
		return getScriptProxy().callAround(methodName, iAction, args);
	}
}
