/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.dataflow.spark;

import java.util.LinkedHashMap;
import java.util.Map;
import net.ibizsys.dataflow.spark.CloudSparkPSModelEngineFactory;
import net.ibizsys.dataflow.spark.SparkPSModelEngineHolder;
import net.ibizsys.model.IPSSystemService;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.engine.IPSModelEngineFactory;
import net.ibizsys.model.engine.cloud.CloudHubPSModelEngineHolder;
import net.ibizsys.model.engine.cloud.CloudHubUtilsHolder;
import net.ibizsys.model.engine.cloud.ICloudHubUtils;
import net.ibizsys.model.engine.cloud.util.domain.DeploySystem;
import net.ibizsys.model.engine.util.JsonUtils;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class CloudSparkApplication {
    private static final Log log = LogFactory.getLog(CloudSparkApplication.class);
    public static final String PARAM_ASYNCACITONID = "ASYNCACITONID";
    public static final String PARAM_CLOUDPARAMS = "CLOUDPARAMS";

    public static void main(String[] args) {
        if (args == null || args.length < 2) {
            System.err.println("\u4f20\u5165\u53c2\u6570\u65e0\u6548");
            System.exit(-1);
            return;
        }
        String dataFlowId = args[0];
        String taskParam = args[1];
        Map map = JsonUtils.asMap((Object)taskParam);
        Object value = map.get(PARAM_CLOUDPARAMS);
        Map cloudParams = null;
        if (value instanceof Map) {
            cloudParams = (Map)value;
        }
        if (cloudParams == null) {
            System.err.println("\u672a\u4f20\u5165cloudparams");
            System.exit(-1);
            return;
        }
        String[] ids = dataFlowId.split("[.]");
        CloudHubPSModelEngineHolder cloudHubPSModelEngineHolder = null;
        try {
            cloudHubPSModelEngineHolder = new CloudHubPSModelEngineHolder(cloudParams);
        }
        catch (Throwable ex) {
            System.err.println(String.format("\u521d\u59cb\u5316CloudHub\u7cfb\u7edf\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()));
            System.exit(-1);
            return;
        }
        CloudHubUtilsHolder.setCurrent((ICloudHubUtils)cloudHubPSModelEngineHolder.getPSSystemEngine());
        IPSSystemService iPSSystemService = null;
        try {
            iPSSystemService = CloudHubUtilsHolder.getCurrentMust().getPSSystemService(ids[0]);
        }
        catch (Throwable ex) {
            System.err.println(String.format("\u83b7\u53d6\u7cfb\u7edf\u6a21\u578b\u670d\u52a1\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()));
            System.exit(-1);
            return;
        }
        DeploySystem deploySysem = null;
        try {
            deploySysem = CloudHubUtilsHolder.getCurrentMust().getDeploySystem(ids[0]);
        }
        catch (Throwable ex) {
            System.err.println(String.format("\u83b7\u53d6\u7cfb\u7edf\u90e8\u7f72\u914d\u7f6e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()));
            System.exit(-1);
            return;
        }
        SparkPSModelEngineHolder sparkPSModelEngineHolder = null;
        try {
            sparkPSModelEngineHolder = new SparkPSModelEngineHolder((IPSModelEngineFactory)CloudSparkPSModelEngineFactory.getInstance(), iPSSystemService, deploySysem.getSettings());
        }
        catch (Throwable ex) {
            System.err.println(String.format("\u521d\u59cb\u5316\u6570\u636e\u6d41\u7cfb\u7edf\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()));
            System.exit(-1);
            return;
        }
        Object[] ids2 = new String[ids.length - 1];
        System.arraycopy(ids, 1, ids2, 0, ids.length - 1);
        String realDataFlowId = StringUtils.arrayToDelimitedString((Object[])ids2, (String)".");
        try {
            LinkedHashMap sessionParams = new LinkedHashMap();
            sessionParams.put(PARAM_ASYNCACITONID, map.get(PARAM_ASYNCACITONID));
            CaseInsensitiveMap dataContext = new CaseInsensitiveMap();
            dataContext.putAll((Map)map.get(PSModelEnums.DEDataFlowParamValueType.DATACONTEXT.value));
            sessionParams.put(PSModelEnums.DEDataFlowParamValueType.DATACONTEXT.value, dataContext);
            CaseInsensitiveMap sessionContext = new CaseInsensitiveMap();
            sessionContext.putAll((Map)map.get(PSModelEnums.DEDataFlowParamValueType.SESSION.value));
            sessionParams.put(PSModelEnums.DEDataFlowParamValueType.SESSION.value, sessionContext);
            sparkPSModelEngineHolder.getPSSystemEngine().executePSDEDataFlow(realDataFlowId, new Object[]{sessionParams});
        }
        catch (Throwable ex) {
            System.err.println(String.format("\u6267\u884c\u6570\u636e\u6d41[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", realDataFlowId, ex.getMessage()));
            System.exit(-1);
            return;
        }
        try {
            sparkPSModelEngineHolder.getPSSystemEngine().shutdown();
        }
        catch (Throwable ex) {
            System.err.println(String.format("\u5173\u95ed\u6570\u636e\u6d41\u7cfb\u7edf\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()));
        }
        try {
            cloudHubPSModelEngineHolder.getPSSystemEngine().shutdown();
        }
        catch (Throwable ex) {
            System.err.println(String.format("\u5173\u95edCloudHub\u7cfb\u7edf\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()));
        }
        System.exit(0);
    }
}

