package net.ibizsys.dataflow.spark;

import net.ibizsys.model.IPSSystemService;
import net.ibizsys.model.PSModelEnums.DEDataFlowParamValueType;
import net.ibizsys.model.engine.cloud.CloudHubPSModelEngineHolder;
import net.ibizsys.model.engine.cloud.CloudHubUtilsHolder;
import net.ibizsys.model.engine.cloud.util.domain.DeploySystem;
import net.ibizsys.model.engine.util.JsonUtils;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.springframework.util.StringUtils;

import java.util.LinkedHashMap;
import java.util.Map;

public class CloudSparkApplication {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(CloudSparkApplication.class);
	
	public final static String PARAM_ASYNCACITONID = "ASYNCACITONID";
	public final static String PARAM_CLOUDPARAMS = "CLOUDPARAMS";
	
	public static void main(String[] args) {

		if(args == null || args.length < 2) {
			System.err.println("传入参数无效");
			System.exit(-1);
			return;
		}

		String dataFlowId = args[0];
		String taskParam = args[1];
		
		Map<String, Object> map = JsonUtils.asMap(taskParam);
		
		Object value =  map.get(PARAM_CLOUDPARAMS);
		Map<String, Object> cloudParams = null;
		if(value instanceof Map) {
			cloudParams = (Map)value;
		}
		
		if(cloudParams == null) {
			System.err.println("未传入cloudparams");
			System.exit(-1);
			return;
		}
		
		//获取系统标识
		String[] ids = dataFlowId.split("[.]");
		//获取CloudHub系统
		CloudHubPSModelEngineHolder cloudHubPSModelEngineHolder = null;
		try {
			cloudHubPSModelEngineHolder = new CloudHubPSModelEngineHolder(cloudParams);
		} catch (Throwable ex) {
			System.err.println(String.format("初始化CloudHub系统发生异常，%1$s", ex.getMessage()));
			System.exit(-1);
			return;
		}
		
		CloudHubUtilsHolder.setCurrent(cloudHubPSModelEngineHolder.getPSSystemEngine());
		
		//获取系统模型服务
		IPSSystemService iPSSystemService = null;
		
		try {
			iPSSystemService = CloudHubUtilsHolder.getCurrentMust().getPSSystemService(ids[0]);
		}
		catch (Throwable ex) {
			System.err.println(String.format("获取系统模型服务发生异常，%1$s", ex.getMessage()));
			System.exit(-1);
			return;
		}
		
		//获取系统部署参数
		DeploySystem deploySysem = null;
		try {
			deploySysem = CloudHubUtilsHolder.getCurrentMust().getDeploySystem(ids[0]);
		}
		catch (Throwable ex) {
			System.err.println(String.format("获取系统部署配置发生异常，%1$s", ex.getMessage()));
			System.exit(-1);
			return;
		}
		
		SparkPSModelEngineHolder sparkPSModelEngineHolder = null;
		try {
			sparkPSModelEngineHolder = new SparkPSModelEngineHolder(CloudSparkPSModelEngineFactory.getInstance(), iPSSystemService, deploySysem.getSettings() );
		} catch (Throwable ex) {
			System.err.println(String.format("初始化数据流系统发生异常，%1$s", ex.getMessage()));
			System.exit(-1);
			return;
		}
		
		
		String[] ids2 = new String[ids.length - 1];
		System.arraycopy(ids, 1, ids2, 0, ids.length - 1);
		String realDataFlowId = StringUtils.arrayToDelimitedString(ids2, ".");
		
		try {
			Map<String, Object> sessionParams = new LinkedHashMap<String, Object>();
			sessionParams.put(PARAM_ASYNCACITONID, map.get(PARAM_ASYNCACITONID));

			Map dataContext= new CaseInsensitiveMap();
			dataContext.putAll( (Map)map.get(DEDataFlowParamValueType.DATACONTEXT.value));
			sessionParams.put(DEDataFlowParamValueType.DATACONTEXT.value, dataContext);

			Map sessionContext= new CaseInsensitiveMap();
			sessionContext.putAll( (Map)map.get(DEDataFlowParamValueType.SESSION.value));
			sessionParams.put(DEDataFlowParamValueType.SESSION.value, sessionContext);

			sparkPSModelEngineHolder.getPSSystemEngine().executePSDEDataFlow(realDataFlowId, new Object[]{sessionParams});
		} catch (Throwable ex) {
			System.err.println(String.format("执行数据流[%1$s]发生异常，%2$s", realDataFlowId, ex.getMessage()));
			System.exit(-1);
			return;
		}
		
		try {
			sparkPSModelEngineHolder.getPSSystemEngine().shutdown();
		}
		catch (Throwable ex) {
			System.err.println(String.format("关闭数据流系统发生异常，%1$s", ex.getMessage()));
		}
		
		try {
			cloudHubPSModelEngineHolder.getPSSystemEngine().shutdown();
		}
		catch (Throwable ex) {
			System.err.println(String.format("关闭CloudHub系统发生异常，%1$s", ex.getMessage()));
		}
		System.exit(0);
	}

}
