package net.ibizsys.dataflow.spark.dataentity.dataflow;

import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.springframework.util.ObjectUtils;

import net.ibizsys.dataflow.spark.dataentity.service.ISparkPSDEMethodDTOEngine;
import net.ibizsys.model.PSModelEnums.DEDataFlowParamValueType;
import net.ibizsys.model.PSModelEnums.DEDataFlowSysDataSyncAgentSinkType;
import net.ibizsys.model.PSModelEnums.DEMethodDTOType;
import net.ibizsys.model.dataentity.service.IPSDEMethodDTO;
import net.ibizsys.model.engine.util.JsonUtils;
import net.ibizsys.model.engine.util.domain.DataSyncOut;

public class CloudSparkPSDEDFSysDataSyncAgentSinkNodeAddin extends SparkPSDEDFSysDataSyncAgentSinkNodeAddin {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(CloudSparkPSDEDFSysDataSyncAgentSinkNodeAddin.class);
	
	/**
	 * 同步包属性：用户上下文
	 */
	public final static String PACKAGE_EMP = "emp";
	
	public final static String PARAM_EMP_TENANT = "tenant";
	
	public final static String PARAM_EMP_SYSTEMID = "systemid";
	
	public final static String PARAM_EMP_DCSYSTEMID = "dcsystemid";
	
	public final static String PARAM_EMP_ORGID = "orgid";
	
	public final static String PARAM_EMP_USERID = "userid";
	
	public final static String PARAM_EMP_USERNAME = "username";
	
	public final static String PARAM_EMP_USERCODE = "usercode";
	
	public final static String PARAM_EMP_ORGCODE = "orgcode";
	
	public final static String PARAM_EMP_ORGNAME = "orgname";
	
	public final static String PARAM_EMP_DEPTID = "deptid";
	
	public final static String PARAM_EMP_DEPTCODE = "deptcode";
	
	public final static String PARAM_EMP_DEPTNAME = "deptname";
	
	
	@Override
	protected Dataset<String> toStringDataset(ISparkPSDEDataFlowSession<?> iSparkPSDEDataFlowSession, Dataset<Row> dataset) throws Exception {
		if(this.getSubType() == DEDataFlowSysDataSyncAgentSinkType.DEDATASYNC) {
			
			IPSDEMethodDTO defaultPSDEMethodDTO = this.getPSDEDataFlowNode().getDstPSDataEntityMust().getDefaultPSDEMethodDTO();
			if(defaultPSDEMethodDTO == null) {
				if(!ObjectUtils.isEmpty(this.getPSDEDataFlowNode().getDstPSDataEntityMust().getAllPSDEMethodDTOs())) {
					for(IPSDEMethodDTO iPSDEMethodDTO : this.getPSDEDataFlowNode().getDstPSDataEntityMust().getAllPSDEMethodDTOs()) {
						if(!DEMethodDTOType.DEFAULT.value.equals(iPSDEMethodDTO.getType())) {
							continue;
						}
						if(iPSDEMethodDTO.isDefaultMode()) {
							defaultPSDEMethodDTO = iPSDEMethodDTO;
							break;
						}
					}
				}
				if(defaultPSDEMethodDTO == null) {
					throw new Exception("未指定目标实体默认实体方法DTO对象");
				}
			}
			
			
			ISparkPSDEMethodDTOEngine<?> iSparkPSDEMethodDTOEngine = this.getPSModelEngineHolder().getPSModelEngine(defaultPSDEMethodDTO, ISparkPSDEMethodDTOEngine.class);
			dataset = iSparkPSDEMethodDTOEngine.getDataset(dataset);
			
			String deId = this.getPSDEDataFlowNode().getDstPSDataEntityMust().getId();
			String deName = this.getPSDEDataFlowNode().getDstPSDataEntityMust().getName();
			String keyFieldName = this.getPSDEDataFlowNode().getDstPSDataEntityMust().getKeyPSDEFieldMust().getName();
			int eventType = this.getPSDEDataFlowNode().getEventType();
			String agent = this.getPSDEDataFlowNode().getPSSysDataSyncAgentMust().getCodeName();
			
			Map<String, Object> emp = new LinkedHashMap<String, Object>();
			Object session = iSparkPSDEDataFlowSession.getParam(DEDataFlowParamValueType.SESSION.value);
			if(session instanceof Map) {
				Map<String, Object> sessionMap = (Map)session;
				emp.put(PARAM_EMP_TENANT, sessionMap.get("srfdcid"));
				emp.put(PARAM_EMP_SYSTEMID, sessionMap.get("srfsystemid"));
				emp.put(PARAM_EMP_DCSYSTEMID, sessionMap.get("srfdcsystemid"));
				emp.put(PARAM_EMP_USERID, sessionMap.get("srfuserid"));
				emp.put(PARAM_EMP_USERNAME, sessionMap.get("srfusername"));
				emp.put(PARAM_EMP_USERCODE, sessionMap.get("srfusercode"));
				emp.put(PARAM_EMP_ORGID, sessionMap.get("srforgid"));
				emp.put(PARAM_EMP_ORGCODE, sessionMap.get("srforgcode"));
				emp.put(PARAM_EMP_ORGNAME, sessionMap.get("srforgname"));
				emp.put(PARAM_EMP_DEPTID, sessionMap.get("srforgsectorid"));
				emp.put(PARAM_EMP_DEPTCODE, sessionMap.get("srforgsectorcode"));
				emp.put(PARAM_EMP_DEPTNAME, sessionMap.get("srforgsectorname"));
			}
			
		
			Dataset<String> stringDataset = dataset.map((MapFunction<Row, String>)row -> {
				
				//IPSModelEngineHolder iPSModelEngineHolder =	getPSModelEngineHolder();
				
				//row.getValuesMap(fieldNames)
				String json = row.json();
				DataSyncOut dataSyncOut = new DataSyncOut();
				dataSyncOut.setEventType(eventType);
				dataSyncOut.setDataKey(null);
				dataSyncOut.setData(json);
				dataSyncOut.setDEId(deId);
				dataSyncOut.setDEName(deName);
				dataSyncOut.setCreateDate(new java.sql.Timestamp(System.currentTimeMillis()));
				
				
				String data = JsonUtils.toString(dataSyncOut);
				
				//附加头
				Map<String, Object> map = new LinkedHashMap<String, Object>();
				map.put(PACKAGE_AGENT, agent);
				map.put(PACKAGE_DATA, data);
				map.put(PACKAGE_EMP, emp);
				
				
				
				return JsonUtils.toString(map);
			}, Encoders.STRING());
			return stringDataset;
		}
		return super.toStringDataset(iSparkPSDEDataFlowSession, dataset);
	}
}
