package net.ibizsys.dataflow.flink.eai;

import org.apache.flink.api.common.serialization.SimpleStringSchema;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.connector.kafka.source.KafkaSource;
import org.apache.flink.connector.kafka.source.enumerator.initializer.OffsetsInitializer;

import net.ibizsys.dataflow.core.eai.PSSysDataSyncAgentEngineBase;
import net.ibizsys.model.PSModelEnums.DataSyncAgentDir;
import net.ibizsys.model.PSModelEnums.DataSyncAgentType;
import net.ibizsys.model.engine.IPSModelEngineHolder;
import net.ibizsys.model.engine.PSModelEngineException;
import net.ibizsys.model.res.IPSSysDataSyncAgent;

public class FlinkPSSysDataSyncAgentEngine extends PSSysDataSyncAgentEngineBase<IPSSysDataSyncAgent> implements IFlinkPSSysDataSyncAgentEngine<IPSSysDataSyncAgent>{

	private Source<?, ?, ?> source = null;
	private Sink<?> sink = null;
	
	@Override
	public void init(IPSModelEngineHolder iPSModelEngineContext, String id, IPSSysDataSyncAgent iPSModelObject) throws Exception {
		super.init(iPSModelEngineContext, id, iPSModelObject);
		
		//判断是否为输入
		if(DataSyncAgentDir.IN.value.equalsIgnoreCase(this.getPSSysDataSyncAgent().getSyncDir())
				|| DataSyncAgentDir.INOUT.value.equalsIgnoreCase(this.getPSSysDataSyncAgent().getSyncDir())) {
			if(this.getSource(true) == null) {
				this.prepareSource();
				if(this.getSource(true) == null) {
					throw new Exception("未提供Source对象");
				}
			}
			
		}
		if(DataSyncAgentDir.OUT.value.equalsIgnoreCase(this.getPSSysDataSyncAgent().getSyncDir())
				|| DataSyncAgentDir.INOUT.value.equalsIgnoreCase(this.getPSSysDataSyncAgent().getSyncDir())) {
			if(this.getSink(true) == null) {
				this.prepareSink();	
				if(this.getSink(true) == null) {
					throw new Exception(String.format("未提供Sink对象"));
				}
			}
		}
	}
	
	
	@Override
	protected void onInit() throws Exception {
		// TODO Auto-generated method stub
		super.onInit();
	}
	
	@Override
	public Source<?, ?, ?> getSource() {
		return this.getSource(false);
	}
	
	public Source<?, ?, ?> getSource(boolean tryMode) {
		if(this.source != null || tryMode) {
			return this.source;
		}
		throw new PSModelEngineException(this, String.format("未提供Source对象"));
	}
	
	
	protected void setSource(Source<?, ?, ?> source) {
		this.source = source;
		
	}
	
	protected void prepareSource() throws Exception{
		if(DataSyncAgentType.KAFKA.value.equalsIgnoreCase(this.getAgentType())) {
			
			this.setSource(
				KafkaSource.<String>builder()
			    .setBootstrapServers(this.getServiceUrl())
			    .setTopics(this.getDefaultTopic())
			    .setGroupId(this.getGroupId())
			    .setStartingOffsets(OffsetsInitializer.earliest())
			    .setValueOnlyDeserializer(new SimpleStringSchema())
			    .build()
		    );
			
			return;
		}
	}


	
	@Override
	public Sink<?> getSink() {
		return this.getSink(false);
	}

	public Sink<?> getSink(boolean tryMode) {
		if(this.sink != null || tryMode) {
			return this.sink;
		}
		throw new PSModelEngineException(this, String.format("未提供Sink对象"));
	}

	protected void setSink(Sink<?> sink) {
		this.sink = sink;
	}
	
	protected void prepareSink() throws Exception{
		if(DataSyncAgentType.KAFKA.value.equalsIgnoreCase(this.getAgentType())) {
			
			return;
		}
	}


	@Override
	public boolean isEnableSource() {
		return this.getSource(true)!=null;
	}

	
	@Override
	public boolean isEnableSink() {
		return this.getSink(true)!=null;
	}
}
