package net.ibizsys.dataflow.flink.dataentity.datasync;

import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;

import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.PSModelEnums.DataSyncDir;
import net.ibizsys.model.engine.IPSModelEngineHolder;
import net.ibizsys.model.engine.PSModelEngineException;
import net.ibizsys.model.engine.dataentity.datasync.PSDEDataSyncEngineBase;

/**
 * 默认实体数据同步代理引擎
 * @author lionlau
 *
 */
public class FlinkPSDEDataSyncEngine extends PSDEDataSyncEngineBase implements IFlinkPSDEDataSyncEngine {

	private SinkFunction<?> sinkFunction = null;
	
	@Override
	public void init(IPSModelEngineHolder iPSModelEngineContext, String id, IPSModelObject iPSModelObject) throws Exception {
		super.init(iPSModelEngineContext, id, iPSModelObject);
		
		if(DataSyncDir.IN.value.equalsIgnoreCase(this.getPSDEDataSync().getSyncDir())){
			if(this.getSinkFunction(true) == null) {
				this.prepareSinkFunction();	
				if(this.getSinkFunction(true) == null) {
					throw new Exception(String.format("未提供SinkFunction对象"));
				}
			}
		}
	}
	
	
	@Override
	public SinkFunction<?> getSinkFunction() {
		return this.getSinkFunction(false);
	}

	public SinkFunction<?> getSinkFunction(boolean tryMode) {
		if(this.sinkFunction != null || tryMode) {
			return this.sinkFunction;
		}
		throw new PSModelEngineException(this, String.format("未提供SinkFunction对象"));
	}

	protected void setSinkFunction(SinkFunction<?> sink) {
		this.sinkFunction = sink;
	}
	
	@SuppressWarnings("serial")
	protected void prepareSinkFunction() throws Exception{
		this.setSinkFunction(new RichSinkFunction<String>() {

			@Override
			public void invoke(String value, Context context) throws Exception {
				// TODO Auto-generated method stub
				super.invoke(value, context);
			}
			
		});
	}


	@Override
	public boolean isEnableSinkFunction() {
		return this.getSinkFunction(true)!=null;
	}
}
