/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.codegen.groovy.util;

import net.ibizsys.codegen.core.util.StdDataTypeUtils;
import net.ibizsys.model.PSModelEnums;

public class GroovyUtils {
    public static String getGroovyType(PSModelEnums.StdDataType stdDataType) {
        if (StdDataTypeUtils.isStringDataType((PSModelEnums.StdDataType)stdDataType)) {
            return "String";
        }
        if (StdDataTypeUtils.isDateTimeDataType((PSModelEnums.StdDataType)stdDataType)) {
            return "Date";
        }
        if (StdDataTypeUtils.isBigDecimalDataType((PSModelEnums.StdDataType)stdDataType)) {
            return "BigDecimal";
        }
        if (StdDataTypeUtils.isBigIntDataType((PSModelEnums.StdDataType)stdDataType)) {
            return "BigInteger";
        }
        if (StdDataTypeUtils.isIntDataType((PSModelEnums.StdDataType)stdDataType)) {
            return "Integer";
        }
        if (StdDataTypeUtils.isNumberDataType((PSModelEnums.StdDataType)stdDataType)) {
            return "Double";
        }
        if (StdDataTypeUtils.isBinaryDataType((PSModelEnums.StdDataType)stdDataType)) {
            return "byte[]";
        }
        return "def";
    }

    public static String getPythonType(PSModelEnums.StdDataType stdDataType) {
        if (StdDataTypeUtils.isStringDataType((PSModelEnums.StdDataType)stdDataType)) {
            return "str";
        }
        if (StdDataTypeUtils.isDateTimeDataType((PSModelEnums.StdDataType)stdDataType)) {
            return "str";
        }
        if (StdDataTypeUtils.isBigDecimalDataType((PSModelEnums.StdDataType)stdDataType)) {
            return "float";
        }
        if (StdDataTypeUtils.isBigIntDataType((PSModelEnums.StdDataType)stdDataType)) {
            return "int";
        }
        if (StdDataTypeUtils.isIntDataType((PSModelEnums.StdDataType)stdDataType)) {
            return "int";
        }
        if (StdDataTypeUtils.isNumberDataType((PSModelEnums.StdDataType)stdDataType)) {
            return "float";
        }
        if (StdDataTypeUtils.isBinaryDataType((PSModelEnums.StdDataType)stdDataType)) {
            return "str";
        }
        return "str";
    }

    public static String getJavaScriptType(PSModelEnums.StdDataType stdDataType) {
        if (StdDataTypeUtils.isStringDataType((PSModelEnums.StdDataType)stdDataType)) {
            return "string";
        }
        if (StdDataTypeUtils.isDateTimeDataType((PSModelEnums.StdDataType)stdDataType)) {
            return "string";
        }
        if (StdDataTypeUtils.isBigDecimalDataType((PSModelEnums.StdDataType)stdDataType)) {
            return "string";
        }
        if (StdDataTypeUtils.isBigIntDataType((PSModelEnums.StdDataType)stdDataType)) {
            return "string";
        }
        if (StdDataTypeUtils.isIntDataType((PSModelEnums.StdDataType)stdDataType)) {
            return "integer";
        }
        if (StdDataTypeUtils.isNumberDataType((PSModelEnums.StdDataType)stdDataType)) {
            return "number";
        }
        if (StdDataTypeUtils.isBinaryDataType((PSModelEnums.StdDataType)stdDataType)) {
            return "array";
        }
        return "object";
    }

    public static String getJavaType(PSModelEnums.StdDataType stdDataType) {
        return GroovyUtils.getJavaType(stdDataType, false);
    }

    public static String getJavaType(PSModelEnums.StdDataType stdDataType, boolean bFull) {
        if (StdDataTypeUtils.isStringDataType((PSModelEnums.StdDataType)stdDataType)) {
            return "String";
        }
        if (StdDataTypeUtils.isLongStringDataType((PSModelEnums.StdDataType)stdDataType)) {
            return "String";
        }
        if (StdDataTypeUtils.isDateTimeDataType((PSModelEnums.StdDataType)stdDataType)) {
            if (bFull) {
                return "java.sql.Timestamp";
            }
            return "Timestamp";
        }
        if (StdDataTypeUtils.isBigIntDataType((PSModelEnums.StdDataType)stdDataType)) {
            if (bFull) {
                return "java.math.BigInteger";
            }
            return "BigInteger";
        }
        if (StdDataTypeUtils.isIntDataType((PSModelEnums.StdDataType)stdDataType)) {
            return "Integer";
        }
        if (StdDataTypeUtils.isBigDecimalDataType((PSModelEnums.StdDataType)stdDataType)) {
            if (bFull) {
                return "java.math.BigDecimal";
            }
            return "BigDecimal";
        }
        if (StdDataTypeUtils.isDoubleDataType((PSModelEnums.StdDataType)stdDataType)) {
            return "Double";
        }
        if (StdDataTypeUtils.isBinaryDataType((PSModelEnums.StdDataType)stdDataType)) {
            return "byte[]";
        }
        if (StdDataTypeUtils.isBooleanDataType((PSModelEnums.StdDataType)stdDataType)) {
            return "Boolean";
        }
        return "Object";
    }
}

