/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.codegen.groovy.support;

import com.google.common.base.CaseFormat;
import java.util.HashMap;
import java.util.Map;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.IPSSystem;
import net.ibizsys.model.system.IPSSysModelGroup;
import net.ibizsys.model.system.IPSSystemModule;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class PSSystemExtension {
    private static Map<String, CaseFormat> CaseFormatMap = new HashMap<String, CaseFormat>();

    public static String getPKGCodeName(IPSSystem self) {
        if (self.getDefaultPSSysSFPub() == null) {
            throw new RuntimeException("\u7cfb\u7edf\u672a\u5b9a\u4e49\u9ed8\u8ba4\u53d1\u5e03\u5bf9\u8c61");
        }
        if (!StringUtils.hasLength((String)self.getDefaultPSSysSFPub().getPKGCodeName())) {
            if (!StringUtils.hasLength((String)self.getDefaultPSSysSFPub().getCodeName())) {
                throw new RuntimeException("\u9ed8\u8ba4\u53d1\u5e03\u5bf9\u8c61\u672a\u5b9a\u4e49\u4ee3\u7801\u6807\u8bc6");
            }
            return PSSystemExtension.getUpperCamelCodeName((IPSModelObject)self.getDefaultPSSysSFPub()).toLowerCase();
        }
        return self.getDefaultPSSysSFPub().getPKGCodeName();
    }

    public static String getPKGCodeName(IPSSystemModule iPSSystemModule) {
        if (StringUtils.hasLength((String)iPSSystemModule.getPKGCodeName())) {
            return iPSSystemModule.getPKGCodeName();
        }
        IPSSysModelGroup iPSSysModelGroup = iPSSystemModule.getPSSysModelGroup();
        if (iPSSysModelGroup != null && StringUtils.hasLength((String)iPSSysModelGroup.getPKGCodeName())) {
            return String.format("%1$s.%2$s", iPSSysModelGroup.getPKGCodeName(), PSSystemExtension.getUpperCamelCodeName((IPSModelObject)iPSSystemModule).toLowerCase());
        }
        return String.format("%1$s.%2$s", PSSystemExtension.getPKGCodeName((IPSSystem)iPSSystemModule.getParentPSModelObject(IPSSystem.class)), PSSystemExtension.getUpperCamelCodeName((IPSModelObject)iPSSystemModule).toLowerCase());
    }

    public static String getLowerCamelCodeName(IPSModelObject iPSModelObject) {
        String strCodeName = iPSModelObject.getCodeName();
        if (StringUtils.hasLength((String)strCodeName)) {
            return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, PSSystemExtension.toUpperCamelCodeName(strCodeName));
        }
        return strCodeName;
    }

    public static String getUpperCamelCodeName(IPSModelObject iPSModelObject) {
        String strCodeName = iPSModelObject.getCodeName();
        if (StringUtils.hasLength((String)strCodeName)) {
            return PSSystemExtension.toUpperCamelCodeName(strCodeName);
        }
        return strCodeName;
    }

    public static String getUpperUnderscoreCodeName(IPSModelObject iPSModelObject) {
        String strCodeName = iPSModelObject.getCodeName();
        if (StringUtils.hasLength((String)strCodeName)) {
            return CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, PSSystemExtension.toUpperCamelCodeName(strCodeName));
        }
        return strCodeName;
    }

    public static String getLowerUnderscoreCodeName(IPSModelObject iPSModelObject) {
        String strCodeName = iPSModelObject.getCodeName();
        if (StringUtils.hasLength((String)strCodeName)) {
            return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, PSSystemExtension.toUpperCamelCodeName(strCodeName));
        }
        return strCodeName;
    }

    public static String getLowerHyphenCodeName(IPSModelObject iPSModelObject) {
        String strCodeName = iPSModelObject.getCodeName();
        if (StringUtils.hasLength((String)strCodeName)) {
            return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, PSSystemExtension.toUpperCamelCodeName(strCodeName));
        }
        return strCodeName;
    }

    public static String toUpperCamelCodeName(String strCodeName) {
        if (ObjectUtils.isEmpty((Object)strCodeName)) {
            return strCodeName;
        }
        StringBuilder sb = new StringBuilder();
        boolean bLastUpper = false;
        boolean bUpper = false;
        for (int i = 0; i < strCodeName.length(); ++i) {
            if (i == 0) {
                sb.append(strCodeName.substring(i, i + 1).toUpperCase());
                bLastUpper = true;
                continue;
            }
            String strItem = strCodeName.substring(i, i + 1);
            if (!strItem.toUpperCase().equals(strItem)) {
                sb.append(strItem);
                bLastUpper = false;
                continue;
            }
            if (i == strCodeName.length() - 1) {
                if (bLastUpper) {
                    sb.append(strItem.toLowerCase());
                    bLastUpper = false;
                    continue;
                }
                sb.append(strItem);
                bLastUpper = true;
                bUpper = true;
                continue;
            }
            if (bLastUpper) {
                String strItem2 = strCodeName.substring(i + 1, i + 2);
                if (strItem2.toUpperCase().equals(strItem2)) {
                    sb.append(strItem.toLowerCase());
                    continue;
                }
                sb.append(strItem);
                bLastUpper = true;
                bUpper = true;
                continue;
            }
            sb.append(strItem);
            bLastUpper = true;
            bUpper = true;
        }
        strCodeName = sb.toString();
        if (strCodeName.indexOf("_") != -1) {
            if (bUpper) {
                StringBuilder sb2 = new StringBuilder();
                for (int i = 0; i < strCodeName.length(); ++i) {
                    if (i == 0) {
                        sb2.append(strCodeName.substring(i, i + 1).toLowerCase());
                        continue;
                    }
                    String strItem = strCodeName.substring(i, i + 1);
                    if (!strItem.toUpperCase().equals(strItem)) {
                        sb2.append(strItem);
                        continue;
                    }
                    sb2.append("_");
                    sb2.append(strItem.toLowerCase());
                }
                strCodeName = sb2.toString();
            }
            strCodeName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, strCodeName);
        }
        return strCodeName;
    }

    static {
        CaseFormatMap.put("LOWER_CAMEL", CaseFormat.LOWER_CAMEL);
        CaseFormatMap.put("LOWER_HYPHEN", CaseFormat.LOWER_HYPHEN);
        CaseFormatMap.put("LOWER_UNDERSCORE", CaseFormat.LOWER_UNDERSCORE);
        CaseFormatMap.put("UPPER_CAMEL", CaseFormat.UPPER_CAMEL);
        CaseFormatMap.put("UPPER_UNDERSCORE", CaseFormat.UPPER_UNDERSCORE);
    }
}

