/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.codegen.groovy.engine;

import groovy.lang.GroovyClassLoader;
import java.util.Map;
import java.util.Random;
import net.ibizsys.codegen.core.engine.ICodeGenEngine;
import net.ibizsys.codegen.groovy.engine.GroovyCodeGenEngineBase;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.IPSSystem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class GroovyCodeGenEngine
extends GroovyCodeGenEngineBase {
    private static final Log log = LogFactory.getLog(GroovyCodeGenEngine.class);
    private static Random random = new Random();
    private static GroovyClassLoader groovyClassLoader = new GroovyClassLoader(GroovyCodeGenEngine.class.getClassLoader());
    public static final String ENGINEFILE = "engine.groovy";
    private ICodeGenEngine realCodeGenEngine = null;

    @Override
    protected void onInit() throws Exception {
        String strEngineContent = this.getTemplateContent(ENGINEFILE, true);
        if (StringUtils.hasLength((String)strEngineContent)) {
            this.prepareRealCodeGenEngine(strEngineContent);
        }
        super.onInit();
    }

    protected void prepareRealCodeGenEngine(String strEngineContent) throws Exception {
        Class engineObjectClass;
        Object engineObject;
        if (strEngineContent.indexOf("package ") == -1) {
            String strAutoPackage = String.format("package net.ibizsys.codegen.groovy.engine.a%1$s\r\n", random.nextInt(99999999));
            strEngineContent = strAutoPackage + strEngineContent;
        }
        if (!((engineObject = (engineObjectClass = groovyClassLoader.parseClass(strEngineContent)).newInstance()) instanceof ICodeGenEngine)) {
            throw new Exception("\u5bf9\u8c61\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        ICodeGenEngine realCodeGenEngine = (ICodeGenEngine)engineObject;
        realCodeGenEngine.init(this.getTemplatePath(), this.isTemplateFromResource(), this.getParams());
        this.setRealCodeGenEngine(realCodeGenEngine);
    }

    protected void setRealCodeGenEngine(ICodeGenEngine realCodeGenEngine) {
        this.realCodeGenEngine = realCodeGenEngine;
    }

    protected ICodeGenEngine getRealCodeGenEngine() {
        return this.realCodeGenEngine;
    }

    protected void onOutput(IPSSystem iPSSystem, String strOutputPath, Object[] filters, Map<String, IPSModelObject> fileMap, boolean bIgnoreException) throws Exception {
        if (this.getRealCodeGenEngine() != null) {
            this.getRealCodeGenEngine().output(iPSSystem, strOutputPath, filters, fileMap, bIgnoreException);
            return;
        }
        super.onOutput(iPSSystem, strOutputPath, filters, fileMap, bIgnoreException);
    }
}

