/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.codegen.groovy.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.ibizsys.model.IPSSystem;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.wf.IPSWFCallActivityProcess;
import net.ibizsys.model.wf.IPSWFCallOrgActivityProcess;
import net.ibizsys.model.wf.IPSWFEmbedWFProcess;
import net.ibizsys.model.wf.IPSWFEmbedWFProcessBase;
import net.ibizsys.model.wf.IPSWFInteractiveProcess;
import net.ibizsys.model.wf.IPSWFLink;
import net.ibizsys.model.wf.IPSWFProcess;
import net.ibizsys.model.wf.IPSWFProcessRole;
import net.ibizsys.model.wf.IPSWFRole;
import net.ibizsys.model.wf.IPSWFVersion;
import net.ibizsys.model.wf.IPSWorkflow;
import org.springframework.util.DigestUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class PSWFVersionExtension {
    public static String getDeployId(IPSWorkflow iPSWorkflow) {
        IPSSystem iPSSytem = (IPSSystem)iPSWorkflow.getParentPSModelObject(IPSSystem.class);
        return DigestUtils.md5DigestAsHex((byte[])String.format("%1$s||%2$s", iPSSytem.getObjectNode().toString(), iPSWorkflow.getCodeName()).getBytes());
    }

    public static String getDeployId(IPSWFVersion iPSWFVersion) {
        String strDeployId = PSWFVersionExtension.getDeployId(iPSWFVersion.getPSWorkflowMust());
        return DigestUtils.md5DigestAsHex((byte[])String.format("%1$s||%2$s", strDeployId, iPSWFVersion.getObjectNode().toString()).getBytes());
    }

    public static String getDeployId(IPSWFProcess iPSWFProcess) {
        String strDeployId = PSWFVersionExtension.getDeployId((IPSWFVersion)iPSWFProcess.getParentPSModelObject(IPSWFVersion.class));
        return DigestUtils.md5DigestAsHex((byte[])String.format("%1$s||%2$s", strDeployId, iPSWFProcess.getObjectNode().toString()).getBytes());
    }

    public static String getDeployId(IPSWFLink iPSWFLink) {
        return String.format("%1$s-%2$s", PSWFVersionExtension.getDeployId(iPSWFLink.getFromPSWFProcessMust()), PSWFVersionExtension.getDeployId(iPSWFLink.getToPSWFProcessMust()));
    }

    public static Collection<IPSWFRole> getPSWFRoles(IPSWFVersion iPSWFVersion) {
        HashMap<String, IPSWFRole> psWFRoleMap = new HashMap<String, IPSWFRole>();
        if (!ObjectUtils.isEmpty((Object)iPSWFVersion.getPSWFProcesses())) {
            ArrayList<IPSWFProcessRole> psWFProcessRoleList = new ArrayList<IPSWFProcessRole>();
            for (IPSWFProcess iPSWFProcess : iPSWFVersion.getPSWFProcesses()) {
                List<IPSWFProcessRole> list = PSWFVersionExtension.getPSWFProcessRoles(iPSWFProcess);
                if (list == null) continue;
                psWFProcessRoleList.addAll(list);
            }
            for (IPSWFProcessRole iPSWFProcessRole : psWFProcessRoleList) {
                if (!PSModelEnums.WFProcRoleType.WFROLE.value.equals(iPSWFProcessRole.getWFProcessRoleType()) || psWFRoleMap.containsKey(iPSWFProcessRole.getPSWFRoleMust().getCodeName())) continue;
                psWFRoleMap.put(iPSWFProcessRole.getPSWFRoleMust().getCodeName(), iPSWFProcessRole.getPSWFRoleMust());
            }
        }
        return psWFRoleMap.values();
    }

    public static List<IPSWFProcessRole> getPSWFProcessRoles(IPSWFProcess iPSWFProcess) {
        if (iPSWFProcess instanceof IPSWFInteractiveProcess) {
            return ((IPSWFInteractiveProcess)iPSWFProcess).getPSWFProcessRoles();
        }
        if (iPSWFProcess instanceof IPSWFCallOrgActivityProcess) {
            return ((IPSWFCallOrgActivityProcess)iPSWFProcess).getPSWFProcessRoles();
        }
        if (iPSWFProcess instanceof IPSWFEmbedWFProcess) {
            return ((IPSWFEmbedWFProcess)iPSWFProcess).getPSWFProcessRoles();
        }
        return null;
    }

    public static String getMultiInstMode(IPSWFProcess iPSWFProcess) {
        if (iPSWFProcess instanceof IPSWFInteractiveProcess) {
            return ((IPSWFInteractiveProcess)iPSWFProcess).getMultiInstMode();
        }
        if (iPSWFProcess instanceof IPSWFEmbedWFProcessBase) {
            return ((IPSWFEmbedWFProcessBase)iPSWFProcess).getMultiInstMode();
        }
        if (iPSWFProcess instanceof IPSWFCallActivityProcess) {
            return ((IPSWFCallActivityProcess)iPSWFProcess).getMultiInstMode();
        }
        return null;
    }

    public static boolean isMultiInstance(IPSWFProcess iPSWFProcess) {
        String strMultiInstMode = PSWFVersionExtension.getMultiInstMode(iPSWFProcess);
        if (StringUtils.hasLength((String)strMultiInstMode) && !strMultiInstMode.equals(PSModelEnums.WFProcMultiInstMode.NONE.value)) {
            return PSModelEnums.WFProcMultiInstMode.PARALLEL.value.equals(strMultiInstMode) || PSModelEnums.WFProcMultiInstMode.SEQUENTIAL.value.equals(strMultiInstMode);
        }
        return false;
    }

    public static boolean isSequential(IPSWFProcess iPSWFProcess) {
        String strMultiInstMode = PSWFVersionExtension.getMultiInstMode(iPSWFProcess);
        if (StringUtils.hasLength((String)strMultiInstMode)) {
            return PSModelEnums.WFProcMultiInstMode.SEQUENTIAL.value.equals(strMultiInstMode);
        }
        return false;
    }

    public static boolean hasTimeOutLink(IPSWFProcess iPSWFProcess) {
        if (!ObjectUtils.isEmpty((Object)iPSWFProcess.getPSWFLinks())) {
            for (IPSWFLink iPSWFLink : iPSWFProcess.getPSWFLinks()) {
                if (!PSModelEnums.WFLinkType.TIMEOUT.value.equals(iPSWFLink.getWFLinkType())) continue;
                return true;
            }
        }
        return false;
    }
}

