/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.codegen.groovy.support;

import com.google.common.base.CaseFormat;
import java.util.HashMap;
import java.util.Map;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.IPSSystem;
import net.ibizsys.model.system.IPSSysModelGroup;
import net.ibizsys.model.system.IPSSystemModule;
import org.springframework.util.StringUtils;

public class PSSystemExtension {
    private static Map<String, CaseFormat> CaseFormatMap = new HashMap<String, CaseFormat>();

    public static String getPKGCodeName(IPSSystem self) {
        if (self.getDefaultPSSysSFPub() == null) {
            throw new RuntimeException("\u7cfb\u7edf\u672a\u5b9a\u4e49\u9ed8\u8ba4\u53d1\u5e03\u5bf9\u8c61");
        }
        if (!StringUtils.hasLength((String)self.getDefaultPSSysSFPub().getPKGCodeName())) {
            if (!StringUtils.hasLength((String)self.getDefaultPSSysSFPub().getCodeName())) {
                throw new RuntimeException("\u9ed8\u8ba4\u53d1\u5e03\u5bf9\u8c61\u672a\u5b9a\u4e49\u4ee3\u7801\u6807\u8bc6");
            }
            return PSSystemExtension.getUpperCamelCodeName((IPSModelObject)self.getDefaultPSSysSFPub()).toLowerCase();
        }
        return self.getDefaultPSSysSFPub().getPKGCodeName();
    }

    public static String getPKGCodeName(IPSSystemModule iPSSystemModule) {
        if (StringUtils.hasLength((String)iPSSystemModule.getPKGCodeName())) {
            return iPSSystemModule.getPKGCodeName();
        }
        IPSSysModelGroup iPSSysModelGroup = iPSSystemModule.getPSSysModelGroup();
        if (iPSSysModelGroup != null && StringUtils.hasLength((String)iPSSysModelGroup.getPKGCodeName())) {
            return String.format("%1$s.%2$s", iPSSysModelGroup.getPKGCodeName(), PSSystemExtension.getUpperCamelCodeName((IPSModelObject)iPSSystemModule).toLowerCase());
        }
        return String.format("%1$s.%2$s", PSSystemExtension.getPKGCodeName((IPSSystem)iPSSystemModule.getParentPSModelObject(IPSSystem.class)), PSSystemExtension.getUpperCamelCodeName((IPSModelObject)iPSSystemModule).toLowerCase());
    }

    public static CaseFormat getCodeNameCaseFormat(IPSSystem iPSSystem) {
        CaseFormat caseFormat = CaseFormatMap.get(iPSSystem.getCodeNameMode());
        return caseFormat == null ? CaseFormat.UPPER_CAMEL : caseFormat;
    }

    public static String getLowerCamelCodeName(IPSModelObject iPSModelObject) {
        String strCodeName = iPSModelObject.getCodeName();
        if (StringUtils.hasLength((String)strCodeName)) {
            IPSSystem iPSSystem = (IPSSystem)iPSModelObject.getParentPSModelObject(IPSSystem.class);
            CaseFormat caseFormat = PSSystemExtension.getCodeNameCaseFormat(iPSSystem);
            return caseFormat.to(CaseFormat.LOWER_CAMEL, strCodeName);
        }
        return strCodeName;
    }

    public static String getUpperCamelCodeName(IPSModelObject iPSModelObject) {
        String strCodeName = iPSModelObject.getCodeName();
        if (StringUtils.hasLength((String)strCodeName)) {
            IPSSystem iPSSystem = (IPSSystem)iPSModelObject.getParentPSModelObject(IPSSystem.class);
            CaseFormat caseFormat = PSSystemExtension.getCodeNameCaseFormat(iPSSystem);
            return caseFormat.to(CaseFormat.UPPER_CAMEL, strCodeName);
        }
        return strCodeName;
    }

    public static String getUpperUnderscoreCodeName(IPSModelObject iPSModelObject) {
        String strCodeName = iPSModelObject.getCodeName();
        if (StringUtils.hasLength((String)strCodeName)) {
            IPSSystem iPSSystem = (IPSSystem)iPSModelObject.getParentPSModelObject(IPSSystem.class);
            CaseFormat caseFormat = PSSystemExtension.getCodeNameCaseFormat(iPSSystem);
            return caseFormat.to(CaseFormat.UPPER_UNDERSCORE, strCodeName);
        }
        return strCodeName;
    }

    public static String getLowerUnderscoreCodeName(IPSModelObject iPSModelObject) {
        String strCodeName = iPSModelObject.getCodeName();
        if (StringUtils.hasLength((String)strCodeName)) {
            IPSSystem iPSSystem = (IPSSystem)iPSModelObject.getParentPSModelObject(IPSSystem.class);
            CaseFormat caseFormat = PSSystemExtension.getCodeNameCaseFormat(iPSSystem);
            return caseFormat.to(CaseFormat.LOWER_UNDERSCORE, strCodeName);
        }
        return strCodeName;
    }

    public static String getLowerHyphenCodeName(IPSModelObject iPSModelObject) {
        String strCodeName = iPSModelObject.getCodeName();
        if (StringUtils.hasLength((String)strCodeName)) {
            IPSSystem iPSSystem = (IPSSystem)iPSModelObject.getParentPSModelObject(IPSSystem.class);
            CaseFormat caseFormat = PSSystemExtension.getCodeNameCaseFormat(iPSSystem);
            return caseFormat.to(CaseFormat.LOWER_HYPHEN, strCodeName);
        }
        return strCodeName;
    }

    static {
        CaseFormatMap.put("LOWER_CAMEL", CaseFormat.LOWER_CAMEL);
        CaseFormatMap.put("LOWER_HYPHEN", CaseFormat.LOWER_HYPHEN);
        CaseFormatMap.put("LOWER_UNDERSCORE", CaseFormat.LOWER_UNDERSCORE);
        CaseFormatMap.put("UPPER_CAMEL", CaseFormat.UPPER_CAMEL);
        CaseFormatMap.put("UPPER_UNDERSCORE", CaseFormat.UPPER_UNDERSCORE);
    }
}

