package net.ibizsys.codegen.groovy.support;



import java.util.HashMap;
import java.util.Map;

import org.springframework.util.StringUtils;

import com.google.common.base.CaseFormat;

import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.IPSSystem;
import net.ibizsys.model.system.IPSSysModelGroup;
import net.ibizsys.model.system.IPSSystemModule;

public class PSSystemExtension {

	private static Map<String, CaseFormat> CaseFormatMap = new HashMap<>();
	static {
		CaseFormatMap.put("LOWER_CAMEL", CaseFormat.LOWER_CAMEL);
		CaseFormatMap.put("LOWER_HYPHEN", CaseFormat.LOWER_HYPHEN);
		CaseFormatMap.put("LOWER_UNDERSCORE", CaseFormat.LOWER_UNDERSCORE);
		CaseFormatMap.put("UPPER_CAMEL", CaseFormat.UPPER_CAMEL);
		CaseFormatMap.put("UPPER_UNDERSCORE", CaseFormat.UPPER_UNDERSCORE);
	}
	
	public static String getPKGCodeName(IPSSystem self) {
		if(self.getDefaultPSSysSFPub()==null) {
			throw new RuntimeException("系统未定义默认发布对象");
		}
		
		if(!StringUtils.hasLength(self.getDefaultPSSysSFPub().getPKGCodeName())) {
			if(!StringUtils.hasLength(self.getDefaultPSSysSFPub().getCodeName())) {
				throw new RuntimeException("默认发布对象未定义代码标识");
			}
			return getUpperCamelCodeName(self.getDefaultPSSysSFPub()).toLowerCase();
		}
		else {
			return self.getDefaultPSSysSFPub().getPKGCodeName();
		}
	}
	
	public static String getPKGCodeName(IPSSystemModule iPSSystemModule) {
		if(StringUtils.hasLength(iPSSystemModule.getPKGCodeName())) {
			return iPSSystemModule.getPKGCodeName();
		}
		
		IPSSysModelGroup iPSSysModelGroup = iPSSystemModule.getPSSysModelGroup();
		if(iPSSysModelGroup != null) {
			if(StringUtils.hasLength(iPSSysModelGroup.getPKGCodeName())) {
				return String.format("%1$s.%2$s", iPSSysModelGroup.getPKGCodeName(), getUpperCamelCodeName(iPSSystemModule).toLowerCase());
			}
		}
		return String.format("%1$s.%2$s", getPKGCodeName(iPSSystemModule.getParentPSModelObject(IPSSystem.class)), getUpperCamelCodeName(iPSSystemModule).toLowerCase());

	}
	
	
	/**
	 * 获取系统代码标识格式
	 * @param iPSSystem
	 * @return
	 */
	public static CaseFormat getCodeNameCaseFormat(IPSSystem iPSSystem) {
		CaseFormat caseFormat = CaseFormatMap.get(iPSSystem.getCodeNameMode());
		return caseFormat == null ? CaseFormat.UPPER_CAMEL:caseFormat;
	}
	
	public static String getLowerCamelCodeName(IPSModelObject iPSModelObject) {
		String strCodeName = iPSModelObject.getCodeName();
		if(StringUtils.hasLength(strCodeName)) {
			IPSSystem iPSSystem = iPSModelObject.getParentPSModelObject(IPSSystem.class);
			CaseFormat caseFormat = PSSystemExtension.getCodeNameCaseFormat(iPSSystem);
			return caseFormat.to(CaseFormat.LOWER_CAMEL, strCodeName);
		}
		return strCodeName;
	}
	
	public static String getUpperCamelCodeName(IPSModelObject iPSModelObject) {
		String strCodeName = iPSModelObject.getCodeName();
		if(StringUtils.hasLength(strCodeName)) {
			IPSSystem iPSSystem = iPSModelObject.getParentPSModelObject(IPSSystem.class);
			CaseFormat caseFormat = PSSystemExtension.getCodeNameCaseFormat(iPSSystem);
			return caseFormat.to(CaseFormat.UPPER_CAMEL, strCodeName);
		}
		return strCodeName;
	}
	
	
	/**
	 * 获取大写+下划线代码标识
	 * @param strCodeName
	 * @return
	 * @throws Exception
	 */
	public static String getUpperUnderscoreCodeName(IPSModelObject iPSModelObject) {
		String strCodeName = iPSModelObject.getCodeName();
		if(StringUtils.hasLength(strCodeName)) {
			IPSSystem iPSSystem = iPSModelObject.getParentPSModelObject(IPSSystem.class);
			CaseFormat caseFormat = PSSystemExtension.getCodeNameCaseFormat(iPSSystem);
			return caseFormat.to(CaseFormat.UPPER_UNDERSCORE, strCodeName);
		}
		return strCodeName;
		
	}
	
	
	/**
	 * 获取小写+下划线代码标识
	 * @param strCodeName
	 * @return
	 * @throws Exception
	 */
	public static String getLowerUnderscoreCodeName(IPSModelObject iPSModelObject) {
		String strCodeName = iPSModelObject.getCodeName();
		if(StringUtils.hasLength(strCodeName)) {
			IPSSystem iPSSystem = iPSModelObject.getParentPSModelObject(IPSSystem.class);
			CaseFormat caseFormat = PSSystemExtension.getCodeNameCaseFormat(iPSSystem);
			return caseFormat.to(CaseFormat.LOWER_UNDERSCORE, strCodeName);
		}
		return strCodeName;
	}
	
	
	
	/**
	 * 获取小写+中划线代码标识
	 * @param strCodeName
	 * @return
	 * @throws Exception
	 */
	public static String getLowerHyphenCodeName(IPSModelObject iPSModelObject) {
		String strCodeName = iPSModelObject.getCodeName();
		if(StringUtils.hasLength(strCodeName)) {
			IPSSystem iPSSystem = iPSModelObject.getParentPSModelObject(IPSSystem.class);
			CaseFormat caseFormat = PSSystemExtension.getCodeNameCaseFormat(iPSSystem);
			return caseFormat.to(CaseFormat.LOWER_HYPHEN, strCodeName);
		}
		return strCodeName;
	}
	
}
