/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.codegen.groovy.support;

import java.util.Arrays;
import net.ibizsys.codegen.groovy.support.GroovyCodeGenEngineExtension;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.dataentity.logic.IPSDELogicLink;
import net.ibizsys.model.dataentity.logic.IPSDELogicNode;
import net.ibizsys.model.dataentity.logic.IPSDELogicNodeParam;
import net.ibizsys.model.dataentity.logic.IPSDERawSqlCallLogic;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class PSDELogicNodeExtension {
    public static String getComment(IPSDELogicNode iPSDELogicNode) {
        StringBuilder stringBuilder = new StringBuilder();
        if (iPSDELogicNode instanceof IPSDERawSqlCallLogic) {
            // empty if block
        }
        return iPSDELogicNode.getMemo();
    }

    public static IPSDELogicLink getCatchPSDELogicLink(IPSDELogicNode iPSDELogicNode) {
        if (ObjectUtils.isEmpty((Object)iPSDELogicNode.getPSDELogicLinks())) {
            return null;
        }
        for (IPSDELogicLink iPSDELogicLink : iPSDELogicNode.getPSDELogicLinks()) {
            if (!iPSDELogicLink.isCatchLink()) continue;
            return iPSDELogicLink;
        }
        return null;
    }

    public static String getPrepareParamGroovyExpression(IPSDELogicNodeParam iPSDELogicNodeParam) {
        String strParamAction = iPSDELogicNodeParam.getParamAction();
        if (PSModelEnums.DELogicParamType.SETPARAMVALUE.value.equals(strParamAction)) {
            if (!StringUtils.hasLength((String)iPSDELogicNodeParam.getDstFieldName())) {
                throw new RuntimeException(String.format("\u5904\u7406\u8282\u70b9\u53c2\u6570[%1$s]\u672a\u6307\u5b9a\u8bbe\u7f6e\u76ee\u6807\u5c5e\u6027", iPSDELogicNodeParam.getName()));
            }
            if (PSModelEnums.DELogicParamValueType.NONEVALUE.value.equalsIgnoreCase(iPSDELogicNodeParam.getSrcValueType())) {
                return String.format("param(%1$s).reset(%2$s)", GroovyCodeGenEngineExtension.getGroovyString(iPSDELogicNodeParam.getDstPSDELogicParamMust().getCodeName()), GroovyCodeGenEngineExtension.getGroovyString(iPSDELogicNodeParam.getDstFieldName()));
            }
            String strValueComment = PSDELogicNodeExtension.getParamValueComment(iPSDELogicNodeParam);
            String strValueExp = PSDELogicNodeExtension.getParamValueExpression(iPSDELogicNodeParam);
            String strExpression = String.format("param(%1$s).set(%2$s, %3$s)", GroovyCodeGenEngineExtension.getGroovyString(iPSDELogicNodeParam.getDstPSDELogicParamMust().getCodeName()), GroovyCodeGenEngineExtension.getGroovyString(iPSDELogicNodeParam.getDstFieldName()), strValueExp);
            if (StringUtils.hasLength((String)strValueComment)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(StringUtils.collectionToDelimitedString(Arrays.asList(strValueComment.replace("\r\n", "\n").replace("\r", "\n").split("\n")), (String)"\n", (String)"// ", (String)""));
                stringBuilder.append("\n");
                strExpression = stringBuilder.toString() + strExpression;
            }
            return strExpression;
        }
        throw new RuntimeException(String.format("\u5904\u7406\u8282\u70b9\u53c2\u6570[%1$s]\u51c6\u5907\u53c2\u6570\u7c7b\u578b[%2$s]\u672a\u652f\u6301", iPSDELogicNodeParam.getName(), strParamAction));
    }

    public static String getParamValueExpression(IPSDELogicNodeParam iPSDELogicNodeParam) {
        if (PSModelEnums.DELogicParamValueType.SRCDLPARAM.value.equals(iPSDELogicNodeParam.getSrcValueType())) {
            if (StringUtils.isEmpty((Object)iPSDELogicNodeParam.getSrcFieldName())) {
                return String.format("param(%1$s).real", GroovyCodeGenEngineExtension.getGroovyString(iPSDELogicNodeParam.getSrcPSDELogicParamMust().getCodeName()));
            }
            return String.format("param(%1$s).get(%2$s)", GroovyCodeGenEngineExtension.getGroovyString(iPSDELogicNodeParam.getSrcPSDELogicParamMust().getCodeName()), GroovyCodeGenEngineExtension.getGroovyString(iPSDELogicNodeParam.getSrcFieldName()));
        }
        if (PSModelEnums.DELogicParamValueType.NULLVALUE.value.equals(iPSDELogicNodeParam.getSrcValueType())) {
            return "null";
        }
        if (PSModelEnums.DELogicParamValueType.SRCVALUE.value.equals(iPSDELogicNodeParam.getSrcValueType())) {
            return GroovyCodeGenEngineExtension.getGroovyString(iPSDELogicNodeParam.getSrcValue());
        }
        IPSDELogicNode iPSDELogcNode = (IPSDELogicNode)iPSDELogicNodeParam.getParentPSModelObject(IPSDELogicNode.class, false);
        int nPos = iPSDELogcNode.getPSDELogicNodeParams().indexOf(iPSDELogicNodeParam);
        if (nPos != -1) {
            return String.format("getNodeParamValue(NODES['%1$s'].getPSDELogicNodeParams()[%2$s])", iPSDELogcNode.getCodeName().toUpperCase(), nPos);
        }
        throw new RuntimeException(String.format("\u5904\u7406\u8282\u70b9\u53c2\u6570[%1$s]\u6e90\u503c\u7c7b\u578b[%2$s]\u672a\u652f\u6301", iPSDELogicNodeParam.getName(), iPSDELogicNodeParam.getSrcValueType()));
    }

    public static String getParamValueComment(IPSDELogicNodeParam iPSDELogicNodeParam) {
        if (PSModelEnums.DELogicParamValueType.EXPRESSION.value.equals(iPSDELogicNodeParam.getSrcValueType())) {
            StringBuilder stringBuilder = new StringBuilder();
            if (iPSDELogicNodeParam.getDstPSDELogicParam() != null) {
                stringBuilder.append(String.format("\u5f53\u524d\u53c2\u6570\uff1a%1$s(%2$s)\n", iPSDELogicNodeParam.getDstPSDELogicParam().getName(), iPSDELogicNodeParam.getDstPSDELogicParam().getCodeName()));
            }
            stringBuilder.append(String.format("\u811a\u672c\u4ee3\u7801\uff1a\n%1$s", iPSDELogicNodeParam.getExpression()));
            return stringBuilder.toString();
        }
        return null;
    }
}

