/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.codegen.groovy.support;

import java.util.ArrayList;
import java.util.Arrays;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.defield.valuerule.IPSDEFVRCondition;
import net.ibizsys.model.dataentity.defield.valuerule.IPSDEFVRGroupCondition;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class PSDEFieldExtension {
    public static String getDefaultValueComment(IPSDEField self) {
        if (!StringUtils.hasLength((String)self.getDefaultValueType()) && !StringUtils.hasLength((String)self.getDefaultValue())) {
            return null;
        }
        if (!StringUtils.hasLength((String)self.getDefaultValueType())) {
            return String.format("[\u76f4\u63a5\u503c] %1$s", self.getDefaultValue());
        }
        PSModelEnums.DEFDefaultValueType defDefaultValueType = PSModelEnums.DEFDefaultValueType.from((String)self.getDefaultValueType());
        if (!StringUtils.hasLength((String)self.getDefaultValue())) {
            return String.format("[%1$s]", defDefaultValueType.text);
        }
        return String.format("[%1$s] %2$s", defDefaultValueType.text, self.getDefaultValue());
    }

    public static String getValueRuleComment(IPSDEField self) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("[\u5141\u8bb8\u7a7a\u8f93\u5165] %1$s", self.isAllowEmpty() ? "\u662f" : "\u5426"));
        if (StringUtils.hasLength((String)self.getDupCheckMode()) && !PSModelEnums.DEFDupCheckMode.NONE.value.equals(self.getDupCheckMode())) {
            PSModelEnums.DEFDupCheckMode defDupCheckMode = PSModelEnums.DEFDupCheckMode.from((String)self.getDupCheckMode());
            stringBuilder.append(String.format("\n[\u91cd\u590d\u503c\u68c0\u67e5] %1$s", defDupCheckMode.text));
            if (!ObjectUtils.isEmpty((Object[])self.getDupCheckValues())) {
                stringBuilder.append(String.format("[%1$s]", StringUtils.collectionToDelimitedString(Arrays.asList(self.getDupCheckValues()), (String)",")));
            }
            if (!ObjectUtils.isEmpty((Object)self.getDupCheckPSDEFields())) {
                ArrayList<String> list = new ArrayList<String>();
                for (IPSDEField iPSDEField : self.getDupCheckPSDEFields()) {
                    list.add(iPSDEField.getName());
                }
                stringBuilder.append(String.format("\uff0c\u7ea6\u675f\u5c5e\u6027[%1$s]", StringUtils.collectionToDelimitedString(list, (String)",")));
            }
        }
        return stringBuilder.toString();
    }

    public static String getComment(IPSDEFVRCondition self) {
        StringBuilder stringBuilder = new StringBuilder();
        if (PSModelEnums.DEFVRType.GROUP.value.equals(self.getCondType())) {
            IPSDEFVRGroupCondition iPSDEFVRGroupCondition = (IPSDEFVRGroupCondition)self;
            if (ObjectUtils.isEmpty((Object)iPSDEFVRGroupCondition.getPSDEFVRConditions())) {
                return null;
            }
            ArrayList<String> list = new ArrayList<String>();
            for (IPSDEFVRCondition iPSDEFVRCondition : iPSDEFVRGroupCondition.getPSDEFVRConditions()) {
                String strComment = PSDEFieldExtension.getComment(iPSDEFVRCondition);
                if (!StringUtils.hasLength((String)strComment)) continue;
                list.add(strComment);
            }
            if (ObjectUtils.isEmpty(list)) {
                return null;
            }
            if (list.size() == 1 && !iPSDEFVRGroupCondition.isNotMode()) {
                return (String)list.get(0);
            }
            if (iPSDEFVRGroupCondition.isNotMode()) {
                stringBuilder.append("[\u53d6\u53cd(NOT)]");
            }
            if (PSModelEnums.GroupCondOP.AND.value.equalsIgnoreCase(iPSDEFVRGroupCondition.getCondOp())) {
                stringBuilder.append(String.format("[%1$s]", PSModelEnums.GroupCondOP.AND.text));
            } else {
                stringBuilder.append(String.format("[%1$s]", PSModelEnums.GroupCondOP.OR.text));
            }
            stringBuilder.append(String.format(" {\n", new Object[0]));
            for (String strComment : list) {
                String[] items;
                for (String item : items = strComment.split("[\n]")) {
                    stringBuilder.append(String.format("    %1$s\n", item));
                }
            }
            stringBuilder.append(String.format("}\n", new Object[0]));
            return stringBuilder.toString();
        }
        PSModelEnums.DEFVRType defVRType = PSModelEnums.DEFVRType.from((String)self.getCondType());
        return String.format("[%1$s] %2$s", defVRType.text, self.getRuleInfo());
    }
}

