package net.ibizsys.codegen.groovy.util;

import net.ibizsys.codegen.core.util.StdDataTypeUtils;
import net.ibizsys.model.PSModelEnums.StdDataType;

public class GroovyUtils {

	public static String getGroovyType(StdDataType stdDataType) {

		if(StdDataTypeUtils.isStringDataType(stdDataType)) {
			return "String";
		}
		
		if(StdDataTypeUtils.isDateTimeDataType(stdDataType)) {
			return "Date";
		}
		
		if(StdDataTypeUtils.isBigDecimalDataType(stdDataType)) {
			return "BigDecimal";
		}
		
		if(StdDataTypeUtils.isBigIntDataType(stdDataType)) {
			return "BigInteger";
		}
		
		if(StdDataTypeUtils.isIntDataType(stdDataType)) {
			return "Integer";
		}
		
		if(StdDataTypeUtils.isNumberDataType(stdDataType)) {
			return "Double";
		}
	
		if(StdDataTypeUtils.isBinaryType(stdDataType)) {
			return "byte[]";
		}
		
		return "def";
	}
	
	
	public static String getPythonType(StdDataType stdDataType) {

		if(StdDataTypeUtils.isStringDataType(stdDataType)) {
			return "str";
		}
		
		if(StdDataTypeUtils.isDateTimeDataType(stdDataType)) {
			return "str";
		}
		
		if(StdDataTypeUtils.isBigDecimalDataType(stdDataType)) {
			return "float";
		}
		
		if(StdDataTypeUtils.isBigIntDataType(stdDataType)) {
			return "int";
		}
		
		if(StdDataTypeUtils.isIntDataType(stdDataType)) {
			return "int";
		}
		
		if(StdDataTypeUtils.isNumberDataType(stdDataType)) {
			return "float";
		}
	
		if(StdDataTypeUtils.isBinaryType(stdDataType)) {
			return "str";
		}
		
		return "str";
	}
	
}
