package net.ibizsys.codegen.groovy.support;



import org.springframework.util.StringUtils;

import net.ibizsys.model.IPSSystem;
import net.ibizsys.model.system.IPSSysModelGroup;
import net.ibizsys.model.system.IPSSystemModule;

public class PSSystemExtension {

	public static String getPKGCodeName(IPSSystem self) {
		if(self.getDefaultPSSysSFPub()==null) {
			throw new RuntimeException("系统未定义默认发布对象");
		}
		
		if(!StringUtils.hasLength(self.getDefaultPSSysSFPub().getCodeName())) {
			throw new RuntimeException("默认发布对象未定义代码标识");
		}
		
		if(!StringUtils.hasLength(self.getDefaultPSSysSFPub().getPKGCodeName())) {
			return self.getDefaultPSSysSFPub().getCodeName().toLowerCase();
		}
		else {
			return String.format("%1$s.%2$s", self.getDefaultPSSysSFPub().getPKGCodeName(), self.getDefaultPSSysSFPub().getCodeName().toLowerCase());
		}
	}
	
	public static String getPKGCodeName(IPSSystemModule iPSSystemModule) {
		if(StringUtils.hasLength(iPSSystemModule.getPKGCodeName())) {
			return iPSSystemModule.getPKGCodeName();
		}
		
		IPSSysModelGroup iPSSysModelGroup = iPSSystemModule.getPSSysModelGroup();
		if(iPSSysModelGroup != null) {
			if(StringUtils.hasLength(iPSSysModelGroup.getPKGCodeName())) {
				return String.format("%1$s.%2$s", iPSSysModelGroup.getPKGCodeName(), iPSSysModelGroup.getCodeName().toLowerCase());
			}
		}
		
		return getPKGCodeName(iPSSystemModule.getParentPSModelObject(IPSSystem.class));
	}
	
	
	
	
}
