/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.task.ebsx.cloudutil;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.cloud.core.security.IEmployeeContext;
import net.ibizsys.central.cloud.core.util.domain.JobsInfo;
import net.ibizsys.central.cloud.saas.ebsx.EBSXSystemRuntime;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.center.dto.DCJobsInfoDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.task.dto.JobsInfoDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.task.dto.JobsLogDTO;
import net.ibizsys.central.cloud.task.core.cloudutil.CloudTaskUtilRuntimeBase;
import net.ibizsys.central.service.client.IWebClientRep;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.central.util.SearchContextDTO;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.IAction;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.KeyValueUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class EBSXCloudTaskUtilRuntime
extends CloudTaskUtilRuntimeBase {
    private static final Log log = LogFactory.getLog(EBSXCloudTaskUtilRuntime.class);
    public static final String TRIGGERTYPE_MANUAL = "\u624b\u52a8\u89e6\u53d1";
    public static final String TRIGGERTYPE_TIMER = "\u5b9a\u65f6\u89e6\u53d1";
    private Map<String, JobsInfoDTO> jobsInfoMap = new HashMap<String, JobsInfoDTO>();

    protected void onInstall() throws Exception {
        super.onInstall();
        this.prepareJobs();
    }

    protected void prepareJobs() {
        this.executeAction("\u51c6\u5907\u4f5c\u4e1a", new IAction(){

            public Object execute(Object[] args) throws Throwable {
                EBSXCloudTaskUtilRuntime.this.onPrepareJobs();
                return null;
            }
        }, null);
    }

    protected void onPrepareJobs() throws Throwable {
        SearchContextDTO searchContextDTO = new SearchContextDTO().all().eq("STATUS", (Object)0).nn("CRON");
        List list = EBSXSystemRuntime.getInstance().getJobsInfoService().selectDefault((ISearchContextDTO)searchContextDTO);
        this.refreshJobsInfos(list);
    }

    protected synchronized void refreshJobsInfos(List<JobsInfoDTO> list) throws Throwable {
        HashMap<String, JobsInfoDTO> lastMap = new HashMap<String, JobsInfoDTO>();
        lastMap.putAll(this.jobsInfoMap);
        for (JobsInfoDTO jobsInfo : list) {
            if (!StringUtils.hasLength((String)jobsInfo.getCron())) continue;
            JobsInfoDTO last = (JobsInfoDTO)lastMap.remove(jobsInfo.getId());
            if (last == null) {
                this.startJob(jobsInfo);
                continue;
            }
            if (jobsInfo.getCron().equalsIgnoreCase(last.getCron())) continue;
            this.stopJob(last);
            this.startJob(jobsInfo);
        }
        for (JobsInfoDTO last : lastMap.values()) {
            this.stopJob(last);
        }
    }

    protected synchronized void startJob(JobsInfoDTO jobsInfoDTO) throws Throwable {
        JobsInfo jobsInfo = new JobsInfo();
        jobsInfoDTO.copyTo((IEntity)jobsInfo, true);
        this.startJob(jobsInfo);
    }

    protected synchronized void stopJob(JobsInfoDTO jobsInfoDTO) throws Throwable {
        JobsInfo jobsInfo = new JobsInfo();
        jobsInfoDTO.copyTo((IEntity)jobsInfo, true);
        this.stopJob(jobsInfo);
    }

    protected Object executeJob(JobsInfoDTO jobsInfoDTO, Map params, String strTriggerType) throws Throwable {
        JobsInfo jobsInfo = new JobsInfo();
        jobsInfoDTO.copyTo((IEntity)jobsInfo, true);
        JobsLogDTO jobsLogDTO = new JobsLogDTO();
        jobsLogDTO.setId(KeyValueUtils.genUniqueId());
        jobsLogDTO.setJobId(jobsInfoDTO.getId());
        jobsLogDTO.setHandler(jobsInfo.getHandler());
        jobsLogDTO.setTriggerType(strTriggerType);
        jobsLogDTO.setCreateTime(new Timestamp(System.currentTimeMillis()));
        jobsLogDTO.setSrfdcid(jobsInfoDTO.getSrfdcid());
        jobsLogDTO.setTriggerCode(Integer.valueOf(0));
        IEmployeeContext iEmployeeContext = EmployeeContext.getCurrent();
        String strUserId = iEmployeeContext != null ? iEmployeeContext.getUserid() : "SYSTEM";
        try {
            IWebClientRep ret = this.executeTaskCallback(jobsInfo, params, String.class);
            try {
                jobsLogDTO.setTriggerMsg((String)ret.getBody());
                EBSXSystemRuntime.getInstance().getJobsLogService().rawCreate(Arrays.asList(jobsLogDTO), true);
            }
            catch (Throwable ex) {
                log.error((Object)ex);
            }
            return ret.getBody();
        }
        catch (Throwable ex) {
            try {
                jobsLogDTO.setTriggerCode(Integer.valueOf(-1));
                jobsLogDTO.setTriggerMsg(ex.getMessage());
                EBSXSystemRuntime.getInstance().getJobsLogService().rawCreate(Arrays.asList(jobsLogDTO), true);
            }
            catch (Throwable ex2) {
                log.error((Object)ex2);
            }
            throw ex;
        }
    }

    protected Object onExecuteTask(JobsInfo jobsInfo, Object objData) throws Throwable {
        JobsLogDTO jobsLogDTO = new JobsLogDTO();
        jobsLogDTO.setId(KeyValueUtils.genUniqueId());
        jobsLogDTO.setJobId(jobsInfo.getId());
        jobsLogDTO.setHandler(jobsInfo.getHandler());
        jobsLogDTO.setTriggerType(TRIGGERTYPE_TIMER);
        jobsLogDTO.setCreateTime(new Timestamp(System.currentTimeMillis()));
        jobsLogDTO.setSrfdcid((String)jobsInfo.get("srfdcid"));
        jobsLogDTO.setTriggerCode(Integer.valueOf(0));
        String strUserId = "SYSTEM";
        try {
            IWebClientRep ret = this.executeTaskCallback(jobsInfo, null, String.class);
            try {
                jobsLogDTO.setTriggerMsg((String)ret.getBody());
                EBSXSystemRuntime.getInstance().getJobsLogService().rawCreate(Arrays.asList(jobsLogDTO), true);
            }
            catch (Throwable ex) {
                log.error((Object)ex);
            }
            return ret.getBody();
        }
        catch (Throwable ex) {
            try {
                jobsLogDTO.setTriggerCode(Integer.valueOf(-1));
                jobsLogDTO.setTriggerMsg(ex.getMessage());
                EBSXSystemRuntime.getInstance().getJobsLogService().rawCreate(Arrays.asList(jobsLogDTO), true);
            }
            catch (Throwable ex2) {
                log.error((Object)ex2);
            }
            throw ex;
        }
    }

    protected Object onExecuteTask(String strId, Map params) throws Throwable {
        IEmployeeContext iEmployeeContext = EmployeeContext.getCurrentMust();
        DCJobsInfoDTO dcJobsInfo = EBSXSystemRuntime.getInstance().getDCJobsInfoService().get(strId);
        JobsInfoDTO jobsInfo = new JobsInfoDTO();
        dcJobsInfo.copyTo((IEntity)jobsInfo);
        jobsInfo.setSrfdcid(iEmployeeContext.getTenant());
        return this.executeJob(jobsInfo, params, TRIGGERTYPE_MANUAL);
    }

    protected void onStartTask(String strId) throws Throwable {
        IEmployeeContext iEmployeeContext = EmployeeContext.getCurrentMust();
        DCJobsInfoDTO dcJobsInfo = EBSXSystemRuntime.getInstance().getDCJobsInfoService().get(strId);
        JobsInfoDTO jobsInfo = new JobsInfoDTO();
        dcJobsInfo.copyTo((IEntity)jobsInfo);
        jobsInfo.setSrfdcid(iEmployeeContext.getTenant());
        if (DataTypeUtils.getIntegerValue((Object)jobsInfo.getStatus(), (Integer)1) != 0) {
            throw new Exception("\u4f5c\u4e1a\u72b6\u6001\u4e0d\u6b63\u786e");
        }
        this.startJob(jobsInfo);
    }

    protected void onStopTask(String strId) throws Throwable {
        IEmployeeContext iEmployeeContext = EmployeeContext.getCurrentMust();
        DCJobsInfoDTO dcJobsInfo = EBSXSystemRuntime.getInstance().getDCJobsInfoService().get(strId);
        JobsInfoDTO jobsInfo = new JobsInfoDTO();
        dcJobsInfo.copyTo((IEntity)jobsInfo);
        jobsInfo.setSrfdcid(iEmployeeContext.getTenant());
        if (DataTypeUtils.getIntegerValue((Object)jobsInfo.getStatus(), (Integer)1) != 1) {
            throw new Exception("\u4f5c\u4e1a\u72b6\u6001\u4e0d\u6b63\u786e");
        }
        this.stopJob(jobsInfo);
    }
}

