package net.ibizsys.central.cloud.saas.ebsx.spring.core.workflow.dto;

import java.sql.Timestamp;
import java.util.List;
import java.math.BigDecimal;

import net.ibizsys.central.util.EntityDTO;

import com.fasterxml.jackson.annotation.JsonIgnore;
import net.ibizsys.runtime.util.DataTypeUtils;

/**
 * 工作流未提交业务数据
 * 
 * @see ibizmos:/psmodules/workflow/psdataentities/WF_UNDOTASK/.ibizmodel.index
 */
public class WFUndoTaskDTO extends EntityDTO {

  /**.
   * 业务数据主键
   *
   * @see ibizmos:/psmodules/workflow/psdataentities/WF_UNDOTASK/psdefields/BUSINESSKEY/.ibizmodel.index
   */
  public final static String FIELD_BUSINESSKEY = "businesskey";

  /**.
   * 租户系统标识
   *
   * @see ibizmos:/psmodules/workflow/psdataentities/WF_UNDOTASK/psdefields/DCSYSTEMID/.ibizmodel.index
   */
  public final static String FIELD_DCSYSTEMID = "dcsystemid";

  /**.
   * 组织部门标识
   *
   * @see ibizmos:/psmodules/workflow/psdataentities/WF_UNDOTASK/psdefields/DEPTID/.ibizmodel.index
   */
  public final static String FIELD_DEPTID = "deptid";

  /**.
   * 实体标识
   *
   * @see ibizmos:/psmodules/workflow/psdataentities/WF_UNDOTASK/psdefields/ENTITYID/.ibizmodel.index
   */
  public final static String FIELD_ENTITYID = "entityid";

  /**.
   * 业务数据主信息属性
   *
   * @see ibizmos:/psmodules/workflow/psdataentities/WF_UNDOTASK/psdefields/MAJORTEXT/.ibizmodel.index
   */
  public final static String FIELD_MAJORTEXT = "majortext";

  /**.
   * 组织机构标识
   *
   * @see ibizmos:/psmodules/workflow/psdataentities/WF_UNDOTASK/psdefields/ORGID/.ibizmodel.index
   */
  public final static String FIELD_ORGID = "orgid";

  /**.
   * 任务标识
   *
   * @see ibizmos:/psmodules/workflow/psdataentities/WF_UNDOTASK/psdefields/TASKID/.ibizmodel.index
   */
  public final static String FIELD_TASKID = "taskid";

  /**.
   * 用户标识
   *
   * @see ibizmos:/psmodules/workflow/psdataentities/WF_UNDOTASK/psdefields/USERID/.ibizmodel.index
   */
  public final static String FIELD_USERID = "userid";


    /**
     * 设置「业务数据主键」
     *
     * @param val
    */
    @JsonIgnore
    public WFUndoTaskDTO setBusinessKey(String val) {
        this._set(FIELD_BUSINESSKEY, val);
        return this;
    }

    /**
     * 获取「业务数据主键」值
     *
    */
    @JsonIgnore
    public String getBusinessKey() {
        return (String) this._get(FIELD_BUSINESSKEY);
    }

    /**
     * 判断 「业务数据主键」是否有值
     *
    */
    @JsonIgnore
    public boolean containsBusinessKey() {
        return this._contains(FIELD_BUSINESSKEY);
    }

    /**
     * 重置 「业务数据主键」
     *
    */
    @JsonIgnore
    public WFUndoTaskDTO resetBusinessKey() {
        this._reset(FIELD_BUSINESSKEY);
        return this;
    }

    /**
     * 设置「租户系统标识」
     *
     * @param val
    */
    @JsonIgnore
    public WFUndoTaskDTO setDCSystemId(String val) {
        this._set(FIELD_DCSYSTEMID, val);
        return this;
    }

    /**
     * 获取「租户系统标识」值
     *
    */
    @JsonIgnore
    public String getDCSystemId() {
        return (String) this._get(FIELD_DCSYSTEMID);
    }

    /**
     * 判断 「租户系统标识」是否有值
     *
    */
    @JsonIgnore
    public boolean containsDCSystemId() {
        return this._contains(FIELD_DCSYSTEMID);
    }

    /**
     * 重置 「租户系统标识」
     *
    */
    @JsonIgnore
    public WFUndoTaskDTO resetDCSystemId() {
        this._reset(FIELD_DCSYSTEMID);
        return this;
    }

    /**
     * 设置「组织部门标识」
     *
     * @param val
    */
    @JsonIgnore
    public WFUndoTaskDTO setDeptId(String val) {
        this._set(FIELD_DEPTID, val);
        return this;
    }

    /**
     * 获取「组织部门标识」值
     *
    */
    @JsonIgnore
    public String getDeptId() {
        return (String) this._get(FIELD_DEPTID);
    }

    /**
     * 判断 「组织部门标识」是否有值
     *
    */
    @JsonIgnore
    public boolean containsDeptId() {
        return this._contains(FIELD_DEPTID);
    }

    /**
     * 重置 「组织部门标识」
     *
    */
    @JsonIgnore
    public WFUndoTaskDTO resetDeptId() {
        this._reset(FIELD_DEPTID);
        return this;
    }

    /**
     * 设置「实体标识」
     *
     * @param val
    */
    @JsonIgnore
    public WFUndoTaskDTO setEntityId(String val) {
        this._set(FIELD_ENTITYID, val);
        return this;
    }

    /**
     * 获取「实体标识」值
     *
    */
    @JsonIgnore
    public String getEntityId() {
        return (String) this._get(FIELD_ENTITYID);
    }

    /**
     * 判断 「实体标识」是否有值
     *
    */
    @JsonIgnore
    public boolean containsEntityId() {
        return this._contains(FIELD_ENTITYID);
    }

    /**
     * 重置 「实体标识」
     *
    */
    @JsonIgnore
    public WFUndoTaskDTO resetEntityId() {
        this._reset(FIELD_ENTITYID);
        return this;
    }

    /**
     * 设置「业务数据主信息属性」
     *
     * @param val
    */
    @JsonIgnore
    public WFUndoTaskDTO setMajorText(String val) {
        this._set(FIELD_MAJORTEXT, val);
        return this;
    }

    /**
     * 获取「业务数据主信息属性」值
     *
    */
    @JsonIgnore
    public String getMajorText() {
        return (String) this._get(FIELD_MAJORTEXT);
    }

    /**
     * 判断 「业务数据主信息属性」是否有值
     *
    */
    @JsonIgnore
    public boolean containsMajorText() {
        return this._contains(FIELD_MAJORTEXT);
    }

    /**
     * 重置 「业务数据主信息属性」
     *
    */
    @JsonIgnore
    public WFUndoTaskDTO resetMajorText() {
        this._reset(FIELD_MAJORTEXT);
        return this;
    }

    /**
     * 设置「组织机构标识」
     *
     * @param val
    */
    @JsonIgnore
    public WFUndoTaskDTO setOrgId(String val) {
        this._set(FIELD_ORGID, val);
        return this;
    }

    /**
     * 获取「组织机构标识」值
     *
    */
    @JsonIgnore
    public String getOrgId() {
        return (String) this._get(FIELD_ORGID);
    }

    /**
     * 判断 「组织机构标识」是否有值
     *
    */
    @JsonIgnore
    public boolean containsOrgId() {
        return this._contains(FIELD_ORGID);
    }

    /**
     * 重置 「组织机构标识」
     *
    */
    @JsonIgnore
    public WFUndoTaskDTO resetOrgId() {
        this._reset(FIELD_ORGID);
        return this;
    }

    /**
     * 设置「任务标识」
     *
     * @param val
    */
    @JsonIgnore
    public WFUndoTaskDTO setTaskId(String val) {
        this._set(FIELD_TASKID, val);
        return this;
    }

    /**
     * 获取「任务标识」值
     *
    */
    @JsonIgnore
    public String getTaskId() {
        return (String) this._get(FIELD_TASKID);
    }

    /**
     * 判断 「任务标识」是否有值
     *
    */
    @JsonIgnore
    public boolean containsTaskId() {
        return this._contains(FIELD_TASKID);
    }

    /**
     * 重置 「任务标识」
     *
    */
    @JsonIgnore
    public WFUndoTaskDTO resetTaskId() {
        this._reset(FIELD_TASKID);
        return this;
    }

    /**
     * 设置「用户标识」
     *
     * @param val
    */
    @JsonIgnore
    public WFUndoTaskDTO setUserId(String val) {
        this._set(FIELD_USERID, val);
        return this;
    }

    /**
     * 获取「用户标识」值
     *
    */
    @JsonIgnore
    public String getUserId() {
        return (String) this._get(FIELD_USERID);
    }

    /**
     * 判断 「用户标识」是否有值
     *
    */
    @JsonIgnore
    public boolean containsUserId() {
        return this._contains(FIELD_USERID);
    }

    /**
     * 重置 「用户标识」
     *
    */
    @JsonIgnore
    public WFUndoTaskDTO resetUserId() {
        this._reset(FIELD_USERID);
        return this;
    }


}
