/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.saas.ebsx.spring.core.extensions.service;

import javax.annotation.Priority;
import net.ibizsys.central.cloud.core.security.PasswordPolicyException;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.ou.dto.DeptMemberDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.ou.dto.EmployeeDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.ou.dto.OrganizationDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.ou.service.impl.EmployeeServiceImpl;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.uaa.dto.UserDTO;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.central.util.SearchContextDTO;
import net.ibizsys.runtime.util.KeyValueUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Priority(value=100)
@Service
public class EmployeeServiceImplEx
extends EmployeeServiceImpl {
    @Override
    protected void onBeforeCreate(EmployeeDTO dto) throws Throwable {
        this.syncUser(dto, true);
        super.onBeforeCreate(dto);
    }

    @Override
    protected void onBeforeUpdate(EmployeeDTO dto) throws Throwable {
        this.syncUser(dto, false);
        super.onBeforeUpdate(dto);
    }

    protected void syncUser(EmployeeDTO dto, boolean bCreate) throws Throwable {
        SearchContextDTO searchContextDTO;
        dto.resetUAAUserId();
        String strLastUserName = "";
        String strLastUAAUserId = "";
        String strLastMDeptId = "";
        String strLastLoginName = "";
        String strUserName = "";
        String strLoginName = dto.getLoginName();
        String strOrgId = dto.getOrgId();
        String strPersonName = dto.getPersonName();
        if (StringUtils.hasLength((String)strLoginName) && StringUtils.hasLength((String)strOrgId)) {
            OrganizationDTO orgDTO = (OrganizationDTO)this.getSystemRuntime().getOrganizationService().get(strOrgId, true);
            if (orgDTO == null) {
                throw new Exception(String.format("\u6307\u5b9a\u7ec4\u7ec7\u65e0\u6548", new Object[0]));
            }
            strUserName = String.format("%1$s@%2$s", strLoginName, strOrgId);
        }
        if (bCreate) {
            if (!StringUtils.hasLength((String)strUserName)) {
                throw new Exception(String.format("\u672a\u6307\u5b9a\u767b\u5f55\u6807\u8bc6\u6216\u6240\u5c5e\u7ec4\u7ec7", new Object[0]));
            }
            dto.setUserName(strUserName);
        } else {
            EmployeeDTO last = this.get(dto.getUserId());
            strLastUserName = last.getUserName();
            strLastUAAUserId = last.getUAAUserId();
            strLastLoginName = last.getLoginName();
            strLastMDeptId = last.getMDeptId();
            if (StringUtils.hasLength((String)strLastUAAUserId)) {
                if (!StringUtils.hasLength((String)strUserName) && StringUtils.hasLength((String)strOrgId)) {
                    strUserName = String.format("%1$s@%2$s", strLastLoginName, dto.getOrgId());
                }
                if (StringUtils.hasLength((String)strUserName) && strUserName.equalsIgnoreCase(strLastUserName)) {
                    strUserName = null;
                }
            }
            if (StringUtils.hasLength((String)strLastMDeptId)) {
                if (dto.containsMDeptId()) {
                    if (strLastMDeptId.equals(dto.getMDeptId())) {
                        strLastMDeptId = null;
                    }
                } else {
                    strLastMDeptId = null;
                }
            }
        }
        if (StringUtils.hasLength((String)strUserName)) {
            String strPassword;
            searchContextDTO = new SearchContextDTO();
            searchContextDTO.eq("LOGINNAME", (Object)strLoginName);
            searchContextDTO.eq("DOMAINS", (Object)strOrgId);
            UserDTO userDTO = (UserDTO)this.getSystemRuntime().getUserService().selectOne((ISearchContextDTO)searchContextDTO, true);
            if (userDTO != null) {
                throw new Exception(String.format("\u6307\u5b9a\u767b\u5f55\u6807\u8bc6\u5df2\u7ecf\u5b58\u5728", new Object[0]));
            }
            userDTO = new UserDTO();
            userDTO.setUserName(strUserName);
            userDTO.setLoginName(strLoginName);
            userDTO.setDomains(strOrgId);
            if (StringUtils.hasLength((String)strPersonName)) {
                userDTO.setPersonName(strPersonName);
            }
            if (StringUtils.hasLength((String)(strPassword = dto.getPassword())) && !"_SRF_HASH_Ab1&_".equals(strPassword)) {
                userDTO.setPassword(strPassword);
            }
            if (StringUtils.hasLength((String)strLastUAAUserId)) {
                userDTO.setUserId(strLastUAAUserId);
                userDTO.resetLoginName();
                this.getSystemRuntime().getUserService().update(userDTO);
            } else {
                this.getSystemRuntime().getUserService().create(userDTO);
            }
            dto.setUserName(strUserName);
            dto.setUAAUserId(userDTO.getUserId());
        } else {
            String strPassword = dto.getPassword();
            if (StringUtils.hasLength((String)strPassword) && !"_SRF_HASH_Ab1&_".equals(strPassword)) {
                UserDTO userDTO = new UserDTO();
                userDTO.setUserId(strLastUAAUserId);
                userDTO.setPassword(strPassword);
                this.getSystemRuntime().getUserService().update(userDTO);
            }
        }
        if (StringUtils.hasLength((String)strLastMDeptId)) {
            searchContextDTO = new SearchContextDTO();
            searchContextDTO.eq("DEPTID", (Object)strLastMDeptId);
            searchContextDTO.eq("USERID", (Object)dto.getUserId());
            this.getSystemRuntime().getDeptMemberService().remove((ISearchContextDTO)searchContextDTO);
        }
        dto.setPassword("_SRF_HASH_Ab1&_");
    }

    @Override
    protected void onBeforeRemove(String key) throws Throwable {
        SearchContextDTO searchContextDTO = new SearchContextDTO();
        searchContextDTO.eq("USERID", (Object)key);
        this.getSystemRuntime().getDeptMemberService().remove((ISearchContextDTO)searchContextDTO);
        EmployeeDTO employeeDTO = this.get(key);
        String userId = employeeDTO.getUAAUserId();
        if (StringUtils.hasLength((String)userId)) {
            UserDTO userDTO = this.getSystemRuntime().getUserService().get(userId);
            String confuseLoginName = String.format("%1$s|%2$s", KeyValueUtils.genGuidEx(), userDTO.getLoginName());
            userDTO.setLoginName(confuseLoginName);
            String confuseUserName = String.format("%1$s@%2$s", confuseLoginName, userDTO.getOrgId());
            userDTO.setUserName(confuseUserName);
            this.getSystemRuntime().getUserService().update(userDTO);
        }
        super.onBeforeRemove(key);
    }

    @Override
    protected void onAfterCreate(EmployeeDTO dto) throws Throwable {
        if (StringUtils.hasLength((String)dto.getMDeptId())) {
            SearchContextDTO searchContextDTO = new SearchContextDTO();
            searchContextDTO.eq("DEPTID", (Object)dto.getMDeptId());
            searchContextDTO.eq("USERID", (Object)dto.getUserId());
            DeptMemberDTO deptMemberDTO = (DeptMemberDTO)this.getSystemRuntime().getDeptMemberService().selectOne((ISearchContextDTO)searchContextDTO, true);
            if (deptMemberDTO == null) {
                deptMemberDTO = new DeptMemberDTO();
                deptMemberDTO.setDeptId(dto.getMDeptId());
                deptMemberDTO.setUserId(dto.getUserId());
                this.getSystemRuntime().getDeptMemberService().create(deptMemberDTO);
            }
        }
        super.onAfterCreate(dto);
    }

    @Override
    protected void onAfterUpdate(EmployeeDTO dto) throws Throwable {
        if (StringUtils.hasLength((String)dto.getMDeptId())) {
            SearchContextDTO searchContextDTO = new SearchContextDTO();
            searchContextDTO.eq("DEPTID", (Object)dto.getMDeptId());
            searchContextDTO.eq("USERID", (Object)dto.getUserId());
            DeptMemberDTO deptMemberDTO = (DeptMemberDTO)this.getSystemRuntime().getDeptMemberService().selectOne((ISearchContextDTO)searchContextDTO, true);
            if (deptMemberDTO == null) {
                deptMemberDTO = new DeptMemberDTO();
                deptMemberDTO.setDeptId(dto.getMDeptId());
                deptMemberDTO.setUserId(dto.getUserId());
                this.getSystemRuntime().getDeptMemberService().create(deptMemberDTO);
            }
        }
        super.onAfterUpdate(dto);
    }

    @Override
    protected void onInitPwd(EmployeeDTO dto) throws Throwable {
        EmployeeDTO last;
        String strPassword = dto.getPassword();
        if (!StringUtils.hasLength((String)strPassword)) {
            strPassword = "123456";
        }
        if (!StringUtils.hasLength((String)(last = this.get(dto.getUserId())).getUAAUserId())) {
            throw new Exception("\u672a\u7ed1\u5b9a\u7cfb\u7edf\u7528\u6237");
        }
        UserDTO userDTO = new UserDTO();
        userDTO.setUserId(last.getUAAUserId());
        userDTO.setPassword(strPassword);
        this.getSystemRuntime().getUserService().initPwd(userDTO);
    }

    @Override
    protected void onChangePwd(EmployeeDTO dto) throws Throwable {
        String strOldPassword = dto.getString("oldpassword", null);
        if (!StringUtils.hasLength((String)strOldPassword)) {
            throw new PasswordPolicyException("\u672a\u6307\u5b9a\u65e7\u5bc6\u7801");
        }
        String strPassword = dto.getPassword();
        if (!StringUtils.hasLength((String)strPassword)) {
            throw new PasswordPolicyException("\u672a\u6307\u5b9a\u65b0\u5bc6\u7801");
        }
        if (strOldPassword.equals(strPassword)) {
            throw new PasswordPolicyException("\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e0e\u65e7\u5bc6\u7801\u4e00\u81f4");
        }
        EmployeeDTO last = this.get(dto.getUserId());
        UserDTO userDTO = new UserDTO();
        userDTO.setUserId(last.getUAAUserId());
        userDTO.set("oldpassword", strOldPassword);
        userDTO.setPassword(strPassword);
        this.getSystemRuntime().getUserService().changePwd(userDTO);
    }
}

