/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.saas.ebsx.spring.core.extensions.service;

import java.util.List;
import javax.annotation.Priority;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.notify.dto.CarbonCopyDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.notify.service.impl.CarbonCopyServiceImpl;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.central.util.SearchContextDTO;
import net.ibizsys.runtime.util.IEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Priority(value=100)
@Service
public class CarbonCopyServiceImplEx
extends CarbonCopyServiceImpl {
    @Override
    public void create(CarbonCopyDTO et) throws Throwable {
        String userId = et.getUserId();
        if (ObjectUtils.isEmpty((Object)userId)) {
            userId = (String)et.get("scusers");
        }
        if (ObjectUtils.isEmpty((Object)userId)) {
            throw new Exception("\u672a\u6307\u5b9a\u6284\u9001\u64cd\u4f5c\u7528\u6237");
        }
        String srfkeys = "";
        String[] ids = userId.trim().split(";");
        for (int i = 0; i < ids.length; ++i) {
            CarbonCopyDTO item = new CarbonCopyDTO();
            et.copyTo((IEntity)item);
            item.setUserId(ids[i]);
            super.create(item);
            if (!ObjectUtils.isEmpty((Object)srfkeys)) {
                srfkeys = srfkeys + ";";
            }
            srfkeys = srfkeys + item.getTodoId();
        }
        et.set("srfkeys", srfkeys);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected CarbonCopyDTO onMarkRead(CarbonCopyDTO et) throws Throwable {
        String userId = et.getUserId();
        if (!StringUtils.hasLength((String)userId)) {
            throw new Exception("\u672a\u6307\u5b9a\u64cd\u4f5c\u7528\u6237");
        }
        String carbonCopyId = et.getTodoId();
        if (ObjectUtils.isEmpty((Object)carbonCopyId)) {
            boolean hasData = false;
            List<CarbonCopyDTO> list = this.getWFTaskCarbonCopies(et);
            for (CarbonCopyDTO item : list) {
                if (!userId.equalsIgnoreCase(item.getUserId())) continue;
                item.setIsRead(1);
                this.update(item);
                return item;
            }
            if (hasData) return et;
            throw new Exception("\u65e0\u6548\u7684\u6d41\u7a0b\u4efb\u52a1\u6807\u8bc6");
        }
        CarbonCopyDTO dto = this.get(carbonCopyId);
        if (!userId.equalsIgnoreCase(dto.getUserId())) throw new Exception("\u65e0\u6548\u7684\u6284\u9001\u6807\u8bc6");
        et.setIsRead(1);
        this.update(et);
        return et;
    }

    protected List<CarbonCopyDTO> getWFTaskCarbonCopies(CarbonCopyDTO et) throws Throwable {
        String taskId = et.getParam01();
        if (!StringUtils.hasLength((String)taskId)) {
            throw new Exception("\u672a\u6307\u5b9a\u6d41\u7a0b\u4efb\u52a1\u6807\u8bc6");
        }
        List list = this.selectDefault((ISearchContextDTO)new SearchContextDTO().all().eq("PARAM01", (Object)taskId).eq("ISREAD", (Object)0));
        if (ObjectUtils.isEmpty((Object)list)) {
            throw new Exception("\u65e0\u6548\u7684\u6d41\u7a0b\u4efb\u52a1\u6807\u8bc6");
        }
        return list;
    }
}

