/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.saas.ebsx.database;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.cloud.core.security.IEmployeeContext;
import net.ibizsys.central.cloud.core.util.CloudCacheTagUtils;
import net.ibizsys.central.cloud.core.util.domain.Application;
import net.ibizsys.central.cloud.core.util.domain.CodeList;
import net.ibizsys.central.cloud.core.util.domain.Config;
import net.ibizsys.central.cloud.core.util.domain.DCSystem;
import net.ibizsys.central.cloud.core.util.domain.DepCenter;
import net.ibizsys.central.cloud.core.util.domain.Department;
import net.ibizsys.central.cloud.core.util.domain.DeptMember;
import net.ibizsys.central.cloud.core.util.domain.Employee;
import net.ibizsys.central.cloud.core.util.domain.MetaDynaModel;
import net.ibizsys.central.cloud.core.util.domain.MsgTemplate;
import net.ibizsys.central.cloud.core.util.domain.OpenAccess;
import net.ibizsys.central.cloud.core.util.domain.OpenDept;
import net.ibizsys.central.cloud.core.util.domain.OpenUser;
import net.ibizsys.central.cloud.core.util.domain.Organization;
import net.ibizsys.central.cloud.core.util.domain.Report;
import net.ibizsys.central.cloud.core.util.domain.Role;
import net.ibizsys.central.cloud.core.util.domain.System;
import net.ibizsys.central.cloud.core.util.domain.Team;
import net.ibizsys.central.cloud.core.util.domain.TeamMember;
import net.ibizsys.central.cloud.core.util.domain.UserRole;
import net.ibizsys.central.cloud.core.util.domain.WFDefinition;
import net.ibizsys.central.cloud.core.util.domain.WFGroup;
import net.ibizsys.central.cloud.core.util.domain.WFMember;
import net.ibizsys.central.database.SysDBSchemeRuntime;
import net.ibizsys.central.sysutil.ISysCacheUtilRuntime;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class EBSXDBSchemeRuntime
extends SysDBSchemeRuntime {
    private static final Log log = LogFactory.getLog(EBSXDBSchemeRuntime.class);
    private static Map<String, String[]> AllDataCacheTagMap = new HashMap<String, String[]>();
    private static Map<String, String[]> AllDataCacheTagMap2 = new HashMap<String, String[]>();
    private static Map<String, String[]> UserDataCacheTagMap = new HashMap<String, String[]>();
    private ISysCacheUtilRuntime iSysCacheUtilRuntime = null;

    protected ISysCacheUtilRuntime getSysCacheUtilRuntime() {
        if (this.iSysCacheUtilRuntime == null) {
            this.iSysCacheUtilRuntime = this.getSystemRuntime().getSysCacheUtilRuntime(false);
        }
        return this.iSysCacheUtilRuntime;
    }

    public Object insert(String strTableName, List<Map<String, Object>> args, Map<String, Object> extParamMap) throws Throwable {
        Object ret = super.insert(strTableName, args, extParamMap);
        this.resetCloudCache(strTableName);
        return ret;
    }

    public Object update(String strTableName, List<Map<String, Object>> args, Map<String, Object> extParamMap) throws Throwable {
        Object ret = super.update(strTableName, args, extParamMap);
        this.resetCloudCache(strTableName);
        return ret;
    }

    public Object insert(String strTableName, Map<String, Object> paramMap, Map<String, Object> extParamMap) throws Throwable {
        Object ret = super.insert(strTableName, paramMap, extParamMap);
        this.resetCloudCache(strTableName);
        return ret;
    }

    public Object update(String strTableName, Map<String, Object> paramMap, Map<String, Object> extParamMap) throws Throwable {
        Object ret = super.update(strTableName, paramMap, extParamMap);
        this.resetCloudCache(strTableName);
        return ret;
    }

    public Object delete(String strTableName, Map<String, Object> paramMap, Map<String, Object> extParamMap) throws Throwable {
        Object ret = super.delete(strTableName, paramMap, extParamMap);
        this.resetCloudCache(strTableName);
        return ret;
    }

    public Object delete(String strTableName, List<Map<String, Object>> args, Map<String, Object> extParamMap) throws Throwable {
        Object ret = super.delete(strTableName, args, extParamMap);
        this.resetCloudCache(strTableName);
        return ret;
    }

    public int executeSQL(String strSQL, List<Object> params) throws Throwable {
        int nRet = super.executeSQL(strSQL, params);
        return nRet;
    }

    protected void resetCloudCache(String strTableName) {
        IEmployeeContext iEmployeeContext = EmployeeContext.getCurrent();
        if (iEmployeeContext == null) {
            return;
        }
        String[] tags = AllDataCacheTagMap.get(strTableName);
        if (!ObjectUtils.isEmpty((Object)tags)) {
            boolean bGlobal = AllDataCacheTagMap2.containsKey(strTableName);
            try {
                String strDCId = iEmployeeContext.getTenant();
                for (String strTag : tags) {
                    if (StringUtils.hasLength((String)strDCId)) {
                        this.getSysCacheUtilRuntime().reset(CloudCacheTagUtils.getCloudDataCat((String)strDCId, (String)strTag));
                        log.debug((Object)String.format("\u91cd\u7f6eCloud\u6570\u636e\u7f13\u5b58[%1$s]", CloudCacheTagUtils.getCloudDataCat((String)strDCId, (String)strTag)));
                        if (!bGlobal) continue;
                        this.getSysCacheUtilRuntime().reset(CloudCacheTagUtils.getCloudDataCat((String)"$saas$", (String)strTag));
                        log.debug((Object)String.format("\u91cd\u7f6eCloud\u6570\u636e\u7f13\u5b58[%1$s]", CloudCacheTagUtils.getCloudDataCat((String)"$saas$", (String)strTag)));
                        continue;
                    }
                    this.getSysCacheUtilRuntime().reset(CloudCacheTagUtils.getCloudDataCat((String)"$saas$", (String)strTag));
                    log.debug((Object)String.format("\u91cd\u7f6eCloud\u6570\u636e\u7f13\u5b58[%1$s]", CloudCacheTagUtils.getCloudDataCat((String)"$saas$", (String)strTag)));
                }
            }
            catch (Throwable ex) {
                log.error((Object)String.format("\u91cd\u7f6eCloud\u7f13\u5b58\u6570\u636e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", tags, ex.getMessage()), ex);
                this.getSystemRuntime().log(40000, ((Object)((Object)this)).getClass().getName(), String.format("\u91cd\u7f6eCloud\u7f13\u5b58\u6570\u636e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", tags, ex.getMessage()), null);
            }
        }
        if (!ObjectUtils.isEmpty((Object)(tags = UserDataCacheTagMap.get(strTableName)))) {
            try {
                String strDCId = iEmployeeContext.getTenant();
                String strUserId = iEmployeeContext.getUserid();
                for (String strTag : tags) {
                    if (StringUtils.hasLength((String)strDCId)) {
                        this.getSysCacheUtilRuntime().reset(CloudCacheTagUtils.getCloudDataCat((String)strDCId, (String)strUserId, (String)strTag));
                        log.debug((Object)String.format("\u91cd\u7f6eCloud\u6570\u636e\u7f13\u5b58[%1$s]", CloudCacheTagUtils.getCloudDataCat((String)strDCId, (String)strUserId, (String)strTag)));
                        continue;
                    }
                    this.getSysCacheUtilRuntime().reset(CloudCacheTagUtils.getCloudDataCat((String)"$saas$", (String)strUserId, (String)strTag));
                    log.debug((Object)String.format("\u91cd\u7f6eCloud\u6570\u636e\u7f13\u5b58[%1$s]", CloudCacheTagUtils.getCloudDataCat((String)"$saas$", (String)strUserId, (String)strTag)));
                }
            }
            catch (Throwable ex) {
                log.error((Object)String.format("\u91cd\u7f6eCloud\u7f13\u5b58\u6570\u636e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", tags, ex.getMessage()), ex);
                this.getSystemRuntime().log(40000, ((Object)((Object)this)).getClass().getName(), String.format("\u91cd\u7f6eCloud\u7f13\u5b58\u6570\u636e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", tags, ex.getMessage()), null);
            }
        }
    }

    static {
        AllDataCacheTagMap.put("IBZORG", new String[]{Organization.class.getSimpleName()});
        AllDataCacheTagMap.put("IBZDEPT", new String[]{Department.class.getSimpleName()});
        AllDataCacheTagMap.put("IBZEMP", new String[]{Employee.class.getSimpleName(), WFMember.class.getSimpleName()});
        AllDataCacheTagMap.put("IBZDEPTMEMBER", new String[]{DeptMember.class.getSimpleName()});
        AllDataCacheTagMap.put("IBZTEAM", new String[]{Team.class.getSimpleName()});
        AllDataCacheTagMap.put("IBZTEAMMEMBER", new String[]{TeamMember.class.getSimpleName()});
        AllDataCacheTagMap.put("IBZROLE", new String[]{Role.class.getSimpleName()});
        AllDataCacheTagMap.put("IBZUSER_ROLE", new String[]{UserRole.class.getSimpleName()});
        AllDataCacheTagMap.put("IBZWFGROUP", new String[]{WFGroup.class.getSimpleName()});
        AllDataCacheTagMap.put("IBZWFMEMBER", new String[]{WFMember.class.getSimpleName()});
        AllDataCacheTagMap.put("IBZWFDEFINITION", new String[]{WFDefinition.class.getSimpleName()});
        AllDataCacheTagMap.put("IBZCENTER", new String[]{DepCenter.class.getSimpleName()});
        AllDataCacheTagMap.put("IBZPSSYSTEM", new String[]{System.class.getSimpleName()});
        AllDataCacheTagMap.put("IBZPSSYSTEMAPP", new String[]{Application.class.getSimpleName()});
        AllDataCacheTagMap.put("IBZDCSYSTEM", new String[]{DCSystem.class.getSimpleName()});
        AllDataCacheTagMap.put("IBZOPENACCESS", new String[]{OpenAccess.class.getSimpleName()});
        AllDataCacheTagMap.put("IBZOPENDEPT", new String[]{OpenDept.class.getSimpleName()});
        AllDataCacheTagMap.put("IBZOPENUSER", new String[]{OpenUser.class.getSimpleName()});
        AllDataCacheTagMap.put("IBZDICTCATALOG", new String[]{CodeList.class.getSimpleName()});
        AllDataCacheTagMap.put("IBZDICTOPTION", new String[]{CodeList.class.getSimpleName()});
        AllDataCacheTagMap.put("IBZCFG", new String[]{Config.class.getSimpleName()});
        AllDataCacheTagMap.put("IBZMSGTEMPL", new String[]{MsgTemplate.class.getSimpleName()});
        AllDataCacheTagMap.put("IBZREPORT", new String[]{Report.class.getSimpleName()});
        AllDataCacheTagMap.put("IBZDYNAMICMODEL", new String[]{MetaDynaModel.class.getSimpleName()});
        UserDataCacheTagMap.put("IBZCFG", new String[]{Config.class.getSimpleName()});
        AllDataCacheTagMap2.put("IBZDCSYSTEM", new String[]{DCSystem.class.getSimpleName()});
    }
}

