/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.saas.ebsx.spring.core.workflow.service;

import java.util.List;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.workflow.dto.WFInstanceDTO;
import net.ibizsys.central.dataentity.service.IDEService;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.central.util.SearchContextDTO;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.model.dataentity.service.IPSDEMethodDTO;
import org.springframework.data.domain.Page;

public interface IWFInstanceService
extends IDEService<WFInstanceDTO, SearchContextDTO> {
    public static final String DATAENTITYID = "PSMODULES/workflow/PSDATAENTITIES/WFInstance.json";
    public static final String FIELD_INSTANCEID = "INSTANCEID";
    public static final String FIELD_INSTANCENAME = "INSTANCENAME";
    public static final String FIELD_DEFINITIONKEY = "DEFINITIONKEY";
    public static final String FIELD_DEFINITIONNAME = "DEFINITIONNAME";
    public static final String FIELD_BUSINESSKEY = "BUSINESSKEY";
    public static final String FIELD_STARTTIME = "STARTTIME";
    public static final String FIELD_ENDTIME = "ENDTIME";
    public static final String FIELD_STARTUSERID = "STARTUSERID";
    public static final String FIELD_STARTUSERNAME = "STARTUSERNAME";
    public static final String FIELD_REALINSTID = "REALINSTID";
    public static final String FIELD_WFSTATE = "WFSTATE";
    public static final String FIELD_CURSTEPNAME = "CURSTEPNAME";
    public static final String FIELD_CURSTEPID = "CURSTEPID";
    public static final String FIELD_UPDATEMAN = "UPDATEMAN";
    public static final String FIELD_CREATEDATE = "CREATEDATE";
    public static final String FIELD_APPID = "APPID";
    public static final String FIELD_DCSYSTEMID = "DCSYSTEMID";
    public static final String FIELD_UPDATEDATE = "UPDATEDATE";
    public static final String FIELD_ENTITYID = "ENTITYID";
    public static final String FIELD_CREATEMAN = "CREATEMAN";
    public static final String ACTION_CREATE = "Create";
    public static final String ACTION_UPDATE = "Update";
    public static final String ACTION_REMOVE = "Remove";
    public static final String ACTION_GET = "Get";
    public static final String ACTION_GETDRAFT = "GetDraft";
    public static final String ACTION_CANCEL = "cancel";
    public static final String ACTION_CHECKKEY = "CheckKey";
    public static final String ACTION_JUMP = "jump";
    public static final String ACTION_RESTART = "restart";
    public static final String ACTION_SAVE = "Save";
    public static final String DATAQUERY_CURUSERFINISH = "CurUserFinish";
    public static final String DATAQUERY_CURUSERSTARTED = "CurUserStarted";
    public static final String DATAQUERY_CURUSERUNDO = "CurUserUndo";
    public static final String DATAQUERY_DEFAULT = "DEFAULT";
    public static final String DATAQUERY_VIEW = "VIEW";
    public static final String DATASET_CURUSERFINISH = "CurUserFinish";
    public static final String DATASET_CURUSERSTARTED = "CurUserStarted";
    public static final String DATASET_CURUSERUNDO = "CurUserUndo";
    public static final String DATASET_DEFAULT = "DEFAULT";

    default public String getDataEntityId() {
        return DATAENTITYID;
    }

    default public IEntityDTO createEntityDTO(IPSDEMethodDTO iPSDEMethodDTO) {
        String strName;
        switch (strName = iPSDEMethodDTO.getName()) {
            case "WFInstanceDTO": {
                return new WFInstanceDTO();
            }
        }
        return null;
    }

    default public ISearchContextDTO createSearchContextDTO(IPSDEMethodDTO iPSDEMethodDTO) {
        return new SearchContextDTO();
    }

    default public Object executeAction(String strActionName, IPSDEAction iPSDEAction, Object[] args) throws Throwable {
        switch (strActionName.toLowerCase()) {
            case "create": {
                this.create((WFInstanceDTO)((Object)args[0]));
                return null;
            }
            case "update": {
                this.update((WFInstanceDTO)((Object)args[0]));
                return null;
            }
            case "remove": {
                this.remove((List)args[0]);
                return null;
            }
            case "get": {
                return this.get((String)args[0]);
            }
            case "getdraft": {
                return this.getDraft((WFInstanceDTO)((Object)args[0]));
            }
            case "cancel": {
                this.cancel((WFInstanceDTO)((Object)args[0]));
                return null;
            }
            case "checkkey": {
                return this.checkKey((WFInstanceDTO)((Object)args[0]));
            }
            case "jump": {
                this.jump((WFInstanceDTO)((Object)args[0]));
                return null;
            }
            case "restart": {
                this.restart((WFInstanceDTO)((Object)args[0]));
                return null;
            }
            case "save": {
                this.save((WFInstanceDTO)((Object)args[0]));
                return null;
            }
        }
        return this.getDataEntityRuntime().executeAction(strActionName, iPSDEAction, args, true);
    }

    default public Object fetchDataSet(String strDataSetName, IPSDEDataSet iPSDEDataSet, Object[] args) throws Throwable {
        switch (strDataSetName.toLowerCase()) {
            case "curuserfinish": {
                return this.fetchCurUserFinish((ISearchContextDTO)args[0]);
            }
            case "curuserstarted": {
                return this.fetchCurUserStarted((ISearchContextDTO)args[0]);
            }
            case "curuserundo": {
                return this.fetchCurUserUndo((ISearchContextDTO)args[0]);
            }
            case "default": {
                return this.fetchDefault((ISearchContextDTO)args[0]);
            }
        }
        return this.getDataEntityRuntime().fetchDataSet(strDataSetName, iPSDEDataSet, args, true);
    }

    default public void create(WFInstanceDTO dto) throws Throwable {
        this.getDataEntityRuntime().executeAction(ACTION_CREATE, null, new Object[]{dto}, true);
    }

    default public void update(WFInstanceDTO dto) throws Throwable {
        this.getDataEntityRuntime().executeAction(ACTION_UPDATE, null, new Object[]{dto}, true);
    }

    default public void remove(List<String> keys) throws Throwable {
        this.getDataEntityRuntime().executeAction(ACTION_REMOVE, null, new Object[]{keys}, true);
    }

    default public WFInstanceDTO get(String key) throws Throwable {
        return (WFInstanceDTO)((Object)this.getDataEntityRuntime().executeAction(ACTION_GET, null, new Object[]{key}, true));
    }

    default public WFInstanceDTO getDraft(WFInstanceDTO dto) throws Throwable {
        return (WFInstanceDTO)((Object)this.getDataEntityRuntime().executeAction(ACTION_GETDRAFT, null, new Object[]{dto}, true));
    }

    default public void cancel(WFInstanceDTO dto) throws Throwable {
        this.getDataEntityRuntime().executeAction(ACTION_CANCEL, null, new Object[]{dto}, true);
    }

    default public Integer checkKey(WFInstanceDTO dto) throws Throwable {
        return (Integer)this.getDataEntityRuntime().executeAction(ACTION_CHECKKEY, null, new Object[]{dto}, true);
    }

    default public void jump(WFInstanceDTO dto) throws Throwable {
        this.getDataEntityRuntime().executeAction(ACTION_JUMP, null, new Object[]{dto}, true);
    }

    default public void restart(WFInstanceDTO dto) throws Throwable {
        this.getDataEntityRuntime().executeAction(ACTION_RESTART, null, new Object[]{dto}, true);
    }

    default public void save(WFInstanceDTO dto) throws Throwable {
        this.getDataEntityRuntime().executeAction(ACTION_SAVE, null, new Object[]{dto}, true);
    }

    default public Page<WFInstanceDTO> fetchCurUserFinish(ISearchContextDTO dto) throws Throwable {
        return (Page)this.getDataEntityRuntime().fetchDataSet("CurUserFinish", null, new Object[]{dto}, true);
    }

    default public Page<WFInstanceDTO> fetchCurUserStarted(ISearchContextDTO dto) throws Throwable {
        return (Page)this.getDataEntityRuntime().fetchDataSet("CurUserStarted", null, new Object[]{dto}, true);
    }

    default public Page<WFInstanceDTO> fetchCurUserUndo(ISearchContextDTO dto) throws Throwable {
        return (Page)this.getDataEntityRuntime().fetchDataSet("CurUserUndo", null, new Object[]{dto}, true);
    }

    default public Page<WFInstanceDTO> fetchDefault(ISearchContextDTO dto) throws Throwable {
        return (Page)this.getDataEntityRuntime().fetchDataSet("DEFAULT", null, new Object[]{dto}, true);
    }

    default public List<WFInstanceDTO> selectCurUserFinish(ISearchContextDTO dto) throws Throwable {
        List obj = this.getDataEntityRuntime().selectDataQuery("CurUserFinish", dto);
        return obj;
    }

    default public List<WFInstanceDTO> selectCurUserStarted(ISearchContextDTO dto) throws Throwable {
        List obj = this.getDataEntityRuntime().selectDataQuery("CurUserStarted", dto);
        return obj;
    }

    default public List<WFInstanceDTO> selectCurUserUndo(ISearchContextDTO dto) throws Throwable {
        List obj = this.getDataEntityRuntime().selectDataQuery("CurUserUndo", dto);
        return obj;
    }

    default public List<WFInstanceDTO> selectDefault(ISearchContextDTO dto) throws Throwable {
        List obj = this.getDataEntityRuntime().selectDataQuery("DEFAULT", dto);
        return obj;
    }

    default public List<WFInstanceDTO> selectView(ISearchContextDTO dto) throws Throwable {
        List obj = this.getDataEntityRuntime().selectDataQuery(DATAQUERY_VIEW, dto);
        return obj;
    }
}

