/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.saas.ebsx.spring.core.extensions.service;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Priority;
import net.ibizsys.central.cloud.core.cloudutil.ICloudSaaSUtilRuntime;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.cloud.core.util.domain.Application;
import net.ibizsys.central.cloud.core.util.domain.DCSystem;
import net.ibizsys.central.cloud.saas.ebsx.EBSXSystemRuntime;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.notify.dto.CarbonCopyDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.notify.dto.TodoDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.notify.dto.TodoHisDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.notify.service.ITodoHisService;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.notify.service.impl.TodoServiceImpl;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.workflow.dto.WFInstanceDTO;
import net.ibizsys.central.cloud.saas.ebsx.util.StaticDict;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.central.util.SearchContextDTO;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.IEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Priority(value=100)
@Service
public class TodoServiceImplEx
extends TodoServiceImpl {
    private static final Log log = LogFactory.getLog(TodoServiceImplEx.class);
    private ICloudSaaSUtilRuntime iCloudSaaSUtilRuntime = null;
    public static String PREKEY_WFINST = "WFINST__";
    public static String PREKEY_TODOHIS = "TODOHIS__";
    public static String PREKEY_CARBONCOPY = "CARBONCOPY__";

    protected ICloudSaaSUtilRuntime getCloudSaaSUtilRuntime() {
        if (this.iCloudSaaSUtilRuntime != null) {
            return this.iCloudSaaSUtilRuntime;
        }
        this.iCloudSaaSUtilRuntime = (ICloudSaaSUtilRuntime)this.getSystemRuntime().getSysUtilRuntime(ICloudSaaSUtilRuntime.class, false);
        return this.iCloudSaaSUtilRuntime;
    }

    @Override
    public void create(TodoDTO et) throws Throwable {
        String userId = et.getUserId();
        if (ObjectUtils.isEmpty((Object)userId)) {
            userId = (String)et.get("todousers");
        }
        if (ObjectUtils.isEmpty((Object)userId)) {
            throw new Exception("\u672a\u6307\u5b9a\u5f85\u529e\u64cd\u4f5c\u7528\u6237");
        }
        String srfkeys = "";
        String[] ids = userId.trim().split(";");
        for (int i = 0; i < ids.length; ++i) {
            TodoDTO item = new TodoDTO();
            et.copyTo((IEntity)item);
            item.setUserId(ids[i]);
            super.create(item);
            if (!ObjectUtils.isEmpty((Object)srfkeys)) {
                srfkeys = srfkeys + ";";
            }
            srfkeys = srfkeys + item.getTodoId();
        }
        et.set("srfkeys", srfkeys);
    }

    @Override
    public TodoDTO get(String key) throws Throwable {
        if (StringUtils.hasLength((String)key)) {
            if (key.indexOf(PREKEY_TODOHIS) == 0) {
                String tempKey = key.substring(PREKEY_TODOHIS.length());
                TodoHisDTO todoHisDTO = this.getSystemRuntime().getTodoHisService().get(tempKey);
                return (TodoDTO)this.getDataEntityRuntime().getDEMapRuntime("TodoHis", false).fromEntityDTO((IEntityDTO)todoHisDTO);
            }
            if (key.indexOf(PREKEY_CARBONCOPY) == 0) {
                String tempKey = key.substring(PREKEY_CARBONCOPY.length());
                CarbonCopyDTO carbonCopyDTO = this.getSystemRuntime().getCarbonCopyService().get(tempKey);
                return (TodoDTO)this.getDataEntityRuntime().getDEMapRuntime("CarbonCopy", false).fromEntityDTO((IEntityDTO)carbonCopyDTO);
            }
            if (key.indexOf(PREKEY_WFINST) == 0) {
                String tempKey = key.substring(PREKEY_WFINST.length());
                WFInstanceDTO wfInstanceDTO = this.getSystemRuntime().getWFInstanceService().get(tempKey);
                return (TodoDTO)this.getDataEntityRuntime().getDEMapRuntime("WFInst", false).fromEntityDTO((IEntityDTO)wfInstanceDTO);
            }
        }
        return super.get(key);
    }

    @Override
    public void remove(List<String> keys) throws Throwable {
        if (ObjectUtils.isEmpty(keys)) {
            return;
        }
        for (String key : keys) {
            String tempKey;
            if (key.indexOf(PREKEY_TODOHIS) == 0) {
                tempKey = key.substring(PREKEY_TODOHIS.length());
                this.getSystemRuntime().getTodoHisService().remove(Arrays.asList(tempKey));
                continue;
            }
            if (key.indexOf(PREKEY_CARBONCOPY) == 0) {
                tempKey = key.substring(PREKEY_CARBONCOPY.length());
                this.getSystemRuntime().getCarbonCopyService().remove(Arrays.asList(tempKey));
                continue;
            }
            if (key.indexOf(PREKEY_WFINST) == 0) {
                tempKey = key.substring(PREKEY_WFINST.length());
                this.getSystemRuntime().getWFInstanceService().remove(Arrays.asList(tempKey));
                continue;
            }
            super.remove(Arrays.asList(key));
        }
    }

    @Override
    public Page<TodoDTO> fetchCurUser(ISearchContextDTO dto) throws Throwable {
        String strTodoSubType = (String)dto.get("n_todosubtype_eq");
        if (StringUtils.hasLength((String)strTodoSubType)) {
            if (StaticDict.TodoSubType.DONE.toString().equalsIgnoreCase(strTodoSubType)) {
                return this.fetchDone(dto);
            }
            if (StaticDict.TodoSubType.CARBONCOPY.toString().equalsIgnoreCase(strTodoSubType)) {
                return this.fetchCarbonCopy(dto);
            }
            if (StaticDict.TodoSubType.STARTED.toString().equalsIgnoreCase(strTodoSubType)) {
                return this.fetchStarted(dto);
            }
            if (StaticDict.TodoSubType.UNDO.toString().equalsIgnoreCase(strTodoSubType)) {
                return this.fetchUndo(dto);
            }
            if (StaticDict.TodoSubType.FINISH.toString().equalsIgnoreCase(strTodoSubType)) {
                return this.fetchFinish(dto);
            }
            if (StaticDict.TodoSubType.TOREAD.toString().equalsIgnoreCase(strTodoSubType)) {
                return this.fetchToread(dto);
            }
            if (StaticDict.TodoSubType.TODO.toString().equalsIgnoreCase(strTodoSubType)) {
                return this.fetchTodo(dto);
            }
        }
        return super.fetchCurUser(dto);
    }

    @Override
    protected TodoDTO onGetLinkUrl(TodoDTO dto) throws Throwable {
        String srfwf = dto.getTodoSubType();
        String urltype = dto.getTodoUrlType();
        String strTodoId = dto.getTodoId();
        String srfapp = dto.getString("srfapp", null);
        String srfapptype = dto.getString("srfapptype", null);
        TodoDTO todo = this.get(strTodoId);
        if ((StaticDict.TodoType.WFTASK.toString().equals(todo.getTodoType()) || StaticDict.TodoType.WFCC.toString().equals(todo.getTodoType())) && StringUtils.hasLength((String)srfwf)) {
            SearchContextDTO searchContextDTO;
            List list;
            String appRedirectPath = "";
            String strSystemId = "";
            String strSystemAppId = "";
            String strDCSystemid = "";
            String strEntityName = "";
            String strWFTaskId = todo.getParam01();
            if (strWFTaskId == null && !ObjectUtils.isEmpty((Object)(list = this.selectDefault((ISearchContextDTO)(searchContextDTO = new SearchContextDTO().limit(1).eq("BIZKEY", (Object)todo.getBizKey()).sort("createdate,desc")))))) {
                todo = (TodoDTO)((Object)list.get(0));
                strWFTaskId = todo.getParam01();
            }
            String strprocessDefinitionKey = todo.getParam02();
            String strBusinessKey = todo.getBizKey();
            String strTaskdefinitionkey = todo.getParam03();
            String strProcessinstancebusinesskey2 = todo.getClobParam01();
            if (!ObjectUtils.isEmpty((Object)strProcessinstancebusinesskey2)) {
                String[] businesskey = strProcessinstancebusinesskey2.split(":");
                if (businesskey.length >= 3) {
                    strSystemId = businesskey[0];
                    strSystemAppId = businesskey[1];
                    strEntityName = businesskey[2];
                } else {
                    strSystemId = todo.getDCSystemId();
                    strSystemAppId = strProcessinstancebusinesskey2;
                    strEntityName = todo.getBizType();
                }
                Collection applicationList = this.getCloudSaaSUtilRuntime().getApplications(strSystemId);
                DCSystem dcSystem = this.getCloudSaaSUtilRuntime().getDCSystem(strSystemId, EmployeeContext.getCurrentMust().getTenant());
                if (StringUtils.hasLength((String)srfapp)) {
                    strSystemAppId = srfapp;
                } else if (StringUtils.hasLength((String)srfapptype)) {
                    strSystemAppId = "";
                }
                Application application = null;
                if (!ObjectUtils.isEmpty((Object)applicationList)) {
                    if (StringUtils.hasLength((String)strSystemAppId)) {
                        for (Application item : applicationList) {
                            if (!strSystemAppId.equalsIgnoreCase(item.getCodeName())) continue;
                            application = item;
                            break;
                        }
                    } else if (StringUtils.hasLength((String)srfapptype)) {
                        for (Application item : applicationList) {
                            if (DataTypeUtils.getIntegerValue((Object)item.getMobileApp(), (Integer)0) == 1 ? !"mob".equalsIgnoreCase(srfapptype) : "mob".equalsIgnoreCase(srfapptype)) continue;
                            application = item;
                            break;
                        }
                    }
                    if (application == null) {
                        Iterator apps;
                        String[] processDefinitionKey = strprocessDefinitionKey.split("-");
                        if (processDefinitionKey.length > 3) {
                            strEntityName = processDefinitionKey[2];
                            String strWFVersionName = processDefinitionKey[3];
                            String strWorkflowCodeName = strWFVersionName.substring(0, strWFVersionName.lastIndexOf("v"));
                            strDCSystemid = dcSystem.getDCSystemId();
                            for (Application item : applicationList) {
                                String[] AppWFs;
                                if (ObjectUtils.isEmpty((Object)item.getAppWFs()) || !Arrays.asList(AppWFs = item.getAppWFs().split(";")).contains(strWorkflowCodeName) || (DataTypeUtils.getIntegerValue((Object)item.getMobileApp(), (Integer)0) == 1 ? !"mob".equalsIgnoreCase(srfapptype) : "mob".equalsIgnoreCase(srfapptype))) continue;
                                application = item;
                                break;
                            }
                            if (application != null) {
                                HashMap<String, String> viewparams = new HashMap<String, String>();
                                viewparams.put("processDefinitionKey", strprocessDefinitionKey);
                                viewparams.put("taskDefinitionKey", strTaskdefinitionkey);
                                viewparams.put("srfwf", srfwf.toLowerCase());
                                viewparams.put("srftaskid", strWFTaskId);
                                viewparams.put("srfdcsystem", strDCSystemid);
                                viewparams.put("srfdename", strEntityName);
                                viewparams.put("srfkey", strBusinessKey);
                                String redirectUrlPart = this.formatWorkflowRedirectUrl(application, viewparams);
                                appRedirectPath = this.caclWorkflowRedirectUrl(application.getUrl(), redirectUrlPart, application, urltype).replace("#", String.format("?srfdcsystem=%1$s#", strDCSystemid));
                                dto.setLinkUrl(appRedirectPath);
                                return dto;
                            }
                        }
                        if ((apps = applicationList.iterator()).hasNext()) {
                            application = (Application)apps.next();
                        }
                    }
                }
                if (application == null) {
                    throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), String.format("\u65e0\u6cd5\u8ba1\u7b97\u6253\u5f00\u7684\u7cfb\u7edf\u5e94\u7528", new Object[0]));
                }
                strDCSystemid = dcSystem.getDCSystemId();
                String strAppUrl = application.getUrl();
                if (!StringUtils.hasLength((String)strAppUrl)) {
                    throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), String.format("\u672a\u5b9a\u4e49\u5e94\u7528\u8bbf\u95ee\u8def\u5f84", new Object[0]));
                }
                if (!strAppUrl.endsWith(application.getIndexCodeName())) {
                    strAppUrl = strAppUrl + application.getIndexCodeName();
                }
                HashMap<String, String> viewparams = new HashMap<String, String>();
                viewparams.put("processDefinitionKey", strprocessDefinitionKey);
                viewparams.put("taskDefinitionKey", strTaskdefinitionkey);
                viewparams.put("srfwf", srfwf.toLowerCase());
                viewparams.put("srftaskid", strWFTaskId);
                viewparams.put("srfdcsystem", strDCSystemid);
                viewparams.put("srfdename", strEntityName);
                viewparams.put("srfkey", strBusinessKey);
                String redirectUrlPart = this.formatWorkflowRedirectUrl(application, viewparams);
                appRedirectPath = this.caclWorkflowRedirectUrl(application.getUrl(), redirectUrlPart, application, urltype).replace("#", String.format("?srfdcsystem=%1$s#", strDCSystemid));
                dto.setLinkUrl(appRedirectPath);
                return dto;
            }
            if (!ObjectUtils.isEmpty((Object)strprocessDefinitionKey)) {
                String strWorkflowCodeName = "";
                String[] processDefinitionKey = strprocessDefinitionKey.split("-");
                if (processDefinitionKey.length > 3) {
                    strSystemId = processDefinitionKey[1];
                    strEntityName = processDefinitionKey[2];
                    String strWFVersionName = processDefinitionKey[3];
                    strWorkflowCodeName = strWFVersionName.substring(0, strWFVersionName.lastIndexOf("v"));
                } else {
                    strWorkflowCodeName = strprocessDefinitionKey;
                    strSystemId = todo.getDCSystemId();
                    strEntityName = todo.getBizType();
                }
                Collection applicationList = this.getCloudSaaSUtilRuntime().getApplications(strSystemId);
                DCSystem dcSystem = this.getCloudSaaSUtilRuntime().getDCSystem(strSystemId, EmployeeContext.getCurrentMust().getTenant());
                strDCSystemid = dcSystem.getDCSystemId();
                Application application = null;
                if (!ObjectUtils.isEmpty((Object)applicationList)) {
                    for (Application item : applicationList) {
                        String[] AppWFs;
                        if (ObjectUtils.isEmpty((Object)item.getAppWFs()) || !Arrays.asList(AppWFs = item.getAppWFs().split(";")).contains(strWorkflowCodeName.toLowerCase()) || (DataTypeUtils.getIntegerValue((Object)item.getMobileApp(), (Integer)0) == 1 ? !"mob".equalsIgnoreCase(srfapptype) : "mob".equalsIgnoreCase(srfapptype))) continue;
                        application = item;
                        break;
                    }
                    if (application != null) {
                        HashMap viewparams = new HashMap();
                        viewparams.put("processDefinitionKey", strprocessDefinitionKey);
                        viewparams.put("taskDefinitionKey", strTaskdefinitionkey);
                        viewparams.put("srfwf", srfwf.toLowerCase());
                        viewparams.put("srftaskid", strWFTaskId);
                        viewparams.put("srfdcsystem", strDCSystemid);
                        viewparams.put("srfdename", strEntityName);
                        viewparams.put("srfkey", strBusinessKey);
                        String redirectUrlPart = this.formatWorkflowRedirectUrl(application, viewparams);
                        appRedirectPath = this.caclWorkflowRedirectUrl(application.getUrl(), redirectUrlPart, application, urltype).replace("#", String.format("?srfdcsystem=%1$s#", strDCSystemid));
                        dto.setLinkUrl(appRedirectPath);
                        return dto;
                    }
                }
            }
        }
        return todo;
    }

    @Override
    protected TodoDTO onGetLinkUrlMob(TodoDTO dto) throws Throwable {
        return this.getLinkUrl(dto);
    }

    protected String formatWorkflowRedirectUrl(Application redirectApp, Map viewparam) {
        String strViewPathFormats = redirectApp.getViewPathFormat();
        if (!StringUtils.hasLength((String)strViewPathFormats)) {
            return null;
        }
        List viewPathFormats = (List)EBSXSystemRuntime.getInstance().deserialize(strViewPathFormats, List.class);
        String formatType = "TODOGLOBALREDIRECT";
        if (viewPathFormats != null && viewPathFormats.size() > 0) {
            for (Object format : viewPathFormats) {
                Map map = (Map)format;
                if (!formatType.equals(map.get("formattype"))) continue;
                String formattempl = map.get("formattempl").toString();
                Map viewparammap = viewparam;
                if (StringUtils.hasLength((String)redirectApp.getIndexCodeName())) {
                    viewparammap.put("srfindexname", redirectApp.getIndexCodeName().toLowerCase());
                } else {
                    viewparammap.put("srfindexname", "");
                }
                return TodoServiceImplEx.renderString(formattempl, viewparammap);
            }
        }
        return "";
    }

    protected String caclWorkflowRedirectUrl(String appurl, String originUrl, Application redirectApp, String urlType) {
        if ("RouterUrl".equals(urlType)) {
            return originUrl;
        }
        if (appurl.endsWith(redirectApp.getIndexCodeName())) {
            appurl = appurl.substring(0, appurl.lastIndexOf(redirectApp.getIndexCodeName())) + originUrl;
            return appurl;
        }
        return appurl + originUrl;
    }

    protected static String renderString(String content, Map<String, Object> map) {
        Set<Map.Entry<String, Object>> sets = map.entrySet();
        for (Map.Entry<String, Object> entry : sets) {
            String regex = "\\$\\{" + entry.getKey() + "\\}";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(content);
            String strValue = (String)entry.getValue();
            if (StringUtils.isEmpty((Object)strValue)) continue;
            if (entry.getKey().equalsIgnoreCase("srfKey") || entry.getKey().equalsIgnoreCase("processDefinitionKey")) {
                content = matcher.replaceAll(strValue);
                continue;
            }
            content = matcher.replaceAll(strValue.toLowerCase());
        }
        return content;
    }

    @Override
    protected TodoDTO onComplete(TodoDTO et) throws Throwable {
        Timestamp processDate = new Timestamp(System.currentTimeMillis());
        boolean enableLastOpt = false;
        String userId = et.getUserId();
        if (ObjectUtils.isEmpty((Object)userId)) {
            throw new Exception("\u672a\u6307\u5b9a\u64cd\u4f5c\u7528\u6237");
        }
        boolean hasTodo = false;
        String srfkeys = "";
        List<TodoDTO> list = this.getWFTaskTodos(et);
        if (ObjectUtils.isEmpty(list)) {
            return et;
        }
        ITodoHisService iTodoHisService = this.getSystemRuntime().getTodoHisService();
        for (TodoDTO item : list) {
            String tempId = item.getTodoId();
            TodoHisDTO todoHis = new TodoHisDTO();
            item.copyTo((IEntity)todoHis);
            if (userId.equalsIgnoreCase(item.getUserId())) {
                todoHis.setTodoState(StaticDict.TodoState.COMPLETED.getValue());
                et = item;
                hasTodo = true;
            } else {
                todoHis.setTodoState(StaticDict.TodoState.CANCELED.getValue());
            }
            todoHis.setProcessDate(processDate);
            iTodoHisService.create(todoHis);
            this.remove(Arrays.asList(item.getTodoId()));
            if (!ObjectUtils.isEmpty((Object)srfkeys)) {
                srfkeys = srfkeys + ";";
            }
            srfkeys = srfkeys + item.getTodoId();
        }
        if (!hasTodo) {
            log.error((Object)"\u672a\u627e\u5230\u64cd\u4f5c\u7528\u6237\u7684\u5f85\u529e\u6570\u636e");
        }
        et.set("srfkeys", srfkeys);
        return et;
    }

    protected List<TodoDTO> getWFTaskTodos(TodoDTO et) throws Throwable {
        String taskId = et.getParam01();
        if (ObjectUtils.isEmpty((Object)taskId)) {
            throw new Exception("\u672a\u6307\u5b9a\u6d41\u7a0b\u4efb\u52a1\u6807\u8bc6");
        }
        List todoList = this.selectDefault((ISearchContextDTO)new SearchContextDTO().eq("PARAM01", (Object)taskId));
        if (ObjectUtils.isEmpty((Object)todoList)) {
            log.error((Object)String.format("\u65e0\u6548\u7684\u6d41\u7a0b\u4efb\u52a1\u6807\u8bc6[%1$s]", taskId));
        }
        return todoList;
    }

    @Override
    protected TodoDTO onMarkRead(TodoDTO et) throws Throwable {
        String userId = et.getUserId();
        if (ObjectUtils.isEmpty((Object)userId)) {
            throw new Exception("\u672a\u6307\u5b9a\u64cd\u4f5c\u7528\u6237");
        }
        String todoId = et.getTodoId();
        if (!ObjectUtils.isEmpty((Object)todoId)) {
            TodoDTO toto = this.get(todoId);
            if (!userId.equalsIgnoreCase(toto.getUserId())) {
                throw new Exception("\u65e0\u6548\u7684\u5f85\u529e\u4efb\u52a1\u6807\u8bc6");
            }
        } else {
            throw new Exception("\u6ca1\u6709\u5b9e\u73b0");
        }
        et.setIsRead(1);
        this.update(et);
        return et;
    }

    @Override
    protected TodoDTO onReassign(TodoDTO et) throws Throwable {
        Timestamp processDate = new Timestamp(System.currentTimeMillis());
        String userId = et.getUserId();
        if (ObjectUtils.isEmpty((Object)userId)) {
            throw new Exception("\u672a\u6307\u5b9a\u64cd\u4f5c\u7528\u6237");
        }
        String targetUserId = et.getParam02();
        if (ObjectUtils.isEmpty((Object)targetUserId)) {
            throw new Exception("\u672a\u6307\u5b9a\u59d4\u6d3e\u7528\u6237");
        }
        List<TodoDTO> list = this.getWFTaskTodos(et);
        for (TodoDTO item : list) {
            if (!userId.equalsIgnoreCase(item.getUserId())) continue;
            TodoHisDTO todoHis = new TodoHisDTO();
            item.copyTo((IEntity)todoHis);
            todoHis.setTodoState(StaticDict.TodoState.COMPLETED.getValue());
            todoHis.setProcessDate(processDate);
            this.getSystemRuntime().getTodoHisService().create(todoHis);
            this.remove(Arrays.asList(item.getTodoId()));
            item.resetTodoId();
            item.setUserId(targetUserId);
            this.create(item);
            return item;
        }
        throw new Exception("\u672a\u627e\u5230\u64cd\u4f5c\u7528\u6237\u7684\u5f85\u529e\u6570\u636e");
    }

    @Override
    protected TodoDTO onActivate(TodoDTO et) throws Throwable {
        List<TodoDTO> list = this.getWFTaskTodos(et);
        String srfkeys = "";
        for (TodoDTO item : list) {
            item.setTodoState(StaticDict.TodoState.ACTIVE.getValue());
            this.update(item);
            if (!ObjectUtils.isEmpty((Object)srfkeys)) {
                srfkeys = srfkeys + ";";
            }
            srfkeys = srfkeys + item.getTodoId();
        }
        et.set("srfkeys", srfkeys);
        return et;
    }

    @Override
    protected TodoDTO onCancel(TodoDTO et) throws Throwable {
        Timestamp processDate = new Timestamp(System.currentTimeMillis());
        List<TodoDTO> list = this.getWFTaskTodos(et);
        for (TodoDTO item : list) {
            TodoHisDTO todoHis = new TodoHisDTO();
            item.copyTo((IEntity)todoHis);
            todoHis.setTodoState(StaticDict.TodoState.CANCELED.getValue());
            todoHis.setProcessDate(processDate);
            this.getSystemRuntime().getTodoHisService().create(todoHis);
            this.remove(Arrays.asList(item.getTodoId()));
        }
        return et;
    }

    @Override
    protected TodoDTO onDelegate(TodoDTO et) throws Throwable {
        String userId = et.getUserId();
        if (ObjectUtils.isEmpty((Object)userId)) {
            throw new Exception("\u672a\u6307\u5b9a\u64cd\u4f5c\u7528\u6237");
        }
        String targetUserId = et.getParam02();
        if (ObjectUtils.isEmpty((Object)targetUserId)) {
            throw new Exception("\u672a\u6307\u5b9a\u59d4\u6d3e\u7528\u6237");
        }
        TodoDTO targetTodo = null;
        List<TodoDTO> list = this.getWFTaskTodos(et);
        for (TodoDTO item : list) {
            if (userId.equalsIgnoreCase(item.getUserId())) {
                targetTodo = new TodoDTO();
                item.copyTo((IEntity)targetTodo);
            }
            item.setTodoState(StaticDict.TodoState.PAUSED.getValue());
            this.update(item);
        }
        if (targetTodo == null) {
            throw new Exception("\u672a\u627e\u5230\u64cd\u4f5c\u7528\u6237\u7684\u5f85\u529e\u6570\u636e");
        }
        targetTodo.setTodoId(null);
        targetTodo.setUserId(targetUserId);
        this.create(targetTodo);
        return targetTodo;
    }

    @Override
    protected TodoDTO onPause(TodoDTO et) throws Throwable {
        List<TodoDTO> list = this.getWFTaskTodos(et);
        String srfkeys = "";
        for (TodoDTO item : list) {
            item.setTodoState(StaticDict.TodoState.PAUSED.getValue());
            this.update(item);
            if (!ObjectUtils.isEmpty((Object)srfkeys)) {
                srfkeys = srfkeys + ";";
            }
            srfkeys = srfkeys + item.getTodoId();
        }
        et.set("srfkeys", srfkeys);
        return et;
    }

    @Override
    protected TodoDTO onResolve(TodoDTO et) throws Throwable {
        Timestamp processDate = new Timestamp(System.currentTimeMillis());
        String userId = et.getUserId();
        if (ObjectUtils.isEmpty((Object)userId)) {
            throw new Exception("\u672a\u6307\u5b9a\u64cd\u4f5c\u7528\u6237");
        }
        List<TodoDTO> list = this.getWFTaskTodos(et);
        boolean hasTodo = false;
        for (TodoDTO item : list) {
            TodoHisDTO todoHis;
            if (userId.equalsIgnoreCase(item.getUserId())) {
                hasTodo = true;
                et = item;
                todoHis = new TodoHisDTO();
                item.copyTo((IEntity)todoHis);
                todoHis.setTodoState(StaticDict.TodoState.COMPLETED.getValue());
                todoHis.setProcessDate(processDate);
                this.getSystemRuntime().getTodoHisService().create(todoHis);
                this.remove(Arrays.asList(item.getTodoId()));
                continue;
            }
            if (StaticDict.TodoState.ACTIVE.getValue().equalsIgnoreCase(item.getTodoState())) {
                todoHis = new TodoHisDTO();
                item.copyTo((IEntity)todoHis);
                todoHis.setTodoState(StaticDict.TodoState.COMPLETED.getValue());
                todoHis.setProcessDate(processDate);
                this.getSystemRuntime().getTodoHisService().create(todoHis);
                this.remove(Arrays.asList(item.getTodoId()));
                continue;
            }
            item.setTodoState(StaticDict.TodoState.ACTIVE.getValue());
            this.update(item);
        }
        if (!hasTodo) {
            throw new Exception("\u672a\u627e\u5230\u64cd\u4f5c\u7528\u6237\u7684\u5f85\u529e\u6570\u636e");
        }
        return et;
    }

    @Override
    protected TodoDTO onSendMsg(TodoDTO dto) throws Throwable {
        return super.onSendMsg(dto);
    }

    @Override
    protected TodoDTO onRollback(TodoDTO dto) throws Throwable {
        SearchContextDTO searchContextDTO = new SearchContextDTO();
        searchContextDTO.eq("PARAM01", (Object)dto.getParam01());
        EBSXSystemRuntime.getInstance().getTodoHisService().remove((ISearchContextDTO)searchContextDTO);
        EBSXSystemRuntime.getInstance().getTodoService().create(dto);
        return dto;
    }
}

