/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.saas.ebsx.spring.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import net.ibizsys.central.ISystemGateway;
import net.ibizsys.central.SystemGatewayException;
import net.ibizsys.central.cloud.core.IServiceHub;
import net.ibizsys.central.cloud.core.cloudutil.ICloudOUUtilRuntime;
import net.ibizsys.central.cloud.core.security.AuthenticationUser;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.cloud.core.security.IAuthenticationUser;
import net.ibizsys.central.cloud.core.security.IEmployeeContext;
import net.ibizsys.central.cloud.core.util.RestUtils;
import net.ibizsys.central.cloud.core.util.domain.Department;
import net.ibizsys.central.cloud.core.util.domain.Employee;
import net.ibizsys.central.cloud.core.util.domain.Organization;
import net.ibizsys.central.cloud.core.util.error.InternalServerErrorException;
import net.ibizsys.central.cloud.ou.core.IOUUtilSystemRuntime;
import net.ibizsys.central.cloud.saas.ebsx.EBSXSystemRuntime;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.ou.dto.DepartmentDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.ou.dto.EmployeeDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.ou.service.IDepartmentService;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.ou.service.IEmployeeService;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.central.util.SearchContextDTO;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.DateUtils;
import net.ibizsys.runtime.util.JsonUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.zalando.problem.ThrowableProblem;

@RestController
@RequestMapping(value={""})
public class EBSXOURestController {
    private static final Log log = LogFactory.getLog(EBSXOURestController.class);
    public static final String ORGID_ALL = "alls";
    @Autowired
    IServiceHub iServiceHub;
    @Autowired(required=false)
    private ICloudOUUtilRuntime iCloudOUUtilRuntime = null;

    @PostConstruct
    protected void postConstruct() {
        log.debug((Object)String.format("CloudOU\u670d\u52a1\uff08\u65e7\u7248\uff09\u5df2\u7ecf\u542f\u52a8", new Object[0]));
        this.iServiceHub.registerNamingService("ebsx-oldou");
        if (this.iCloudOUUtilRuntime == null) {
            this.iServiceHub.requireCloudUtilRuntime(IOUUtilSystemRuntime.class, ICloudOUUtilRuntime.class);
        }
    }

    protected ICloudOUUtilRuntime getCloudOUUtilRuntime() {
        if (this.iCloudOUUtilRuntime == null) {
            try {
                this.iCloudOUUtilRuntime = (ICloudOUUtilRuntime)this.iServiceHub.getCloudUtilRuntime(IOUUtilSystemRuntime.class, ICloudOUUtilRuntime.class, false);
            }
            catch (Throwable ex) {
                log.debug((Object)String.format("\u672a\u6307\u5b9aCloudOU\u529f\u80fd\u6a21\u5757", new Object[0]), ex);
                throw new SystemGatewayException((ISystemGateway)this.iServiceHub, String.format("\u672a\u6307\u5b9aCloudOU\u529f\u80fd\u6a21\u5757", new Object[0]), ex);
            }
        }
        return this.iCloudOUUtilRuntime;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/ebsx/oldou/ibzemployees/fetchwfselect"})
    public ResponseEntity<Collection<EmployeeDTO>> fetchwfselect(HttpServletRequest httpServletRequest) {
        IEmployeeContext iEmployeeContext = EmployeeContext.getCurrentMust();
        try {
            Map context = RestUtils.queryString2Map((String)httpServletRequest.getQueryString());
            IEmployeeService iEmployeeService = EBSXSystemRuntime.getInstance().getEmployeeService();
            SearchContextDTO searchContextDTO = (SearchContextDTO)iEmployeeService.createSearchContextDTO(context);
            return RestUtils.sendBackPage(iEmployeeService.fetchWFSelect((ISearchContextDTO)searchContextDTO), EmployeeDTO.class);
        }
        catch (Throwable ex) {
            if (ex instanceof ThrowableProblem) {
                throw (ThrowableProblem)ex;
            }
            throw new InternalServerErrorException(ex.getMessage());
        }
    }

    @GetMapping(value={"/ebsx/oldou/ibzemployees/{userId}/oumaps", "/ebsx/oldou/sysemployees/{userId}/oumaps"})
    public ResponseEntity<Map<String, Set<String>>> getOUMapsByUserId(@PathVariable(value="userId") String userId) {
        throw new InternalServerErrorException("\u6ca1\u6709\u5b9e\u73b0");
    }

    @GetMapping(value={"/ebsx/oldou/ibzdepartments/{deptId}/emp", "/ebsx/oldou/sysdepartments/{deptId}/emp"})
    public ResponseEntity<Map> getEmpByDept(@PathVariable(value="deptId") String deptId) {
        throw new InternalServerErrorException("\u6ca1\u6709\u5b9e\u73b0");
    }

    @GetMapping(value={"/ebsx/oldou/ibzorganizations/{orgId}/ibzdepartments/picker", "/ebsx/oldou/sysorganizations/{orgId}/sysdepartments/picker"})
    public ResponseEntity<Collection<ObjectNode>> fetchDeptNodesByOrg(@PathVariable(value="orgId") String orgId) {
        List<Department> rootList;
        EmployeeContext.getCurrentMust();
        ArrayList<ObjectNode> list = new ArrayList<ObjectNode>();
        Collection departments = this.getCloudOUUtilRuntime().getDepartmentsByOrg(orgId);
        if (!ObjectUtils.isEmpty((Object)departments) && !ObjectUtils.isEmpty(rootList = this.getDepartments(null, departments))) {
            for (Department department : rootList) {
                list.add(this.getDeptNode(department, departments));
            }
        }
        return ResponseEntity.ok(list);
    }

    protected ObjectNode getDeptNode(Department department, Collection<Department> departments) {
        ObjectNode objectNode = JsonUtils.createObjectNode();
        objectNode.put("id", department.getDeptId());
        objectNode.put("label", department.getDeptName());
        objectNode.put("code", department.getDeptCode());
        objectNode.put("level", department.getDeptLevel());
        objectNode.put("bcode", department.getBCode());
        try {
            objectNode.put("disabled", DataTypeUtils.getBooleanValue((Object)department.getIsValid(), (Boolean)true) == false);
        }
        catch (Exception ex) {
            log.error((Object)ex);
            objectNode.put("disabled", false);
        }
        List<Department> childList = this.getDepartments(department.getDeptId(), departments);
        if (!ObjectUtils.isEmpty(childList)) {
            ArrayNode arrayNode = objectNode.putArray("children");
            for (Department sub : childList) {
                arrayNode.add((JsonNode)this.getDeptNode(sub, departments));
            }
            objectNode.put("isLeaf", false);
        } else {
            objectNode.put("isLeaf", true);
        }
        return objectNode;
    }

    protected List<Department> getDepartments(String strPDeptId, Collection<Department> departments) {
        ArrayList<Department> list = null;
        for (Department department : departments) {
            if (StringUtils.hasLength((String)strPDeptId)) {
                if (!strPDeptId.equals(department.getParentDeptId())) continue;
                if (list == null) {
                    list = new ArrayList();
                }
                list.add(department);
                continue;
            }
            if (StringUtils.hasLength((String)department.getParentDeptId())) continue;
            if (list == null) {
                list = new ArrayList<Department>();
            }
            list.add(department);
        }
        return list;
    }

    @GetMapping(value={"/ebsx/oldou/ibzorganizations/{orgId}/ibzemployees/picker", "/ebsx/oldou/sysorganizations/{orgId}/sysemployees/picker"})
    public ResponseEntity<List<ObjectNode>> fetchEmployeeNodesByOrg(@PathVariable(value="orgId") String orgId) {
        EmployeeContext.getCurrentMust();
        ArrayList<ObjectNode> list = new ArrayList<ObjectNode>();
        Collection employees = this.getCloudOUUtilRuntime().getEmployeesByOrg(orgId);
        if (!ObjectUtils.isEmpty((Object)employees)) {
            for (Employee employee : employees) {
                list.add(this.getEmployeeNode(employee));
            }
        }
        return ResponseEntity.ok(list);
    }

    protected ObjectNode getEmployeeNode(Employee employee) {
        ObjectNode objectNode = JsonUtils.createObjectNode();
        objectNode.put("id", employee.getUserId());
        objectNode.put("label", employee.getPersonName());
        objectNode.put("code", employee.getUserCode());
        objectNode.put("ccode", employee.getBCode());
        objectNode.put("level", employee.getShowOrder());
        objectNode.put("mdeptid", employee.getMDeptId());
        objectNode.put("mdeptname", employee.getMDeptName());
        objectNode.put("group", employee.getMDeptName());
        objectNode.put("mdeptcode", employee.getMDeptCode());
        objectNode.put("postid", employee.getPostId());
        objectNode.put("postname", employee.getPostName());
        objectNode.put("postcode", employee.getPostCode());
        objectNode.put("orgid", employee.getOrgId());
        objectNode.put("orgname", employee.getOrgName());
        objectNode.put("orgcode", employee.getOrgCode());
        objectNode.put("nickname", employee.getNickName());
        objectNode.put("sex", employee.getSex());
        objectNode.put("certcode", employee.getCertCode());
        objectNode.put("phone", employee.getPhone());
        objectNode.put("email", employee.getEmail());
        objectNode.put("avatar", employee.getAvatar());
        objectNode.put("addr", employee.getAddr());
        if (employee.getBirthday() != null) {
            objectNode.put("birthday", DateUtils.toDateString((Date)employee.getBirthday()));
        }
        return objectNode;
    }

    @GetMapping(value={"/ebsx/oldou/ibzorganizations/picker", "/ebsx/oldou/sysorganizations/picker"})
    public ResponseEntity<List<ObjectNode>> fetchAllOrgNodes() {
        return this.fetchOrgNodesByOrg(ORGID_ALL);
    }

    @GetMapping(value={"/ebsx/oldou/ibzorganizations/{orgId}/suborg/picker", "/ebsx/oldou/sysorganizations/{orgId}/suborg/picker"})
    public ResponseEntity<List<ObjectNode>> fetchOrgNodesByOrg(@PathVariable(value="orgId") String orgId) {
        EmployeeContext.getCurrentMust();
        ArrayList<ObjectNode> list = new ArrayList<ObjectNode>();
        Collection organizationList = this.getCloudOUUtilRuntime().getAllOrganizations();
        if (!ObjectUtils.isEmpty((Object)organizationList)) {
            HashMap<String, Organization> orgMap = new HashMap<String, Organization>();
            if (ORGID_ALL.equals(orgId)) {
                orgId = "";
            }
            boolean bAll = !StringUtils.hasLength((String)orgId);
            for (Organization organization : organizationList) {
                ObjectNode orgNode;
                if ((!bAll ? !orgId.equals(organization.getParentOrgId()) : StringUtils.hasLength((String)organization.getParentOrgId())) || (orgNode = this.getOrgNode(organization, organizationList, orgMap)) == null) continue;
                list.add(orgNode);
            }
        }
        return ResponseEntity.ok(list);
    }

    protected ObjectNode getOrgNode(Organization organization, Collection<Organization> organizations, Map<String, Organization> orgMap) {
        if (orgMap.containsKey(organization.getOrgId())) {
            throw new RuntimeException(String.format("\u7ec4\u7ec7[%1$s]\u51fa\u73b0\u9012\u5f52", organization.getOrgName()));
        }
        orgMap.put(organization.getOrgId(), organization);
        ObjectNode objectNode = JsonUtils.createObjectNode();
        objectNode.put("id", organization.getOrgId());
        objectNode.put("label", organization.getOrgName());
        objectNode.put("code", organization.getOrgCode());
        objectNode.put("level", organization.getOrgLevel());
        objectNode.put("parentorgid", organization.getParentOrgId());
        try {
            objectNode.put("disabled", DataTypeUtils.getBooleanValue((Object)organization.getIsValid(), (Boolean)true) == false);
        }
        catch (Exception ex) {
            log.error((Object)ex);
            objectNode.put("disabled", false);
        }
        List<Organization> childList = this.getOrganizations(organization.getOrgId(), organizations);
        if (!ObjectUtils.isEmpty(childList)) {
            ArrayNode arrayNode = objectNode.putArray("children");
            for (Organization sub : childList) {
                arrayNode.add((JsonNode)this.getOrgNode(sub, organizations, orgMap));
            }
            objectNode.put("isLeaf", false);
        } else {
            objectNode.put("isLeaf", true);
        }
        return objectNode;
    }

    protected List<Organization> getOrganizations(String strPOrgId, Collection<Organization> organizations) {
        ArrayList<Organization> list = null;
        for (Organization organization : organizations) {
            if (StringUtils.hasLength((String)strPOrgId)) {
                if (!strPOrgId.equals(organization.getParentOrgId())) continue;
                if (list == null) {
                    list = new ArrayList();
                }
                list.add(organization);
                continue;
            }
            if (StringUtils.hasLength((String)organization.getParentOrgId())) continue;
            if (list == null) {
                list = new ArrayList<Organization>();
            }
            list.add(organization);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/ebsx/oldou/ibzorganizations/{srfdcId}/orgtreedata", "/ebsx/oldou/sysorganizations/{srfdcId}/orgtreedata"})
    public ResponseEntity<List<ObjectNode>> fetchOrgNodesByDC(@PathVariable(value="srfdcId") String srfdcId) {
        IAuthenticationUser iAuthenticationUser = AuthenticationUser.getCurrentMust();
        if (iAuthenticationUser.getSuperuser() != 1 && iAuthenticationUser.getApiuser() != 1) {
            throw new RuntimeException("\u5fc5\u987b\u5e73\u53f0\u7ba1\u7406\u5458\u624d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c");
        }
        IEmployeeContext lastEmployeeContext = EmployeeContext.getCurrent();
        Employee employee = new Employee();
        employee.setUserId(iAuthenticationUser.getUserid());
        employee.setPersonName(iAuthenticationUser.getUsername());
        employee.setSrfdcid(srfdcId);
        EmployeeContext iEmployeeContext = new EmployeeContext(employee, null, null);
        EmployeeContext.setCurrent((IEmployeeContext)iEmployeeContext);
        try {
            ResponseEntity<List<ObjectNode>> responseEntity = this.fetchOrgNodesByOrg(ORGID_ALL);
            return responseEntity;
        }
        finally {
            EmployeeContext.setCurrent((IEmployeeContext)lastEmployeeContext);
        }
    }

    @GetMapping(value={"/ebsx/oldou/sysdepartments/{deptId}/emp/picker", "/ebsx/oldou/ibzdepartments/{deptId}/emp/picker", "/ebsx/oldou/ibzdepartments/{deptId}/ibzemployees/picker"})
    public ResponseEntity<List<ObjectNode>> fetchEmployeeNodeByDept(@PathVariable(value="deptId") String deptId) {
        EmployeeContext.getCurrentMust();
        ArrayList<ObjectNode> list = new ArrayList<ObjectNode>();
        Collection employees = this.getCloudOUUtilRuntime().getEmployeesByDept(deptId);
        if (!ObjectUtils.isEmpty((Object)employees)) {
            for (Employee employee : employees) {
                list.add(this.getEmployeeNode(employee));
            }
        }
        return ResponseEntity.ok(list);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/ebsx/oldou/sysdepartments/fetchexclude", "/ebsx/oldou/ibzdepartments/fetchexclude"})
    public ResponseEntity<Collection<DepartmentDTO>> fetchexclude(HttpServletRequest httpServletRequest) {
        IEmployeeContext iEmployeeContext = EmployeeContext.getCurrentMust();
        try {
            Map context = RestUtils.queryString2Map((String)httpServletRequest.getQueryString());
            IDepartmentService iDepartmentService = EBSXSystemRuntime.getInstance().getDepartmentService();
            SearchContextDTO searchContextDTO = (SearchContextDTO)iDepartmentService.createSearchContextDTO(context);
            return RestUtils.sendBackPage(iDepartmentService.fetchExclude((ISearchContextDTO)searchContextDTO), DepartmentDTO.class);
        }
        catch (Throwable ex) {
            if (ex instanceof ThrowableProblem) {
                throw (ThrowableProblem)ex;
            }
            throw new InternalServerErrorException(ex.getMessage());
        }
    }
}

