/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.saas.ebsx.spring.core.extensions.service;

import java.util.HashMap;
import javax.annotation.Priority;
import net.ibizsys.central.cloud.core.cloudutil.client.ICloudOpenClient;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.cloud.core.security.IEmployeeContext;
import net.ibizsys.central.cloud.core.sysutil.ISysCloudClientUtilRuntime;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.uaa.dto.OpenAccessDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.uaa.service.impl.OpenAccessServiceImpl;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.KeyValueUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Priority(value=100)
@Service
public class OpenAccessServiceImplEx
extends OpenAccessServiceImpl {
    private static final Log log = LogFactory.getLog(OpenAccessServiceImplEx.class);
    private ICloudOpenClient iCloudOpenClient = null;

    protected ICloudOpenClient getCloudOpenClient() {
        if (this.iCloudOpenClient == null) {
            ISysCloudClientUtilRuntime iSysCloudClientUtilRuntime = (ISysCloudClientUtilRuntime)this.getSystemRuntime().getSysUtilRuntime(ISysCloudClientUtilRuntime.class, false);
            this.iCloudOpenClient = (ICloudOpenClient)iSysCloudClientUtilRuntime.getServiceClient("OPEN", ICloudOpenClient.class);
        }
        return this.iCloudOpenClient;
    }

    @Override
    protected void onSyncData(OpenAccessDTO dto) throws Throwable {
        this.get(dto.getId());
        this.getCloudOpenClient().syncOrganizationUnits(dto.getId(), new HashMap());
    }

    @Override
    public void create(OpenAccessDTO dto) throws Throwable {
        if (!StringUtils.hasLength((String)dto.getId()) && DataTypeUtils.getIntegerValue((Object)dto.getDefaultflag(), (Integer)0) == 1) {
            IEmployeeContext iEmployeeContext = EmployeeContext.getCurrentMust();
            String strDefaultAccessId = KeyValueUtils.genUniqueId((Object)iEmployeeContext.getTenant(), (Object)dto.getOpenType().toUpperCase());
            dto.setId(strDefaultAccessId);
        }
        super.create(dto);
    }
}

