/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.saas.ebsx.spring.core.extensions.service;

import javax.annotation.Priority;
import net.ibizsys.central.cloud.core.cloudutil.client.ICloudDevOpsClient;
import net.ibizsys.central.cloud.core.sysutil.ISysCloudClientUtilRuntime;
import net.ibizsys.central.cloud.saas.ebsx.EBSXSystemRuntime;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.lite.dto.MetaDynaModelDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.uaa.dto.DCSystemDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.uaa.dto.DynaInstDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.uaa.service.impl.DCSystemServiceImpl;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;

@Priority(value=100)
@Service
public class DCSystemServiceImplEx
extends DCSystemServiceImpl {
    private static final Log log = LogFactory.getLog(DCSystemServiceImplEx.class);
    private ICloudDevOpsClient iCloudDevOpsClient = null;

    protected ICloudDevOpsClient getCloudDevOpsClient() {
        if (this.iCloudDevOpsClient == null) {
            ISysCloudClientUtilRuntime iSysCloudClientUtilRuntime = (ISysCloudClientUtilRuntime)this.getSystemRuntime().getSysUtilRuntime(ISysCloudClientUtilRuntime.class, false);
            this.iCloudDevOpsClient = (ICloudDevOpsClient)iSysCloudClientUtilRuntime.getServiceClient("DEVOPS", ICloudDevOpsClient.class);
        }
        return this.iCloudDevOpsClient;
    }

    @Override
    protected void onBeforeCreate(DCSystemDTO dto) throws Throwable {
        super.onBeforeCreate(dto);
    }

    @Override
    protected void onAfterCreate(DCSystemDTO dto) throws Throwable {
        DynaInstDTO dynaInstDTO = new DynaInstDTO();
        try {
            dynaInstDTO.setDynaInstName(String.format("\u9ed8\u8ba4\u5b9e\u4f8b[%1$s]", dto.getDCSystemName()));
            dynaInstDTO.setDCSystemId(dto.getDCSystemId());
            dynaInstDTO.setSystemId(dto.getSystemId());
            dynaInstDTO.setInternalInst(1);
            dynaInstDTO.setIsValid(1);
            dynaInstDTO.setSrfdcid(dto.getSrfdcid());
            dynaInstDTO.setDefaultInst(1);
            EBSXSystemRuntime.getInstance().getDynaInstService().create(dynaInstDTO);
        }
        catch (Throwable ex) {
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), String.format("\u5efa\u7acb\u9ed8\u8ba4\u52a8\u6001\u5b9e\u4f8b\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        try {
            MetaDynaModelDTO metaDynaModelDTO = new MetaDynaModelDTO();
            metaDynaModelDTO.setConfigName(String.format("\u9ed8\u8ba4\u914d\u7f6e[%1$s]", dto.getDCSystemName()));
            metaDynaModelDTO.setSysDynaInstId(dynaInstDTO.getDynaInstId());
            metaDynaModelDTO.setSysDynaInstName(dynaInstDTO.getDynaInstName());
            metaDynaModelDTO.setStatus("1");
            metaDynaModelDTO.setSrfdcid(dto.getSrfdcid());
            EBSXSystemRuntime.getInstance().getMetaDynaModelService().create(metaDynaModelDTO);
        }
        catch (Throwable ex) {
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), String.format("\u5efa\u7acb\u9ed8\u8ba4\u52a8\u6001\u6a21\u578b\u914d\u7f6e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        super.onAfterCreate(dto);
    }

    @Override
    protected void onPublish(DCSystemDTO dto) throws Throwable {
        this.get(dto.getDCSystemId());
        this.getCloudDevOpsClient().publishDCSystem(dto.getDCSystemId(), null);
    }
}

