/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.saas.ebsx.spring.core.extensions.service;

import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.annotation.Priority;
import net.ibizsys.central.cloud.core.cloudutil.client.ICloudDevOpsClient;
import net.ibizsys.central.cloud.core.sysutil.ISysCloudClientUtilRuntime;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.center.dto.DCDCSystemDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.center.service.impl.DCDCSystemServiceImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;

@Priority(value=100)
@Service
public class DCDCSystemServiceImplEx
extends DCDCSystemServiceImpl {
    private static final Log log = LogFactory.getLog(DCDCSystemServiceImplEx.class);
    private ICloudDevOpsClient iCloudDevOpsClient = null;

    protected ICloudDevOpsClient getCloudDevOpsClient() {
        if (this.iCloudDevOpsClient == null) {
            ISysCloudClientUtilRuntime iSysCloudClientUtilRuntime = (ISysCloudClientUtilRuntime)this.getSystemRuntime().getSysUtilRuntime(ISysCloudClientUtilRuntime.class, false);
            this.iCloudDevOpsClient = (ICloudDevOpsClient)iSysCloudClientUtilRuntime.getServiceClient("DEVOPS", ICloudDevOpsClient.class);
        }
        return this.iCloudDevOpsClient;
    }

    @Override
    protected void onPublish(DCDCSystemDTO dto) throws Throwable {
        this.get(dto.getDCSystemId());
        this.getCloudDevOpsClient().publishDCSystem(dto.getDCSystemId(), new HashMap());
    }

    @Override
    protected void onInitTestProjects(DCDCSystemDTO dto) throws Throwable {
        this.get(dto.getDCSystemId());
        this.getCloudDevOpsClient().executeDCSystemAction(dto.getDCSystemId(), "INITTESTPROJECTS", new HashMap());
    }

    @Override
    protected void onRunModelTestProject(DCDCSystemDTO dto) throws Throwable {
        this.get(dto.getDCSystemId());
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("projecttype", "MODELTEST");
        params.put("projecttag", "DEFAULT");
        this.getCloudDevOpsClient().executeDCSystemAction(dto.getDCSystemId(), "RUNTESTPROJECT", params);
    }

    @Override
    protected void onRunUnitTestProject(DCDCSystemDTO dto) throws Throwable {
        this.get(dto.getDCSystemId());
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("projecttype", "UNITTEST");
        params.put("projecttag", "DEFAULT");
        this.getCloudDevOpsClient().executeDCSystemAction(dto.getDCSystemId(), "RUNTESTPROJECT", params);
    }
}

