/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.saas.ebsx.spring.core.workflow.service;

import java.util.List;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.workflow.dto.WFTaskDTO;
import net.ibizsys.central.dataentity.service.IDEService;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.central.util.SearchContextDTO;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.model.dataentity.service.IPSDEMethodDTO;
import org.springframework.data.domain.Page;

public interface IWFTaskService
extends IDEService<WFTaskDTO, SearchContextDTO> {
    public static final String DATAENTITYID = "PSMODULES/workflow/PSDATAENTITIES/WFTask.json";
    public static final String FIELD_TASKID = "TASKID";
    public static final String FIELD_TASKNAME = "TASKNAME";
    public static final String FIELD_DEFINITIONID = "DEFINITIONID";
    public static final String FIELD_DEFINITIONKEY = "DEFINITIONKEY";
    public static final String FIELD_DEFINITIONNAME = "DEFINITIONNAME";
    public static final String FIELD_TASKDEFINITIONKEY = "TASKDEFINITIONKEY";
    public static final String FIELD_DESCRIPTION = "DESCRIPTION";
    public static final String FIELD_CREATETIME = "CREATETIME";
    public static final String FIELD_INSTANCEID = "INSTANCEID";
    public static final String FIELD_BUSINESSKEY2 = "BUSINESSKEY2";
    public static final String FIELD_BUSINESSKEY = "BUSINESSKEY";
    public static final String FIELD_ORGID = "ORGID";
    public static final String FIELD_ENTITYID = "ENTITYID";
    public static final String FIELD_SYSAPPID = "SYSAPPID";
    public static final String FIELD_URL = "URL";
    public static final String FIELD_DCSYSTEMID = "DCSYSTEMID";
    public static final String ACTION_CREATE = "Create";
    public static final String ACTION_UPDATE = "Update";
    public static final String ACTION_REMOVE = "Remove";
    public static final String ACTION_GET = "Get";
    public static final String ACTION_GETDRAFT = "GetDraft";
    public static final String ACTION_CHECKKEY = "CheckKey";
    public static final String ACTION_GETWFTASKURL = "GetWFTaskUrl";
    public static final String ACTION_SAVE = "Save";
    public static final String DATAQUERY_DEFAULT = "DEFAULT";
    public static final String DATAQUERY_DONETASK = "doneTask";
    public static final String DATAQUERY_FINISHTASK = "finishTask";
    public static final String DATAQUERY_TODOTASK = "todoTask";
    public static final String DATAQUERY_TOREADTASK = "toreadTask";
    public static final String DATAQUERY_VIEW = "VIEW";
    public static final String DATASET_DEFAULT = "DEFAULT";
    public static final String DATASET_DONETASK = "doneTask";
    public static final String DATASET_FINISHTASK = "finishTask";
    public static final String DATASET_TODOTASK = "todoTask";
    public static final String DATASET_TOREADTASK = "toreadTask";

    default public String getDataEntityId() {
        return DATAENTITYID;
    }

    default public IEntityDTO createEntityDTO(IPSDEMethodDTO iPSDEMethodDTO) {
        String strName;
        switch (strName = iPSDEMethodDTO.getName()) {
            case "WFTaskDTO": {
                return new WFTaskDTO();
            }
        }
        return null;
    }

    default public ISearchContextDTO createSearchContextDTO(IPSDEMethodDTO iPSDEMethodDTO) {
        return new SearchContextDTO();
    }

    default public Object executeAction(String strActionName, IPSDEAction iPSDEAction, Object[] args) throws Throwable {
        switch (strActionName.toLowerCase()) {
            case "create": {
                this.create((WFTaskDTO)((Object)args[0]));
                return null;
            }
            case "update": {
                this.update((WFTaskDTO)((Object)args[0]));
                return null;
            }
            case "remove": {
                this.remove((List)args[0]);
                return null;
            }
            case "get": {
                return this.get((String)args[0]);
            }
            case "getdraft": {
                return this.getDraft((WFTaskDTO)((Object)args[0]));
            }
            case "checkkey": {
                return this.checkKey((WFTaskDTO)((Object)args[0]));
            }
            case "getwftaskurl": {
                return this.getWFTaskUrl((String)args[0]);
            }
            case "save": {
                this.save((WFTaskDTO)((Object)args[0]));
                return null;
            }
        }
        return this.getDataEntityRuntime().executeAction(strActionName, iPSDEAction, args, true);
    }

    default public Object fetchDataSet(String strDataSetName, IPSDEDataSet iPSDEDataSet, Object[] args) throws Throwable {
        switch (strDataSetName.toLowerCase()) {
            case "default": {
                return this.fetchDefault((ISearchContextDTO)args[0]);
            }
            case "donetask": {
                return this.fetchDoneTask((ISearchContextDTO)args[0]);
            }
            case "finishtask": {
                return this.fetchFinishTask((ISearchContextDTO)args[0]);
            }
            case "todotask": {
                return this.fetchTodoTask((ISearchContextDTO)args[0]);
            }
            case "toreadtask": {
                return this.fetchToreadTask((ISearchContextDTO)args[0]);
            }
        }
        return this.getDataEntityRuntime().fetchDataSet(strDataSetName, iPSDEDataSet, args, true);
    }

    default public void create(WFTaskDTO dto) throws Throwable {
        this.getDataEntityRuntime().executeAction(ACTION_CREATE, null, new Object[]{dto}, true);
    }

    default public void update(WFTaskDTO dto) throws Throwable {
        this.getDataEntityRuntime().executeAction(ACTION_UPDATE, null, new Object[]{dto}, true);
    }

    default public void remove(List<String> keys) throws Throwable {
        this.getDataEntityRuntime().executeAction(ACTION_REMOVE, null, new Object[]{keys}, true);
    }

    default public WFTaskDTO get(String key) throws Throwable {
        return (WFTaskDTO)((Object)this.getDataEntityRuntime().executeAction(ACTION_GET, null, new Object[]{key}, true));
    }

    default public WFTaskDTO getDraft(WFTaskDTO dto) throws Throwable {
        return (WFTaskDTO)((Object)this.getDataEntityRuntime().executeAction(ACTION_GETDRAFT, null, new Object[]{dto}, true));
    }

    default public Integer checkKey(WFTaskDTO dto) throws Throwable {
        return (Integer)this.getDataEntityRuntime().executeAction(ACTION_CHECKKEY, null, new Object[]{dto}, true);
    }

    default public WFTaskDTO getWFTaskUrl(String key) throws Throwable {
        return (WFTaskDTO)((Object)this.getDataEntityRuntime().executeAction(ACTION_GETWFTASKURL, null, new Object[]{key}, true));
    }

    default public void save(WFTaskDTO dto) throws Throwable {
        this.getDataEntityRuntime().executeAction(ACTION_SAVE, null, new Object[]{dto}, true);
    }

    default public Page<WFTaskDTO> fetchDefault(ISearchContextDTO dto) throws Throwable {
        return (Page)this.getDataEntityRuntime().fetchDataSet("DEFAULT", null, new Object[]{dto}, true);
    }

    default public Page<WFTaskDTO> fetchDoneTask(ISearchContextDTO dto) throws Throwable {
        return (Page)this.getDataEntityRuntime().fetchDataSet("doneTask", null, new Object[]{dto}, true);
    }

    default public Page<WFTaskDTO> fetchFinishTask(ISearchContextDTO dto) throws Throwable {
        return (Page)this.getDataEntityRuntime().fetchDataSet("finishTask", null, new Object[]{dto}, true);
    }

    default public Page<WFTaskDTO> fetchTodoTask(ISearchContextDTO dto) throws Throwable {
        return (Page)this.getDataEntityRuntime().fetchDataSet("todoTask", null, new Object[]{dto}, true);
    }

    default public Page<WFTaskDTO> fetchToreadTask(ISearchContextDTO dto) throws Throwable {
        return (Page)this.getDataEntityRuntime().fetchDataSet("toreadTask", null, new Object[]{dto}, true);
    }

    default public List<WFTaskDTO> selectDefault(ISearchContextDTO dto) throws Throwable {
        List obj = this.getDataEntityRuntime().selectDataQuery("DEFAULT", dto);
        return obj;
    }

    default public List<WFTaskDTO> selectDoneTask(ISearchContextDTO dto) throws Throwable {
        List obj = this.getDataEntityRuntime().selectDataQuery("doneTask", dto);
        return obj;
    }

    default public List<WFTaskDTO> selectFinishTask(ISearchContextDTO dto) throws Throwable {
        List obj = this.getDataEntityRuntime().selectDataQuery("finishTask", dto);
        return obj;
    }

    default public List<WFTaskDTO> selectTodoTask(ISearchContextDTO dto) throws Throwable {
        List obj = this.getDataEntityRuntime().selectDataQuery("todoTask", dto);
        return obj;
    }

    default public List<WFTaskDTO> selectToreadTask(ISearchContextDTO dto) throws Throwable {
        List obj = this.getDataEntityRuntime().selectDataQuery("toreadTask", dto);
        return obj;
    }

    default public List<WFTaskDTO> selectView(ISearchContextDTO dto) throws Throwable {
        List obj = this.getDataEntityRuntime().selectDataQuery(DATAQUERY_VIEW, dto);
        return obj;
    }
}

