/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.saas.ebsx.spring.core.extensions.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.LinkedHashSet;
import javax.annotation.Priority;
import net.ibizsys.central.cloud.core.cloudutil.client.ICloudWFClient;
import net.ibizsys.central.cloud.core.sysutil.ISysCloudClientUtilRuntime;
import net.ibizsys.central.cloud.core.util.domain.WFInstance;
import net.ibizsys.central.cloud.core.util.error.BadRequestAlertException;
import net.ibizsys.central.cloud.saas.ebsx.EBSXSystemRuntime;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.workflow.dto.WFInstanceDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.workflow.service.impl.WFInstanceServiceImpl;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.JsonUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Priority(value=100)
@Service
public class WFInstanceServiceImplEx
extends WFInstanceServiceImpl {
    private ICloudWFClient iCloudWFClient = null;

    protected ICloudWFClient getCloudWFClient() {
        if (this.iCloudWFClient == null) {
            ISysCloudClientUtilRuntime iSysCloudClientUtilRuntime = (ISysCloudClientUtilRuntime)this.getSystemRuntime().getSysUtilRuntime(ISysCloudClientUtilRuntime.class, false);
            this.iCloudWFClient = (ICloudWFClient)iSysCloudClientUtilRuntime.getServiceClient("WF", ICloudWFClient.class);
        }
        return this.iCloudWFClient;
    }

    @Override
    protected void onJump(WFInstanceDTO dto) throws Throwable {
        String strWFInstanceId = dto.getId();
        LinkedHashSet<String> wfUsers = new LinkedHashSet<String>();
        Object wfuser = dto.get("wfusers");
        if (ObjectUtils.isEmpty((Object)wfuser)) {
            throw new BadRequestAlertException("\u672a\u4f20\u5165\u6d41\u7a0b\u6b65\u9aa4\u7528\u6237", "", "");
        }
        ArrayNode arrayNodes = JsonUtils.toArrayNode((Object)wfuser);
        if (arrayNodes.isArray()) {
            for (JsonNode node : arrayNodes) {
                JsonNode srfKey = node.get("srfkey");
                wfUsers.add(srfKey.asText());
            }
        }
        String strUserIds = String.join((CharSequence)",", wfUsers);
        WFInstance wfInstance = new WFInstance();
        WFInstanceDTO wfInstanceDTO = EBSXSystemRuntime.getInstance().getWFInstanceService().get(strWFInstanceId);
        wfInstanceDTO.copyTo((IEntity)wfInstance, true);
        wfInstance.set("taskdefinitionkey", dto.get("taskdefinitionkey"));
        wfInstance.set("wfusers", (Object)strUserIds);
        wfInstance.setProcessDefinitionKey(wfInstanceDTO.getProcessDefinitionKey());
        this.getCloudWFClient().jumpWFInstance(strWFInstanceId, wfInstance);
    }

    @Override
    protected void onCancel(WFInstanceDTO dto) throws Throwable {
        WFInstance instance = new WFInstance();
        String strWFInstanceId = dto.getId();
        instance.setId(strWFInstanceId);
        this.getCloudWFClient().cancelWFInstance(strWFInstanceId, instance);
    }
}

