/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.saas.ebsx.spring.core.extensions.service;

import java.sql.Timestamp;
import javax.annotation.Priority;
import net.ibizsys.central.cloud.saas.core.addin.IUserManager;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.uaa.dto.UserDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.uaa.service.impl.UserServiceImpl;
import net.ibizsys.central.cloud.uaa.core.util.SM3Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;

@Priority(value=100)
@Service
public class UserServiceImplEx
extends UserServiceImpl {
    private static final Log log = LogFactory.getLog(UserServiceImplEx.class);
    public static int MAXPASSWORDLENGTH = 30;
    private IUserManager iUserManager = null;

    @Override
    protected void onPrepare() {
        super.onPrepare();
        String strUserManagerObj = this.getDataEntityRuntime().getSetting().getParam("param.usermanager", "");
        if (StringUtils.hasLength((String)strUserManagerObj)) {
            // empty if block
        }
    }

    protected IUserManager getUserManager() {
        return this.iUserManager;
    }

    protected void setUserManager(IUserManager iUserManager) {
        this.iUserManager = iUserManager;
    }

    @Override
    protected void onBeforeCreate(UserDTO dto) throws Throwable {
        if (dto.containsPassword()) {
            dto.setPassword(this.getPassword(dto.getLoginName(), dto.getPassword()));
        }
        super.onBeforeCreate(dto);
    }

    @Override
    protected void onBeforeUpdate(UserDTO dto) throws Throwable {
        if (dto.containsPassword()) {
            dto.setPassword(this.getPassword(dto.getLoginName(), dto.getPassword()));
        }
        super.onBeforeUpdate(dto);
    }

    @Override
    protected void onInitPwd(UserDTO dto) throws Throwable {
        UserDTO last = this.get(dto.getUserId());
        String strPassword = dto.getPassword();
        if (!StringUtils.hasLength((String)strPassword)) {
            strPassword = "123456";
        }
        strPassword = this.getPassword(last.getLoginName(), strPassword);
        UserDTO userDTO = new UserDTO();
        userDTO.setUserId(dto.getUserId());
        userDTO.setPassword(strPassword);
        userDTO.setPwdChgTime(new Timestamp(System.currentTimeMillis()));
        this.update(userDTO);
    }

    @Override
    protected void onChangePwd(UserDTO dto) throws Throwable {
        UserDTO last = this.get(dto.getUserId());
        String strOldPassword = dto.getString("oldpassword", null);
        if (!StringUtils.hasLength((String)strOldPassword)) {
            throw new Exception("\u672a\u6307\u5b9a\u65e7\u5bc6\u7801");
        }
        String strPassword = dto.getPassword();
        if (!StringUtils.hasLength((String)strPassword)) {
            throw new Exception("\u672a\u6307\u5b9a\u65b0\u5bc6\u7801");
        }
        if (strOldPassword.equals(strPassword)) {
            throw new Exception("\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e0e\u65e7\u5bc6\u7801\u4e00\u81f4");
        }
        strOldPassword = this.getPassword(last.getLoginName(), strOldPassword);
        if (!last.getPassword().equals(strOldPassword)) {
            throw new Exception("\u65e7\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        strPassword = this.getPassword(last.getLoginName(), strPassword);
        UserDTO userDTO = new UserDTO();
        userDTO.setUserId(dto.getUserId());
        userDTO.setPassword(strPassword);
        userDTO.setPwdChgTime(new Timestamp(System.currentTimeMillis()));
        this.update(userDTO);
    }

    protected String getPassword(String loginname, String password) throws Throwable {
        if (StringUtils.hasLength((String)password) && password.length() > MAXPASSWORDLENGTH) {
            return password;
        }
        if (this.getPwdCryptMode() == 1) {
            return DigestUtils.md5DigestAsHex((byte[])password.getBytes());
        }
        if (this.getPwdCryptMode() == 2) {
            return DigestUtils.md5DigestAsHex((byte[])String.format("%1$s||%2$s", loginname, password).getBytes());
        }
        if (this.getPwdCryptMode() == 3 && password.length() != 64) {
            return SM3Utils.encrypt((String)password).toUpperCase();
        }
        throw new Exception(String.format("\u672a\u8bc6\u522b\u7684\u5bc6\u7801\u52a0\u5bc6\u65b9\u5f0f[%1$s]", this.getPwdCryptMode()));
    }

    protected int getPwdCryptMode() {
        return 3;
    }
}

