/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.saas.ebsx.spring.core.extensions.service;

import javax.annotation.Priority;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.cloud.core.security.IEmployeeContext;
import net.ibizsys.central.cloud.core.util.domain.Employee;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.ou.dto.EmployeeDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.ou.dto.OrganizationDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.uaa.dto.CenterDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.uaa.dto.OpenAccessDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.uaa.service.impl.CenterServiceImpl;
import net.ibizsys.central.cloud.saas.ebsx.util.StaticDict;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.central.util.SearchContextDTO;
import net.ibizsys.runtime.util.KeyValueUtils;
import org.springframework.stereotype.Service;

@Priority(value=100)
@Service
public class CenterServiceImplEx
extends CenterServiceImpl {
    @Override
    protected void onAfterCreate(CenterDTO dto) throws Throwable {
        super.onAfterCreate(dto);
        this.initDefaultOrgAndUser(dto);
    }

    protected void initDefaultOrgAndUser(CenterDTO dto) throws Throwable {
        IEmployeeContext lastEmployeeContext = EmployeeContext.getCurrentMust();
        Employee employee = new Employee();
        employee.setUserId(lastEmployeeContext.getUserid());
        employee.setPersonName(lastEmployeeContext.getUsername());
        employee.setSrfdcid(dto.getSysCenterId());
        EmployeeContext iEmployeeContext = new EmployeeContext(employee, null, null);
        EmployeeContext.setCurrent((IEmployeeContext)iEmployeeContext);
        try {
            this.onInitDefaultOrgAndUser(dto);
        }
        catch (Throwable ex) {
            throw ex;
        }
        finally {
            EmployeeContext.setCurrent((IEmployeeContext)lastEmployeeContext);
        }
    }

    protected void onInitDefaultOrgAndUser(CenterDTO dto) throws Throwable {
        OrganizationDTO organization = (OrganizationDTO)this.getSystemRuntime().getOrganizationService().selectOne((ISearchContextDTO)new SearchContextDTO().nvl("PORGID"), true);
        if (organization == null) {
            organization = new OrganizationDTO();
            organization.setOrgName(dto.getCenterName());
            organization.setShowOrder(0);
            this.getSystemRuntime().getOrganizationService().create(organization);
        }
        String strLoginName = String.format("%1$s_%2$s", dto.getSysCenterId(), "admin").toLowerCase();
        EmployeeDTO employee = (EmployeeDTO)this.getSystemRuntime().getEmployeeService().selectOne((ISearchContextDTO)new SearchContextDTO().eq("LOGINNAME", (Object)strLoginName), true);
        if (employee == null) {
            employee = new EmployeeDTO();
            employee.setOrgId(organization.getOrgId());
            employee.setPersonName("\u673a\u6784\u7ba1\u7406\u5458");
            employee.setShowOrder(999999);
            employee.setLoginName(strLoginName);
            employee.setPassword("123456");
            employee.setUserCode("ADMIN");
            employee.setSuperUser(1);
            this.getSystemRuntime().getEmployeeService().create(employee);
        }
    }

    @Override
    public void initDefaultOpenAccess(CenterDTO dto) throws Throwable {
        IEmployeeContext lastEmployeeContext = EmployeeContext.getCurrentMust();
        Employee employee = new Employee();
        employee.setUserId(lastEmployeeContext.getUserid());
        employee.setPersonName(lastEmployeeContext.getUsername());
        employee.setSrfdcid(dto.getSysCenterId());
        EmployeeContext iEmployeeContext = new EmployeeContext(employee, null, null);
        EmployeeContext.setCurrent((IEmployeeContext)iEmployeeContext);
        try {
            super.initDefaultOpenAccess(dto);
        }
        catch (Throwable ex) {
            throw ex;
        }
        finally {
            EmployeeContext.setCurrent((IEmployeeContext)lastEmployeeContext);
        }
    }

    @Override
    protected void onInitDefaultOpenAccess(CenterDTO dto) throws Throwable {
        StaticDict.OpenAccessType[] openTypes;
        for (StaticDict.OpenAccessType openAccessType : openTypes = new StaticDict.OpenAccessType[]{StaticDict.OpenAccessType.DINGTALK, StaticDict.OpenAccessType.WXWORK}) {
            String strDefaultAccessId = KeyValueUtils.genUniqueId((Object)dto.getSysCenterId(), (Object)openAccessType.getValue().toUpperCase());
            OpenAccessDTO openAccess = (OpenAccessDTO)this.getSystemRuntime().getOpenAccessService().get(strDefaultAccessId, true);
            if (openAccess != null) continue;
            openAccess = new OpenAccessDTO();
            openAccess.setOpenType(openAccessType.getValue());
            openAccess.setId(strDefaultAccessId);
            openAccess.setName(String.format("%1$s[\u9ed8\u8ba4]", openAccessType.getText()));
            openAccess.setDefaultflag(1);
            this.getSystemRuntime().getOpenAccessService().create(openAccess);
        }
    }
}

