/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.saas.ebsx.cloudutil;

import com.fasterxml.jackson.core.type.TypeReference;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.ibizsys.central.cloud.core.security.AuthenticationUser;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.cloud.core.security.IAuthenticationUser;
import net.ibizsys.central.cloud.core.security.IEmployeeContext;
import net.ibizsys.central.cloud.core.security.IUAAGrantedAuthority;
import net.ibizsys.central.cloud.core.security.UAADEAuthority;
import net.ibizsys.central.cloud.core.security.UAARoleAuthority;
import net.ibizsys.central.cloud.core.security.UAAUniResAuthority;
import net.ibizsys.central.cloud.core.util.domain.Application;
import net.ibizsys.central.cloud.core.util.domain.CodeItem;
import net.ibizsys.central.cloud.core.util.domain.CodeList;
import net.ibizsys.central.cloud.core.util.domain.Config;
import net.ibizsys.central.cloud.core.util.domain.DCSystem;
import net.ibizsys.central.cloud.core.util.domain.DepCenter;
import net.ibizsys.central.cloud.core.util.domain.Department;
import net.ibizsys.central.cloud.core.util.domain.Employee;
import net.ibizsys.central.cloud.core.util.domain.MetaDynaModel;
import net.ibizsys.central.cloud.core.util.domain.MsgTemplate;
import net.ibizsys.central.cloud.core.util.domain.OpenAccess;
import net.ibizsys.central.cloud.core.util.domain.OpenUser;
import net.ibizsys.central.cloud.core.util.domain.OrgSystem;
import net.ibizsys.central.cloud.core.util.domain.Organization;
import net.ibizsys.central.cloud.core.util.domain.PermissionType;
import net.ibizsys.central.cloud.core.util.domain.Role;
import net.ibizsys.central.cloud.core.util.domain.SysAudit;
import net.ibizsys.central.cloud.core.util.domain.SysEvent;
import net.ibizsys.central.cloud.core.util.domain.SysLog;
import net.ibizsys.central.cloud.core.util.domain.SysPO;
import net.ibizsys.central.cloud.core.util.domain.User;
import net.ibizsys.central.cloud.core.util.domain.UserRole;
import net.ibizsys.central.cloud.core.util.domain.WFDefinition;
import net.ibizsys.central.cloud.core.util.domain.WFGroup;
import net.ibizsys.central.cloud.core.util.domain.WFMember;
import net.ibizsys.central.cloud.saas.core.cloudutil.CloudSaaSUtilRuntimeBase;
import net.ibizsys.central.cloud.saas.ebsx.EBSXSystemRuntime;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.dict.dto.DictCatalogDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.dict.dto.DictOptionDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.lite.dto.DstConfigDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.lite.dto.MetaDynaModelDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.lite.service.IMetaDynaModelService;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.log.dto.SysAuditDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.log.dto.SysEventDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.log.dto.SysLogDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.log.dto.SysPODTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.notify.dto.MsgTemplateDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.ou.dto.DepartmentDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.ou.dto.EmployeeDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.ou.dto.OrganizationDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.ou.service.IEmployeeService;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.uaa.dto.ApplicationDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.uaa.dto.CenterDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.uaa.dto.DCEmployeeDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.uaa.dto.DCSystemDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.uaa.dto.OpenAccessDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.uaa.dto.OpenUserDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.uaa.dto.PermissionActionDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.uaa.dto.PermissionDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.uaa.dto.RoleDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.uaa.dto.SystemDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.uaa.dto.UserDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.uaa.dto.UserRoleDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.uaa.service.IDCEmployeeService;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.uaa.service.IUserService;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.workflow.dto.WFDefinitionDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.workflow.dto.WFGroupDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.workflow.dto.WFInstanceDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.workflow.dto.WFMemberDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.workflow.service.IWFDefinitionService;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.central.util.SearchContextDTO;
import net.ibizsys.central.util.UserContextActionBuilder;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.IAction;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.KeyValueUtils;
import net.ibizsys.runtime.util.domain.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Page;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.DigestUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class EBSXCloudSaaSUtilRuntime
extends CloudSaaSUtilRuntimeBase {
    private static final org.apache.commons.logging.Log log = LogFactory.getLog(EBSXCloudSaaSUtilRuntime.class);

    protected void onInstall() throws Exception {
        super.onInstall();
    }

    protected Employee onGetEmployeeByDC(IAuthenticationUser iAuthenticationUser, String strDCId, String strSystemId) throws Throwable {
        IDCEmployeeService iDCEmployeeService = EBSXSystemRuntime.getInstance().getDCEmployeeService();
        SearchContextDTO searchContextDTO = new SearchContextDTO();
        searchContextDTO.eq("UAAUSERID", (Object)iAuthenticationUser.getUserid()).eq("SRFDCID", (Object)strDCId);
        DCEmployeeDTO dcEmployeeDTO = (DCEmployeeDTO)iDCEmployeeService.selectOne((ISearchContextDTO)searchContextDTO, true);
        if (dcEmployeeDTO == null) {
            throw new UsernameNotFoundException(String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u673a\u6784\u7528\u6237", new Object[0]));
        }
        Employee employee = new Employee();
        dcEmployeeDTO.copyTo((IEntity)employee, true);
        if (StringUtils.hasLength((String)strSystemId)) {
            DCSystem dcSystem = this.getDCSystem(strSystemId, dcEmployeeDTO.getSrfdcid());
            employee.setDCSystemId(dcSystem.getDCSystemId());
        }
        this.fillEmployee(employee, dcEmployeeDTO, strSystemId);
        return employee;
    }

    protected Employee onGetEmployee(IAuthenticationUser iAuthenticationUser, String strSystemId, String strOrgId) throws Throwable {
        IDCEmployeeService iDCEmployeeService = EBSXSystemRuntime.getInstance().getDCEmployeeService();
        SearchContextDTO searchContextDTO = new SearchContextDTO();
        searchContextDTO.eq("UAAUSERID", (Object)iAuthenticationUser.getUserid()).eq("ORGID", (Object)strOrgId);
        DCEmployeeDTO dcEmployeeDTO = (DCEmployeeDTO)iDCEmployeeService.selectOne((ISearchContextDTO)searchContextDTO, true);
        if (dcEmployeeDTO == null) {
            throw new UsernameNotFoundException(String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u673a\u6784\u7528\u6237", new Object[0]));
        }
        DCSystem dcSystem = this.getDCSystem(strSystemId, dcEmployeeDTO.getSrfdcid());
        Employee employee = new Employee();
        dcEmployeeDTO.copyTo((IEntity)employee, true);
        employee.setDCSystemId(dcSystem.getDCSystemId());
        this.fillEmployee(employee, dcEmployeeDTO, strSystemId);
        return employee;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillEmployee(Employee employee, DCEmployeeDTO dcEmployeeDTO, String strSystemId) throws Throwable {
        IEmployeeContext lastEmployeeContext = EmployeeContext.getCurrent();
        try {
            Collection organizations;
            Collection departments;
            EmployeeContext.setCurrent((IEmployeeContext)new EmployeeContext(employee, null, strSystemId));
            if (!StringUtils.hasLength((String)employee.getMqttTopic()) && StringUtils.hasLength((String)strSystemId)) {
                employee.setMqttTopic(this.getPortalMqttTopic(employee, strSystemId));
            }
            if (!DataTypeUtils.getBooleanValue((Object)employee.getSuperUser(), (Boolean)false).booleanValue()) {
                SearchContextDTO userRoleFilter = new SearchContextDTO().limit(1).count(false).eq("USERID", (Object)dcEmployeeDTO.getUserId()).eq("DCSYSTEMID", (Object)employee.getDCSystemId()).eq("USERMODE", (Object)"ACCESSDMIN");
                Page<UserRoleDTO> page2 = EBSXSystemRuntime.getInstance().getUserRoleService().fetchDefault((ISearchContextDTO)userRoleFilter);
                if (!ObjectUtils.isEmpty(page2) && !ObjectUtils.isEmpty((Object)page2.getContent())) {
                    employee.setSuperUser(Integer.valueOf(1));
                }
            }
            if (StringUtils.hasLength((String)dcEmployeeDTO.getMDeptId()) && !ObjectUtils.isEmpty((Object)(departments = this.getAllDepartments()))) {
                Set<String> sDeptIds;
                HashMap<String, Department> departmentMap = new HashMap<String, Department>();
                departments.forEach(t -> departmentMap.put(t.getDeptId(), (Department)t));
                Set<String> pDeptIds = this.getPDeptIds(dcEmployeeDTO.getMDeptId(), departmentMap, null);
                if (!ObjectUtils.isEmpty(pDeptIds)) {
                    employee.setPDeptIds(StringUtils.collectionToDelimitedString(pDeptIds, (String)","));
                }
                if (!ObjectUtils.isEmpty(sDeptIds = this.getSDeptIds(dcEmployeeDTO.getMDeptId(), departmentMap, null))) {
                    employee.setSDeptIds(StringUtils.collectionToDelimitedString(sDeptIds, (String)","));
                }
            }
            if (StringUtils.hasLength((String)dcEmployeeDTO.getOrgId()) && !ObjectUtils.isEmpty((Object)(organizations = this.getAllOrganizations()))) {
                Set<String> sOrgIds;
                HashMap<String, Organization> organizationMap = new HashMap<String, Organization>();
                organizations.forEach(t -> organizationMap.put(t.getOrgId(), (Organization)t));
                Set<String> pOrgIds = this.getPOrgIds(dcEmployeeDTO.getOrgId(), organizationMap, null);
                if (!ObjectUtils.isEmpty(pOrgIds)) {
                    employee.setPOrgIds(StringUtils.collectionToDelimitedString(pOrgIds, (String)","));
                }
                if (!ObjectUtils.isEmpty(sOrgIds = this.getSOrgIds(dcEmployeeDTO.getOrgId(), organizationMap, null))) {
                    employee.setSOrgIds(StringUtils.collectionToDelimitedString(sOrgIds, (String)","));
                }
            }
        }
        finally {
            EmployeeContext.setCurrent((IEmployeeContext)lastEmployeeContext);
        }
    }

    protected Set<String> getPDeptIds(String strDeptId, Map<String, Department> departmentMap, Set<String> deptids) {
        Department department;
        if (deptids == null) {
            deptids = new HashSet<String>();
        }
        if ((department = departmentMap.get(strDeptId)) == null) {
            log.warn((Object)String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7ec4\u7ec7\u90e8\u95e8[%1$s]", strDeptId));
            return deptids;
        }
        String strPDeptId = department.getParentDeptId();
        if (StringUtils.hasLength((String)strPDeptId) && !deptids.contains(strPDeptId)) {
            deptids.add(strPDeptId);
            return this.getPDeptIds(strPDeptId, departmentMap, deptids);
        }
        return deptids;
    }

    protected Set<String> getSDeptIds(String strDeptId, Map<String, Department> departmentMap, Set<String> deptids2) {
        if (deptids2 == null) {
            deptids2 = new HashSet<String>();
        }
        Set<String> deptids = deptids2;
        departmentMap.forEach((k, v) -> {
            String strSDeptId;
            if (strDeptId.equals(v.getParentDeptId()) && !deptids.contains(strSDeptId = v.getDeptId())) {
                deptids.add(strSDeptId);
                this.getSDeptIds(strSDeptId, departmentMap, deptids);
            }
        });
        return deptids;
    }

    protected Set<String> getPOrgIds(String strOrgId, Map<String, Organization> orgMap, Set<String> orgids) {
        Organization organization;
        if (orgids == null) {
            orgids = new HashSet<String>();
        }
        if ((organization = orgMap.get(strOrgId)) == null) {
            log.warn((Object)String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7ec4\u7ec7\u90e8\u95e8[%1$s]", strOrgId));
            return orgids;
        }
        String strPOrgId = organization.getParentOrgId();
        if (StringUtils.hasLength((String)strPOrgId) && !orgids.contains(strPOrgId)) {
            orgids.add(strPOrgId);
            return this.getPOrgIds(strPOrgId, orgMap, orgids);
        }
        return orgids;
    }

    protected Set<String> getSOrgIds(String strOrgId, Map<String, Organization> orgMap, Set<String> orgids2) {
        if (orgids2 == null) {
            orgids2 = new HashSet<String>();
        }
        Set<String> orgids = orgids2;
        orgMap.forEach((k, v) -> {
            String strSOrgId;
            if (strOrgId.equals(v.getParentOrgId()) && !orgids.contains(strSOrgId = v.getOrgId())) {
                orgids.add(strSOrgId);
                this.getSOrgIds(strSOrgId, orgMap, orgids);
            }
        });
        return orgids;
    }

    protected Employee onGetEmployee(String id) throws Throwable {
        EmployeeDTO employeeDTO = EBSXSystemRuntime.getInstance().getEmployeeService().get(id);
        Employee employee = new Employee();
        employee.putAll(employeeDTO.any());
        return employee;
    }

    protected Department onGetDepartment(String id) throws Throwable {
        DepartmentDTO departmentDTO = EBSXSystemRuntime.getInstance().getDepartmentService().get(id);
        Department department = new Department();
        departmentDTO.copyTo((IEntity)department, true);
        return department;
    }

    protected MetaDynaModel onGetMetaDynaModel(String strSystemId, String strOrgId) throws Throwable {
        List<MetaDynaModelDTO> list;
        IEmployeeContext iEmployeeContext = EmployeeContext.getCurrentMust();
        IMetaDynaModelService iMetaDynaModelService = EBSXSystemRuntime.getInstance().getMetaDynaModelService();
        SearchContextDTO searchContextDTO = new SearchContextDTO();
        searchContextDTO.count(false).limit(1);
        searchContextDTO.eq("SYSTEMID", (Object)strSystemId);
        searchContextDTO.eq("STATUS", (Object)"1");
        searchContextDTO.nvl("PDYNAINSTID");
        searchContextDTO.eq("SRFDCID", (Object)iEmployeeContext.getTenant());
        if (StringUtils.hasLength((String)strOrgId)) {
            // empty if block
        }
        if (ObjectUtils.isEmpty(list = iMetaDynaModelService.selectView((ISearchContextDTO)searchContextDTO))) {
            throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u673a\u6784\u7cfb\u7edf\u9ed8\u8ba4\u52a8\u6001\u6a21\u578b\u914d\u7f6e", new Object[0]));
        }
        MetaDynaModel dcDynaModel = new MetaDynaModel();
        list.get(0).copyTo((IEntity)dcDynaModel, true);
        return dcDynaModel;
    }

    protected List<WFDefinition> onGetWFDefinitions(String strSystemTag, String strModuleInstTag, String strModuleInstTag2, String strDataEntity, String strAppName) throws Throwable {
        MetaDynaModel dcDynaModel = null;
        dcDynaModel = !StringUtils.hasLength((String)strModuleInstTag) ? this.getDefaultMetaDynaModel() : this.getMetaDynaModel(strModuleInstTag, strModuleInstTag2);
        IWFDefinitionService iWFDefinitionService = EBSXSystemRuntime.getInstance().getWFDefinitionService();
        SearchContextDTO searchContext = new SearchContextDTO();
        searchContext.count(false).limit(Integer.MAX_VALUE).ll("definitionkey", (Object)("wf" + dcDynaModel.getConfigId() + "-" + strSystemTag + "-" + strDataEntity + "-")).eq("modelenable", (Object)1).sort("modelversion,desc");
        ArrayList<WFDefinition> wfDefinitionList = new ArrayList<WFDefinition>();
        List<WFDefinitionDTO> list = iWFDefinitionService.selectDefault((ISearchContextDTO)searchContext);
        if (!ObjectUtils.isEmpty(list)) {
            for (WFDefinitionDTO item : list) {
                WFDefinition wfDefinition = new WFDefinition();
                item.copyTo((IEntity)wfDefinition, true);
                wfDefinitionList.add(wfDefinition);
            }
        }
        return wfDefinitionList;
    }

    protected WFDefinition onGetWFDefinition(String strSystemTag, String strModuleInstTag, String strModuleInstTag2, String strDataEntity, String strWFDefinitionId, String strAppName) throws Throwable {
        MetaDynaModel dcDynaModel = null;
        dcDynaModel = !StringUtils.hasLength((String)strModuleInstTag) ? this.getDefaultMetaDynaModel() : this.getMetaDynaModel(strModuleInstTag, strModuleInstTag2);
        IWFDefinitionService iWFDefinitionService = EBSXSystemRuntime.getInstance().getWFDefinitionService();
        SearchContextDTO searchContext = new SearchContextDTO();
        if (strWFDefinitionId.split("-").length > 1) {
            searchContext.ll("DEFINITIONKEY", (Object)("wf" + dcDynaModel.getConfigId() + "-" + strSystemTag + "-" + strDataEntity + "-")).eq("MODELENABLE", (Object)1).eq("DEFINITIONKEY", (Object)strWFDefinitionId);
        } else {
            searchContext.ll("DEFINITIONKEY", (Object)("wf" + dcDynaModel.getConfigId() + "-" + strSystemTag + "-" + strDataEntity + "-" + strWFDefinitionId + "v")).eq("MODELENABLE", (Object)1).sort("modelversion,desc");
        }
        WFDefinitionDTO item = (WFDefinitionDTO)iWFDefinitionService.selectOne((ISearchContextDTO)searchContext, false);
        WFDefinition wfDefinition = new WFDefinition();
        item.copyTo((IEntity)wfDefinition, true);
        return wfDefinition;
    }

    protected WFDefinition onGetWFDefinition(String strSystemTag, String strDataEntity, String strKey, String strProcessDefinitionKey, String strAppName) throws Throwable {
        if (!StringUtils.hasLength((String)strProcessDefinitionKey)) {
            String instanceId = DigestUtils.md5DigestAsHex((byte[])String.format("%s||%s||%s", strSystemTag, strDataEntity, strKey).getBytes());
            try {
                WFInstanceDTO wfInstanceDTO = EBSXSystemRuntime.getInstance().getWFInstanceService().get(instanceId);
                strProcessDefinitionKey = wfInstanceDTO.getProcessDefinitionKey();
            }
            catch (Throwable ex) {
                throw new Exception(String.format("\u83b7\u53d6\u9ed8\u8ba4\u6d41\u7a0b\u5b9e\u4f8b\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
        }
        WFDefinitionDTO item = EBSXSystemRuntime.getInstance().getWFDefinitionService().get(strProcessDefinitionKey);
        WFDefinition wfDefinition = new WFDefinition();
        item.copyTo((IEntity)wfDefinition, true);
        return wfDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<OrgSystem> onGetOrgSystems(IAuthenticationUser iAuthenticationUser, String strDCSystemId) throws Throwable {
        DCSystem dcSystem = this.getDCSystem(strDCSystemId);
        SearchContextDTO searchContextDTO = new SearchContextDTO();
        searchContextDTO.eq("UAAUSERID", (Object)iAuthenticationUser.getUserid()).eq("SRFDCID", (Object)dcSystem.getSrfdcid());
        searchContextDTO.setPageable(0, 2000, 0L);
        searchContextDTO.setCount(false);
        ArrayList<OrgSystem> orgSystemList = new ArrayList<OrgSystem>();
        Page<DCEmployeeDTO> page = EBSXSystemRuntime.getInstance().getDCEmployeeService().fetchDefault((ISearchContextDTO)searchContextDTO);
        if (ObjectUtils.isEmpty((Object)page.getContent())) {
            return orgSystemList;
        }
        IEmployeeContext lastEmployeeContext = EmployeeContext.getCurrent();
        Employee employee = new Employee();
        employee.setUserId("SYSTEM");
        employee.setPersonName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        employee.setSrfdcid(dcSystem.getSrfdcid());
        EmployeeContext iEmployeeContext = new EmployeeContext(employee, null, null);
        EmployeeContext.setCurrent((IEmployeeContext)iEmployeeContext);
        try {
            for (DCEmployeeDTO dcEmployeeDTO : page.getContent()) {
                if (!StringUtils.hasLength((String)dcEmployeeDTO.getOrgId())) continue;
                if (DataTypeUtils.getIntegerValue((Object)dcEmployeeDTO.getSuperUser(), (Integer)0) == 0) {
                    SearchContextDTO userRoleFilter = new SearchContextDTO().limit(1).count(false).eq("USERID", (Object)dcEmployeeDTO.getUserId()).param("DCSYSTEMID", (Object)dcSystem.getDCSystemId());
                    Page<UserRoleDTO> page2 = EBSXSystemRuntime.getInstance().getUserRoleService().fetchAccessDCSystem((ISearchContextDTO)userRoleFilter);
                    if (ObjectUtils.isEmpty(page2) || ObjectUtils.isEmpty((Object)page2.getContent())) {
                        log.debug((Object)String.format("\u7cfb\u7edf[%1$s]\u672a\u6388\u4e88\u7528\u6237[%2$s]\u8bbf\u95ee\u6743\u9650", dcSystem.getDCSystemName(), dcEmployeeDTO.getUserId()));
                        continue;
                    }
                }
                OrgSystem orgSystem = new OrgSystem();
                orgSystem.setSystemId(dcSystem.getSystemId());
                orgSystem.setOrgId(dcEmployeeDTO.getOrgId());
                orgSystem.setOrgName(dcEmployeeDTO.getOrgName());
                orgSystem.setDCSystemId(dcSystem.getDCSystemId());
                orgSystemList.add(orgSystem);
            }
        }
        finally {
            EmployeeContext.setCurrent((IEmployeeContext)lastEmployeeContext);
        }
        return orgSystemList;
    }

    protected User onGetUserByName(String strName) throws Throwable {
        UserDTO sysUserDTO;
        IUserService iUserService = EBSXSystemRuntime.getInstance().getUserService();
        SearchContextDTO searchContextDTO = new SearchContextDTO();
        String[] data = strName.split("[|,@]");
        String loginname = "";
        String domains = "";
        if (data.length > 0) {
            loginname = data[0].trim();
        }
        if (data.length > 1) {
            domains = data[1].trim();
        }
        if (!ObjectUtils.isEmpty((Object)loginname)) {
            searchContextDTO.eq("loginname", (Object)loginname);
        }
        if (!ObjectUtils.isEmpty((Object)domains)) {
            searchContextDTO.eq("domains", (Object)domains);
        }
        if ((sysUserDTO = (UserDTO)iUserService.selectOne((ISearchContextDTO)searchContextDTO, true)) == null) {
            throw new UsernameNotFoundException("\u6307\u5b9a\u7528\u6237\u4e0d\u5b58\u5728");
        }
        User user = new User();
        sysUserDTO.copyTo((IEntity)user, true);
        return user;
    }

    protected User onGetUserByName(String strSystemId, String strOrgId, String strName) throws Throwable {
        return this.onGetUserByName(strName);
    }

    protected void onChangePassword(String strUserId, String oldpassword, String newpassword) throws Throwable {
        UserDTO user = new UserDTO();
        user.setUserId(strUserId);
        user.set("oldpassword", oldpassword);
        user.setPassword(newpassword);
        EBSXSystemRuntime.getInstance().getUserService().changePwd(user);
    }

    protected List<Employee> onGetEmployees(String[] ids) throws Throwable {
        IEmployeeContext employeeContext = EmployeeContext.getCurrentMust();
        IEmployeeService employeeService = EBSXSystemRuntime.getInstance().getEmployeeService();
        SearchContextDTO searchContextDTO = new SearchContextDTO();
        searchContextDTO.count(false).limit(Integer.MAX_VALUE).eq("ORGID", (Object)employeeContext.getOrgid()).in("USERID", (Object)StringUtils.arrayToDelimitedString((Object[])ids, (String)","));
        ArrayList<Employee> employeeList = new ArrayList<Employee>();
        List<EmployeeDTO> list = employeeService.selectDefault((ISearchContextDTO)searchContextDTO);
        if (!ObjectUtils.isEmpty(list)) {
            for (EmployeeDTO item : list) {
                Employee employee = new Employee();
                item.copyTo((IEntity)employee, true);
                employeeList.add(employee);
            }
        }
        return employeeList;
    }

    protected Collection<Employee> onGetEmployeesByOrg(String strOrgId) throws Throwable {
        IEmployeeService employeeService = EBSXSystemRuntime.getInstance().getEmployeeService();
        SearchContextDTO searchContextDTO = new SearchContextDTO();
        searchContextDTO.count(false).limit(Integer.MAX_VALUE).eq("ORGID", (Object)strOrgId).sort("showorder");
        ArrayList<Employee> employeeList = new ArrayList<Employee>();
        List<EmployeeDTO> list = employeeService.selectDefault((ISearchContextDTO)searchContextDTO);
        if (!ObjectUtils.isEmpty(list)) {
            for (EmployeeDTO item : list) {
                Employee employee = new Employee();
                item.copyTo((IEntity)employee, true);
                employeeList.add(employee);
            }
        }
        return employeeList;
    }

    protected Collection<Employee> onGetEmployeesByDept(String strDeptId) throws Throwable {
        IEmployeeService employeeService = EBSXSystemRuntime.getInstance().getEmployeeService();
        SearchContextDTO searchContextDTO = new SearchContextDTO();
        searchContextDTO.count(false).limit(Integer.MAX_VALUE).eq("MDEPTID", (Object)strDeptId).sort("showorder");
        ArrayList<Employee> employeeList = new ArrayList<Employee>();
        List<EmployeeDTO> list = employeeService.selectDefault((ISearchContextDTO)searchContextDTO);
        if (!ObjectUtils.isEmpty(list)) {
            for (EmployeeDTO item : list) {
                Employee employee = new Employee();
                item.copyTo((IEntity)employee, true);
                employeeList.add(employee);
            }
        }
        return employeeList;
    }

    protected Config onGetConfig(String strConfigType, String strTargetType, boolean bTryMode) throws Throwable {
        IEmployeeContext employeeContext = EmployeeContext.getCurrentMust();
        String strKey = KeyValueUtils.genUniqueId((Object)employeeContext.getSystemid(), (Object)strConfigType, (Object)strTargetType, (Object)employeeContext.getUserid());
        DstConfigDTO dstConfigDTO = (DstConfigDTO)EBSXSystemRuntime.getInstance().getDstConfigService().get(strKey, bTryMode);
        Config config = new Config();
        if (dstConfigDTO != null) {
            dstConfigDTO.copyTo((IEntity)config, true);
        }
        return config;
    }

    protected Config onSaveConfig(String strConfigType, String strTargetType, Object objConfig) throws Throwable {
        IEmployeeContext employeeContext = EmployeeContext.getCurrentMust();
        String strConfig = objConfig != null ? (String)this.getSystemRuntime().serialize(objConfig) : null;
        DstConfigDTO dstConfigDTO = new DstConfigDTO();
        String strKey = KeyValueUtils.genUniqueId((Object)employeeContext.getSystemid(), (Object)strConfigType, (Object)strTargetType, (Object)employeeContext.getUserid());
        dstConfigDTO.setCfgId(strKey);
        dstConfigDTO.setSystemId(employeeContext.getSystemid());
        dstConfigDTO.setUserId(employeeContext.getUserid());
        dstConfigDTO.setCfgType(strConfigType);
        dstConfigDTO.setTargetType(strTargetType);
        dstConfigDTO.setCfg(strConfig);
        EBSXSystemRuntime.getInstance().getDstConfigService().save(dstConfigDTO);
        Config config = new Config();
        dstConfigDTO.copyTo((IEntity)config, true);
        return config;
    }

    protected CodeList onGetCodeList(String strCodeListTag, boolean bTryMode) throws Throwable {
        return this.onGetCodeList(strCodeListTag, bTryMode, Integer.MAX_VALUE);
    }

    protected CodeList onGetCodeList(String strCodeListTag, boolean bTryMode, Integer maxSize) throws Throwable {
        SearchContextDTO searchContextDTO = new SearchContextDTO();
        searchContextDTO.eq("CCODE", (Object)strCodeListTag);
        DictCatalogDTO dictCatalogDTO = (DictCatalogDTO)EBSXSystemRuntime.getInstance().getDictCatalogService().selectOne((ISearchContextDTO)searchContextDTO, bTryMode);
        if (dictCatalogDTO == null) {
            return null;
        }
        List<DictOptionDTO> options = EBSXSystemRuntime.getInstance().getDictOptionService().selectDefault((ISearchContextDTO)new SearchContextDTO().limit(maxSize.intValue()).count(false).sort("SHOWORDER").eq("CID", (Object)dictCatalogDTO.getId()));
        CodeList codeList = new CodeList();
        codeList.setId(dictCatalogDTO.getId());
        codeList.setName(dictCatalogDTO.getName());
        codeList.setCode(dictCatalogDTO.getCode());
        if (!ObjectUtils.isEmpty(options)) {
            ArrayList<CodeItem> codeItemList = new ArrayList<CodeItem>();
            for (DictOptionDTO option : options) {
                CodeItem codeItem = new CodeItem();
                codeItem.setValue(option.getValue());
                codeItem.setText(option.getLabel());
                codeItem.setIconClass(option.getIconClass());
                codeItem.setShowOrder(option.getShowOrder());
                codeItem.setDisabled(DataTypeUtils.getBooleanValue((Object)option.getDisabled(), (Boolean)false));
                codeItem.setPValue(option.getParent());
                codeItemList.add(codeItem);
            }
            codeList.setItems(codeItemList);
        }
        return codeList;
    }

    protected Collection<IUAAGrantedAuthority> onGetGrantedAuthorities(final IEmployeeContext iEmployeeContext) throws Throwable {
        return (Collection)new UserContextActionBuilder((IUserContext)iEmployeeContext).action(new IAction(){

            public Object execute(Object[] args) throws Throwable {
                LinkedHashSet<Object> authorities = new LinkedHashSet<Object>();
                SearchContextDTO sysPermissionActionSearchContext = new SearchContextDTO().all();
                sysPermissionActionSearchContext.set("userid", iEmployeeContext.getUserid());
                sysPermissionActionSearchContext.set("dcsystemid", iEmployeeContext.getDcsystemid());
                List<PermissionActionDTO> actions = EBSXSystemRuntime.getInstance().getPermissionActionService().selectAuthority((ISearchContextDTO)sysPermissionActionSearchContext);
                SearchContextDTO sysPermissionSearchContext = new SearchContextDTO().all();
                sysPermissionSearchContext.set("userid", iEmployeeContext.getUserid());
                sysPermissionSearchContext.set("dcsystemid", iEmployeeContext.getDcsystemid());
                List<PermissionDTO> permissions = EBSXSystemRuntime.getInstance().getPermissionService().selectAuthority((ISearchContextDTO)sysPermissionSearchContext);
                for (PermissionDTO permission : permissions) {
                    UAADEAuthority authority;
                    if (permission.getPermissionType().equals(PermissionType.OPPRIV.toString())) {
                        authority = new UAADEAuthority();
                        authority.setSystemid(permission.getPSSystemId());
                        authority.setName(permission.getPermissionName());
                        authority.setEntity(permission.getEntityName());
                        authority.setIsAllData(permission.getIsAllData());
                        authority.setEnableorgdr(permission.getEnableOrgDR());
                        authority.setEnabledeptdr(permission.getEnableDeptDR());
                        authority.setEnabledeptbc(permission.getEnableDeptBC());
                        authority.setOrgdr(permission.getOrgDR());
                        authority.setDeptdr(permission.getDeptDR());
                        authority.setDeptbc(permission.getDeptBC());
                        authority.setBscope(permission.getBScope());
                        authority.setDeAction(actions.stream().filter(f -> f.getPermissionId().equals(permission.getPermissionId())).map(m -> {
                            HashMap<String, String> action = new HashMap<String, String>();
                            if (!ObjectUtils.isEmpty((Object)m.getOPPriv())) {
                                action.put(m.getOPPriv(), ObjectUtils.isEmpty((Object)m.getBScope()) ? "" : m.getBScope());
                            }
                            return action;
                        }).collect(Collectors.toList()));
                        authorities.add(authority);
                        continue;
                    }
                    if (permission.getPermissionType().equals(PermissionType.APPMENU.toString()) || !permission.getPermissionType().equals(PermissionType.UNIRES.toString())) continue;
                    authority = new UAAUniResAuthority();
                    authority.setSystemid(permission.getPSSystemId());
                    authority.setName(permission.getPermissionName());
                    authority.setAuthority(permission.getPermissionTag());
                    authorities.add(authority);
                }
                SearchContextDTO sysRoleSearchContext = new SearchContextDTO().all();
                String sysRoleFind = "(T1.DCSYSTEMID IS NULL OR T1.DCSYSTEMID = '%1$s') AND EXISTS (SELECT 1 FROM IBZUSER_ROLE T2 WHERE T1.SYS_ROLEID = T2.SYS_ROLEID AND T2.ISVALID = 1 AND T2.USERID = '%2$s' )";
                sysRoleSearchContext.custom(String.format(sysRoleFind, iEmployeeContext.getDcsystemid(), iEmployeeContext.getUserid()));
                List<RoleDTO> sysRoles = EBSXSystemRuntime.getInstance().getRoleService().selectDefault((ISearchContextDTO)sysRoleSearchContext);
                for (RoleDTO sysRole : sysRoles) {
                    UAARoleAuthority authority = new UAARoleAuthority();
                    authority.setName(sysRole.getRoleName());
                    authority.setAuthority(sysRole.getRoleTag());
                    authorities.add(authority);
                }
                return authorities;
            }
        }).build().execute((TypeReference)new TypeReference<Collection<IUAAGrantedAuthority>>(){});
    }

    protected Collection<GrantedAuthority> getAuthoritiesByUserId(String userId) throws Throwable {
        LinkedHashSet<GrantedAuthority> authorities = new LinkedHashSet<GrantedAuthority>();
        Set<String> roleIds = this.getRoleIdsByUserId(userId);
        if (roleIds.size() > 0) {
            roleIds.forEach(roleid -> authorities.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_" + roleid)));
            String ids = "";
            for (String id : roleIds) {
                if (!StringUtils.isEmpty((Object)ids)) {
                    ids = ids + ",";
                }
                ids = ids + "'" + id + "'";
            }
            String sql = " SELECT distinct t21.PERMISSIONTYPE, t1.SYS_PERMISSIONID FROM IBZROLE_PERMISSION t1  INNER JOIN IBZPERMISSION t21 ON t1.SYS_PERMISSIONID = t21.SYS_PERMISSIONID where sys_roleid in (" + ids + ")";
            HashSet apps = new HashSet();
            List rolePermissionDTOList = EBSXSystemRuntime.getInstance().getRolePermissionService().executeSelectSQL(sql, null);
            rolePermissionDTOList.forEach(item -> {
                String appid;
                String permissiontype = item.getPermissionType();
                String permissionid = item.getPermissionId();
                if (StringUtils.isEmpty((Object)permissionid) || StringUtils.isEmpty((Object)permissiontype)) {
                    return;
                }
                if (PermissionType.APPMENU.toString().equals(permissiontype) && !apps.contains(appid = permissionid.split("-")[0].toLowerCase() + "-" + permissionid.split("-")[1].toLowerCase())) {
                    apps.add(appid);
                    authorities.add((GrantedAuthority)new SimpleGrantedAuthority(permissiontype + "_" + appid));
                }
                if (PermissionType.OPPRIV.toString().equals(permissiontype)) {
                    authorities.add((GrantedAuthority)new SimpleGrantedAuthority(permissionid));
                } else {
                    authorities.add((GrantedAuthority)new SimpleGrantedAuthority(permissiontype + "_" + permissionid));
                }
            });
        }
        return authorities;
    }

    protected Set<String> getRoleIdsByUserId(String userId) throws Throwable {
        HashSet<String> roleIds = new HashSet<String>();
        SearchContextDTO searchContextDTO = new SearchContextDTO().all();
        searchContextDTO.eq("USERID", (Object)userId);
        List<UserRoleDTO> userRoleDTOList = EBSXSystemRuntime.getInstance().getUserRoleService().selectDefault((ISearchContextDTO)searchContextDTO);
        if (ObjectUtils.isEmpty(userRoleDTOList)) {
            return roleIds;
        }
        for (UserRoleDTO userRoleDTO : userRoleDTOList) {
            roleIds.add(userRoleDTO.getRoleId());
        }
        List<RoleDTO> roles = EBSXSystemRuntime.getInstance().getRoleService().selectDefault((ISearchContextDTO)new SearchContextDTO().all().nn("PROLEID"));
        if (ObjectUtils.isEmpty(roles)) {
            return roleIds;
        }
        ArrayList<RoleDTO> backupRoleDTOList = new ArrayList<RoleDTO>();
        while (true) {
            if (roles.size() > 0) {
                RoleDTO roleDTO = roles.remove(0);
                if (roleIds.contains(roleDTO.getPRoleId())) {
                    roleIds.add(roleDTO.getRoleId());
                    continue;
                }
                backupRoleDTOList.add(roleDTO);
                continue;
            }
            if (backupRoleDTOList.size() == 0) break;
            roles.addAll(backupRoleDTOList);
            backupRoleDTOList.clear();
        }
        return roleIds;
    }

    protected void onLog(SysLog sysLog) throws Throwable {
        IEmployeeContext employeeContext = EmployeeContext.getCurrent();
        SysLogDTO sysLogDTO = new SysLogDTO();
        sysLog.copyTo((IEntity)sysLogDTO);
        sysLogDTO.setLogCat(sysLog.getCat());
        sysLogDTO.setLogInfo(sysLog.getInfo());
        if (employeeContext != null) {
            sysLogDTO.setDCSystemId(employeeContext.getDcsystemid());
            sysLogDTO.setSrfdcid(employeeContext.getTenant());
        }
        EBSXSystemRuntime.getInstance().getSysLogService().create(sysLogDTO);
    }

    protected void onLogAudit(SysAudit sysAudit) throws Throwable {
        IEmployeeContext employeeContext = EmployeeContext.getCurrent();
        SysAuditDTO sysAuditDTO = new SysAuditDTO();
        sysAudit.copyTo((IEntity)sysAuditDTO);
        sysAuditDTO.setAuditCat(sysAudit.getCat());
        sysAuditDTO.setAuditInfo(sysAudit.getInfo());
        if (employeeContext != null) {
            sysAuditDTO.setDCSystemId(employeeContext.getDcsystemid());
            sysAuditDTO.setSrfdcid(employeeContext.getTenant());
        }
        EBSXSystemRuntime.getInstance().getSysAuditService().create(sysAuditDTO);
    }

    protected void onLogEvent(SysEvent sysEvent) throws Throwable {
        IEmployeeContext employeeContext = EmployeeContext.getCurrent();
        SysEventDTO sysEventDTO = new SysEventDTO();
        sysEvent.copyTo((IEntity)sysEventDTO);
        sysEventDTO.setEventCat(sysEvent.getCat());
        sysEventDTO.setEventInfo(sysEvent.getInfo());
        if (employeeContext != null) {
            sysEventDTO.setSrfdcid(employeeContext.getTenant());
            sysEventDTO.setDCSystemId(employeeContext.getDcsystemid());
        }
        EBSXSystemRuntime.getInstance().getSysEventService().create(sysEventDTO);
    }

    protected void onLogPO(SysPO sysPO) throws Throwable {
        IEmployeeContext employeeContext = EmployeeContext.getCurrent();
        SysPODTO sysPODTO = new SysPODTO();
        sysPO.copyTo((IEntity)sysPODTO);
        sysPODTO.setPOCat(sysPO.getCat());
        sysPODTO.setPOInfo(sysPO.getInfo());
        sysPODTO.setDEName(sysPO.getDE());
        sysPODTO.setTime(sysPO.getTime());
        if (employeeContext != null) {
            sysPODTO.setSrfdcid(employeeContext.getTenant());
            sysPODTO.setDCSystemId(employeeContext.getDcsystemid());
        }
        EBSXSystemRuntime.getInstance().getSysPOService().create(sysPODTO);
    }

    protected void onLog(List<Log> list) throws Throwable {
        IEmployeeContext employeeContext = EmployeeContext.getCurrent();
        String strUserId = null;
        strUserId = employeeContext != null ? employeeContext.getUserid() : AuthenticationUser.getCurrentMust().getUserid();
        ArrayList<SysLogDTO> sysLogDTOList = null;
        ArrayList<SysAuditDTO> sysAuditDTOList = null;
        ArrayList<SysPODTO> sysPODTOList = null;
        ArrayList<SysEventDTO> sysEventDTOList = null;
        for (Log log : list) {
            if ("NORMAL".equals(log.getLogType())) {
                SysLogDTO sysLogDTO = new SysLogDTO();
                sysLogDTO.setSysLogId(KeyValueUtils.genUniqueId());
                sysLogDTO.setLogCat(this.getRealCatName(log.getLogCat()));
                sysLogDTO.setSysLogName(log.getLogName());
                if (!StringUtils.hasLength((String)sysLogDTO.getSysLogName())) {
                    sysLogDTO.setSysLogName(log.getInfo());
                }
                if (StringUtils.hasLength((String)sysLogDTO.getSysLogName())) {
                    sysLogDTO.setSysLogName(this.getRealLogName(sysLogDTO.getSysLogName()));
                }
                sysLogDTO.setLogLevel(log.getLogLevel());
                sysLogDTO.setLogInfo(log.getInfo());
                sysLogDTO.setCreateDate(log.getLogTime());
                sysLogDTO.setCreateMan(log.getUserId());
                sysLogDTO.setOPPersonId(log.getUserId());
                sysLogDTO.setDCSystemId((String)log.get("dcsystemid"));
                sysLogDTO.setSrfdcid(log.getTenant());
                if (sysLogDTOList == null) {
                    sysLogDTOList = new ArrayList<SysLogDTO>();
                }
                sysLogDTOList.add(sysLogDTO);
                continue;
            }
            if ("AUDIT".equals(log.getLogType())) {
                SysAuditDTO sysAuditDTO = new SysAuditDTO();
                sysAuditDTO.setSysAuditId(KeyValueUtils.genUniqueId());
                sysAuditDTO.setAuditCat(this.getRealCatName(log.getLogCat()));
                sysAuditDTO.setSysAuditName(log.getLogName());
                if (!StringUtils.hasLength((String)sysAuditDTO.getSysAuditName())) {
                    sysAuditDTO.setSysAuditName(log.getInfo());
                }
                if (StringUtils.hasLength((String)sysAuditDTO.getSysAuditName())) {
                    sysAuditDTO.setSysAuditName(this.getRealLogName(sysAuditDTO.getSysAuditName()));
                }
                sysAuditDTO.setLogLevel(log.getLogLevel());
                sysAuditDTO.setAuditInfo(log.getInfo());
                sysAuditDTO.setCreateDate(log.getLogTime());
                sysAuditDTO.setCreateMan(log.getUserId());
                sysAuditDTO.setOPPersonId(log.getUserId());
                sysAuditDTO.setDCSystemId((String)log.get("dcsystemid"));
                sysAuditDTO.setSrfdcid(log.getTenant());
                sysAuditDTO.setAddress(log.getRemoteAddress());
                if (sysAuditDTOList == null) {
                    sysAuditDTOList = new ArrayList<SysAuditDTO>();
                }
                sysAuditDTOList.add(sysAuditDTO);
                continue;
            }
            if ("PO".equals(log.getLogType())) {
                SysPODTO sysPODTO = new SysPODTO();
                sysPODTO.setSysPOId(KeyValueUtils.genUniqueId());
                sysPODTO.setPOCat(this.getRealCatName(log.getLogCat()));
                sysPODTO.setSysPOName(log.getLogName());
                if (!StringUtils.hasLength((String)sysPODTO.getSysPOName())) {
                    sysPODTO.setSysPOName(log.getInfo());
                }
                if (StringUtils.hasLength((String)sysPODTO.getSysPOName())) {
                    sysPODTO.setSysPOName(this.getRealLogName(sysPODTO.getSysPOName()));
                }
                sysPODTO.setLogLevel(log.getLogLevel());
                sysPODTO.setPOInfo(log.getInfo());
                sysPODTO.setCreateDate(log.getLogTime());
                sysPODTO.setCreateMan(log.getUserId());
                sysPODTO.setDEName(log.getActionOwner());
                sysPODTO.setAction(log.getAction());
                if (log.getActionDuration() != null) {
                    sysPODTO.setTime(log.getActionDuration().longValue());
                }
                sysPODTO.setDCSystemId((String)log.get("dcsystemid"));
                sysPODTO.setSrfdcid(log.getTenant());
                if (sysPODTOList == null) {
                    sysPODTOList = new ArrayList<SysPODTO>();
                }
                sysPODTOList.add(sysPODTO);
                continue;
            }
            if (!"EVENT".equals(log.getLogType())) continue;
            SysEventDTO sysEventDTO = new SysEventDTO();
            sysEventDTO.setSysEventId(KeyValueUtils.genUniqueId());
            sysEventDTO.setEventCat(this.getRealCatName(log.getLogCat()));
            sysEventDTO.setSysEventName(log.getLogName());
            if (!StringUtils.hasLength((String)sysEventDTO.getSysEventName())) {
                sysEventDTO.setSysEventName(log.getInfo());
            }
            if (StringUtils.hasLength((String)sysEventDTO.getSysEventName())) {
                sysEventDTO.setSysEventName(this.getRealLogName(sysEventDTO.getSysEventName()));
            }
            sysEventDTO.setLogLevel(log.getLogLevel());
            sysEventDTO.setEventInfo(log.getInfo());
            sysEventDTO.setCreateDate(log.getLogTime());
            sysEventDTO.setCreateMan(log.getUserId());
            sysEventDTO.setOPPersonId(log.getUserId());
            sysEventDTO.setDCSystemId((String)log.get("dcsystemid"));
            sysEventDTO.setSrfdcid(log.getTenant());
            if (sysEventDTOList == null) {
                sysEventDTOList = new ArrayList<SysEventDTO>();
            }
            sysEventDTOList.add(sysEventDTO);
        }
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        if (!ObjectUtils.isEmpty(sysLogDTOList)) {
            for (SysLogDTO sysLogDTO : sysLogDTOList) {
                if (sysLogDTO.getCreateDate() == null) {
                    sysLogDTO.setCreateDate(currentTime);
                }
                if (!StringUtils.hasLength((String)sysLogDTO.getCreateMan())) {
                    sysLogDTO.setCreateMan(strUserId);
                }
                sysLogDTO.setUpdateDate(sysLogDTO.getCreateDate());
                sysLogDTO.setUpdateMan(sysLogDTO.getCreateMan());
            }
            EBSXSystemRuntime.getInstance().getSysLogService().rawCreate(sysLogDTOList, true);
        }
        if (!ObjectUtils.isEmpty(sysAuditDTOList)) {
            for (SysAuditDTO sysAuditDTO : sysAuditDTOList) {
                if (sysAuditDTO.getCreateDate() == null) {
                    sysAuditDTO.setCreateDate(currentTime);
                }
                if (!StringUtils.hasLength((String)sysAuditDTO.getCreateMan())) {
                    sysAuditDTO.setCreateMan(strUserId);
                }
                sysAuditDTO.setUpdateDate(sysAuditDTO.getCreateDate());
                sysAuditDTO.setUpdateMan(sysAuditDTO.getCreateMan());
            }
            EBSXSystemRuntime.getInstance().getSysAuditService().rawCreate(sysAuditDTOList, true);
        }
        if (!ObjectUtils.isEmpty(sysPODTOList)) {
            for (SysPODTO sysPODTO : sysPODTOList) {
                if (sysPODTO.getCreateDate() == null) {
                    sysPODTO.setCreateDate(currentTime);
                }
                if (!StringUtils.hasLength((String)sysPODTO.getCreateMan())) {
                    sysPODTO.setCreateMan(strUserId);
                }
                sysPODTO.setUpdateDate(sysPODTO.getCreateDate());
                sysPODTO.setUpdateMan(sysPODTO.getCreateMan());
            }
            EBSXSystemRuntime.getInstance().getSysPOService().rawCreate(sysPODTOList, true);
        }
        if (!ObjectUtils.isEmpty(sysEventDTOList)) {
            for (SysEventDTO sysEventDTO : sysEventDTOList) {
                if (sysEventDTO.getCreateDate() == null) {
                    sysEventDTO.setCreateDate(currentTime);
                }
                if (!StringUtils.hasLength((String)sysEventDTO.getCreateMan())) {
                    sysEventDTO.setCreateMan(strUserId);
                }
                sysEventDTO.setUpdateDate(sysEventDTO.getCreateDate());
                sysEventDTO.setUpdateMan(sysEventDTO.getCreateMan());
            }
            EBSXSystemRuntime.getInstance().getSysEventService().rawCreate(sysEventDTOList, true);
        }
    }

    protected String getRealCatName(String strCatName) {
        if (!StringUtils.hasLength((String)strCatName)) {
            return null;
        }
        if (strCatName.length() <= 60) {
            return strCatName;
        }
        String strRealCatName = "";
        String[] items = strCatName.split("[.]");
        for (int i = 0; i < items.length - 1; ++i) {
            if (items[i].length() > 0) {
                strRealCatName = strRealCatName + items[i].substring(0, 1);
            }
            strRealCatName = strRealCatName + ".";
        }
        if ((strRealCatName = strRealCatName + items[items.length - 1]).length() > 60) {
            strRealCatName = strRealCatName.substring(0, 60);
        }
        return strRealCatName;
    }

    protected String getRealLogName(String strLogName) {
        if (!StringUtils.hasLength((String)strLogName)) {
            return null;
        }
        int nPos = strLogName.indexOf("\r\n");
        if (nPos != -1) {
            strLogName = strLogName.substring(0, nPos);
        }
        if (strLogName.length() > 200) {
            return strLogName.substring(0, 190) + "...";
        }
        return strLogName;
    }

    protected Collection<Department> onGetAllDepartments() throws Throwable {
        List<DepartmentDTO> list = EBSXSystemRuntime.getInstance().getDepartmentService().selectDefault((ISearchContextDTO)new SearchContextDTO().all().sort("showorder;deptcode"));
        ArrayList<Department> departmentList = new ArrayList<Department>();
        if (!ObjectUtils.isEmpty(list)) {
            list.forEach(t -> {
                Department department = new Department();
                t.copyTo((IEntity)department, true);
                departmentList.add(department);
            });
        }
        return departmentList;
    }

    protected Collection<Organization> onGetAllOrganizations() throws Throwable {
        List<OrganizationDTO> list = EBSXSystemRuntime.getInstance().getOrganizationService().selectDefault((ISearchContextDTO)new SearchContextDTO().all().sort("showorder;orgcode"));
        ArrayList<Organization> organizationList = new ArrayList<Organization>();
        if (!ObjectUtils.isEmpty(list)) {
            list.forEach(t -> {
                Organization organization = new Organization();
                t.copyTo((IEntity)organization, true);
                organizationList.add(organization);
            });
        }
        return organizationList;
    }

    protected Collection<Employee> onGetAllEmployees() throws Throwable {
        List<EmployeeDTO> list = EBSXSystemRuntime.getInstance().getEmployeeService().selectDefault((ISearchContextDTO)new SearchContextDTO().all().sort("showorder"));
        ArrayList<Employee> employeeList = new ArrayList<Employee>();
        if (!ObjectUtils.isEmpty(list)) {
            list.forEach(t -> {
                Employee employee = new Employee();
                t.copyTo((IEntity)employee, true);
                employeeList.add(employee);
            });
        }
        return employeeList;
    }

    protected Collection<net.ibizsys.central.cloud.core.util.domain.System> onGetAllSystems() throws Throwable {
        List<SystemDTO> list = EBSXSystemRuntime.getInstance().getSystemService().selectDefault((ISearchContextDTO)new SearchContextDTO().all());
        ArrayList<net.ibizsys.central.cloud.core.util.domain.System> systemList = new ArrayList<net.ibizsys.central.cloud.core.util.domain.System>();
        if (!ObjectUtils.isEmpty(list)) {
            list.forEach(t -> {
                net.ibizsys.central.cloud.core.util.domain.System system = new net.ibizsys.central.cloud.core.util.domain.System();
                t.copyTo((IEntity)system, true);
                systemList.add(system);
            });
        }
        return systemList;
    }

    protected Collection<Application> onGetAllApplications() throws Throwable {
        List<ApplicationDTO> list = EBSXSystemRuntime.getInstance().getApplicationService().selectDefault((ISearchContextDTO)new SearchContextDTO().all());
        ArrayList<Application> applicationList = new ArrayList<Application>();
        if (!ObjectUtils.isEmpty(list)) {
            list.forEach(t -> {
                Application application = new Application();
                t.copyTo((IEntity)application, true);
                applicationList.add(application);
            });
        }
        return applicationList;
    }

    protected Collection<Application> onGetApplications(String strSystemId) throws Throwable {
        Collection allApplications = this.getAllApplications();
        ArrayList<Application> applicationList = new ArrayList<Application>();
        if (!ObjectUtils.isEmpty((Object)allApplications)) {
            allApplications.forEach(t -> {
                if (strSystemId.equals(t.getSystemId())) {
                    applicationList.add((Application)t);
                }
            });
        }
        return applicationList;
    }

    protected Collection<DepCenter> onGetAllDepCenters() throws Throwable {
        List<CenterDTO> list = EBSXSystemRuntime.getInstance().getCenterService().selectDefault((ISearchContextDTO)new SearchContextDTO().all());
        ArrayList<DepCenter> depCenterList = new ArrayList<DepCenter>();
        if (!ObjectUtils.isEmpty(list)) {
            list.forEach(t -> {
                DepCenter depCenter = new DepCenter();
                t.copyTo((IEntity)depCenter, true);
                depCenterList.add(depCenter);
            });
        }
        return depCenterList;
    }

    protected Collection<DCSystem> onGetAllDCSystems() throws Throwable {
        List<DCSystemDTO> list = EBSXSystemRuntime.getInstance().getDCSystemService().selectDefault((ISearchContextDTO)new SearchContextDTO().all());
        ArrayList<DCSystem> dcSystemList = new ArrayList<DCSystem>();
        if (!ObjectUtils.isEmpty(list)) {
            list.forEach(t -> {
                DCSystem dcSystem = new DCSystem();
                t.copyTo((IEntity)dcSystem, true);
                dcSystemList.add(dcSystem);
            });
        }
        return dcSystemList;
    }

    protected Collection<Role> onGetAllGlobalRoles() throws Throwable {
        List<RoleDTO> list = EBSXSystemRuntime.getInstance().getRoleService().selectDefault((ISearchContextDTO)new SearchContextDTO().all().eq("GLOBALFLAG", (Object)1));
        ArrayList<Role> roleList = new ArrayList<Role>();
        if (!ObjectUtils.isEmpty(list)) {
            list.forEach(t -> {
                Role role = new Role();
                t.copyTo((IEntity)role, true);
                roleList.add(role);
            });
        }
        return roleList;
    }

    protected Collection<UserRole> onGetGlobalUserRoles(String strRoleId) throws Throwable {
        Role role = this.getGlobalRole(strRoleId);
        List<UserRoleDTO> list = EBSXSystemRuntime.getInstance().getUserRoleService().selectDefault((ISearchContextDTO)new SearchContextDTO().all().eq("SYS_ROLEID", (Object)role.getRoleId()).eq("ISVALID", (Object)1));
        ArrayList<UserRole> userRoles = new ArrayList<UserRole>();
        if (!ObjectUtils.isEmpty(list)) {
            list.forEach(t -> {
                UserRole userRole = new UserRole();
                t.copyTo((IEntity)userRole, true);
                userRoles.add(userRole);
            });
        }
        return userRoles;
    }

    protected Collection<Role> onGetSystemRoles(String strDCSystemId) throws Throwable {
        List<RoleDTO> list = EBSXSystemRuntime.getInstance().getRoleService().selectDefault((ISearchContextDTO)new SearchContextDTO().all().eq("GLOBALFLAG", (Object)0).eq("DCSYSTEMID", (Object)strDCSystemId));
        ArrayList<Role> roleList = new ArrayList<Role>();
        if (!ObjectUtils.isEmpty(list)) {
            list.forEach(t -> {
                Role role = new Role();
                t.copyTo((IEntity)role, true);
                roleList.add(role);
            });
        }
        return roleList;
    }

    protected Collection<UserRole> onGetSystemUserRoles(String strDCSystemId, String strRoleId) throws Throwable {
        Role role = this.getSystemRole(strDCSystemId, strRoleId, false);
        List<UserRoleDTO> list = EBSXSystemRuntime.getInstance().getUserRoleService().selectDefault((ISearchContextDTO)new SearchContextDTO().all().eq("SYS_ROLEID", (Object)role.getRoleId()).eq("ISVALID", (Object)1));
        ArrayList<UserRole> userRoles = new ArrayList<UserRole>();
        if (!ObjectUtils.isEmpty(list)) {
            list.forEach(t -> {
                UserRole userRole = new UserRole();
                t.copyTo((IEntity)userRole, true);
                userRoles.add(userRole);
            });
        }
        return userRoles;
    }

    protected Collection<WFGroup> onGetAllWFGroups() throws Throwable {
        List<WFGroupDTO> list = EBSXSystemRuntime.getInstance().getWFGroupService().selectDefault((ISearchContextDTO)new SearchContextDTO().all());
        ArrayList<WFGroup> wfGroupList = new ArrayList<WFGroup>();
        if (!ObjectUtils.isEmpty(list)) {
            list.forEach(t -> {
                WFGroup wfGroup = new WFGroup();
                t.copyTo((IEntity)wfGroup, true);
                wfGroupList.add(wfGroup);
            });
        }
        return wfGroupList;
    }

    protected Collection<WFMember> onGetWFMembers(String strWFGroupId) throws Throwable {
        WFGroup wfGroup = this.getWFGroup(strWFGroupId);
        List<WFMemberDTO> list = EBSXSystemRuntime.getInstance().getWFMemberService().selectDefault((ISearchContextDTO)new SearchContextDTO().all().eq("GROUPID", (Object)wfGroup.getId()));
        ArrayList<WFMember> wfMemberList = new ArrayList<WFMember>();
        if (!ObjectUtils.isEmpty(list)) {
            list.forEach(t -> {
                WFMember wfMember = new WFMember();
                t.copyTo((IEntity)wfMember, true);
                wfMemberList.add(wfMember);
            });
        }
        return wfMemberList;
    }

    protected OpenAccess onGetOpenAccess(String strOpenAccessId) throws Throwable {
        return this.onGetOpenAccess(strOpenAccessId, false);
    }

    protected OpenAccess onGetOpenAccess(String strOpenAccessId, boolean bTryMode) throws Throwable {
        OpenAccessDTO dto = (OpenAccessDTO)EBSXSystemRuntime.getInstance().getOpenAccessService().get(strOpenAccessId, bTryMode);
        if (dto == null) {
            return null;
        }
        OpenAccess openAccess = new OpenAccess();
        dto.copyTo((IEntity)openAccess, true);
        return openAccess;
    }

    protected OpenUser onGetOpenUser(String strOpenType, String strUserId) throws Throwable {
        Employee employee = this.getEmployee(strUserId);
        OpenUserDTO dto = (OpenUserDTO)EBSXSystemRuntime.getInstance().getOpenUserService().selectOne((ISearchContextDTO)new SearchContextDTO().eq("OPEN_TYPE", (Object)strOpenType.toLowerCase()).eq("MOBILE", (Object)employee.getPhone()), true);
        if (dto == null) {
            OpenUser openUser = new OpenUser();
            openUser.setSysUserId(strUserId);
            openUser.setOpenUserName(employee.getPersonName());
            return openUser;
        }
        OpenUser openUser = new OpenUser();
        dto.copyTo((IEntity)openUser, true);
        return openUser;
    }

    protected Collection<MsgTemplate> onGetAllMsgTemplates() throws Throwable {
        List<MsgTemplateDTO> list = EBSXSystemRuntime.getInstance().getMsgTemplateService().selectDefault((ISearchContextDTO)new SearchContextDTO().all());
        ArrayList<MsgTemplate> msgTemplateList = new ArrayList<MsgTemplate>();
        if (!ObjectUtils.isEmpty(list)) {
            list.forEach(t -> {
                MsgTemplate msgTemplate = new MsgTemplate();
                t.copyTo((IEntity)msgTemplate, true);
                msgTemplateList.add(msgTemplate);
            });
        }
        return msgTemplateList;
    }

    protected User onGetUserByOpenUser(OpenUser openUser) throws Throwable {
        IEmployeeService employeeService = EBSXSystemRuntime.getInstance().getEmployeeService();
        EmployeeDTO employeeDTO = null;
        if (StringUtils.hasLength((String)openUser.getSysUserId())) {
            employeeDTO = (EmployeeDTO)employeeService.get(openUser.getSysUserId(), true);
            if (employeeDTO == null) {
                throw new Exception(String.format("\u5f00\u653e\u7528\u6237[%1$s]\u624b\u673a\u53f7\u7801[%2$s]\u7ed1\u5b9a\u673a\u6784\u7528\u6237\u4e0d\u5b58\u5728", openUser.getOpenUserName(), openUser.getMobile()));
            }
        } else {
            if (!StringUtils.hasLength((String)openUser.getMobile())) {
                throw new Exception(String.format("\u5f00\u653e\u7528\u6237[%1$s]\u672a\u6307\u5b9a\u624b\u673a\u53f7\u7801\uff0c\u65e0\u6cd5\u5339\u914d\u673a\u6784\u7528\u6237", openUser.getOpenUserName()));
            }
            SearchContextDTO searchContextDTO = new SearchContextDTO();
            searchContextDTO.eq("PHONE", (Object)openUser.getMobile());
            employeeDTO = (EmployeeDTO)employeeService.selectOne((ISearchContextDTO)searchContextDTO, true);
            if (employeeDTO == null) {
                throw new Exception(String.format("\u5f00\u653e\u7528\u6237[%1$s]\u624b\u673a\u53f7\u7801[%2$s]\u672a\u7ed1\u5b9a\u673a\u6784\u7528\u6237", openUser.getOpenUserName(), openUser.getMobile()));
            }
        }
        IUserService iUserService = EBSXSystemRuntime.getInstance().getUserService();
        User user = new User();
        iUserService.get(employeeDTO.getUAAUserId()).copyTo((IEntity)user, true);
        return user;
    }

    protected void prepareSysCacheUtilRuntime() {
        this.setSysCacheUtilRuntime(this.getSystemRuntime().getSysCacheUtilRuntime(false));
    }
}

