/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.report.grafana.addin;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.cloud.core.util.RestUtils;
import net.ibizsys.central.cloud.report.core.addin.ReportDataSourceBase;
import net.ibizsys.central.cloud.report.grafana.util.GrafanaUtils;
import net.ibizsys.central.service.client.IWebClientRep;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class GrafanaDataSource
extends ReportDataSourceBase {
    private static final Log log = LogFactory.getLog(GrafanaDataSource.class);

    protected Object onExecuteAction(String strAction, Object params) throws Throwable {
        if ("QUERY".equalsIgnoreCase(strAction)) {
            return this.doExecuteQuery(params);
        }
        log.warn((Object)String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u64cd\u4f5c[%1$s]", strAction));
        return null;
    }

    protected Object doExecuteQuery(Object params) throws Throwable {
        List targetList;
        Map body = null;
        if (params instanceof Map) {
            body = (Map)params;
        }
        if ((targetList = GrafanaUtils.getQueryTargets(body)) == null) {
            throw new Exception("\u672a\u6307\u5b9a\u67e5\u8be2\u76ee\u6807\u96c6\u5408");
        }
        ArrayList totalList = new ArrayList();
        for (Object target : targetList) {
            String[] paths;
            Map targetMap = (Map)target;
            String strType = GrafanaUtils.getQueryTargetType(targetMap);
            String strTarget = GrafanaUtils.getQueryTarget(targetMap);
            String[] parts = strTarget.split("[?]");
            String strPath = parts[0];
            String strQuery = null;
            if (parts.length > 1) {
                strQuery = parts[1];
            }
            if ((paths = strPath.toLowerCase().split("[/]")).length < 4) {
                throw new Exception(String.format("\u76ee\u6807\u8def\u5f84[%1$s]\u4e0d\u6b63\u786e", strPath));
            }
            String strServiceId = String.format("lb://%1$s-%2$s", paths[0], paths[1]);
            String strServiceUrl = "";
            for (int i = 0; i < paths.length; ++i) {
                strServiceUrl = strServiceUrl + "/";
                strServiceUrl = strServiceUrl + paths[i];
            }
            if (!"table".equalsIgnoreCase(strType)) continue;
            Map paramMap = RestUtils.queryString2Map((String)strQuery, (boolean)false);
            String strColumns = (String)paramMap.remove("columns");
            if (!StringUtils.hasLength((String)strColumns)) {
                throw new Exception("\u672a\u6307\u5b9a\u67e5\u8be2\u5217");
            }
            String[] columns = strColumns.toLowerCase().split("[,]");
            LinkedHashMap<String, Object> columnMap = new LinkedHashMap<String, Object>();
            for (String strColumn : columns) {
                columnMap.put(strColumn.trim(), null);
            }
            IWebClientRep rep = this.getContext().executeCloudServiceCall(strServiceId, strServiceUrl, (Object)paramMap, String.class, paths[0]);
            String strRet = (String)rep.getBody();
            LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
            ArrayList columnsList = new ArrayList();
            ArrayList rowsList = new ArrayList();
            ret.put("columns", columnsList);
            ret.put("rows", rowsList);
            ret.put("type", "table");
            for (String strColumn : columns) {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                map.put("text", strColumn);
                columnsList.add(map);
            }
            if (StringUtils.hasLength((String)strRet)) {
                List list = (List)this.getSystemRuntime().deserialize((Object)strRet, List.class);
                for (Object item : list) {
                    if (!(item instanceof Map)) continue;
                    Map map = (Map)item;
                    ArrayList row = new ArrayList();
                    for (String strColumn : columns) {
                        Object value = map.get(strColumn);
                        row.add(value);
                    }
                    rowsList.add(row);
                }
            }
            totalList.add(ret);
        }
        if (totalList.size() == 0) {
            return null;
        }
        return totalList;
    }
}

