/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.uaa.rabbitmq.spring.controller;

import java.util.Date;
import java.util.Map;
import javax.annotation.PostConstruct;
import net.ibizsys.central.ISystemGateway;
import net.ibizsys.central.SystemGatewayException;
import net.ibizsys.central.cloud.core.IServiceHub;
import net.ibizsys.central.cloud.core.cloudutil.ICloudUAAUtilRuntime;
import net.ibizsys.central.cloud.core.cloudutil.client.ICloudPortalClient;
import net.ibizsys.central.cloud.core.sysutil.ISysCloudClientUtilRuntime;
import net.ibizsys.central.cloud.core.util.CloudCacheTagUtils;
import net.ibizsys.central.cloud.core.util.domain.Employee;
import net.ibizsys.central.cloud.uaa.core.IUAAUtilSystemRuntime;
import net.ibizsys.central.cloud.uaa.rabbitmq.util.domain.ResourceCheck;
import net.ibizsys.central.cloud.uaa.rabbitmq.util.domain.TopicCheck;
import net.ibizsys.central.cloud.uaa.rabbitmq.util.domain.VirtualHostCheck;
import net.ibizsys.central.sysutil.ISysCacheUtilRuntime;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={""})
public class AuthRestController {
    private static final Log log = LogFactory.getLog(AuthRestController.class);
    @Autowired
    IServiceHub iServiceHub;
    private ICloudUAAUtilRuntime iCloudUAAUtilRuntime = null;
    private ISysCacheUtilRuntime iSysCacheUtilRuntime = null;
    private ICloudPortalClient iCloudPortalClient = null;

    @PostConstruct
    protected void postConstruct() {
        log.debug((Object)String.format("CloudRabbitMQ\u8ba4\u8bc1\u670d\u52a1\u5df2\u7ecf\u542f\u52a8", new Object[0]));
        this.iServiceHub.registerIgnoreAuthPattern("/uaa/rabbitmq/**");
        if (this.iCloudUAAUtilRuntime == null) {
            this.iServiceHub.requireCloudUtilRuntime(IUAAUtilSystemRuntime.class, ICloudUAAUtilRuntime.class);
        }
    }

    protected ICloudUAAUtilRuntime getCloudUAAUtilRuntime() {
        if (this.iCloudUAAUtilRuntime == null) {
            try {
                this.iCloudUAAUtilRuntime = (ICloudUAAUtilRuntime)this.iServiceHub.getCloudUtilRuntime(IUAAUtilSystemRuntime.class, ICloudUAAUtilRuntime.class, false);
            }
            catch (Throwable ex) {
                log.error((Object)String.format("\u83b7\u53d6Cloud\u4f53\u7cfbUAA\u529f\u80fd\u6a21\u5757\u53d1\u751f\u5f02\u5e38\uff0c$1%s", ex.getMessage()), ex);
                throw new SystemGatewayException((ISystemGateway)this.iServiceHub, String.format("\u672a\u6307\u5b9aCloud\u4f53\u7cfbUAA\u529f\u80fd\u6a21\u5757", new Object[0]), ex);
            }
        }
        return this.iCloudUAAUtilRuntime;
    }

    protected ISysCacheUtilRuntime getSysCacheUtilRuntime() {
        if (this.iSysCacheUtilRuntime == null) {
            try {
                this.iSysCacheUtilRuntime = (ISysCacheUtilRuntime)this.iServiceHub.getSysUtilRuntime(null, ISysCacheUtilRuntime.class, false);
            }
            catch (Throwable ex) {
                log.error((Object)String.format("\u83b7\u53d6\u7cfb\u7edf\u7f13\u5b58\u529f\u80fd\u7ec4\u4ef6\u53d1\u751f\u5f02\u5e38\uff0c$1%s", ex.getMessage()), ex);
                throw new SystemGatewayException((ISystemGateway)this.iServiceHub, String.format("\u672a\u6307\u5b9a\u7cfb\u7edf\u7f13\u5b58\u529f\u80fd\u7ec4\u4ef6", new Object[0]), ex);
            }
        }
        return this.iSysCacheUtilRuntime;
    }

    protected ICloudPortalClient getCloudPortalClient() {
        if (this.iCloudPortalClient == null) {
            try {
                ISysCloudClientUtilRuntime iSysCloudClientUtilRuntime = (ISysCloudClientUtilRuntime)this.iServiceHub.getSysUtilRuntime(null, ISysCloudClientUtilRuntime.class, false);
                this.iCloudPortalClient = (ICloudPortalClient)iSysCloudClientUtilRuntime.getServiceClient("ibizcloud-portal", ICloudPortalClient.class, true);
            }
            catch (Throwable ex) {
                log.error((Object)String.format("\u83b7\u53d6Cloud\u95e8\u6237\u5ba2\u6237\u7aef\u53d1\u751f\u5f02\u5e38\uff0c$1%s", ex.getMessage()), ex);
                throw new SystemGatewayException((ISystemGateway)this.iServiceHub, String.format("\u672a\u6307\u5b9aCloud\u95e8\u6237\u5ba2\u6237\u7aef", new Object[0]), ex);
            }
        }
        return this.iCloudPortalClient;
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST}, value={"/uaa/rabbitmq/user"})
    public String user(@RequestParam(value="username") String username, @RequestParam(value="password") String password) {
        block7: {
            if (!StringUtils.hasLength((String)username) || !StringUtils.hasLength((String)password)) {
                return "deny";
            }
            try {
                if (!this.getCloudUAAUtilRuntime().validateToken(password)) {
                    throw new Exception("Token\u5df2\u5931\u6548");
                }
                String strUserName = this.getCloudUAAUtilRuntime().getUsernameFromToken(password);
                String strCacheCat = CloudCacheTagUtils.getAuthenticationUserCat((String)strUserName, (String)password);
                Map map = this.getSysCacheUtilRuntime().getAll(strCacheCat);
                if (ObjectUtils.isEmpty((Object)map)) break block7;
                for (Map.Entry entry : map.entrySet()) {
                    Employee employee;
                    if (!StringUtils.hasLength((String)((String)entry.getKey())) || ((String)entry.getKey()).indexOf("sysemp-") != 0 || (employee = (Employee)this.getSysCacheUtilRuntime().getSystemRuntime().deserialize(entry.getValue(), Employee.class)) == null || !StringUtils.hasLength((String)employee.getMqttTopic()) || !username.equals(employee.getMqttTopic())) continue;
                    try {
                        Date date = this.getCloudUAAUtilRuntime().getExpirationDateFromToken(password);
                        Employee emp = new Employee();
                        emp.setUserId(employee.getUserId());
                        emp.setUAAUserId(employee.getUAAUserId());
                        emp.setDCSystemId(employee.getDCSystemId());
                        emp.setMqttTopic(employee.getMqttTopic());
                        emp.setMqttExpiration(Long.valueOf(date.getTime()));
                        this.getCloudPortalClient().registerEmployee(emp);
                    }
                    catch (Throwable ex) {
                        log.error((Object)String.format("\u5411CloudPortal\u767b\u8bb0\u4eba\u5458MQTT\u94fe\u8def\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
                    }
                    return "allow";
                }
            }
            catch (Throwable ex) {
                log.error((Object)String.format("\u6821\u9a8c\u7528\u6237[%1$s][%2$s]\u53d1\u751f\u5f02\u5e38\uff0c%3$s", username, password, ex.getMessage()), ex);
                return "deny";
            }
        }
        log.warn((Object)String.format("\u6821\u9a8c\u7528\u6237[%1$s][%2$s]\u5931\u8d25", username, password));
        return "deny";
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST}, value={"/uaa/rabbitmq/vhost"})
    public String vhost(VirtualHostCheck check) {
        log.debug((Object)String.format("Checking vhost access with %1$s", check));
        return "allow";
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST}, value={"/uaa/rabbitmq/resource"})
    public String resource(ResourceCheck check) {
        log.debug((Object)String.format("Checking resource access with %1$s", check));
        return "allow";
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST}, value={"/uaa/rabbitmq/topic"})
    public String topic(TopicCheck check) {
        boolean result = check.getUsername().replace("/", ".").equals(check.getRouting_key());
        log.debug((Object)String.format("Checking topic access with %1$s, result: %2$s", check, result));
        return result ? "allow" : "deny";
    }
}

