package net.ibizsys.central.cloud.portal.ebsx.cloudutil;

import java.util.Map;

import org.apache.commons.logging.LogFactory;

import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.cloud.core.security.IEmployeeContext;
import net.ibizsys.central.cloud.core.util.domain.PortalAsyncAction;
import net.ibizsys.central.cloud.portal.core.cloudutil.CloudPortalUtilRuntimeBase;
import net.ibizsys.central.cloud.saas.ebsx.EBSXSystemRuntime;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.portal.dto.PTAsyncActionDTO;
import net.ibizsys.central.cloud.saas.ebsx.util.StaticDict.BackendActionState;
import net.ibizsys.runtime.util.DataTypeUtils;

public class EBSXCloudPortalUtilRuntime extends CloudPortalUtilRuntimeBase {

	private static final org.apache.commons.logging.Log log = LogFactory.getLog(EBSXCloudPortalUtilRuntime.class);
	
	
	@Override
	protected PortalAsyncAction onCreateAsyncAction(Map params) throws Throwable {
		
		IEmployeeContext iEmployeeContext = EmployeeContext.getCurrentMust();
		
		PTAsyncActionDTO ptAsyncActionDTO  = new PTAsyncActionDTO();
		ptAsyncActionDTO.reload(params, true, true);
		ptAsyncActionDTO.setSrfdcid(iEmployeeContext.getTenant());
		ptAsyncActionDTO.setDCSystemId(iEmployeeContext.getDcsystemid());
		ptAsyncActionDTO.setActionState(BackendActionState.NOTCREATED.getValue());
		ptAsyncActionDTO.setFullTopicTag(iEmployeeContext.getMqtttopic());
		
		EBSXSystemRuntime.getInstance().getPTAsyncActionService().create(ptAsyncActionDTO);
		
		
		PortalAsyncAction portalAsyncAction = new PortalAsyncAction();
		ptAsyncActionDTO.copyTo(portalAsyncAction, true);
		return portalAsyncAction;
	}
	
	@Override
	protected PortalAsyncAction onExecuteAsyncAction(String strId, Map params) throws Throwable {
		
		PTAsyncActionDTO lastPTAsyncActionDTO = EBSXSystemRuntime.getInstance().getPTAsyncActionService().get(strId);
		int nActionState = DataTypeUtils.getIntegerValue(lastPTAsyncActionDTO.getActionState(), BackendActionState.CREATING.getValue());
		if(nActionState == BackendActionState.CREATED.getValue() || nActionState == BackendActionState.FAILED.getValue()) {
			throw new Exception("作业已结束");
		}
		
		PTAsyncActionDTO paramPTAsyncActionDTO  = new PTAsyncActionDTO();
		paramPTAsyncActionDTO.reload(params, true, true);
		
		PTAsyncActionDTO ptAsyncActionDTO = new PTAsyncActionDTO();
		ptAsyncActionDTO.setAsyncAcitonId(strId);
		if(nActionState != BackendActionState.CREATING.getValue()) {
			ptAsyncActionDTO.setActionState(BackendActionState.CREATING.getValue());
			ptAsyncActionDTO.setBeginTime(new java.sql.Timestamp(System.currentTimeMillis()));
		}
		ptAsyncActionDTO.setStepInfo(paramPTAsyncActionDTO.getStepInfo());
		
		EBSXSystemRuntime.getInstance().getPTAsyncActionService().update(ptAsyncActionDTO);
		
		PortalAsyncAction portalAsyncAction = new PortalAsyncAction();
		ptAsyncActionDTO.copyTo(portalAsyncAction, true);
		return portalAsyncAction;
	}
	
	@Override
	protected PortalAsyncAction onFinishAsyncAction(String strId, Map params) throws Throwable {
		PTAsyncActionDTO lastPTAsyncActionDTO = EBSXSystemRuntime.getInstance().getPTAsyncActionService().get(strId);
		int nActionState = DataTypeUtils.getIntegerValue(lastPTAsyncActionDTO.getActionState(), BackendActionState.CREATING.getValue());
		if(nActionState == BackendActionState.CREATED.getValue() || nActionState == BackendActionState.FAILED.getValue()) {
			throw new Exception("作业已结束");
		}
		
		PTAsyncActionDTO paramPTAsyncActionDTO  = new PTAsyncActionDTO();
		paramPTAsyncActionDTO.reload(params, true, true);
		
		PTAsyncActionDTO ptAsyncActionDTO = new PTAsyncActionDTO();
		ptAsyncActionDTO.setAsyncAcitonId(strId);
		ptAsyncActionDTO.setActionState(BackendActionState.CREATED.getValue());
		ptAsyncActionDTO.setEndTime(new java.sql.Timestamp(System.currentTimeMillis()));
		ptAsyncActionDTO.setStepInfo(null);
		
		ptAsyncActionDTO.setActionResult(paramPTAsyncActionDTO.getActionResult());
		ptAsyncActionDTO.setAsyncResultDownloadUrl(paramPTAsyncActionDTO.getAsyncResultDownloadUrl());
		
		EBSXSystemRuntime.getInstance().getPTAsyncActionService().update(ptAsyncActionDTO);
		
		PortalAsyncAction portalAsyncAction = new PortalAsyncAction();
		ptAsyncActionDTO.copyTo(portalAsyncAction, true);
		return portalAsyncAction;
	}
	
	
	@Override
	protected PortalAsyncAction onErrorAsyncAction(String strId, Map params) throws Throwable {
		PTAsyncActionDTO lastPTAsyncActionDTO = EBSXSystemRuntime.getInstance().getPTAsyncActionService().get(strId);
		int nActionState = DataTypeUtils.getIntegerValue(lastPTAsyncActionDTO.getActionState(), BackendActionState.CREATING.getValue());
		if(nActionState == BackendActionState.CREATED.getValue() || nActionState == BackendActionState.FAILED.getValue()) {
			throw new Exception("作业已结束");
		}
		
		PTAsyncActionDTO paramPTAsyncActionDTO  = new PTAsyncActionDTO();
		paramPTAsyncActionDTO.reload(params, true, true);
		
		PTAsyncActionDTO ptAsyncActionDTO = new PTAsyncActionDTO();
		ptAsyncActionDTO.setAsyncAcitonId(strId);
		ptAsyncActionDTO.setActionState(BackendActionState.FAILED.getValue());
		ptAsyncActionDTO.setEndTime(new java.sql.Timestamp(System.currentTimeMillis()));
		ptAsyncActionDTO.setStepInfo(null);
		
		ptAsyncActionDTO.setActionResult(paramPTAsyncActionDTO.getActionResult());
		ptAsyncActionDTO.setAsyncResultDownloadUrl(paramPTAsyncActionDTO.getAsyncResultDownloadUrl());
		
		EBSXSystemRuntime.getInstance().getPTAsyncActionService().update(ptAsyncActionDTO);
		
		PortalAsyncAction portalAsyncAction = new PortalAsyncAction();
		ptAsyncActionDTO.copyTo(portalAsyncAction, true);
		return portalAsyncAction;
	}
	
	
	
	@Override
	protected PortalAsyncAction onGetAsyncAction(String strId) throws Throwable {
		
		
		
		PTAsyncActionDTO ptAsyncActionDTO  = EBSXSystemRuntime.getInstance().getPTAsyncActionService().get(strId);
		
		PortalAsyncAction portalAsyncAction = new PortalAsyncAction();
		ptAsyncActionDTO.copyTo(portalAsyncAction, true);
		return portalAsyncAction;
	}
	
}
