/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.oss.minio.cloudutil;

import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.ListObjectsArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.Result;
import io.minio.messages.Item;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import net.ibizsys.central.cloud.core.util.error.NotFoundException;
import net.ibizsys.central.cloud.oss.core.cloudutil.SimpleCloudOSSUtilRuntime;
import net.ibizsys.central.cloud.oss.core.util.domain.FileItem;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.util.KeyValueUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class MinIOCloudOSSUtilRuntime
extends SimpleCloudOSSUtilRuntime {
    private static final Log log = LogFactory.getLog(MinIOCloudOSSUtilRuntime.class);
    private MinioClient minioClient = null;
    private String strBucket = null;

    protected void onInit() throws Exception {
        super.onInit();
        if (this.getMinioClient(true) == null) {
            this.prepareMinioClient();
            if (this.getMinioClient(true) == null) {
                throw new Exception(String.format("Minio\u5ba2\u6237\u7aef\u5bf9\u8c61\u5bf9\u8c61\u65e0\u6548", new Object[0]));
            }
        }
    }

    protected MinioClient getMinioClient() {
        return this.getMinioClient(false);
    }

    protected MinioClient getMinioClient(boolean bTryMode) {
        if (this.minioClient != null || bTryMode) {
            return this.minioClient;
        }
        throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), (IModelRuntime)this, "\u672a\u6307\u5b9aMinio\u5ba2\u6237\u7aef\u5bf9\u8c61");
    }

    protected void setMinioClient(MinioClient minioClient) {
        this.minioClient = minioClient;
    }

    protected void prepareMinioClient() throws Exception {
        String strServiceUrl = this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".minioclient.serviceurl", null);
        if (!StringUtils.hasLength((String)strServiceUrl)) {
            throw new Exception("\u672a\u6307\u5b9aMinio\u670d\u52a1\u8def\u5f84");
        }
        String strBucket = this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".minioclient.bucket", null);
        if (!StringUtils.hasLength((String)strBucket)) {
            throw new Exception("\u672a\u6307\u5b9aMinio\u5b58\u50a8\u6876");
        }
        String strClientId = this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".minioclient.clientid", null);
        if (!StringUtils.hasLength((String)strClientId)) {
            throw new Exception("\u672a\u6307\u5b9aMinio\u5ba2\u6237\u7aef\u6807\u8bc6");
        }
        String strClientSecret = this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".minioclient.clientsecret", null);
        if (!StringUtils.hasLength((String)strClientSecret)) {
            throw new Exception("\u672a\u6307\u5b9aMinio\u5ba2\u6237\u7aef\u5bc6\u94a5");
        }
        MinioClient minioClient = MinioClient.builder().endpoint(strServiceUrl).credentials(strClientId, strClientSecret).build();
        this.setMinioClient(minioClient);
        this.setBucket(strBucket);
    }

    protected String getBucket() {
        return this.strBucket;
    }

    protected void setBucket(String strBucket) {
        this.strBucket = strBucket;
    }

    public FileItem saveFile(String strCat, MultipartFile multipartFile) {
        List<String> fileExtfilterList;
        String fileName = multipartFile.getOriginalFilename();
        String fileExt = MinIOCloudOSSUtilRuntime.getFileExt((String)fileName);
        String fileExtfilter = this.getSystemRuntimeSetting().getParam("cloudossutil.fileextfilter", null);
        if (StringUtils.hasLength((String)fileExtfilter) && !ObjectUtils.isEmpty(fileExtfilterList = Arrays.asList(fileExtfilter.split(",")))) {
            String finalFileExt = fileExt;
            fileExtfilterList.forEach(item -> {
                if (item.equalsIgnoreCase(finalFileExt)) {
                    log.error((Object)String.format("%1$s\u4fdd\u5b58\u4e0a\u4f20\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\uff0c\u6587\u4ef6\u7c7b\u578b[%2$s]\u4e0d\u5141\u8bb8\u4e0a\u4f20", this.getLogicName(), finalFileExt));
                    throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), (IModelRuntime)this, String.format("\u4fdd\u5b58\u4e0a\u4f20\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\uff0c\u6587\u4ef6\u7c7b\u578b[%1$s]\u4e0d\u5141\u8bb8\u4e0a\u4f20", finalFileExt));
                }
            });
        }
        if (StringUtils.hasLength((String)fileExt)) {
            fileExt = "." + fileExt;
        }
        try {
            String fileId = KeyValueUtils.genUniqueId();
            String fileFullPath = null;
            if (ObjectUtils.isEmpty((Object)strCat) || strCat.equalsIgnoreCase("default")) {
                fileFullPath = "default/" + fileId + "/" + fileName;
            } else {
                strCat = strCat.toLowerCase();
                fileFullPath = strCat + "/" + fileId + "/" + fileName;
            }
            PutObjectArgs objectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.getBucket())).object(fileFullPath)).stream(multipartFile.getInputStream(), multipartFile.getSize(), -1L).contentType(multipartFile.getContentType()).build();
            this.getMinioClient().putObject(objectArgs);
            FileItem item2 = new FileItem();
            item2.setFileId(fileId);
            item2.setFileName(fileName);
            item2.setFileSize(Long.valueOf(multipartFile.getSize()));
            item2.setFileExt(fileExt);
            item2.setFolder(strCat);
            return item2;
        }
        catch (Throwable ex) {
            log.error((Object)String.format("%1$s\u4fdd\u5b58\u4e0a\u4f20\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getLogicName(), ex.getMessage()), ex);
            throw this.dealException(String.format("\u4fdd\u5b58\u4e0a\u4f20\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    public void donwloadFile(String strCat, String strFileId, HttpServletResponse response) {
        String strRealObjectName = null;
        try {
            String dirpath = null;
            if (ObjectUtils.isEmpty((Object)strCat) || strCat.equalsIgnoreCase("default")) {
                dirpath = "default/" + strFileId + "/";
            } else {
                strCat = strCat.toLowerCase();
                dirpath = strCat + "/" + strFileId + "/";
            }
            ListObjectsArgs listObjectsArgs = (ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(this.getBucket())).recursive(false).maxKeys(100).prefix(dirpath).build();
            Iterable ret = this.getMinioClient().listObjects(listObjectsArgs);
            for (Result result : ret) {
                Item item = (Item)result.get();
                if (item.isDir()) continue;
                strRealObjectName = item.objectName();
                break;
            }
        }
        catch (Throwable ex) {
            log.error((Object)String.format("%1$s\u4e0b\u8f7d\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getLogicName(), ex.getMessage()), ex);
            throw this.dealException(String.format("\u4e0b\u8f7d\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        if (!StringUtils.hasLength(strRealObjectName)) {
            throw new NotFoundException(String.format("\u6587\u4ef6[%1$s]\u672a\u627e\u5230", strFileId));
        }
        try {
            GetObjectArgs getObjectArgs = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.getBucket())).object(strRealObjectName)).build();
            String[] names = strRealObjectName.split("[/]");
            response.setHeader("Content-Disposition", "attachment;filename=" + this.getFileName(names[names.length - 1]));
            GetObjectResponse is = this.getMinioClient().getObject(getObjectArgs);
            Object object = null;
            try {
                this.sendResponse(response, (InputStream)is);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (object != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (Throwable ex) {
            log.error((Object)String.format("%1$s\u4e0b\u8f7d\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getLogicName(), ex.getMessage()), ex);
            throw this.dealException(String.format("\u4e0b\u8f7d\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }
}

