package net.ibizsys.central.cloud.oss.minio.cloudutil;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

import io.minio.GetObjectArgs;
import io.minio.ListObjectsArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.Result;
import io.minio.messages.Item;
import net.ibizsys.central.cloud.core.util.error.NotFoundException;
import net.ibizsys.central.cloud.oss.core.cloudutil.SimpleCloudOSSUtilRuntime;
import net.ibizsys.central.cloud.oss.core.util.domain.FileItem;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.util.KeyValueUtils;

public class MinIOCloudOSSUtilRuntime extends SimpleCloudOSSUtilRuntime {

	private static final org.apache.commons.logging.Log log = LogFactory.getLog(MinIOCloudOSSUtilRuntime.class);
	private MinioClient minioClient = null;
	private String strBucket = null;
	
	
	@Override
	protected void onInit() throws Exception {
		super.onInit();
		
		if (getMinioClient(true) == null) {
			this.prepareMinioClient();

			if (this.getMinioClient(true) == null) {
				throw new Exception(String.format("Minio客户端对象对象无效"));
			}
		}
	}
	
	
	protected MinioClient getMinioClient() {
		return this.getMinioClient(false);
	}

	protected MinioClient getMinioClient(boolean bTryMode) {
		if (this.minioClient != null || bTryMode) {
			return this.minioClient;
		}
		throw new SystemRuntimeException(getSystemRuntime(), this, "未指定Minio客户端对象");
	}

	protected void setMinioClient(MinioClient minioClient) {
		this.minioClient = minioClient;
	}

	protected void prepareMinioClient() throws Exception {

		String strServiceUrl = this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".minioclient.serviceurl", null);
		if(!StringUtils.hasLength(strServiceUrl)) {
			throw new Exception("未指定Minio服务路径");
		}
		String strBucket = this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".minioclient.bucket", null);
		if(!StringUtils.hasLength(strBucket)) {
			throw new Exception("未指定Minio存储桶");
		}
		
		String strClientId = this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".minioclient.clientid", null);
		if(!StringUtils.hasLength(strClientId)) {
			throw new Exception("未指定Minio客户端标识");
		}
		String strClientSecret = this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".minioclient.clientsecret", null);
		if(!StringUtils.hasLength(strClientSecret)) {
			throw new Exception("未指定Minio客户端密钥");
		}
		
		
		MinioClient minioClient = MinioClient.builder()
				.endpoint(strServiceUrl)
				.credentials(strClientId, strClientSecret)
				.build();
		this.setMinioClient(minioClient);
		this.setBucket(strBucket);
	}
	
	protected String getBucket() {
		return this.strBucket;
	}
	
	protected void setBucket(String strBucket) {
		this.strBucket = strBucket;
	}
	
	@Override
	public FileItem saveFile(String strCat, MultipartFile multipartFile) {
		// 获取文件名
		String fileName = multipartFile.getOriginalFilename();
		// 获取文件后缀
		String fileExt = getFileExt(fileName);
		// 文件后缀过滤
		String fileExtfilter = this.getSystemRuntimeSetting().getParam(CLOUDOSSUTIL_CONFIGFOLDER + ".fileextfilter", null);
		if(StringUtils.hasLength(fileExtfilter)) {
			List<String> fileExtfilterList = Arrays.asList(fileExtfilter.split(","));
			if (!ObjectUtils.isEmpty(fileExtfilterList)) {
				String finalFileExt = fileExt;
				fileExtfilterList.forEach(item -> {
					if (item.equalsIgnoreCase(finalFileExt)) {
						log.error(String.format("%1$s保存上传文件发生异常，文件类型[%2$s]不允许上传", this.getLogicName(), finalFileExt));
						throw new SystemRuntimeException(this.getSystemRuntime(),this,String.format("保存上传文件发生异常，文件类型[%1$s]不允许上传", finalFileExt));
					}
				});
			}
		}
		if(StringUtils.hasLength(fileExt)) {
			fileExt = "." + fileExt;
		}
		try {
			// String fileId =
			// DigestUtils.md5DigestAsHex(multipartFile.getInputStream());
			String fileId = KeyValueUtils.genUniqueId();
			String fileFullPath = null;
			if (ObjectUtils.isEmpty(strCat) || strCat.equalsIgnoreCase(CAT_DEFAULT)) {
				fileFullPath = "default" + "/" + fileId + "/" + fileName;
			} else {
				strCat = strCat.toLowerCase();
				fileFullPath = strCat + "/" + fileId + "/" + fileName;
			}
			
			PutObjectArgs objectArgs = PutObjectArgs.builder()
                    .bucket(this.getBucket())
                    .object(fileFullPath)
                    .stream(multipartFile.getInputStream(), multipartFile.getSize(), -1)
                    .contentType(multipartFile.getContentType())
                    .build();
            this.getMinioClient().putObject(objectArgs);
        
			FileItem item = new FileItem();
			item.setFileId(fileId);
			item.setFileName(fileName);
			item.setFileSize(multipartFile.getSize());
			item.setFileExt(fileExt);
			item.setFolder(strCat);
			return item;
		} catch (Throwable ex) {
			log.error(String.format("%1$s保存上传文件发生异常，%2$s", this.getLogicName(), ex.getMessage()), ex);
			throw dealException(String.format("保存上传文件发生异常，%1$s", ex.getMessage()), ex);
		}
	}
	
	
	
	@Override
	public void donwloadFile(String strCat, String strFileId, HttpServletResponse response) {
		String strRealObjectName = null;
		try {
			String dirpath = null;
			if (ObjectUtils.isEmpty(strCat) || strCat.equalsIgnoreCase(CAT_DEFAULT)) {
				dirpath = "default" + "/" + strFileId + "/" ;
			} else {
				strCat = strCat.toLowerCase();
				dirpath = strCat + "/" + strFileId + "/" ;
			}
			
			ListObjectsArgs listObjectsArgs = ListObjectsArgs.builder()
					.bucket(this.getBucket())
					.recursive(false)
					.maxKeys(100)
					.prefix(dirpath)
					.build();
				
		
			Iterable<Result<Item>> ret = this.getMinioClient().listObjects(listObjectsArgs);
			for (Result<Item> result : ret) {
                Item item = result.get();
                if(!item.isDir()) {
                	strRealObjectName = item.objectName();
                	break;
                }
            }
		}
		catch (Throwable ex) {
			log.error(String.format("%1$s下载文件发生异常，%2$s", this.getLogicName(), ex.getMessage()), ex);
			throw dealException(String.format("下载文件发生异常，%1$s", ex.getMessage()), ex);
		}
		
		if(!StringUtils.hasLength(strRealObjectName)) {
			throw new NotFoundException(String.format("文件[%1$s]未找到", strFileId));
		}
		
		try {

			GetObjectArgs getObjectArgs = GetObjectArgs.builder()
					.bucket(this.getBucket())
					.object(strRealObjectName)
					.build();
			
			String[] names = strRealObjectName.split("[/]");
			
			response.setHeader("Content-Disposition", "attachment;filename="+getFileName(names[names.length - 1]));
			try (InputStream is = this.getMinioClient().getObject(getObjectArgs)) {
				this.sendResponse(response, is);
			}
		}
		catch (Throwable ex) {
			log.error(String.format("%1$s下载文件发生异常，%2$s", this.getLogicName(), ex.getMessage()), ex);
			throw dealException(String.format("下载文件发生异常，%1$s", ex.getMessage()), ex);
		}
	}



	
}
