/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.oss.core.cloudutil;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.ibizsys.central.cloud.core.util.error.NotFoundException;
import net.ibizsys.central.cloud.oss.core.addin.IOSSPreviewProvider;
import net.ibizsys.central.cloud.oss.core.cloudutil.CloudOSSUtilRuntimeBase;
import net.ibizsys.central.cloud.oss.core.cloudutil.ISimpleFileStorageService;
import net.ibizsys.central.cloud.oss.core.util.domain.FileItem;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.util.KeyValueUtils;
import net.ibizsys.runtime.util.ZipUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class SimpleCloudOSSUtilRuntime
extends CloudOSSUtilRuntimeBase
implements ISimpleFileStorageService {
    private static final Log log = LogFactory.getLog(SimpleCloudOSSUtilRuntime.class);
    private String strFileRootFolder = null;

    @Override
    protected void onInit() throws Exception {
        this.setFileRootFolder(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".filepath", null));
        if (!StringUtils.hasLength((String)this.getFileRootFolder())) {
            this.setFileRootFolder(this.getSystemRuntimeSetting().getParam("cloudossutil.filepath", null));
            if (!StringUtils.hasLength((String)this.getFileRootFolder())) {
                if (!StringUtils.hasLength((String)this.getSystemRuntime().getFileFolder())) {
                    throw new Exception("\u672a\u5b9a\u4e49\u6587\u4ef6\u5b58\u50a8\u8def\u5f84");
                }
                String strFolder = this.getSystemRuntime().getFileFolder() + File.separator + "ibizutil";
                File folder = new File(strFolder);
                if (!folder.exists() && !folder.mkdirs()) {
                    throw new Exception(String.format("\u6587\u4ef6\u5b58\u50a8\u8def\u5f84[%1$s]\u65e0\u6548", strFolder));
                }
                this.setFileRootFolder(strFolder);
            }
        }
        super.onInit();
    }

    protected String getFileRootFolder() {
        return this.strFileRootFolder;
    }

    protected void setFileRootFolder(String strFileRootFolder) {
        this.strFileRootFolder = strFileRootFolder;
    }

    @Override
    public FileItem saveFile(String strCat, MultipartFile multipartFile) {
        List<String> fileExtfilterList;
        String fileName = multipartFile.getOriginalFilename();
        String fileExt = SimpleCloudOSSUtilRuntime.getFileExt(fileName);
        String fileExtfilter = this.getSystemRuntimeSetting().getParam("cloudossutil.fileextfilter", null);
        if (StringUtils.hasLength((String)fileExtfilter) && !ObjectUtils.isEmpty(fileExtfilterList = Arrays.asList(fileExtfilter.split(",")))) {
            String finalFileExt = fileExt;
            fileExtfilterList.forEach(item -> {
                if (item.equalsIgnoreCase(finalFileExt)) {
                    log.error((Object)String.format("%1$s\u4fdd\u5b58\u4e0a\u4f20\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\uff0c\u6587\u4ef6\u7c7b\u578b[%2$s]\u4e0d\u5141\u8bb8\u4e0a\u4f20", this.getLogicName(), finalFileExt));
                    throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), (IModelRuntime)this, String.format("\u4fdd\u5b58\u4e0a\u4f20\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\uff0c\u6587\u4ef6\u7c7b\u578b[%1$s]\u4e0d\u5141\u8bb8\u4e0a\u4f20", finalFileExt));
                }
            });
        }
        if (StringUtils.hasLength((String)fileExt)) {
            fileExt = "." + fileExt;
        }
        try {
            String fileId = KeyValueUtils.genUniqueId();
            String fileFullPath = null;
            if (ObjectUtils.isEmpty((Object)strCat) || strCat.equalsIgnoreCase("default")) {
                fileFullPath = this.getFileRootFolder() + File.separator + fileId + File.separator + fileName;
            } else {
                strCat = strCat.toLowerCase();
                fileFullPath = this.getFileRootFolder() + File.separator + strCat + File.separator + fileId + File.separator + fileName;
            }
            File file = new File(fileFullPath);
            File parent = new File(file.getParent());
            if (!parent.exists()) {
                parent.mkdirs();
            }
            FileUtils.copyInputStreamToFile((InputStream)multipartFile.getInputStream(), (File)file);
            FileItem item2 = new FileItem();
            item2.setFileId(fileId);
            item2.setFileName(fileName);
            item2.setFileSize(multipartFile.getSize());
            item2.setFileExt(fileExt);
            item2.setFolder(strCat);
            try {
                this.getCloudSaaSUtilRuntime(false).saveOSSFile((net.ibizsys.runtime.util.domain.File)item2);
            }
            catch (Exception ex) {
                log.error((Object)String.format("\u4fdd\u5b58OSS\u6587\u4ef6\u9879\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), (Throwable)ex);
            }
            return item2;
        }
        catch (Throwable ex) {
            log.error((Object)String.format("%1$s\u4fdd\u5b58\u4e0a\u4f20\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getLogicName(), ex.getMessage()), ex);
            throw this.dealException(String.format("\u4fdd\u5b58\u4e0a\u4f20\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    @Override
    public File getFile(String strCat, String strFileId) {
        String dirpath = null;
        if (ObjectUtils.isEmpty((Object)strCat) || strCat.equalsIgnoreCase("default")) {
            dirpath = this.getFileRootFolder() + File.separator + strFileId;
        } else {
            strCat = strCat.toLowerCase();
            dirpath = this.getFileRootFolder() + File.separator + strCat + File.separator + strFileId;
        }
        File parent = new File(dirpath);
        if (parent.exists() && parent.isDirectory() && parent.listFiles().length > 0) {
            if (parent.listFiles()[0].isDirectory()) {
                throw new NotFoundException(String.format("\u6587\u4ef6[%1$s]\u672a\u627e\u5230", strFileId));
            }
            return parent.listFiles()[0];
        }
        throw new NotFoundException(String.format("\u6587\u4ef6[%1$s]\u672a\u627e\u5230", strFileId));
    }

    @Override
    public File getFile(String strCat, List<JsonNode> list) {
        return this.getFile(strCat, list, "default");
    }

    @Override
    public File getFile(String strCat, List<JsonNode> list, String strPackMode) {
        if (ObjectUtils.isEmpty(list)) {
            throw new NotFoundException("\u672a\u4f20\u5165\u6587\u4ef6\u6e05\u5355");
        }
        ArrayList<File> fileList = new ArrayList<File>();
        for (JsonNode item : list) {
            if (item instanceof ObjectNode) {
                ObjectNode map = (ObjectNode)item;
                item = map.get("id");
            }
            fileList.add(this.getFile(strCat, item.asText()));
        }
        HashMap<Integer, String> fileZipEntryMap = null;
        if ("flat".equals(strPackMode)) {
            fileZipEntryMap = new HashMap<Integer, String>();
            HashMap<String, File> nameFileMap = new HashMap<String, File>();
            block12: for (int i = 0; i < fileList.size(); ++i) {
                File file = (File)fileList.get(i);
                String strFullName = file.getName();
                if (!nameFileMap.containsKey(strFullName)) {
                    nameFileMap.put(strFullName, file);
                    fileZipEntryMap.put(i, strFullName);
                    continue;
                }
                String strName = "";
                String strExt = "";
                int dot = strFullName.lastIndexOf(46);
                if (dot != -1) {
                    strName = strFullName.substring(0, dot);
                    strExt = strFullName.substring(dot);
                } else {
                    strName = strFullName;
                }
                int nIndex = 2;
                while (true) {
                    String strNewName;
                    if (!nameFileMap.containsKey(strNewName = String.format("%1$s(%2$s)%3$s", strName, nIndex, strExt))) {
                        nameFileMap.put(strNewName, file);
                        fileZipEntryMap.put(i, strNewName);
                        continue block12;
                    }
                    ++nIndex;
                }
            }
        }
        try {
            File tempFile = File.createTempFile("oss", ".zip");
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(tempFile));){
                for (int i = 0; i < fileList.size(); ++i) {
                    long nTime;
                    File file = (File)fileList.get(i);
                    if ("flat".equals(strPackMode)) {
                        String strEntry = (String)fileZipEntryMap.get(i);
                        nTime = System.currentTimeMillis();
                        ZipUtils.zipFile((File)file, (ZipOutputStream)zipOutputStream, (String)strEntry);
                        log.debug((Object)String.format("\u538b\u7f29\u6587\u4ef6[%1$s]\u8017\u65f6[%2$s]ms", file.getAbsolutePath(), System.currentTimeMillis() - nTime));
                        continue;
                    }
                    if ("default".equals(strPackMode)) {
                        if (file.getParentFile() == null || file.getParentFile().getParentFile() == null) {
                            throw new Exception("\u6587\u4ef6\u8def\u5f84\u4e0d\u6b63\u786e");
                        }
                        int nFolderLength = file.getParentFile().getParentFile().getAbsolutePath().length() + 1;
                        nTime = System.currentTimeMillis();
                        ZipUtils.zip((File)file, (ZipOutputStream)zipOutputStream, (int)nFolderLength);
                        log.debug((Object)String.format("\u538b\u7f29\u6587\u4ef6[%1$s]\u8017\u65f6[%2$s]ms", file.getAbsolutePath(), System.currentTimeMillis() - nTime));
                        continue;
                    }
                    throw new RuntimeException(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u6587\u4ef6\u6253\u5305\u7c7b\u578b[%1$s]", strPackMode));
                }
                zipOutputStream.flush();
                zipOutputStream.close();
            }
            return tempFile;
        }
        catch (Throwable ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), (IModelRuntime)this, String.format("\u751f\u6210\u538b\u7f29\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    public static String getFileExt(String filename) {
        int dot;
        if (filename != null && filename.length() > 0 && (dot = filename.lastIndexOf(46)) > -1 && dot < filename.length() - 1) {
            return filename.substring(dot + 1);
        }
        return "";
    }

    @Override
    public void donwloadFile(String strCat, String strFileId, HttpServletResponse response) {
        File file = this.getFile(strCat, strFileId);
        response.setHeader("Content-Disposition", String.format("attachment;filename=\"%1$s\"", this.getFileName(file.getName())));
        this.sendResponse(response, file);
    }

    @Override
    public FileItem uploadFile(String strCat, MultipartFile multipartFile) {
        return this.uploadFile(strCat, multipartFile, false);
    }

    @Override
    public FileItem uploadFile(String strCat, MultipartFile multipartFile, boolean bPreview) {
        File file;
        String ext;
        FileItem fileItem = this.saveFile(strCat, multipartFile);
        if (bPreview && StringUtils.hasLength((String)(ext = SimpleCloudOSSUtilRuntime.getFileExt((file = this.getFile(strCat, fileItem.getFileId())).getName())))) {
            try {
                IOSSPreviewProvider iOSSPreviewProvider = this.getOSSPreviewProvider(ext, true);
                if (iOSSPreviewProvider != null) {
                    iOSSPreviewProvider.fillPreviewInfo(fileItem, file);
                }
            }
            catch (Throwable ex) {
                throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), (IModelRuntime)this, String.format("\u751f\u6210\u9884\u89c8\u4fe1\u606f\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
        }
        return fileItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendResponse(HttpServletResponse response, File file) {
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            int bytesRead;
            bis = new BufferedInputStream(new FileInputStream(file));
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                ((BufferedOutputStream)bos).write(buff, 0, bytesRead);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendResponse(HttpServletResponse response, InputStream is) {
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            int bytesRead;
            bis = new BufferedInputStream(is);
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                ((BufferedOutputStream)bos).write(buff, 0, bytesRead);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        }
    }

    protected String getFileName(String fileName) {
        try {
            return new String(fileName.getBytes("utf-8"), "iso8859-1");
        }
        catch (UnsupportedEncodingException ex) {
            log.error((Object)ex);
            return fileName;
        }
    }
}

