/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.oss.core.spring.controller;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletResponse;
import net.ibizsys.central.ISystemGateway;
import net.ibizsys.central.SystemGatewayException;
import net.ibizsys.central.cloud.core.IServiceHub;
import net.ibizsys.central.cloud.core.cloudutil.ICloudOSSUtilRuntime;
import net.ibizsys.central.cloud.core.security.AuthenticationUser;
import net.ibizsys.central.cloud.core.security.IAuthenticationUser;
import net.ibizsys.central.cloud.core.util.RestUtils;
import net.ibizsys.central.cloud.oss.core.IOSSUtilSystemRuntime;
import net.ibizsys.central.cloud.oss.core.cloudutil.ISimpleFileStorageService;
import net.ibizsys.central.cloud.oss.core.util.domain.FileItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={""})
public class OSSRestController {
    private static final Log log = LogFactory.getLog(OSSRestController.class);
    @Autowired
    IServiceHub iServiceHub;
    @Value(value="${ibiz.cloud.oss.ignoreauth:true}")
    private boolean ignoreAuth;
    @Autowired(required=false)
    private ICloudOSSUtilRuntime iCloudOSSUtilRuntime = null;
    private ISimpleFileStorageService iSimpleFileStorageService = null;

    @PostConstruct
    protected void postConstruct() {
        log.debug((Object)String.format("CloudOSS\u670d\u52a1\u5df2\u7ecf\u542f\u52a8", new Object[0]));
        if (this.ignoreAuth) {
            this.iServiceHub.registerIgnoreAuthPattern("/ibizutil/download/**");
        }
        this.iServiceHub.registerNamingService("ibizcloud-oss");
        if (this.iCloudOSSUtilRuntime == null) {
            this.iServiceHub.requireCloudUtilRuntime(IOSSUtilSystemRuntime.class, ICloudOSSUtilRuntime.class);
        }
    }

    protected ICloudOSSUtilRuntime getCloudOSSUtilRuntime() {
        if (this.iCloudOSSUtilRuntime == null) {
            try {
                this.iCloudOSSUtilRuntime = (ICloudOSSUtilRuntime)this.iServiceHub.getCloudUtilRuntime(IOSSUtilSystemRuntime.class, ICloudOSSUtilRuntime.class, false);
            }
            catch (Throwable ex) {
                log.debug((Object)String.format("\u672a\u6307\u5b9aCloud\u670d\u52a1OSS\u529f\u80fd\u6a21\u5757", new Object[0]), ex);
                throw new SystemGatewayException((ISystemGateway)this.iServiceHub, String.format("\u672a\u6307\u5b9aCloud\u670d\u52a1OSS\u529f\u80fd\u6a21\u5757", new Object[0]), ex);
            }
        }
        return this.iCloudOSSUtilRuntime;
    }

    protected ISimpleFileStorageService getSimpleFileStorageService() {
        if (this.iSimpleFileStorageService == null) {
            if (this.getCloudOSSUtilRuntime() instanceof ISimpleFileStorageService) {
                this.iSimpleFileStorageService = (ISimpleFileStorageService)this.getCloudOSSUtilRuntime();
            }
            if (this.iSimpleFileStorageService == null) {
                throw new SystemGatewayException((ISystemGateway)this.iServiceHub, String.format("Cloud\u670d\u52a1OSS\u529f\u80fd\u6a21\u5757\u672a\u63d0\u4f9b\u7b80\u5355\u6587\u4ef6\u5b58\u50a8\u670d\u52a1\u529f\u80fd", new Object[0]));
            }
        }
        return this.iSimpleFileStorageService;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/oss/object/{db}/{table}/create", "/oss/object/{db}/{table}"})
    public ResponseEntity<String> createObject(@PathVariable(value="db") String db, @PathVariable(value="table") String table, @RequestBody Map params) {
        if (!AuthenticationUser.isApiuser((IAuthenticationUser)AuthenticationUser.getCurrentMust()) && !AuthenticationUser.isSuperuser((IAuthenticationUser)AuthenticationUser.getCurrentMust())) {
            throw new RuntimeException("\u4ec5\u9650API\u7528\u6237\u8bbf\u95ee");
        }
        return ResponseEntity.ok((Object)this.getCloudOSSUtilRuntime().createObject(db, table, params));
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/oss/object/{db}/{table}/{key}/update", "/oss/object/{db}/{table}/{key}"})
    public ResponseEntity<Integer> updateObject(@PathVariable(value="db") String db, @PathVariable(value="table") String table, @PathVariable(value="key") String key, @RequestBody Map params) {
        if (!AuthenticationUser.isApiuser((IAuthenticationUser)AuthenticationUser.getCurrentMust()) && !AuthenticationUser.isSuperuser((IAuthenticationUser)AuthenticationUser.getCurrentMust())) {
            throw new RuntimeException("\u4ec5\u9650API\u7528\u6237\u8bbf\u95ee");
        }
        return ResponseEntity.ok((Object)this.getCloudOSSUtilRuntime().updateObject(db, table, key, params, true));
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/oss/object/{db}/{table}/{key}/delete", "/oss/object/{db}/{table}/{key}"})
    public ResponseEntity<Integer> deleteObject(@PathVariable(value="db") String db, @PathVariable(value="table") String table, @PathVariable(value="key") String key) {
        if (!AuthenticationUser.isApiuser((IAuthenticationUser)AuthenticationUser.getCurrentMust()) && !AuthenticationUser.isSuperuser((IAuthenticationUser)AuthenticationUser.getCurrentMust())) {
            throw new RuntimeException("\u4ec5\u9650API\u7528\u6237\u8bbf\u95ee");
        }
        return ResponseEntity.ok((Object)this.getCloudOSSUtilRuntime().deleteObject(db, table, key));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/oss/object/{db}/{table}/{key}/get", "/oss/object/{db}/{table}/{key}"})
    public ResponseEntity<Map> getObject(@PathVariable(value="db") String db, @PathVariable(value="table") String table, @PathVariable(value="key") String key) {
        if (!AuthenticationUser.isApiuser((IAuthenticationUser)AuthenticationUser.getCurrentMust()) && !AuthenticationUser.isSuperuser((IAuthenticationUser)AuthenticationUser.getCurrentMust())) {
            throw new RuntimeException("\u4ec5\u9650API\u7528\u6237\u8bbf\u95ee");
        }
        return ResponseEntity.ok((Object)this.getCloudOSSUtilRuntime().getObject(db, table, key));
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/oss/object/{db}/{table}/fetch"})
    public ResponseEntity<Object> fetchObjects(@PathVariable(value="db") String db, @PathVariable(value="table") String table, @RequestBody Map params) {
        if (!AuthenticationUser.isApiuser((IAuthenticationUser)AuthenticationUser.getCurrentMust()) && !AuthenticationUser.isSuperuser((IAuthenticationUser)AuthenticationUser.getCurrentMust())) {
            throw new RuntimeException("\u4ec5\u9650API\u7528\u6237\u8bbf\u95ee");
        }
        Page page = this.getCloudOSSUtilRuntime().fetchObjects(db, table, params);
        return RestUtils.sendBackPage((Page)page, Map.class);
    }

    @PostMapping(value={"${ibiz.cloud.oss.uploadpath:/ibizutil/upload}"})
    public ResponseEntity<FileItem> upload(@RequestParam(value="file") MultipartFile multipartFile) {
        return ResponseEntity.ok().body((Object)this.getSimpleFileStorageService().uploadFile(null, multipartFile));
    }

    @GetMapping(value={"${ibiz.cloud.oss.downloadpath:/ibizutil/download/{id}}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void download(@PathVariable String id, HttpServletResponse response) {
        this.getSimpleFileStorageService().donwloadFile(null, id, response);
    }

    @PostMapping(value={"${ibiz.cloud.oss.uploadpath2:/ibizutil/upload/{cat}}"})
    public ResponseEntity<FileItem> upload(@PathVariable String cat, @RequestParam(value="file") MultipartFile multipartFile) {
        return ResponseEntity.ok().body((Object)this.getSimpleFileStorageService().uploadFile(cat, multipartFile));
    }

    @GetMapping(value={"${ibiz.cloud.oss.downloadpath2:/ibizutil/download/{cat}/{id}}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void download(@PathVariable String cat, @PathVariable String id, HttpServletResponse response) {
        this.getSimpleFileStorageService().donwloadFile(cat, id, response);
    }

    @PostMapping(value={"${ibiz.cloud.oss.downloadpath3:/ibizutil/download}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void download(@RequestBody List<JsonNode> list, HttpServletResponse response, @RequestParam(value="packmode", required=false, defaultValue="default") String packmode) {
        File file = this.getSimpleFileStorageService().getFile(null, list, packmode);
        response.setHeader("Content-Disposition", "attachment;filename=" + this.getFileName(file.getName()));
        this.sendResponse(response, file);
    }

    @PostMapping(value={"${ibiz.cloud.oss.downloadpath4:/ibizutil/download/{cat}}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void download(@PathVariable String cat, @RequestBody List<JsonNode> list, HttpServletResponse response, @RequestParam(value="packmode", required=false, defaultValue="default") String packmode) {
        File file = this.getSimpleFileStorageService().getFile(cat, list, packmode);
        response.setHeader("Content-Disposition", "attachment;filename=" + this.getFileName(file.getName()));
        this.sendResponse(response, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendResponse(HttpServletResponse response, File file) {
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            int bytesRead;
            bis = new BufferedInputStream(new FileInputStream(file));
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                ((BufferedOutputStream)bos).write(buff, 0, bytesRead);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        }
    }

    protected String getFileName(String fileName) {
        try {
            return new String(fileName.getBytes("utf-8"), "iso8859-1");
        }
        catch (UnsupportedEncodingException ex) {
            log.error((Object)ex);
            return fileName;
        }
    }
}

