/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.oss.core.cloudutil;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.ISystemRuntimeContext;
import net.ibizsys.central.ba.ISysBDSchemeRuntime;
import net.ibizsys.central.ba.SysBDSchemeRuntime;
import net.ibizsys.central.cloud.core.cloudutil.CloudUtilRuntimeBase;
import net.ibizsys.central.cloud.core.cloudutil.ICloudOSSUtilRuntime;
import net.ibizsys.central.util.ISearchContext;
import net.ibizsys.central.util.SimpleSearchContextDTO;
import net.ibizsys.model.ba.IPSSysBDScheme;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.util.ErrorException;
import net.ibizsys.runtime.util.IAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Page;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class CloudOSSUtilRuntimeBase
extends CloudUtilRuntimeBase
implements ICloudOSSUtilRuntime {
    private static final Log log = LogFactory.getLog(CloudOSSUtilRuntimeBase.class);
    private ISysBDSchemeRuntime iSysBDSchemeRuntime = null;

    public String getLogicName() {
        return String.format("Cloud\u4f53\u7cfbOSS\u529f\u80fd\u7ec4\u4ef6[%1$s]", this.getName());
    }

    protected String getGlobalConfigId() {
        return "cloudossutil";
    }

    protected String getCloudConfigId() {
        return "cloud-oss";
    }

    protected void onInit() throws Exception {
        super.onInit();
        if (this.getSysBDSchemeRuntime(true) == null) {
            this.prepareSysBDSchemeRuntime();
            if (this.getSysBDSchemeRuntime(true) == null) {
                this.getSystemRuntime().logEvent(30000, this.getLogCat(), String.format("\u5927\u6570\u636e\u4f53\u7cfb\u5bf9\u8c61\u65e0\u6548\uff0c\u65e0\u6cd5\u8fdb\u884c\u5bf9\u8c61\u6570\u636e\u5b58\u50a8\u64cd\u4f5c", new Object[0]), null);
            }
        }
    }

    protected ISysBDSchemeRuntime getSysBDSchemeRuntime() {
        return this.getSysBDSchemeRuntime(false);
    }

    protected ISysBDSchemeRuntime getSysBDSchemeRuntime(boolean bTryMode) {
        if (this.iSysBDSchemeRuntime != null || bTryMode) {
            return this.iSysBDSchemeRuntime;
        }
        throw new SystemRuntimeException(this.getSystemRuntimeBase(), (IModelRuntime)this, "\u672a\u6307\u5b9a\u5927\u6570\u636e\u4f53\u7cfb\u5bf9\u8c61");
    }

    protected void setSysBDSchemeRuntime(ISysBDSchemeRuntime iSysBDSchemeRuntime) {
        this.iSysBDSchemeRuntime = iSysBDSchemeRuntime;
    }

    protected void prepareSysBDSchemeRuntime() throws Exception {
        Map params = this.getSystemRuntimeSetting().getParams(this.getConfigFolder() + ".sysbdscheme", null);
        if (ObjectUtils.isEmpty((Object)params)) {
            return;
        }
        String strBDType = (String)params.get("bdtype");
        if (!StringUtils.hasLength((String)strBDType)) {
            throw new Exception("\u672a\u6307\u5b9a\u5927\u6570\u636e\u4f53\u7cfb\u7c7b\u578b");
        }
        ISysBDSchemeRuntime iSysBDSchemeRuntime = (ISysBDSchemeRuntime)this.getSystemRuntime().getRuntimeObject(ISysBDSchemeRuntime.class, strBDType);
        if (iSysBDSchemeRuntime == null) {
            throw new Exception(String.format("\u65e0\u6cd5\u5efa\u7acb\u6307\u5b9a\u7c7b\u578b[%1$s]\u5927\u6570\u636e\u4f53\u7cfb\u8fd0\u884c\u65f6", strBDType));
        }
        params.put("name", "CloudOSS\u5927\u6570\u636e\u4f53\u7cfb");
        params.put("codename", "cloudossbdscheme");
        IPSSysBDScheme iPSSysBDScheme = SysBDSchemeRuntime.getPSSysBDScheme((ISystemRuntimeContext)this.getSystemRuntimeContext(), (Map)params);
        iSysBDSchemeRuntime.init(this.getSystemRuntimeContext(), iPSSysBDScheme);
        this.setSysBDSchemeRuntime(iSysBDSchemeRuntime);
    }

    protected ISysBDSchemeRuntime getSysBDSchemeRuntime(String strDBName) {
        return this.getSysBDSchemeRuntime();
    }

    public String createObject(final String strDBName, final String strTableName, final Map<String, Object> data) {
        return (String)this.executeAction("\u5efa\u7acb\u6570\u636e", new IAction(){

            public Object execute(Object[] args) throws Throwable {
                return CloudOSSUtilRuntimeBase.this.onCreateObject(strDBName, strTableName, data);
            }
        }, null);
    }

    protected String onCreateObject(String strDBName, String strTableName, Map<String, Object> data) throws Throwable {
        try {
            SysBDSchemeRuntime.setCurrentDBName((String)strDBName);
            String string = (String)this.getSysBDSchemeRuntime(strDBName).insert(strTableName, data, null);
            return string;
        }
        catch (Throwable ex) {
            throw ex;
        }
        finally {
            SysBDSchemeRuntime.setCurrentDBName(null);
        }
    }

    public int updateObject(final String strDBName, final String strTableName, final String key, final Map<String, Object> data, final boolean bAppend) {
        return (Integer)this.executeAction("\u66f4\u65b0\u6570\u636e", new IAction(){

            public Object execute(Object[] args) throws Throwable {
                return CloudOSSUtilRuntimeBase.this.onUpdateObject(strDBName, strTableName, key, data, bAppend);
            }
        }, null);
    }

    protected int onUpdateObject(String strDBName, String strTableName, String key, Map<String, Object> data, boolean bAppend) throws Throwable {
        try {
            SysBDSchemeRuntime.setCurrentDBName((String)strDBName);
            data.put("_id", key);
            int n = (Integer)this.getSysBDSchemeRuntime(strDBName).update(strTableName, data, null, bAppend);
            return n;
        }
        catch (Throwable ex) {
            throw ex;
        }
        finally {
            SysBDSchemeRuntime.setCurrentDBName(null);
        }
    }

    public int deleteObject(final String strDBName, final String strTableName, final String key) {
        return (Integer)this.executeAction("\u5220\u9664\u6570\u636e", new IAction(){

            public Object execute(Object[] args) throws Throwable {
                return CloudOSSUtilRuntimeBase.this.onDeleteObject(strDBName, strTableName, key);
            }
        }, null);
    }

    protected int onDeleteObject(String strDBName, String strTableName, String key) throws Throwable {
        try {
            SysBDSchemeRuntime.setCurrentDBName((String)strDBName);
            LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
            data.put("_id", key);
            int n = (Integer)this.getSysBDSchemeRuntime(strDBName).delete(strTableName, data, null);
            return n;
        }
        catch (Throwable ex) {
            throw ex;
        }
        finally {
            SysBDSchemeRuntime.setCurrentDBName(null);
        }
    }

    public Page fetchObjects(final String strDBName, final String strTableName, final Map<String, Object> data) {
        return (Page)this.executeAction("\u83b7\u53d6\u6570\u636e\u96c6\u5408", new IAction(){

            public Object execute(Object[] args) throws Throwable {
                return CloudOSSUtilRuntimeBase.this.onFetchObjects(strDBName, strTableName, data);
            }
        }, null);
    }

    protected Page onFetchObjects(String strDBName, String strTableName, Map<String, Object> data) throws Throwable {
        try {
            SysBDSchemeRuntime.setCurrentDBName((String)strDBName);
            Object fieldsObject = data.get("fields");
            String[] fields = null;
            if (fieldsObject instanceof List) {
                List list = (List)fieldsObject;
                fields = list.toArray(new String[list.size()]);
            }
            Page page = this.getSysBDSchemeRuntime(strDBName).fetch(strTableName, (ISearchContext)new SimpleSearchContextDTO(data), fields, null);
            return page;
        }
        catch (Throwable ex) {
            throw ex;
        }
        finally {
            SysBDSchemeRuntime.setCurrentDBName(null);
        }
    }

    public Map getObject(final String strDBName, final String strTableName, final String key) {
        return (Map)this.executeAction("\u83b7\u53d6\u6570\u636e", new IAction(){

            public Object execute(Object[] args) throws Throwable {
                return CloudOSSUtilRuntimeBase.this.onGetObject(strDBName, strTableName, key);
            }
        }, null);
    }

    protected Map onGetObject(String strDBName, String strTableName, String key) throws Throwable {
        try {
            SysBDSchemeRuntime.setCurrentDBName((String)strDBName);
            SimpleSearchContextDTO simpleSearchContextDTO = new SimpleSearchContextDTO();
            simpleSearchContextDTO.setCount(false);
            simpleSearchContextDTO.eq("_id", (Object)key);
            Page page = this.getSysBDSchemeRuntime(strDBName).fetch(strTableName, (ISearchContext)simpleSearchContextDTO, null, null);
            if (page == null || ObjectUtils.isEmpty((Object)page.getContent())) {
                throw new ErrorException("", 3);
            }
            Map map = (Map)page.getContent().get(0);
            return map;
        }
        catch (Throwable ex) {
            throw ex;
        }
        finally {
            SysBDSchemeRuntime.setCurrentDBName(null);
        }
    }
}

