package net.ibizsys.central.cloud.oss.core.cloudutil;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Arrays;
import java.util.zip.ZipOutputStream;

import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import net.ibizsys.central.cloud.core.util.error.NotFoundException;
import net.ibizsys.central.cloud.oss.core.util.domain.FileItem;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.util.KeyValueUtils;
import net.ibizsys.runtime.util.ZipUtils;

public class SimpleCloudOSSUtilRuntime extends CloudOSSUtilRuntimeBase implements ISimpleFileStorageService {

	private static final org.apache.commons.logging.Log log = LogFactory.getLog(SimpleCloudOSSUtilRuntime.class);
	private String strFileRootFolder = null;

	@Override
	protected void onInit() throws Exception {
		this.setFileRootFolder(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".filepath", null));
		if (!StringUtils.hasLength(this.getFileRootFolder())) {
			this.setFileRootFolder(this.getSystemRuntimeSetting().getParam(CLOUDOSSUTIL_CONFIGFOLDER + ".filepath", null));
			if (!StringUtils.hasLength(this.getFileRootFolder())) {
				if (!StringUtils.hasLength(this.getSystemRuntime().getFileFolder())) {
					throw new Exception("未定义文件存储路径");
				}
				String strFolder = this.getSystemRuntime().getFileFolder() + File.separator + "ibizutil";
				File folder = new File(strFolder);
				if (!folder.exists() && !folder.mkdirs()) {
					throw new Exception(String.format("文件存储路径[%1$s]无效", strFolder));
				}
				this.setFileRootFolder(strFolder);
			}
		}

		super.onInit();
	}

	protected String getFileRootFolder() {
		return this.strFileRootFolder;
	}

	protected void setFileRootFolder(String strFileRootFolder) {
		this.strFileRootFolder = strFileRootFolder;
	}

	@Override
	public FileItem saveFile(String strCat, MultipartFile multipartFile) {
		// 获取文件名
		String fileName = multipartFile.getOriginalFilename();
		// 获取文件后缀
		String fileExt = getFileExt(fileName);
		// 文件后缀过滤
		String fileExtfilter = this.getSystemRuntimeSetting().getParam(CLOUDOSSUTIL_CONFIGFOLDER + ".fileextfilter", null);
		if(StringUtils.hasLength(fileExtfilter)) {
			List<String> fileExtfilterList = Arrays.asList(fileExtfilter.split(","));
			if (!ObjectUtils.isEmpty(fileExtfilterList)) {
				String finalFileExt = fileExt;
				fileExtfilterList.forEach(item -> {
					if (item.equalsIgnoreCase(finalFileExt)) {
						log.error(String.format("%1$s保存上传文件发生异常，文件类型[%2$s]不允许上传", this.getLogicName(), finalFileExt));
						throw new SystemRuntimeException(this.getSystemRuntime(),this,String.format("保存上传文件发生异常，文件类型[%1$s]不允许上传", finalFileExt));
					}
				});
			}
		}
		if(StringUtils.hasLength(fileExt)) {
			fileExt = "." + fileExt;
		}
		try {
			// String fileId =
			// DigestUtils.md5DigestAsHex(multipartFile.getInputStream());
			String fileId = KeyValueUtils.genUniqueId();
			String fileFullPath = null;
			if (ObjectUtils.isEmpty(strCat) || strCat.equalsIgnoreCase(CAT_DEFAULT)) {
				fileFullPath = getFileRootFolder() + File.separator + fileId + File.separator + fileName;
			} else {
				strCat = strCat.toLowerCase();
				fileFullPath = getFileRootFolder() + File.separator + strCat + File.separator + fileId + File.separator + fileName;
			}

			File file = new File(fileFullPath);
			File parent = new File(file.getParent());
			if (!parent.exists()) {
				parent.mkdirs();
			}
			FileUtils.copyInputStreamToFile(multipartFile.getInputStream(), file);
			// FileCopyUtils.copy(multipartFile.getInputStream(),
			// Files.newOutputStream(file.toPath()));
			FileItem item = new FileItem();
			item.setFileId(fileId);
			item.setFileName(fileName);
			item.setFileSize(multipartFile.getSize());
			item.setFileExt(fileExt);
			item.setFolder(strCat);
			return item;
		} catch (Throwable ex) {
			log.error(String.format("%1$s保存上传文件发生异常，%2$s", this.getLogicName(), ex.getMessage()), ex);
			throw dealException(String.format("保存上传文件发生异常，%1$s", ex.getMessage()), ex);
		}
	}

	@Override
	public File getFile(String strCat, String strFileId) {
		String dirpath = null;
		if (ObjectUtils.isEmpty(strCat) || strCat.equalsIgnoreCase(CAT_DEFAULT)) {
			dirpath = getFileRootFolder() + File.separator + strFileId;
		} else {
			strCat = strCat.toLowerCase();
			dirpath = getFileRootFolder() + File.separator + strCat + File.separator + strFileId;
		}
		// String dirpath = getFileRootFolder() + File.separator + strFileId;
		File parent = new File(dirpath);
		if (parent.exists() && parent.isDirectory() && parent.listFiles().length > 0) {
			if (parent.listFiles()[0].isDirectory()) {
				throw new NotFoundException(String.format("文件[%1$s]未找到", strFileId));
			}

			return parent.listFiles()[0];
		}
		throw new NotFoundException(String.format("文件[%1$s]未找到", strFileId));
	}

	@Override
	public File getFile(String strCat, List<JsonNode> list) {
		return getFile(strCat, list, PACKMODE_DEFAULT);
	}

	@Override
	public File getFile(String strCat, List<JsonNode> list, String strPackMode) {

		if (ObjectUtils.isEmpty(list)) {
			throw new NotFoundException("未传入文件清单");
		}

		List<File> fileList = new ArrayList<File>();
		for (JsonNode item : list) {

			if (item instanceof ObjectNode) {
				ObjectNode map = (ObjectNode) item;
				item = map.get("id");
			}
			fileList.add(this.getFile(strCat, item.asText()));
		}

		Map<Integer, String> fileZipEntryMap = null;
		//重新计算打包文件名
		if(PACKMODE_FLAT.equals(strPackMode)) {
			fileZipEntryMap = new HashMap<Integer, String>();
			Map<String, File> nameFileMap = new HashMap<String, File>();
			for(int i = 0;i<fileList.size();i++) {
				File file = fileList.get(i);
				String strFullName = file.getName();
				if(!nameFileMap.containsKey(strFullName)) {
					nameFileMap.put(strFullName, file);
					fileZipEntryMap.put(i, strFullName);
				}
				else {
					String strName = "";
					String strExt = "";
					//计算名称
					int dot = strFullName.lastIndexOf('.');
					if(dot != -1) {
						strName = strFullName.substring(0, dot);
						strExt = strFullName.substring(dot);
					}
					else {
						strName = strFullName;
					}
					int nIndex = 2;
					while(true) {
						String strNewName = String.format("%1$s(%2$s)%3$s",  strName, nIndex, strExt);
						if(!nameFileMap.containsKey(strNewName)) {
							nameFileMap.put(strNewName, file);
							fileZipEntryMap.put(i, strNewName);
							break;
						}
						else {
							nIndex ++;
						}
					}
				}
			}

		}

		try {
			File tempFile = File.createTempFile("oss", ".zip");
			try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(tempFile))) {
				for(int i = 0;i<fileList.size();i++) {
					File file = fileList.get(i);
					if(PACKMODE_FLAT.equals(strPackMode)) {
						String strEntry = fileZipEntryMap.get(i);
						long nTime = System.currentTimeMillis();
						ZipUtils.zipFile(file, zipOutputStream, strEntry);
						log.debug(String.format("压缩文件[%1$s]耗时[%2$s]ms", file.getAbsolutePath(), System.currentTimeMillis() - nTime));
					}
					else
					if(PACKMODE_DEFAULT.equals(strPackMode)) {
						if (file.getParentFile() == null || file.getParentFile().getParentFile() == null) {
							throw new Exception("文件路径不正确");
						}
						int nFolderLength = file.getParentFile().getParentFile().getAbsolutePath().length() + 1;
						long nTime = System.currentTimeMillis();
						ZipUtils.zip(file, zipOutputStream, nFolderLength);
						log.debug(String.format("压缩文件[%1$s]耗时[%2$s]ms", file.getAbsolutePath(), System.currentTimeMillis() - nTime));
					}
					else {
						throw new RuntimeException(String.format("无法识别的文件打包类型[%1$s]", strPackMode));
					}

				}
				zipOutputStream.flush();
				zipOutputStream.close();
			}
			return tempFile;
		} catch (Throwable ex) {
			throw new SystemRuntimeException(this.getSystemRuntime(), this, String.format("生成压缩文件发生异常，%1$s", ex.getMessage()), ex);
		}

	}



	/**
	 * 获取文件扩展名
	 *
	 * @param filename
	 * @return
	 */
	public static String getFileExt(String filename) {
		if ((filename != null) && (filename.length() > 0)) {
			int dot = filename.lastIndexOf('.');
			if ((dot > -1) && (dot < (filename.length() - 1))) {
				return filename.substring(dot + 1);
			}
		}
		return "";
	}
}
